/*
 * Decompiled with CFR 0.152.
 */
package com.hidoni.transmog;

import com.hidoni.transmog.Constants;
import com.hidoni.transmog.RenderUtils;
import com.hidoni.transmog.component.TransmogAppearanceItem;
import com.hidoni.transmog.config.Config;
import com.hidoni.transmog.registry.ModDataComponents;
import com.hidoni.transmog.registry.ModItems;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_9331;

public class TransmogUtils {
    private static boolean notInPvP = true;
    private static Thread pvpTimerThread = null;

    public static void startPvP() {
        if (Config.pvpDisableDuration > 0) {
            TransmogUtils.setNotInPvP(false);
            if (pvpTimerThread != null) {
                Constants.LOG.info("Client player still involved in PvP, Extending transmog disable for another {} seconds", (Object)Config.pvpDisableDuration);
                Constants.LOG.debug("Interrupting existing PvP timer thread: {}", (Object)pvpTimerThread);
                pvpTimerThread.interrupt();
            } else {
                Constants.LOG.info("Client player involved in PvP, Disabling transmogs for {} seconds", (Object)Config.pvpDisableDuration);
            }
            pvpTimerThread = new Thread(() -> {
                try {
                    TimeUnit.SECONDS.sleep(Config.pvpDisableDuration);
                    TransmogUtils.setNotInPvP(true);
                    Constants.LOG.info("PvP Timer finished, Transmog re-enabled.");
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            pvpTimerThread.start();
            Constants.LOG.debug("Created new PvP timer thread: {}", (Object)pvpTimerThread);
        }
    }

    private static synchronized void setNotInPvP(boolean notInPvP) {
        TransmogUtils.notInPvP = notInPvP;
    }

    public static boolean isItemStackTransmogged(class_1799 itemStack) {
        return itemStack.method_57826((class_9331)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get());
    }

    public static boolean isHiddenItem(class_1799 appearanceItem) {
        return appearanceItem.method_31574((class_1792)ModItems.VOID_FRAGMENT.get());
    }

    public static void transmogAppearanceOntoItemStack(class_1799 appearanceItem, class_1799 itemToTransmog) {
        itemToTransmog.method_57379((class_9331)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get(), (Object)new TransmogAppearanceItem(appearanceItem));
    }

    public static class_1799 getAppearanceItemStack(class_1799 itemStack, boolean keepHiddenItem) {
        if (!itemStack.method_57826((class_9331)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get())) {
            return itemStack;
        }
        TransmogAppearanceItem appearanceItem = (TransmogAppearanceItem)itemStack.method_57824((class_9331)ModDataComponents.TRANSMOG_APPEARANCE_ITEM.get());
        if (appearanceItem == null) {
            return itemStack;
        }
        if (!keepHiddenItem && TransmogUtils.isHiddenItem(appearanceItem.itemStack())) {
            return class_1799.field_8037;
        }
        return appearanceItem.itemStack();
    }

    public static class_1799 getAppearanceStackOrOriginal(class_1799 itemStack) {
        if (notInPvP && Config.renderOption.renderInWorld && TransmogUtils.isItemStackTransmogged(itemStack)) {
            if (!RenderUtils.isCalledForInventory()) {
                return TransmogUtils.getAppearanceItemStack(itemStack, false);
            }
            if (Config.renderOption.renderInInventory) {
                class_1799 appearanceItemStack = TransmogUtils.getAppearanceItemStack(itemStack, true);
                if (TransmogUtils.isHiddenItem(appearanceItemStack)) {
                    return itemStack;
                }
                appearanceItemStack.method_7939(itemStack.method_7947());
                return appearanceItemStack;
            }
        }
        return itemStack;
    }
}

