/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.lunar.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mrbysco.lunar.LunarPhaseData;
import com.mrbysco.lunar.api.ILunarEvent;
import com.mrbysco.lunar.registry.LunarRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1324;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class LunarCommands {
    public static void initializeCommands(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder root = class_2170.method_9247((String)"lunar");
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"forceEvent").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"eventID", (ArgumentType)class_2232.method_9441()).suggests((cs, builder) -> class_2172.method_9265(LunarRegistry.instance().getIDList(), (SuggestionsBuilder)builder)).executes(ctx -> LunarCommands.forceEvent((CommandContext<class_2168>)ctx, false))).then(class_2170.method_9244((String)"forceCurrent", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> LunarCommands.forceEvent((CommandContext<class_2168>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"forceCurrent"))))));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"skip").executes(LunarCommands::skipEvent));
        ((LiteralArgumentBuilder)root.requires(sourceStack -> sourceStack.method_9259(2))).then(class_2170.method_9247((String)"randomize").executes(LunarCommands::randomizeEvent));
        dispatcher.register(root);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static int forceEvent(CommandContext<class_2168> ctx, boolean forceCurrent) {
        class_2960 eventID = class_2232.method_9443(ctx, (String)"eventID");
        class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(class_1937.field_25179);
        LunarPhaseData phaseData = LunarPhaseData.get((class_1937)level);
        ILunarEvent event = LunarRegistry.instance().getEventByID(eventID);
        if (event == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)("No lunar event found with ID: " + String.valueOf(eventID))));
            return 0;
        }
        if (!forceCurrent) {
            phaseData.setForcedEvent(event);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully forced a ").method_10852((class_2561)class_2561.method_43471((String)event.getTranslationKey()).method_27692(class_124.field_1065)).method_27693(" next night"), true);
            return 0;
        }
        int currentTime = (int)(level.method_8532() % 24000L);
        if (currentTime > 13000 && currentTime < 23000) {
            ILunarEvent activeEvent = phaseData.getActiveLunarEvent();
            if (activeEvent != null) {
                LunarCommands.stopEvent(level, activeEvent);
            }
            phaseData.setActiveEvent(event);
            phaseData.syncEvent((class_1937)level);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully forced a ").method_10852((class_2561)class_2561.method_43471((String)event.getTranslationKey()).method_27692(class_124.field_1065)).method_27693(" tonight"), true);
            return 0;
        }
        ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You can only force an event to occur at night!"));
        return 0;
    }

    private static int skipEvent(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(class_1937.field_25179);
        LunarPhaseData phaseData = LunarPhaseData.get((class_1937)level);
        ILunarEvent event = phaseData.getActiveLunarEvent();
        if (event == null) {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"There is no active lunar event to skip tonight!"));
            return 0;
        }
        LunarCommands.stopEvent(level, event);
        phaseData.setDefaultMoon();
        phaseData.syncEvent((class_1937)level);
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully skipped the lunar event for tonight"), true);
        return 0;
    }

    private static int randomizeEvent(CommandContext<class_2168> ctx) {
        class_3218 level = ((class_2168)ctx.getSource()).method_9211().method_3847(class_1937.field_25179);
        LunarPhaseData phaseData = LunarPhaseData.get((class_1937)level);
        int currentTime = (int)(level.method_8532() % 24000L);
        if (currentTime > 13000 && currentTime < 23000) {
            ILunarEvent event = phaseData.getActiveLunarEvent();
            if (event != null) {
                LunarCommands.stopEvent(level, event);
            }
        } else {
            ((class_2168)ctx.getSource()).method_9213((class_2561)class_2561.method_43470((String)"You can only randomize an event to occur at night!"));
            return 0;
        }
        phaseData.setRandomLunarEvent((class_1937)level);
        phaseData.syncEvent((class_1937)level);
        ILunarEvent newEvent = phaseData.getActiveLunarEvent();
        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Successfully randomized the lunar event for tonight to ").method_10852((class_2561)class_2561.method_43471((String)newEvent.getTranslationKey()).method_27692(class_124.field_1065)), true);
        return 0;
    }

    private static void stopEvent(@NotNull class_3218 level, @NotNull ILunarEvent event) {
        if (event.applyEntityEffect()) {
            level.method_27909().forEach(entity -> {
                if (entity.method_7325()) {
                    return;
                }
                event.removeEntityEffect((class_1297)entity);
            });
        }
        if (event.applyPlayerEffect()) {
            level.method_18456().forEach(event::removePlayerEffect);
        }
        for (Pair<class_6880<class_1320>, class_2960> modifierPair : LunarRegistry.instance().getEventModifiers()) {
            level.method_27909().forEach(entity -> {
                if (entity instanceof class_1309) {
                    class_1324 modifier;
                    class_1309 livingEntity = (class_1309)entity;
                    if (!entity.method_7325() && (modifier = livingEntity.method_5996((class_6880)modifierPair.getLeft())) != null) {
                        modifier.method_6200((class_2960)modifierPair.getRight());
                    }
                }
            });
        }
    }
}

