/*
 * Decompiled with CFR 0.152.
 */
package more_rpg_loot.compat.spell_engine;

import com.google.common.base.Suppliers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import more_rpg_loot.compat.spell_engine.LNE_RelicsConfig;
import more_rpg_loot.item.Group;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1322;
import net.minecraft.class_1792;
import net.minecraft.class_1814;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_9285;
import net.spell_engine.api.config.AttributeModifier;
import net.spell_engine.api.config.ConfigUtil;
import net.spell_engine.api.spell.SpellDataComponents;
import net.spell_engine.api.spell.container.SpellContainer;
import net.spell_engine.api.spell.container.SpellContainerHelper;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchools;
import org.jetbrains.annotations.Nullable;

public class LNE_Relics {
    public static final List<Entry> entries = new ArrayList<Entry>();
    public static Function<ItemArgs, class_1792> factory = args -> {
        class_1792.class_1793 settings = args.settings;
        if (args.attributes != null) {
            settings.method_57348(args.attributes);
        }
        return new class_1792(settings);
    };
    public static float spell_power = 0.05f;
    public static float attack_power = 0.05f;
    public static float haste = 0.05f;
    public static float crit_rate = 0.05f;
    public static float crit_damage = 0.1f;
    public static float armor = 2.0f;
    public static float health = 2.0f;
    public static float armor_toughness = 1.0f;
    public static final String RANGED_WEAPON_HASTE = "ranged_weapon:haste";
    public static final String RANGED_WEAPON_DAMAGE = "ranged_weapon:damage";
    public static final String WATER_SPELL_POWER = "spell_power:water";
    public static final Entry ENDER_DRAGON_TOOTH = LNE_Relics.add(new Entry(2, "ender_dragon_tooth")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23721.method_55840(), attack_power, class_1322.class_1323.field_6330))));
    public static final Entry CHARGED_AMETHYST = LNE_Relics.add(new Entry(2, "charged_amethyst")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellSchools.ARCANE.id, spell_power, class_1322.class_1323.field_6330))));
    public static final Entry CORRUPTED_ENDER_PEARL = LNE_Relics.add(new Entry(3, "corrupted_ender_pearl")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:enderman_teleport"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellPowerMechanics.CRITICAL_CHANCE.id, crit_rate, class_1322.class_1323.field_6330))));
    public static final Entry ENDER_DRAGON_SCALES = LNE_Relics.add(new Entry(4, "ender_dragon_scales")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:ender_dragon_scales"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23723.method_55840(), haste, class_1322.class_1323.field_6330))));
    public static final Entry UNKNOWN_REMAINS = LNE_Relics.add(new Entry(2, "unknown_remains")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier("ranged_weapon:haste", haste, class_1322.class_1323.field_6330))));
    public static final Entry LOST_SOUL = LNE_Relics.add(new Entry(2, "lost_soul")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellSchools.SOUL.id, spell_power, class_1322.class_1323.field_6330))));
    public static final Entry WITHERED_OBSIDIAN_SHARD = LNE_Relics.add(new Entry(3, "withered_obsidian_shard")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:wither_touch"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23725.method_55840(), armor_toughness, class_1322.class_1323.field_6328))));
    public static final Entry WITHER_SPINE = LNE_Relics.add(new Entry(4, "wither_spine")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:wither_spine"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23724.method_55840(), armor, class_1322.class_1323.field_6328))));
    public static final Entry ETERNAL_SNOWFLAKE = LNE_Relics.add(new Entry(2, "eternal_snowflake")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellSchools.FROST.id, spell_power, class_1322.class_1323.field_6330))));
    public static final Entry GLACIER_SHARD = LNE_Relics.add(new Entry(2, "glacier_shard")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23724.method_55840(), armor, class_1322.class_1323.field_6328))));
    public static final Entry FROZEN_RIB = LNE_Relics.add(new Entry(3, "frozen_rib")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:frozen_touch"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellPowerMechanics.HASTE.id, haste, class_1322.class_1323.field_6330))));
    public static final Entry FROZEN_SOUL = LNE_Relics.add(new Entry(4, "frozen_soul")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:frozen_soul"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellSchools.FROST.id, spell_power, class_1322.class_1323.field_6330))));
    public static final Entry AMPHITRITE_DIADEM = LNE_Relics.add(new Entry(2, "amphitrite_diadem")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier("spell_power:water", spell_power, class_1322.class_1323.field_6330))));
    public static final Entry RAINBOW_CORAL = LNE_Relics.add(new Entry(2, "rainbow_coral")).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(SpellPowerMechanics.HASTE.id, haste, class_1322.class_1323.field_6330))));
    public static final Entry POSEIDONS_AMPHORA = LNE_Relics.add(new Entry(3, "poseidons_amphora")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:poseidons_grace"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier(class_5134.field_23716.method_55840(), health, class_1322.class_1323.field_6328))));
    public static final Entry ELDER_GUARDIAN_EYE = LNE_Relics.add(new Entry(4, "elder_guardian_eye")).spell(SpellContainerHelper.createForRelic((class_2960)class_2960.method_60654((String)"loot_n_explore:elder_guardian_eye"))).config(new LNE_RelicsConfig.Entry().withAttributes(List.of(new AttributeModifier("ranged_weapon:damage", spell_power, class_1322.class_1323.field_6330))));

    public static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Function<ItemArgs, class_1792> getFactory() {
        return factory;
    }

    public static void register(Map<String, LNE_RelicsConfig.Entry> config) {
        for (Entry entry : entries) {
            String key = entry.id().toString();
            LNE_RelicsConfig.Entry configEntry = config.get(key);
            if (configEntry != null) {
                entry.config(configEntry);
                continue;
            }
            config.put(key, entry.config());
        }
        for (Entry entry : entries) {
            if (!entry.isEnabled()) continue;
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)entry.id(), (Object)entry.item().get());
        }
        ItemGroupEvents.modifyEntriesEvent(Group.RPG_LOOT_KEY).register(content -> {
            for (Entry entry : entries) {
                if (!entry.isEnabled()) continue;
                content.method_45421((class_1935)entry.item().get());
            }
        });
    }

    public static final class Entry {
        private final int tier;
        private final String name;
        private LNE_RelicsConfig.Entry config;
        public LNE_RelicsConfig.Entry defaults;
        private final Supplier<class_1792> item;
        private SpellContainer spellContainer;

        public Entry(int tier, String name) {
            this(tier, name, LNE_RelicsConfig.Entry.EMPTY);
        }

        public Entry(int tier, String name, LNE_RelicsConfig.Entry config) {
            this.tier = tier;
            this.name = name;
            this.config = config;
            this.defaults = config;
            this.item = Suppliers.memoize(() -> {
                class_1814 rarity;
                class_1792.class_1793 settings = new class_1792.class_1793().method_7889(1);
                class_9285 attributes = this.config().attributes != null && !this.config().attributes.isEmpty() ? ConfigUtil.attributesComponent((class_2960)class_2960.method_60655((String)"loot_n_explore", (String)name), this.config().attributes).method_57486() : null;
                SpellContainer spellContainer = this.spellContainer();
                if (spellContainer != null) {
                    settings = settings.method_57349(SpellDataComponents.SPELL_CONTAINER, (Object)spellContainer);
                }
                if (this.config().durability > 0) {
                    settings = settings.method_7895(this.config().durability);
                }
                if ((rarity = Entry.rarityFrom(tier)) != class_1814.field_8906) {
                    settings = settings.method_7894(rarity);
                }
                return LNE_Relics.getFactory().apply(new ItemArgs(settings, attributes));
            });
        }

        private static class_1814 rarityFrom(int tier) {
            return switch (tier) {
                case 0, 1 -> class_1814.field_8906;
                case 2 -> class_1814.field_8907;
                case 3 -> class_1814.field_8903;
                default -> class_1814.field_8904;
            };
        }

        public int tier() {
            return this.tier;
        }

        public class_2960 id() {
            return class_2960.method_60655((String)"loot_n_explore", (String)this.name);
        }

        public String name() {
            return this.name;
        }

        public LNE_RelicsConfig.Entry config() {
            return this.config;
        }

        public Supplier<class_1792> item() {
            return this.item;
        }

        @Nullable
        public SpellContainer spellContainer() {
            return this.spellContainer;
        }

        public Entry config(LNE_RelicsConfig.Entry config) {
            this.config = config;
            return this;
        }

        public Entry spell(SpellContainer spellContainer) {
            this.spellContainer = spellContainer;
            return this;
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public record ItemArgs(class_1792.class_1793 settings, @Nullable class_9285 attributes) {
    }
}

