/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.widget;

import com.google.common.collect.Lists;
import dev.emi.emi.EmiPort;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.bom.BoM;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.HelpLevel;
import dev.emi.emi.runtime.EmiHistory;
import dev.emi.emi.screen.RecipeScreen;
import dev.emi.emi.screen.tooltip.IngredientTooltipComponent;
import dev.emi.emi.widget.RecipeButtonWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_5481;
import net.minecraft.class_5684;

public class RecipeDefaultButtonWidget
extends RecipeButtonWidget {
    public RecipeDefaultButtonWidget(int x, int y, EmiRecipe recipe) {
        super(x, y, 48, 0, recipe);
    }

    @Override
    public int getTextureOffset(int mouseX, int mouseY) {
        int v = super.getTextureOffset(mouseX, mouseY);
        return v += (switch (BoM.getRecipeStatus(this.recipe)) {
            default -> throw new MatchException(null, null);
            case BoM.DefaultStatus.EMPTY -> 0;
            case BoM.DefaultStatus.PARTIAL -> 60;
            case BoM.DefaultStatus.FULL -> 36;
        });
    }

    @Override
    public List<class_5684> getTooltip(int mouseX, int mouseY) {
        ArrayList list = Lists.newArrayList();
        switch (BoM.getRecipeStatus(this.recipe)) {
            case PARTIAL: {
                ArrayList stacks = Lists.newArrayList();
                for (EmiStack stack : this.recipe.getOutputs()) {
                    if (BoM.getRecipe(stack) != this.recipe) continue;
                    stacks.add(stack);
                }
                if (stacks.size() > 0) {
                    list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable("tooltip.emi.set_default"))));
                    list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable("tooltip.emi.current_defaults"))));
                    list.add(new IngredientTooltipComponent(stacks));
                    break;
                }
            }
            case EMPTY: {
                list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable("tooltip.emi.set_default"))));
                break;
            }
            case FULL: {
                list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable("tooltip.emi.unset_default"))));
            }
        }
        if (this.recipe.getOutputs().size() > 1 && EmiConfig.helpLevel.has(HelpLevel.NORMAL) && EmiConfig.defaultStack.isBound()) {
            list.add(class_5684.method_32662((class_5481)EmiPort.ordered((class_2561)EmiPort.translatable("tooltip.emi.set_default_stack", EmiConfig.defaultStack.getBindText()))));
        }
        return list;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (BoM.getRecipeStatus(this.recipe) == BoM.DefaultStatus.FULL) {
            BoM.removeRecipe(this.recipe);
        } else {
            BoM.addRecipe(this.recipe);
        }
        this.playButtonSound();
        if (RecipeScreen.resolve != null) {
            EmiHistory.pop();
        }
        return true;
    }
}

