/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntLists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_9283;
import net.minecraft.class_9334;

public class EmiFireworkStarFadeRecipe
extends EmiPatternCraftingRecipe {
    private static final List<class_1769> DYES = Stream.of(class_1767.values()).map(class_1769::method_7803).toList();

    public EmiFireworkStarFadeRecipe(class_2960 id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of((class_1935)i)).collect(Collectors.toList())), EmiStack.of((class_1935)class_1802.field_8450)), EmiStack.of((class_1935)class_1802.field_8450), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            EmiStack fireworkStar = this.getFireworkStar((Random)r, false);
            List<class_1769> dyeItems = this.getDyes((Random)r, 8);
            int s = slot - 1;
            if (slot == 0) {
                return fireworkStar;
            }
            if (s < dyeItems.size()) {
                return EmiStack.of((class_1935)dyeItems.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getFireworkStar((Random)r, true), this.unique, x, y);
    }

    private List<class_1769> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private EmiStack getFireworkStar(Random random, Boolean faded) {
        IntList fadedColors;
        class_1799 stack = new class_1799((class_1935)class_1802.field_8450);
        int items = 0;
        int amount = random.nextInt(5);
        class_9283.class_1782 type = class_9283.class_1782.values()[random.nextInt(class_9283.class_1782.values().length)];
        if (amount != 0) {
            ++items;
        }
        amount = random.nextInt(4);
        boolean flicker = false;
        boolean trail = false;
        if (amount == 0) {
            flicker = true;
            ++items;
        } else if (amount == 1) {
            trail = true;
            ++items;
        } else if (amount == 2) {
            flicker = true;
            trail = true;
            items += 2;
        }
        List<class_1769> dyeItems = this.getDyes(random, 8 - items);
        IntArrayList colors = new IntArrayList();
        for (class_1769 dyeItem : dyeItems) {
            colors.add(dyeItem.method_7802().method_7790());
        }
        if (faded.booleanValue()) {
            List<class_1769> dyeItemsFaded = this.getDyes(random, 8);
            fadedColors = new IntArrayList();
            for (class_1769 dyeItem : dyeItemsFaded) {
                fadedColors.add(dyeItem.method_7802().method_7790());
            }
        } else {
            fadedColors = IntLists.emptyList();
        }
        class_9283 component = new class_9283(type, (IntList)colors, fadedColors, trail, flicker);
        stack.method_57379(class_9334.field_49615, (Object)component);
        return EmiStack.of(stack);
    }
}

