/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi;

import com.google.common.collect.BiMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiRenderHelper;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiInitRegistry;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.EmiRecipeSorting;
import dev.emi.emi.api.recipe.EmiWorldInteractionRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiRenderable;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.Comparison;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.FluidEmiStack;
import dev.emi.emi.api.stack.ItemEmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.config.EffectLocation;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.config.FluidUnit;
import dev.emi.emi.handler.CookingRecipeHandler;
import dev.emi.emi.handler.CraftingRecipeHandler;
import dev.emi.emi.handler.InventoryRecipeHandler;
import dev.emi.emi.handler.StonecuttingRecipeHandler;
import dev.emi.emi.mixin.accessor.AxeItemAccessor;
import dev.emi.emi.mixin.accessor.HandledScreenAccessor;
import dev.emi.emi.mixin.accessor.HoeItemAccessor;
import dev.emi.emi.mixin.accessor.ShovelItemAccessor;
import dev.emi.emi.mixin.accessor.SmithingTransformRecipeAccessor;
import dev.emi.emi.mixin.accessor.SmithingTrimRecipeAccessor;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.platform.EmiClient;
import dev.emi.emi.recipe.EmiAnvilRecipe;
import dev.emi.emi.recipe.EmiCompostingRecipe;
import dev.emi.emi.recipe.EmiCookingRecipe;
import dev.emi.emi.recipe.EmiFuelRecipe;
import dev.emi.emi.recipe.EmiGrindstoneRecipe;
import dev.emi.emi.recipe.EmiShapedRecipe;
import dev.emi.emi.recipe.EmiShapelessRecipe;
import dev.emi.emi.recipe.EmiSmithingRecipe;
import dev.emi.emi.recipe.EmiStonecuttingRecipe;
import dev.emi.emi.recipe.EmiTagRecipe;
import dev.emi.emi.recipe.special.EmiAnvilEnchantRecipe;
import dev.emi.emi.recipe.special.EmiAnvilRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiArmorDyeRecipe;
import dev.emi.emi.recipe.special.EmiBannerDuplicateRecipe;
import dev.emi.emi.recipe.special.EmiBannerShieldRecipe;
import dev.emi.emi.recipe.special.EmiBookCloningRecipe;
import dev.emi.emi.recipe.special.EmiFireworkRocketRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarFadeRecipe;
import dev.emi.emi.recipe.special.EmiFireworkStarRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingBookRecipe;
import dev.emi.emi.recipe.special.EmiGrindstoneDisenchantingRecipe;
import dev.emi.emi.recipe.special.EmiMapCloningRecipe;
import dev.emi.emi.recipe.special.EmiRepairItemRecipe;
import dev.emi.emi.recipe.special.EmiSmithingTrimRecipe;
import dev.emi.emi.recipe.special.EmiSuspiciousStewRecipe;
import dev.emi.emi.registry.EmiTags;
import dev.emi.emi.runtime.EmiDrawContext;
import dev.emi.emi.runtime.EmiLog;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.stack.serializer.FluidEmiStackSerializer;
import dev.emi.emi.stack.serializer.ItemEmiStackSerializer;
import dev.emi.emi.stack.serializer.ListEmiIngredientSerializer;
import dev.emi.emi.stack.serializer.TagEmiIngredientSerializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1747;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1848;
import net.minecraft.class_1849;
import net.minecraft.class_1850;
import net.minecraft.class_1851;
import net.minecraft.class_1852;
import net.minecraft.class_1853;
import net.minecraft.class_1854;
import net.minecraft.class_1855;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1861;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_1871;
import net.minecraft.class_1872;
import net.minecraft.class_1873;
import net.minecraft.class_1874;
import net.minecraft.class_1876;
import net.minecraft.class_1887;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2480;
import net.minecraft.class_2521;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3489;
import net.minecraft.class_3609;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3859;
import net.minecraft.class_3861;
import net.minecraft.class_3862;
import net.minecraft.class_3917;
import net.minecraft.class_3920;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_3962;
import net.minecraft.class_3975;
import net.minecraft.class_4317;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_5321;
import net.minecraft.class_5953;
import net.minecraft.class_5955;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_8059;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import net.minecraft.class_9636;
import net.minecraft.class_9695;

@EmiEntrypoint
public class VanillaPlugin
implements EmiPlugin {
    public static EmiRecipeCategory TAG = new EmiRecipeCategory(EmiPort.id("emi:tag"), EmiStack.of((class_1935)class_1802.field_8448), VanillaPlugin.simplifiedRenderer(240, 208), EmiRecipeSorting.none());
    public static EmiRecipeCategory INGREDIENT = new EmiRecipeCategory(EmiPort.id("emi:ingredient"), EmiStack.of((class_1935)class_1802.field_8251), VanillaPlugin.simplifiedRenderer(240, 208));
    public static EmiRecipeCategory RESOLUTION = new EmiRecipeCategory(EmiPort.id("emi:resolution"), EmiStack.of((class_1935)class_1802.field_8251), VanillaPlugin.simplifiedRenderer(240, 208));

    @Override
    public void initialize(EmiInitRegistry registry) {
        registry.addIngredientSerializer(ItemEmiStack.class, new ItemEmiStackSerializer());
        registry.addIngredientSerializer(FluidEmiStack.class, new FluidEmiStackSerializer());
        registry.addIngredientSerializer(TagEmiIngredient.class, new TagEmiIngredientSerializer());
        registry.addIngredientSerializer(ListEmiIngredient.class, new ListEmiIngredientSerializer());
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(class_1792.class, EmiPort.getItemRegistry(), EmiStack::of));
        registry.addRegistryAdapter(EmiRegistryAdapter.simple(class_3611.class, EmiPort.getFluidRegistry(), EmiStack::of));
    }

    @Override
    public void register(EmiRegistry registry) {
        registry.addCategory(VanillaEmiRecipeCategories.CRAFTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMELTING);
        registry.addCategory(VanillaEmiRecipeCategories.BLASTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMOKING);
        registry.addCategory(VanillaEmiRecipeCategories.CAMPFIRE_COOKING);
        registry.addCategory(VanillaEmiRecipeCategories.STONECUTTING);
        registry.addCategory(VanillaEmiRecipeCategories.SMITHING);
        registry.addCategory(VanillaEmiRecipeCategories.ANVIL_REPAIRING);
        registry.addCategory(VanillaEmiRecipeCategories.GRINDING);
        registry.addCategory(VanillaEmiRecipeCategories.BREWING);
        registry.addCategory(VanillaEmiRecipeCategories.WORLD_INTERACTION);
        registry.addCategory(VanillaEmiRecipeCategories.FUEL);
        registry.addCategory(VanillaEmiRecipeCategories.COMPOSTING);
        registry.addCategory(VanillaEmiRecipeCategories.INFO);
        registry.addCategory(TAG);
        registry.addCategory(INGREDIENT);
        registry.addCategory(RESOLUTION);
        registry.addWorkstation(VanillaEmiRecipeCategories.CRAFTING, EmiStack.of((class_1935)class_1802.field_8465));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMELTING, EmiStack.of((class_1935)class_1802.field_8732));
        registry.addWorkstation(VanillaEmiRecipeCategories.BLASTING, EmiStack.of((class_1935)class_1802.field_16306));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMOKING, EmiStack.of((class_1935)class_1802.field_16309));
        registry.addWorkstation(VanillaEmiRecipeCategories.CAMPFIRE_COOKING, EmiStack.of((class_1935)class_1802.field_17346));
        registry.addWorkstation(VanillaEmiRecipeCategories.CAMPFIRE_COOKING, EmiStack.of((class_1935)class_1802.field_23842));
        registry.addWorkstation(VanillaEmiRecipeCategories.STONECUTTING, EmiStack.of((class_1935)class_1802.field_16305));
        registry.addWorkstation(VanillaEmiRecipeCategories.SMITHING, EmiStack.of((class_1935)class_1802.field_16308));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((class_1935)class_1802.field_8782));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((class_1935)class_1802.field_8750));
        registry.addWorkstation(VanillaEmiRecipeCategories.ANVIL_REPAIRING, EmiStack.of((class_1935)class_1802.field_8427));
        registry.addWorkstation(VanillaEmiRecipeCategories.BREWING, EmiStack.of((class_1935)class_1802.field_8740));
        registry.addWorkstation(VanillaEmiRecipeCategories.GRINDING, EmiStack.of((class_1935)class_1802.field_16311));
        registry.addWorkstation(VanillaEmiRecipeCategories.COMPOSTING, EmiStack.of((class_1935)class_1802.field_17530));
        registry.addRecipeHandler(null, new InventoryRecipeHandler());
        registry.addRecipeHandler(class_3917.field_17333, new CraftingRecipeHandler());
        registry.addRecipeHandler(class_3917.field_17335, new CookingRecipeHandler(VanillaEmiRecipeCategories.SMELTING));
        registry.addRecipeHandler(class_3917.field_17331, new CookingRecipeHandler(VanillaEmiRecipeCategories.BLASTING));
        registry.addRecipeHandler(class_3917.field_17342, new CookingRecipeHandler(VanillaEmiRecipeCategories.SMOKING));
        registry.addRecipeHandler(class_3917.field_17625, new StonecuttingRecipeHandler());
        registry.addExclusionArea(class_481.class, (screen, consumer) -> {
            int left = ((HandledScreenAccessor)screen).getX();
            int top = ((HandledScreenAccessor)screen).getY();
            int width = ((HandledScreenAccessor)screen).getBackgroundWidth();
            int bottom = top + ((HandledScreenAccessor)screen).getBackgroundHeight();
            consumer.accept(new Bounds(left, top - 28, width, 28));
            consumer.accept(new Bounds(left, bottom, width, 28));
        });
        registry.addGenericExclusionArea((screen, consumer) -> {
            if (EmiConfig.effectLocation != EffectLocation.HIDDEN && screen instanceof class_485) {
                class_485 inv = (class_485)screen;
                class_310 client = class_310.method_1551();
                Collection collection = client.field_1724.method_6026();
                if (!collection.isEmpty()) {
                    int right;
                    int rightWidth;
                    int k = 33;
                    if (collection.size() > 5) {
                        k = 132 / (collection.size() - 1);
                    }
                    if ((rightWidth = inv.field_22789 - (right = ((HandledScreenAccessor)inv).getX() + ((HandledScreenAccessor)inv).getBackgroundWidth() + 2)) >= 32) {
                        int left;
                        int width;
                        int top = ((HandledScreenAccessor)inv).getY();
                        int height = (collection.size() - 1) * k + 32;
                        if (EmiConfig.effectLocation == EffectLocation.TOP) {
                            int size = collection.size();
                            top = ((HandledScreenAccessor)inv).getY() - 34;
                            if (screen instanceof class_481) {
                                top -= 28;
                                if (EmiAgnos.isForge()) {
                                    top -= 22;
                                }
                            }
                            int xOff = 34;
                            if (size == 1) {
                                xOff = 122;
                            } else if (size > 5) {
                                xOff = (((HandledScreenAccessor)inv).getBackgroundWidth() - 32) / (size - 1);
                            }
                            width = Math.max(122, (size - 1) * xOff + 32);
                            left = ((HandledScreenAccessor)inv).getX() + (((HandledScreenAccessor)inv).getBackgroundWidth() - width) / 2;
                            height = 32;
                        } else {
                            left = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT_COMPRESSED -> ((HandledScreenAccessor)inv).getX() - 2 - 32;
                                case EffectLocation.LEFT -> ((HandledScreenAccessor)inv).getX() - 2 - 120;
                                default -> right;
                            };
                            width = switch (EmiConfig.effectLocation) {
                                case EffectLocation.LEFT, EffectLocation.RIGHT -> 120;
                                case EffectLocation.LEFT_COMPRESSED, EffectLocation.RIGHT_COMPRESSED -> 32;
                                default -> 32;
                            };
                        }
                        consumer.accept(new Bounds(left, top, width, height));
                    }
                }
            }
        });
        Comparison potionComparison = Comparison.compareData(stack -> (class_1844)stack.get(class_9334.field_49651));
        registry.setDefaultComparison((Object)class_1802.field_8574, potionComparison);
        registry.setDefaultComparison((Object)class_1802.field_8436, potionComparison);
        registry.setDefaultComparison((Object)class_1802.field_8150, potionComparison);
        registry.setDefaultComparison((Object)class_1802.field_8087, potionComparison);
        registry.setDefaultComparison((Object)class_1802.field_8598, EmiPort.compareStrict());
        Set hiddenItems = Stream.concat(EmiUtil.values(class_6862.method_40092((class_5321)EmiPort.getItemRegistry().method_30517(), (class_2960)EmiTags.HIDDEN_FROM_RECIPE_VIEWERS)).map(class_6880::comp_349), EmiPort.getDisabledItems()).collect(Collectors.toSet());
        List dyeableItems = EmiUtil.values(class_3489.field_48803).map(class_6880::comp_349).collect(Collectors.toList());
        for (class_3955 class_39552 : VanillaPlugin.getRecipes(registry, class_3956.field_17545)) {
            class_2960 id = EmiPort.getId(class_39552);
            if (class_39552 instanceof class_1861) {
                class_1861 map = (class_1861)class_39552;
                EmiStack paper = EmiStack.of((class_1935)class_1802.field_8407);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(paper, paper, paper, paper, EmiStack.of((class_1935)class_1802.field_8204), paper, paper, paper, paper), EmiStack.of((class_1935)class_1802.field_8204), id, false), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1869) {
                class_1869 shaped = (class_1869)class_39552;
                if (class_39552.method_8113(3, 3)) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapedRecipe(shaped), class_39552);
                    continue;
                }
            }
            if (class_39552 instanceof class_1867) {
                class_1867 shapeless = (class_1867)class_39552;
                if (class_39552.method_8113(3, 3)) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiShapelessRecipe(shapeless), class_39552);
                    continue;
                }
            }
            if (class_39552 instanceof class_1849) {
                class_1849 dye = (class_1849)class_39552;
                for (class_1792 i : dyeableItems) {
                    if (hiddenItems.contains(i)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiArmorDyeRecipe(i, VanillaPlugin.synthetic("crafting/dying", EmiUtil.subId(i))), class_39552);
                }
                continue;
            }
            if (class_39552 instanceof class_1873) {
                class_1873 stew = (class_1873)class_39552;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiSuspiciousStewRecipe(id), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1871) {
                class_1871 shulker = (class_1871)class_39552;
                for (class_1767 dye : class_1767.values()) {
                    class_1769 dyeItem = class_1769.method_7803((class_1767)dye);
                    class_2960 sid = VanillaPlugin.synthetic("crafting/shulker_box_dying", EmiUtil.subId((class_1792)dyeItem));
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(EmiStack.of((class_1935)class_1802.field_8545), EmiStack.of((class_1935)dyeItem)), EmiStack.of(class_2480.method_10529((class_1767)dye)), sid), class_39552);
                }
                continue;
            }
            if (class_39552 instanceof class_1872) {
                class_1872 shield = (class_1872)class_39552;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiBannerShieldRecipe(id), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1850) {
                class_1850 book = (class_1850)class_39552;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiBookCloningRecipe(id), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1876) {
                class_1876 tipped = (class_1876)class_39552;
                EmiPort.getPotionRegistry().method_40270().forEach(entry -> {
                    EmiStack arrow = EmiStack.of((class_1935)class_1802.field_8107);
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(List.of(arrow, arrow, arrow, arrow, EmiStack.of(EmiPort.setPotion(new class_1799((class_1935)class_1802.field_8150), (class_1842)entry.comp_349())), arrow, arrow, arrow, arrow), EmiStack.of(EmiPort.setPotion(new class_1799((class_1935)class_1802.field_8087, 8), (class_1842)entry.comp_349())), VanillaPlugin.synthetic("crafting/tipped_arrow", EmiUtil.subId(EmiPort.getPotionRegistry().method_10221((Object)((class_1842)entry.comp_349())))), false), recipe);
                });
                continue;
            }
            if (class_39552 instanceof class_1853) {
                class_1853 star = (class_1853)class_39552;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarRecipe(id), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1854) {
                class_1854 star = (class_1854)class_39552;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkStarFadeRecipe(id), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1851) {
                class_1851 rocket = (class_1851)class_39552;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiFireworkRocketRecipe(id), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1848) {
                class_1848 banner = (class_1848)class_39552;
                for (class_1792 i : EmiBannerDuplicateRecipe.BANNERS) {
                    if (hiddenItems.contains(i)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiBannerDuplicateRecipe(i, VanillaPlugin.synthetic("crafting/banner_copying", EmiUtil.subId(i))), class_39552);
                }
                continue;
            }
            if (class_39552 instanceof class_4317) {
                class_4317 tool = (class_4317)class_39552;
                for (class_1792 i : EmiRepairItemRecipe.TOOLS) {
                    if (hiddenItems.contains(i)) continue;
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiRepairItemRecipe(i, VanillaPlugin.synthetic("crafting/repairing", EmiUtil.subId(i))), class_39552);
                }
                continue;
            }
            if (class_39552 instanceof class_1855) {
                class_1855 map = (class_1855)class_39552;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiMapCloningRecipe(id), class_39552);
                continue;
            }
            if (class_39552 instanceof class_1852) continue;
            try {
                ArrayList input;
                boolean shapeless;
                if (class_39552.method_8117().isEmpty() || EmiPort.getOutput(class_39552).method_7960() || !class_39552.method_8113(3, 3)) continue;
                boolean bl = shapeless = class_39552.method_8113(1, class_39552.method_8117().size()) && class_39552.method_8113(class_39552.method_8117().size(), 1);
                if (shapeless) {
                    input = class_39552.method_8117().stream().map(EmiIngredient::of).toList();
                } else {
                    int width = class_39552.method_8113(2, 3) ? (class_39552.method_8113(1, 3) ? 1 : 2) : 3;
                    input = Lists.newArrayList();
                    for (int i = 0; i < class_39552.method_8117().size(); ++i) {
                        input.add(EmiIngredient.of((class_1856)class_39552.method_8117().get(i)));
                        if ((i + 1) % width != 0) continue;
                        for (int j = width; j < 3; ++j) {
                            input.add(EmiStack.EMPTY);
                        }
                    }
                }
                EmiShapedRecipe.setRemainders(input, class_39552);
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiCraftingRecipe(input, EmiStack.of(EmiPort.getOutput(recipe)), id, shapeless));
            }
            catch (Exception e) {
                EmiReloadLog.warn("Exception when parsing vanilla crafting recipe " + String.valueOf(id), e);
            }
        }
        for (class_3861 class_38612 : VanillaPlugin.getRecipes(registry, class_3956.field_17546)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((class_1874)class_38612, VanillaEmiRecipeCategories.SMELTING, 1, false), class_38612);
        }
        for (class_3859 class_38592 : VanillaPlugin.getRecipes(registry, class_3956.field_17547)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((class_1874)class_38592, VanillaEmiRecipeCategories.BLASTING, 2, false), class_38592);
        }
        for (class_3862 class_38622 : VanillaPlugin.getRecipes(registry, class_3956.field_17548)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((class_1874)class_38622, VanillaEmiRecipeCategories.SMOKING, 2, false), class_38622);
        }
        for (class_3920 class_39202 : VanillaPlugin.getRecipes(registry, class_3956.field_17549)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiCookingRecipe((class_1874)class_39202, VanillaEmiRecipeCategories.CAMPFIRE_COOKING, 1, true), class_39202);
        }
        for (class_8059 class_80592 : VanillaPlugin.getRecipes(registry, class_3956.field_25388)) {
            class_310 client = class_310.method_1551();
            if (class_80592 instanceof SmithingTransformRecipeAccessor) {
                SmithingTransformRecipeAccessor stra = (SmithingTransformRecipeAccessor)class_80592;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiSmithingRecipe(EmiIngredient.of(stra.getTemplate()), EmiIngredient.of(stra.getBase()), EmiIngredient.of(stra.getAddition()), EmiStack.of(EmiPort.getOutput(class_80592)), EmiPort.getId(class_80592)), class_80592);
                continue;
            }
            if (!(class_80592 instanceof SmithingTrimRecipeAccessor)) continue;
            SmithingTrimRecipeAccessor stra = (SmithingTrimRecipeAccessor)class_80592;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiSmithingTrimRecipe(EmiIngredient.of(stra.getTemplate()), EmiIngredient.of(stra.getBase()), EmiIngredient.of(stra.getAddition()), EmiStack.of(EmiPort.getOutput(class_80592)), class_80592), class_80592);
        }
        for (class_3975 class_39752 : VanillaPlugin.getRecipes(registry, class_3956.field_17641)) {
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiStonecuttingRecipe(class_39752), class_39752);
        }
        VanillaPlugin.safely("repair", () -> VanillaPlugin.addRepair(registry, hiddenItems));
        VanillaPlugin.safely("brewing", () -> EmiAgnos.addBrewingRecipes(registry));
        VanillaPlugin.safely("world interaction", () -> VanillaPlugin.addWorldInteraction(registry, hiddenItems, dyeableItems));
        VanillaPlugin.safely("fuel", () -> VanillaPlugin.addFuel(registry, hiddenItems));
        VanillaPlugin.safely("composting", () -> VanillaPlugin.addComposting(registry, hiddenItems));
        for (class_6862 class_68622 : EmiTags.TAGS) {
            if (new TagEmiIngredient(class_68622, 1L).getEmiStacks().size() <= 1) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> new EmiTagRecipe(key));
        }
    }

    private static void addRepair(EmiRegistry registry, Set<class_1792> hiddenItems) {
        ArrayList targetedEnchantments = Lists.newArrayList();
        ArrayList universalEnchantments = Lists.newArrayList();
        for (class_1887 enchantment : EmiPort.getEnchantmentRegistry().method_10220().toList()) {
            try {
                if (enchantment.method_8192(class_1799.field_8037)) {
                    universalEnchantments.add(enchantment);
                    continue;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            targetedEnchantments.add(enchantment);
        }
        for (class_1792 i : EmiPort.getItemRegistry()) {
            class_2521 tf;
            class_1747 bi;
            class_2248 consumer;
            if (hiddenItems.contains(i)) continue;
            try {
                if ((Integer)i.method_57347().method_57830(class_9334.field_50072, (Object)0) > 0) {
                    class_1831 ti;
                    class_1738 ai;
                    if (i instanceof class_1738 && (ai = (class_1738)i).method_7686() != null && ((class_1741)ai.method_7686().comp_349()).comp_2301().get() != null && !((class_1856)((class_1741)ai.method_7686().comp_349()).comp_2301().get()).method_8103()) {
                        id = VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(i) + "/" + EmiUtil.subId(((class_1856)((class_1741)ai.method_7686().comp_349()).comp_2301().get()).method_8105()[0].method_7909()));
                        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((class_1935)i), EmiIngredient.of((class_1856)((class_1741)ai.method_7686().comp_349()).comp_2301().get()), id));
                    } else if (i instanceof class_1831 && (ti = (class_1831)i).method_8022().method_8023() != null && !ti.method_8022().method_8023().method_8103()) {
                        id = VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(i) + "/" + EmiUtil.subId(ti.method_8022().method_8023().method_8105()[0].method_7909()));
                        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((class_1935)i), EmiIngredient.of(ti.method_8022().method_8023()), id));
                    }
                }
                if ((Integer)i.method_57347().method_57830(class_9334.field_50072, (Object)0) > 0) {
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRepairItemRecipe(i, VanillaPlugin.synthetic("anvil/repairing/tool", EmiUtil.subId(i))));
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneRecipe(i, VanillaPlugin.synthetic("grindstone/repairing", EmiUtil.subId(i))));
                }
            }
            catch (Throwable t) {
                EmiLog.error("Exception thrown registering repair recipes", t);
            }
            try {
                class_1799 defaultStack = i.method_7854();
                int acceptableEnchantments = 0;
                consumer = e -> {
                    int max = e.method_8183();
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilEnchantRecipe(i, (class_1887)e, max, VanillaPlugin.synthetic("anvil/enchanting", EmiUtil.subId(i) + "/" + EmiUtil.subId(EmiPort.getEnchantmentRegistry().method_10221(e)) + "/" + max)));
                };
                for (class_1887 e2 : targetedEnchantments) {
                    if (!e2.method_8192(defaultStack)) continue;
                    consumer.accept(e2);
                    ++acceptableEnchantments;
                }
                if (acceptableEnchantments > 0) {
                    for (class_1887 e2 : universalEnchantments) {
                        if (!e2.method_8192(defaultStack)) continue;
                        consumer.accept(e2);
                        ++acceptableEnchantments;
                    }
                    VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneDisenchantingRecipe(i, VanillaPlugin.synthetic("grindstone/disenchanting/tool", EmiUtil.subId(i))));
                }
            }
            catch (Throwable t) {
                EmiReloadLog.warn("Exception thrown registering enchantment recipes", t);
            }
            if (!(i instanceof class_1747) || !((consumer = (bi = (class_1747)i).method_7711()) instanceof class_2521) || !EmiPort.canTallFlowerDuplicate(tf = (class_2521)consumer)) continue;
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)bi).setRemainder(EmiStack.of((class_1935)bi)), EmiStack.of((class_1935)class_1802.field_8324), EmiStack.of((class_1935)i), VanillaPlugin.synthetic("world/flower_duping", EmiUtil.subId(i)), false));
        }
        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((class_1935)class_1802.field_8833), EmiStack.of((class_1935)class_1802.field_8614), VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(class_1802.field_8833) + "/" + EmiUtil.subId(class_1802.field_8614))));
        VanillaPlugin.addRecipeSafe(registry, () -> new EmiAnvilRecipe(EmiStack.of((class_1935)class_1802.field_8255), EmiIngredient.of(class_3489.field_15537), VanillaPlugin.synthetic("anvil/repairing/material", EmiUtil.subId(class_1802.field_8255) + "/" + EmiUtil.subId(class_1802.field_8118))));
        for (class_1887 e3 : EmiPort.getEnchantmentRegistry().method_10220().toList()) {
            if (EmiPort.getEnchantmentRegistry().method_47983((Object)e3).method_40220(class_9636.field_51551)) continue;
            int max = Math.min(10, e3.method_8183());
            int min = e3.method_8187();
            while (min <= max) {
                int level = min++;
                VanillaPlugin.addRecipeSafe(registry, () -> new EmiGrindstoneDisenchantingBookRecipe(e3, level, VanillaPlugin.synthetic("grindstone/disenchanting/book", EmiUtil.subId(EmiPort.getEnchantmentRegistry().method_10221((Object)e3)) + "/" + level)));
            }
        }
    }

    private static void addWorldInteraction(EmiRegistry registry, Set<class_1792> hiddenItems, List<class_1792> dyeableItems) {
        class_2960 id;
        Object id2;
        EmiStack concreteWater = EmiStack.of((class_3611)class_3612.field_15910);
        concreteWater.setRemainder(concreteWater);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10197, concreteWater, class_2246.field_10107);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10022, concreteWater, class_2246.field_10210);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10300, concreteWater, class_2246.field_10585);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10321, concreteWater, class_2246.field_10242);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10145, concreteWater, class_2246.field_10542);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10133, concreteWater, class_2246.field_10421);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10522, concreteWater, class_2246.field_10434);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10353, concreteWater, class_2246.field_10038);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10628, concreteWater, class_2246.field_10172);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10233, concreteWater, class_2246.field_10308);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10404, concreteWater, class_2246.field_10206);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10456, concreteWater, class_2246.field_10011);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10023, concreteWater, class_2246.field_10439);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10529, concreteWater, class_2246.field_10367);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10287, concreteWater, class_2246.field_10058);
        VanillaPlugin.addConcreteRecipe(registry, class_2246.field_10506, concreteWater, class_2246.field_10458);
        EmiIngredient axes = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:axes", "c:axes", "c:tools/axes", "fabric:axes", "forge:tools/axes"), EmiStack.of((class_1935)class_1802.field_8475)), 1);
        for (Map.Entry<class_2248, class_2248> entry2 : AxeItemAccessor.getStrippedBlocks().entrySet()) {
            class_2960 id22 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId(entry2.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)entry2.getKey()), axes, EmiStack.of((class_1935)entry2.getValue()), id22));
        }
        for (Map.Entry<Object, Object> entry3 : ((BiMap)class_5955.field_29565.get()).entrySet()) {
            id2 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId((class_2248)entry3.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.lambda$addWorldInteraction$46(entry3, axes, (class_2960)id2));
        }
        for (Map.Entry<Object, Object> entry4 : ((BiMap)class_5953.field_29561.get()).entrySet()) {
            id2 = VanillaPlugin.synthetic("world/stripping", EmiUtil.subId((class_2248)entry4.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.lambda$addWorldInteraction$47(entry4, axes, (class_2960)id2));
        }
        EmiIngredient shears = VanillaPlugin.damagedTool(EmiStack.of((class_1935)class_1802.field_8868), 1);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/shearing", "minecraft/pumpkin")).leftInput(EmiStack.of((class_1935)class_1802.field_17518)).rightInput(shears, true).output(EmiStack.of((class_1935)class_1802.field_46249, 4L)).output(EmiStack.of((class_1935)class_1802.field_17519)).build());
        EmiIngredient emiIngredient = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:hoes", "c:hoes", "c:tools/hoes", "fabric:hoes", "forge:tools/hoes"), EmiStack.of((class_1935)class_1802.field_8609)), 1);
        for (Map.Entry entry5 : HoeItemAccessor.getTillingActions().entrySet()) {
            Consumer consumer = (Consumer)((Pair)entry5.getValue()).getSecond();
            if (!EmiClient.HOE_ACTIONS.containsKey(consumer)) continue;
            class_2248 b = (class_2248)entry5.getKey();
            id = VanillaPlugin.synthetic("world/tilling", EmiUtil.subId(b));
            List<EmiStack> list = EmiClient.HOE_ACTIONS.get(consumer).stream().map(EmiStack::of).toList();
            if (list.size() == 1) {
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)b), hoes, (EmiStack)list.get(0), id));
                continue;
            }
            if (list.size() == 2) {
                VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(id).leftInput(EmiStack.of((class_1935)b)).rightInput(hoes, true).output((EmiStack)list.get(0)).output((EmiStack)list.get(1)).build());
                continue;
            }
            EmiReloadLog.warn("Encountered hoe action of peculiar size " + list.size() + ", skipping.");
        }
        EmiIngredient shovels = VanillaPlugin.damagedTool(VanillaPlugin.getPreferredTag(List.of("minecraft:shovels", "c:shovels", "c:tools/shovels", "fabric:shovels", "forge:tools/shovels"), EmiStack.of((class_1935)class_1802.field_8699)), 1);
        for (Map.Entry<class_2248, class_2680> entry6 : ShovelItemAccessor.getPathStates().entrySet()) {
            class_2248 result = entry6.getValue().method_26204();
            id = VanillaPlugin.synthetic("world/flattening", EmiUtil.subId(entry6.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)entry4.getKey()), shovels, EmiStack.of((class_1935)result), id));
        }
        EmiStack emiStack = EmiStack.of((class_1935)class_1802.field_20414);
        for (Map.Entry entry5 : ((BiMap)class_5953.field_29560.get()).entrySet()) {
            id = VanillaPlugin.synthetic("world/waxing", EmiUtil.subId((class_2248)entry5.getKey()));
            VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)entry5.getKey()), honeycomb, EmiStack.of((class_1935)entry5.getValue()), id, false));
        }
        for (class_1792 i : dyeableItems) {
            if (hiddenItems.contains(i)) continue;
            EmiStack cauldron = EmiStack.of((class_1935)class_1802.field_8638);
            EmiStack waterThird = EmiStack.of((class_3611)class_3612.field_15910, (long)FluidUnit.BOTTLE);
            int uniq = EmiUtil.RANDOM.nextInt();
            VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/cauldron_washing", EmiUtil.subId(i))).leftInput(EmiStack.EMPTY, s -> new GeneratedSlotWidget(r -> {
                class_1799 stack = i.method_7854();
                stack.method_57379(class_9334.field_49644, (Object)new class_9282(r.nextInt(0x1000000), true));
                return EmiStack.of(stack);
            }, uniq, s.getBounds().x(), s.getBounds().y())).rightInput(cauldron, true).rightInput(waterThird, false).output(EmiStack.of((class_1935)i)).supportsRecipeTree(false).build());
        }
        EmiStack emiStack2 = EmiStack.of((class_3611)class_3612.field_15910, (long)FluidUnit.BUCKET);
        EmiStack lava = EmiStack.of((class_3611)class_3612.field_15908, (long)FluidUnit.BUCKET);
        EmiStack waterCatalyst = emiStack2.copy().setRemainder(emiStack2);
        EmiStack lavaCatalyst = lava.copy().setRemainder(lava);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_spring", "minecraft/water")).leftInput(waterCatalyst).rightInput(waterCatalyst, false).output(EmiStack.of((class_3611)class_3612.field_15910, (long)FluidUnit.BUCKET)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/cobblestone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of((class_1935)class_1802.field_20412)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/stone")).leftInput(waterCatalyst).rightInput(lavaCatalyst, false).output(EmiStack.of((class_1935)class_1802.field_20391)).build());
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/obsidian")).leftInput(lava).rightInput(waterCatalyst, false).output(EmiStack.of((class_1935)class_1802.field_8281)).build());
        EmiStack soulSoil = EmiStack.of((class_1935)class_1802.field_21999);
        soulSoil.setRemainder(soulSoil);
        EmiStack blueIce = EmiStack.of((class_1935)class_1802.field_8178);
        blueIce.setRemainder(blueIce);
        VanillaPlugin.addRecipeSafe(registry, () -> EmiWorldInteractionRecipe.builder().id(VanillaPlugin.synthetic("world/fluid_interaction", "minecraft/basalt")).leftInput(lavaCatalyst).rightInput(soulSoil, false, s -> s.appendTooltip((class_2561)EmiPort.translatable("tooltip.emi.fluid_interaction.basalt.soul_soil", class_124.field_1060))).rightInput(blueIce, false, s -> s.appendTooltip((class_2561)EmiPort.translatable("tooltip.emi.fluid_interaction.basalt.blue_ice", class_124.field_1060))).output(EmiStack.of((class_1935)class_1802.field_22000)).build());
        EmiPort.getFluidRegistry().method_40270().forEach(entry -> {
            class_3611 fluid = (class_3611)entry.comp_349();
            class_1792 bucket = fluid.method_15774();
            if (fluid.method_15793(fluid.method_15785()) && !fluid.method_15785().method_15759().method_26215() && bucket != class_1802.field_8162 && fluid instanceof class_3609) {
                VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)class_1802.field_8550), EmiStack.of(fluid, (long)FluidUnit.BUCKET), EmiStack.of((class_1935)bucket), VanillaPlugin.synthetic("emi", "bucket_filling/" + EmiUtil.subId(fluid)), false));
            }
        });
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)class_1802.field_8469), water, EmiStack.of(EmiPort.setPotion(new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991.comp_349())), VanillaPlugin.synthetic("world/unique", "minecraft/water_bottle")));
        EmiStack waterBottle = EmiStack.of(EmiPort.setPotion(new class_1799((class_1935)class_1802.field_8574), (class_1842)class_1847.field_8991.comp_349())).setRemainder(EmiStack.of((class_1935)class_1802.field_8469));
        EmiStack mud = EmiStack.of((class_1935)class_1802.field_37537);
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)class_1802.field_8831), waterBottle, mud, VanillaPlugin.synthetic("world/unique", "minecraft/mud"), false));
    }

    private static EmiIngredient damagedTool(EmiIngredient tool, int damage) {
        for (EmiStack stack : tool.getEmiStacks()) {
            class_1799 is = stack.getItemStack().method_7972();
            is.method_7974(1);
            stack.setRemainder(EmiStack.of(is));
        }
        return tool;
    }

    private static EmiIngredient getPreferredTag(List<String> candidates, EmiIngredient fallback) {
        for (String id : candidates) {
            EmiIngredient potential = EmiIngredient.of(class_6862.method_40092((class_5321)EmiPort.getItemRegistry().method_30517(), (class_2960)EmiPort.id(id)));
            if (potential.isEmpty()) continue;
            return potential;
        }
        return fallback;
    }

    private static void addFuel(EmiRegistry registry, Set<class_1792> hiddenItems) {
        Map<class_1792, Integer> fuelMap = EmiAgnos.getFuelMap();
        VanillaPlugin.compressRecipesToTags(fuelMap.keySet().stream().collect(Collectors.toSet()), (a, b) -> Integer.compare((Integer)fuelMap.get(a), (Integer)fuelMap.get(b)), tag -> {
            EmiIngredient stack = EmiIngredient.of(tag);
            class_1792 item = stack.getEmiStacks().get(0).getItemStack().method_7909();
            int time = (Integer)fuelMap.get(item);
            registry.addRecipe(new EmiFuelRecipe(stack, time, VanillaPlugin.synthetic("fuel/tag", EmiUtil.subId(tag.comp_327()))));
        }, item -> {
            if (!hiddenItems.contains(item)) {
                int time = (Integer)fuelMap.get(item);
                registry.addRecipe(new EmiFuelRecipe(EmiStack.of((class_1935)item), time, VanillaPlugin.synthetic("fuel/item", EmiUtil.subId(item))));
            }
        });
    }

    private static void addComposting(EmiRegistry registry, Set<class_1792> hiddenItems) {
        VanillaPlugin.compressRecipesToTags(class_3962.field_17566.keySet().stream().map(class_1935::method_8389).collect(Collectors.toSet()), (a, b) -> Float.compare(class_3962.field_17566.getFloat(a), class_3962.field_17566.getFloat(b)), tag -> {
            EmiIngredient stack = EmiIngredient.of(tag);
            class_1792 item = stack.getEmiStacks().get(0).getItemStack().method_7909();
            float chance = class_3962.field_17566.getFloat((Object)item);
            registry.addRecipe(new EmiCompostingRecipe(stack, chance, VanillaPlugin.synthetic("composting/tag", EmiUtil.subId(tag.comp_327()))));
        }, item -> {
            if (!hiddenItems.contains(item)) {
                float chance = class_3962.field_17566.getFloat(item);
                registry.addRecipe(new EmiCompostingRecipe(EmiStack.of((class_1935)item), chance, VanillaPlugin.synthetic("composting/item", EmiUtil.subId(item))));
            }
        });
    }

    private static void compressRecipesToTags(Set<class_1792> stacks, Comparator<class_1792> comparator, Consumer<class_6862<class_1792>> tagConsumer, Consumer<class_1792> itemConsumer) {
        HashSet handled = Sets.newHashSet();
        block0: for (class_6862<class_1792> key : EmiTags.getTags(EmiPort.getItemRegistry())) {
            class_1792 base;
            List<class_1792> items = EmiUtil.values(key).map(class_6880::comp_349).toList();
            if (items.size() < 2 || !stacks.contains(base = items.get(0))) continue;
            for (int i = 1; i < items.size(); ++i) {
                class_1792 item = items.get(i);
                if (!stacks.contains(item) || comparator.compare(base, item) != 0) continue block0;
            }
            if (handled.containsAll(items)) continue;
            handled.addAll(items);
            tagConsumer.accept(key);
        }
        for (class_1792 item : stacks) {
            if (handled.contains(item)) continue;
            itemConsumer.accept(item);
        }
    }

    private static class_2960 synthetic(String type, String name) {
        return EmiPort.id("emi", "/" + type + "/" + name);
    }

    private static <C extends class_9695, T extends class_1860<C>> Iterable<T> getRecipes(EmiRegistry registry, class_3956<T> type) {
        return registry.getRecipeManager().method_30027(type).stream().map(e -> e.comp_1933())::iterator;
    }

    private static void safely(String name, Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            EmiReloadLog.warn("Exception thrown when reloading " + name + " step in vanilla EMI plugin", t);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception thrown when parsing EMI recipe (no ID available)", e);
        }
    }

    private static void addRecipeSafe(EmiRegistry registry, Supplier<EmiRecipe> supplier, class_1860<?> recipe) {
        try {
            registry.addRecipe(supplier.get());
        }
        catch (Throwable e) {
            EmiReloadLog.warn("Exception thrown when parsing vanilla recipe " + String.valueOf(EmiPort.getId(recipe)), e);
        }
    }

    private static EmiRenderable simplifiedRenderer(int u, int v) {
        return (raw, x, y, delta) -> {
            EmiDrawContext context = EmiDrawContext.wrap(raw);
            context.drawTexture(EmiRenderHelper.WIDGETS, x, y, u, v, 16, 16);
        };
    }

    private static void addConcreteRecipe(EmiRegistry registry, class_2248 powder, EmiStack water, class_2248 result) {
        VanillaPlugin.addRecipeSafe(registry, () -> VanillaPlugin.basicWorld(EmiStack.of((class_1935)powder), water, EmiStack.of((class_1935)result), VanillaPlugin.synthetic("world/concrete", EmiUtil.subId(result))));
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, class_2960 id) {
        return VanillaPlugin.basicWorld(left, right, output, id, true);
    }

    private static EmiRecipe basicWorld(EmiIngredient left, EmiIngredient right, EmiStack output, class_2960 id, boolean catalyst) {
        return EmiWorldInteractionRecipe.builder().id(id).leftInput(left).rightInput(right, catalyst).output(output).build();
    }

    private static /* synthetic */ EmiRecipe lambda$addWorldInteraction$47(Map.Entry entry, EmiIngredient axes, class_2960 id) {
        return VanillaPlugin.basicWorld(EmiStack.of((class_1935)entry.getKey()), axes, EmiStack.of((class_1935)entry.getValue()), id);
    }

    private static /* synthetic */ EmiRecipe lambda$addWorldInteraction$46(Map.Entry entry, EmiIngredient axes, class_2960 id) {
        return VanillaPlugin.basicWorld(EmiStack.of((class_1935)entry.getKey()), axes, EmiStack.of((class_1935)entry.getValue()), id);
    }

    static {
        VanillaEmiRecipeCategories.CRAFTING = new EmiRecipeCategory(EmiPort.id("minecraft:crafting"), EmiStack.of((class_1935)class_1802.field_8465), VanillaPlugin.simplifiedRenderer(240, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.SMELTING = new EmiRecipeCategory(EmiPort.id("minecraft:smelting"), EmiStack.of((class_1935)class_1802.field_8732), VanillaPlugin.simplifiedRenderer(224, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.BLASTING = new EmiRecipeCategory(EmiPort.id("minecraft:blasting"), EmiStack.of((class_1935)class_1802.field_16306), VanillaPlugin.simplifiedRenderer(208, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.SMOKING = new EmiRecipeCategory(EmiPort.id("minecraft:smoking"), EmiStack.of((class_1935)class_1802.field_16309), VanillaPlugin.simplifiedRenderer(192, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.CAMPFIRE_COOKING = new EmiRecipeCategory(EmiPort.id("minecraft:campfire_cooking"), EmiStack.of((class_1935)class_1802.field_17346), VanillaPlugin.simplifiedRenderer(176, 240), EmiRecipeSorting.compareOutputThenInput());
        VanillaEmiRecipeCategories.STONECUTTING = new EmiRecipeCategory(EmiPort.id("minecraft:stonecutting"), EmiStack.of((class_1935)class_1802.field_16305), VanillaPlugin.simplifiedRenderer(160, 240), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.SMITHING = new EmiRecipeCategory(EmiPort.id("minecraft:smithing"), EmiStack.of((class_1935)class_1802.field_16308), VanillaPlugin.simplifiedRenderer(240, 224), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.ANVIL_REPAIRING = new EmiRecipeCategory(EmiPort.id("emi:anvil_repairing"), EmiStack.of((class_1935)class_1802.field_8782), VanillaPlugin.simplifiedRenderer(240, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.GRINDING = new EmiRecipeCategory(EmiPort.id("emi:grinding"), EmiStack.of((class_1935)class_1802.field_16311), VanillaPlugin.simplifiedRenderer(192, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.BREWING = new EmiRecipeCategory(EmiPort.id("minecraft:brewing"), EmiStack.of((class_1935)class_1802.field_8740), VanillaPlugin.simplifiedRenderer(224, 224), EmiRecipeSorting.none());
        VanillaEmiRecipeCategories.WORLD_INTERACTION = new EmiRecipeCategory(EmiPort.id("emi:world_interaction"), EmiStack.of((class_1935)class_1802.field_8270), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
        EmiRenderable flame = (matrices, x, y, delta) -> EmiTexture.FULL_FLAME.render(matrices, x + 1, y + 1, delta);
        VanillaEmiRecipeCategories.FUEL = new EmiRecipeCategory(EmiPort.id("emi:fuel"), flame, flame, EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.COMPOSTING = new EmiRecipeCategory(EmiPort.id("emi:composting"), EmiStack.of((class_1935)class_1802.field_17530), EmiStack.of((class_1935)class_1802.field_17530), EmiRecipeSorting.compareInputThenOutput());
        VanillaEmiRecipeCategories.INFO = new EmiRecipeCategory(EmiPort.id("emi:info"), EmiStack.of((class_1935)class_1802.field_8674), VanillaPlugin.simplifiedRenderer(208, 224), EmiRecipeSorting.none());
    }
}

