/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.tclayer.compat;

import com.google.common.collect.Multimap;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.TrinketModifiers;
import dev.emi.trinkets.api.SlotAttributes;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.api.TrinketsApi;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.AccessoriesHolder;
import io.wispforest.accessories.api.slot.SlotEntryReference;
import io.wispforest.accessories.api.slot.SlotReference;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.data.EntitySlotLoader;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.tclayer.OuterGroupMap;
import io.wispforest.tclayer.compat.WrappingTrinketsUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.slf4j.Logger;

public record WrappedTrinketComponent(class_1309 entity) implements TrinketComponent
{
    private static final Logger LOGGER = LogUtils.getLogger();

    public AccessoriesCapability capability() {
        return this.entity.accessoriesCapability();
    }

    @Override
    public Map<String, SlotGroup> getGroups() {
        return TrinketsApi.getEntitySlots(this.entity().method_37908(), this.entity().method_5864());
    }

    @Override
    public Map<String, Map<String, TrinketInventory>> getInventory() {
        class_1309 entity = this.entity();
        return new OuterGroupMap(WrappingTrinketsUtils.getGroupedSlots(entity.method_37908().method_8608(), entity.method_5864()), this, this.capability(), additionalMsg -> {
            LOGGER.warn("Unable to get some value leading to an error, here comes the dumping data!");
            LOGGER.warn("Entity: {}", (Object)this.entity());
            LOGGER.warn("Entity Slots: {}", (Object)EntitySlotLoader.getEntitySlots((class_1309)this.entity()));
            LOGGER.warn("Current Containers: {}", (Object)this.entity().accessoriesCapability().getContainers());
            LOGGER.warn("More Info: ({})", additionalMsg);
        });
    }

    @Override
    public void update() {
        this.capability().updateContainers();
    }

    @Override
    public void addTemporaryModifiers(Multimap<String, class_1322> modifiers) {
        this.capability().addTransientSlotModifiers(modifiers);
    }

    @Override
    public void addPersistentModifiers(Multimap<String, class_1322> modifiers) {
        this.capability().addPersistentSlotModifiers(modifiers);
    }

    @Override
    public void removeModifiers(Multimap<String, class_1322> modifiers) {
        this.capability().removeSlotModifiers(modifiers);
    }

    @Override
    public void clearModifiers() {
        this.capability().clearSlotModifiers();
    }

    @Override
    public Multimap<String, class_1322> getModifiers() {
        return this.capability().getSlotModifiers();
    }

    @Override
    public boolean isEquipped(Predicate<class_1799> predicate) {
        return this.capability().isEquipped(predicate);
    }

    @Override
    public List<class_3545<dev.emi.trinkets.api.SlotReference, class_1799>> getEquipped(Predicate<class_1799> predicate) {
        List equipped = this.capability().getEquipped(predicate);
        return equipped.stream().map(slotResult -> {
            Optional<dev.emi.trinkets.api.SlotReference> reference = WrappingTrinketsUtils.createTrinketsReference(slotResult.reference());
            return reference.map(slotReference -> new class_3545(slotReference, (Object)slotResult.stack())).orElse(null);
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public List<class_3545<dev.emi.trinkets.api.SlotReference, class_1799>> getAllEquipped() {
        return this.capability().getAllEquipped().stream().map(slotResult -> {
            Optional<dev.emi.trinkets.api.SlotReference> reference = WrappingTrinketsUtils.createTrinketsReference(slotResult.reference());
            return reference.map(slotReference -> new class_3545(slotReference, (Object)slotResult.stack())).orElse(null);
        }).filter(Objects::nonNull).toList();
    }

    @Override
    public void forEach(BiConsumer<dev.emi.trinkets.api.SlotReference, class_1799> consumer) {
        for (class_3545<dev.emi.trinkets.api.SlotReference, class_1799> tuple : this.getAllEquipped()) {
            consumer.accept((dev.emi.trinkets.api.SlotReference)tuple.method_15442(), (class_1799)tuple.method_15441());
        }
    }

    @Override
    public Set<TrinketInventory> getTrackingUpdates() {
        return new HashSet<TrinketInventory>();
    }

    @Override
    public void clearCachedModifiers() {
        this.capability().clearCachedSlotModifiers();
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 lookup) {
        if (tag.method_10545("data_written_by_accessories")) {
            return;
        }
        AccessoriesHolder holder = this.capability().getHolder();
        List dropped = ((AccessoriesHolderImpl)holder).invalidStacks;
        for (String groupKey : tag.method_10541()) {
            class_2499 list;
            class_2487 slotTag;
            class_2487 groupTag = tag.method_10562(groupKey);
            if (groupTag == null) continue;
            Map<String, TrinketInventory> groupSlots = this.getInventory().get(groupKey);
            if (groupSlots != null) {
                for (String slotKey : groupTag.method_10541()) {
                    slotTag = groupTag.method_10562(slotKey);
                    list = slotTag.method_10554("Items", 10);
                    TrinketInventory inv = groupSlots.get(slotKey);
                    if (inv != null) {
                        inv.fromTag(slotTag.method_10562("Metadata"));
                    }
                    for (int i = 0; i < list.size(); ++i) {
                        class_2487 c = list.method_10602(i);
                        class_1799 stack = class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)c);
                        if (inv != null && i < inv.method_5439()) {
                            inv.method_5447(i, stack);
                            continue;
                        }
                        dropped.add(stack);
                    }
                }
                continue;
            }
            for (String slotKey : groupTag.method_10541()) {
                slotTag = groupTag.method_10562(slotKey);
                list = slotTag.method_10554("Items", 10);
                for (int i = 0; i < list.size(); ++i) {
                    class_2487 c = list.method_10602(i);
                    dropped.add(class_1799.method_57359((class_7225.class_7874)lookup, (class_2487)c));
                }
            }
        }
        for (SlotEntryReference entryRef : this.capability().getAllEquipped()) {
            SlotReference reference = entryRef.reference();
            SlotType slotType = reference.type();
            if (AccessoriesAPI.getPredicateResults((Set)slotType.validators(), (class_1937)reference.entity().method_37908(), (class_1309)reference.entity(), (SlotType)slotType, (int)0, (class_1799)entryRef.stack())) continue;
            dropped.add(entryRef.stack().method_7972());
            entryRef.reference().setStack(class_1799.field_8037);
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 lookup) {
        tag.method_10566("data_written_by_accessories", (class_2520)new class_2487());
        for (Map.Entry<String, Map<String, TrinketInventory>> group : this.getInventory().entrySet()) {
            class_2487 groupTag = new class_2487();
            for (Map.Entry<String, TrinketInventory> slot : group.getValue().entrySet()) {
                class_2487 slotTag = new class_2487();
                class_2499 list = new class_2499();
                TrinketInventory inv = slot.getValue();
                for (int i = 0; i < inv.method_5439(); ++i) {
                    class_2487 c = (class_2487)inv.method_5438(i).method_57375(lookup);
                    list.add((Object)c);
                }
                slotTag.method_10566("Metadata", (class_2520)inv.toTag());
                slotTag.method_10566("Items", (class_2520)list);
                groupTag.method_10566(slot.getKey(), (class_2520)slotTag);
            }
            tag.method_10566(group.getKey(), (class_2520)groupTag);
        }
    }

    private /* synthetic */ void lambda$readFromNbt$5(Multimap slotMap, dev.emi.trinkets.api.SlotReference ref, class_1799 stack) {
        if (!stack.method_7960()) {
            Multimap<class_6880<class_1320>, class_1322> map = TrinketModifiers.get(stack, ref, this.entity());
            for (class_6880 entityAttribute : map.keySet()) {
                Object patt0$temp;
                if (!entityAttribute.method_40227() || !((patt0$temp = entityAttribute.comp_349()) instanceof SlotAttributes.SlotEntityAttribute)) continue;
                SlotAttributes.SlotEntityAttribute slotEntityAttribute = (SlotAttributes.SlotEntityAttribute)((Object)patt0$temp);
                slotMap.putAll((Object)slotEntityAttribute.slot, (Iterable)map.get((Object)entityAttribute));
            }
        }
    }
}

