/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.tclayer;

import com.mojang.logging.LogUtils;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.TrinketInventory;
import io.wispforest.accessories.api.AccessoriesContainer;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.tclayer.compat.WrappedSlotGroup;
import io.wispforest.tclayer.compat.WrappedSlotType;
import io.wispforest.tclayer.compat.WrappedTrinketComponent;
import io.wispforest.tclayer.compat.WrappedTrinketInventory;
import io.wispforest.tclayer.compat.WrappingTrinketsUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ImmutableDelegatingMap<K, V, I>
implements Map<K, V> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public final String debugNaming;
    private Runnable errorMessage;
    public final Class<K> keyClass;
    public final Class<V> valueClass;
    public final Map<K, I> map;
    public final UnaryOperator<K> toKeyNamespace;
    public final UnaryOperator<K> fromKeyNamespace;
    public final BiFunction<K, I, V> toValueMapFunc;
    public final Function<V, @Nullable I> fromValueMapFunc;

    private ImmutableDelegatingMap(String debugNaming, Class<K> keyClass, Class<V> valueClass, Map<K, I> map, UnaryOperator<K> toKeyNamespace, UnaryOperator<K> fromKeyNamespace, Function<I, V> toValueMapFunc, Function<V, @Nullable I> fromValueMapFunc) {
        this(debugNaming, keyClass, valueClass, map, toKeyNamespace, fromKeyNamespace, (K k, I i) -> toValueMapFunc.apply(i), fromValueMapFunc);
    }

    private ImmutableDelegatingMap(String debugNaming, Class<K> keyClass, Class<V> valueClass, Map<K, I> map, UnaryOperator<K> toKeyNamespace, UnaryOperator<K> fromKeyNamespace, BiFunction<K, I, V> toValueMapFunc, Function<V, @Nullable I> fromValueMapFunc) {
        this.debugNaming = debugNaming;
        this.keyClass = keyClass;
        this.valueClass = valueClass;
        this.map = map;
        this.toKeyNamespace = toKeyNamespace;
        this.fromKeyNamespace = fromKeyNamespace;
        this.toValueMapFunc = toValueMapFunc;
        this.fromValueMapFunc = fromValueMapFunc;
    }

    public static Map<String, dev.emi.trinkets.api.SlotType> slotType(Map<String, SlotType> map, String group) {
        return new ImmutableDelegatingMap<String, dev.emi.trinkets.api.SlotType, SlotType>("slot_types", String.class, dev.emi.trinkets.api.SlotType.class, map, WrappingTrinketsUtils::accessoriesToTrinkets_Slot, string -> WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.empty(), string), slotType -> new WrappedSlotType((SlotType)slotType, group), trinketSlot -> {
            SlotType slotType;
            if (trinketSlot instanceof WrappedSlotType) {
                WrappedSlotType wrappedSlotType = (WrappedSlotType)trinketSlot;
                slotType = wrappedSlotType.slotType;
            } else {
                slotType = null;
            }
            return slotType;
        });
    }

    public static Map<String, SlotGroup> slotGroups(Map<String, Map<String, SlotType>> map, boolean isClientSide) {
        return new ImmutableDelegatingMap<String, SlotGroup, Map>("slot_group", String.class, SlotGroup.class, map, WrappingTrinketsUtils::accessoriesToTrinkets_Group, WrappingTrinketsUtils::trinketsToAccessories_Group, (group, slotData) -> new WrappedSlotGroup((String)group, (Map<String, SlotType>)slotData, isClientSide), trinketSlot -> {
            Map<String, SlotType> map;
            if (trinketSlot instanceof WrappedSlotGroup) {
                WrappedSlotGroup wrappedSlotType = (WrappedSlotGroup)trinketSlot;
                map = wrappedSlotType.innerSlots();
            } else {
                map = null;
            }
            return map;
        });
    }

    public static Map<String, Map<String, TrinketInventory>> trinketComponentView(Map<String, Map<String, SlotType>> map, WrappedTrinketComponent component, Map<String, AccessoriesContainer> containerMap, Runnable errorMessage) {
        return new ImmutableDelegatingMap<String, Map, Map>("grouped_trinket_inventories", String.class, Map.class, map, WrappingTrinketsUtils::accessoriesToTrinkets_Group, WrappingTrinketsUtils::trinketsToAccessories_Group, (group, slotData) -> ImmutableDelegatingMap.groupedTrinketInventories(group, component, slotData, containerMap), trinketSlots -> null).errorMessageSupplier(errorMessage);
    }

    public static Map<String, TrinketInventory> groupedTrinketInventories(String group, WrappedTrinketComponent component, Map<String, SlotType> slotTypeMap, Map<String, AccessoriesContainer> containerMap) {
        return new ImmutableDelegatingMap<String, TrinketInventory, SlotType>("trinket_inventories", String.class, TrinketInventory.class, slotTypeMap, WrappingTrinketsUtils::accessoriesToTrinkets_Slot, string -> WrappingTrinketsUtils.trinketsToAccessories_Slot(Optional.of(group), string), (key, type) -> {
            AccessoriesContainer container = (AccessoriesContainer)containerMap.get(type.name());
            if (container == null) {
                throw new IllegalStateException("Unable to get the required Accessories container to wrap for Trinkets API call: [Slot: " + type.name() + "]");
            }
            return new WrappedTrinketInventory(component, container, (SlotType)type);
        }, object -> null);
    }

    private ImmutableDelegatingMap<K, V, I> errorMessageSupplier(Runnable errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (!this.keyClass.isInstance(key)) {
            return false;
        }
        return this.map.containsKey(this.fromKeyNamespace.apply(key));
    }

    @Override
    public boolean containsValue(Object value) {
        if (!this.valueClass.isInstance(value)) {
            return false;
        }
        I possibleValue = this.fromValueMapFunc.apply(value);
        return possibleValue != null && this.map.containsValue(possibleValue);
    }

    @Override
    @Nullable
    public V get(Object key) {
        if (!this.keyClass.isInstance(key)) {
            return null;
        }
        Object convertedKey = this.fromKeyNamespace.apply(key);
        I entry = this.map.get(convertedKey);
        if (entry == null) {
            return null;
        }
        return this.toValueMapFunc.apply(key, entry);
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        return this.map.keySet().stream().map(this.toKeyNamespace).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public Collection<V> values() {
        return this.map.entrySet().stream().map(kiEntry -> this.toValueMapFunc.apply(kiEntry.getKey(), kiEntry.getValue())).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        return this.map.entrySet().stream().map(kiEntry -> Map.entry(this.toKeyNamespace.apply(kiEntry.getKey()), this.toValueMapFunc.apply(kiEntry.getKey(), kiEntry.getValue()))).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    @Nullable
    public V put(K key, V value) {
        return null;
    }

    @Override
    public V remove(Object key) {
        return null;
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends V> m) {
    }

    @Override
    public void clear() {
    }
}

