/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Function3;
import com.mojang.logging.LogUtils;
import dev.emi.trinkets.TrinketSlotTarget;
import dev.emi.trinkets.api.SlotGroup;
import dev.emi.trinkets.api.SlotReference;
import dev.emi.trinkets.api.SlotType;
import dev.emi.trinkets.api.Trinket;
import dev.emi.trinkets.api.TrinketComponent;
import dev.emi.trinkets.api.TrinketInventory;
import dev.emi.trinkets.data.EntitySlotLoader;
import io.wispforest.accessories.Accessories;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.api.Accessory;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.EntityBasedPredicate;
import io.wispforest.accessories.api.slot.SlotBasedPredicate;
import io.wispforest.accessories.data.SlotTypeLoader;
import io.wispforest.tclayer.compat.EmptyComponent;
import io.wispforest.tclayer.compat.WrappedAccessory;
import io.wispforest.tclayer.compat.WrappedSlotType;
import io.wispforest.tclayer.compat.WrappedTrinket;
import io.wispforest.tclayer.compat.WrappedTrinketComponent;
import io.wispforest.tclayer.compat.WrappedTrinketInventory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.cca.api.v3.component.ComponentKey;
import org.ladysnake.cca.api.v3.component.ComponentRegistryV3;
import org.slf4j.Logger;

public class TrinketsApi {
    public static final ComponentKey<TrinketComponent> TRINKET_COMPONENT = ComponentRegistryV3.INSTANCE.getOrCreate(class_2960.method_60655((String)"trinkets", (String)"trinkets"), TrinketComponent.class);
    private static final Map<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>> PREDICATES = new HashMap<class_2960, Function3<class_1799, SlotReference, class_1309, TriState>>();
    private static final Map<class_1792, Trinket> TRINKETS = new HashMap<class_1792, Trinket>();
    private static final Trinket DEFAULT_TRINKET;

    public static void registerTrinket(class_1792 item, Trinket trinket) {
        TRINKETS.put(item, trinket);
        AccessoriesAPI.registerAccessory((class_1792)item, (Accessory)new WrappedTrinket(trinket));
    }

    public static Trinket getTrinket(class_1792 item) {
        Accessory accessory;
        Trinket trinket = TRINKETS.get(item);
        if (trinket == null && (accessory = AccessoriesAPI.getAccessory((class_1792)item)) != null) {
            trinket = new WrappedAccessory(accessory);
        }
        if (trinket == null) {
            return DEFAULT_TRINKET;
        }
        return trinket;
    }

    public static Trinket getDefaultTrinket() {
        return DEFAULT_TRINKET;
    }

    public static Optional<TrinketComponent> getTrinketComponent(class_1309 livingEntity) {
        if (livingEntity == null) {
            return Optional.empty();
        }
        AccessoriesCapability capability = AccessoriesCapability.get((class_1309)livingEntity);
        return Optional.of(capability != null ? new WrappedTrinketComponent(livingEntity) : new EmptyComponent(livingEntity));
    }

    public static void onTrinketBroken(class_1799 stack, SlotReference ref, class_1309 entity) {
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        io.wispforest.accessories.api.slot.SlotReference reference = io.wispforest.accessories.api.slot.SlotReference.of((class_1309)entity, (String)slotName, (int)ref.index());
        AccessoriesAPI.breakStack((io.wispforest.accessories.api.slot.SlotReference)reference);
    }

    @Deprecated
    public static Map<String, SlotGroup> getPlayerSlots() {
        return TrinketsApi.getEntitySlots(class_1299.field_6097);
    }

    public static Map<String, SlotGroup> getPlayerSlots(class_1937 world) {
        return TrinketsApi.getEntitySlots(world, class_1299.field_6097);
    }

    public static Map<String, SlotGroup> getPlayerSlots(class_1657 player) {
        return TrinketsApi.getEntitySlots((class_1297)player);
    }

    @Deprecated
    public static Map<String, SlotGroup> getEntitySlots(class_1299<?> type) {
        EntitySlotLoader loader = FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
        return loader.getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(class_1937 world, class_1299<?> type) {
        EntitySlotLoader loader = world.method_8608() ? EntitySlotLoader.CLIENT : EntitySlotLoader.SERVER;
        return loader.getEntitySlots(type);
    }

    public static Map<String, SlotGroup> getEntitySlots(class_1297 entity) {
        if (entity != null) {
            return TrinketsApi.getEntitySlots(entity.method_37908(), entity.method_5864());
        }
        return ImmutableMap.of();
    }

    public static void registerTrinketPredicate(class_2960 id, Function3<class_1799, SlotReference, class_1309, TriState> predicate) {
        PREDICATES.put(id, predicate);
        AccessoriesAPI.registerPredicate((class_2960)id, (SlotBasedPredicate)new SafeSlotBasedPredicate(id, predicate));
    }

    public static Optional<Function3<class_1799, SlotReference, class_1309, TriState>> getTrinketPredicate(class_2960 id) {
        return Optional.ofNullable(PREDICATES.get(id));
    }

    public static boolean evaluatePredicateSet(Set<class_2960> set, class_1799 stack, SlotReference ref, class_1309 entity) {
        HashSet<class_2960> convertedSet = new HashSet<class_2960>();
        for (class_2960 location : set) {
            class_2960 converetdLocation = switch (location.toString()) {
                case "trinkets:all" -> Accessories.of((String)"all");
                case "trinkets:none" -> Accessories.of((String)"none");
                case "trinkets:tag" -> Accessories.of((String)"tag");
                case "trinkets:relevant" -> Accessories.of((String)"relevant");
                default -> location;
            };
            convertedSet.add(converetdLocation);
        }
        String slotName = ((WrappedTrinketInventory)ref.inventory()).container.getSlotName();
        io.wispforest.accessories.api.slot.SlotType slotType = SlotTypeLoader.getSlotType((class_1937)entity.method_37908(), (String)slotName);
        if (slotType == null) {
            throw new IllegalStateException("Unable to get a SlotType using the WrappedTrinketInventory from the SlotTypeLoader! [Name: " + slotName + "]");
        }
        return AccessoriesAPI.getPredicateResults(convertedSet, (class_1937)entity.method_37908(), (class_1309)entity, (io.wispforest.accessories.api.slot.SlotType)slotType, (int)ref.index(), (class_1799)stack);
    }

    public static class_1887.class_9427 withTrinketSlots(class_1887.class_9427 definition, Set<String> slots) {
        class_1887.class_9427 def = new class_1887.class_9427(definition.comp_2506(), definition.comp_2507(), definition.comp_2508(), definition.comp_2509(), definition.comp_2510(), definition.comp_2511(), definition.comp_2512(), definition.comp_2513());
        ((TrinketSlotTarget)def).trinkets$slots(slots);
        return def;
    }

    static {
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"all"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.TRUE));
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"none"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> TriState.FALSE));
        class_6862 trinketsAll = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"trinkets", (String)"all"));
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"tag"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            SlotType slot = ref.inventory().getSlotType();
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"trinkets", (String)slot.getId()));
            if (stack.method_31573(tag) || stack.method_31573(trinketsAll)) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        TrinketsApi.registerTrinketPredicate(class_2960.method_60655((String)"trinkets", (String)"relevant"), (Function3<class_1799, SlotReference, class_1309, TriState>)((Function3)(stack, ref, entity) -> {
            io.wispforest.accessories.api.slot.SlotReference reference = io.wispforest.accessories.api.slot.SlotReference.of((class_1309)entity, (String)ref.inventory().getSlotType().getName(), (int)ref.index());
            AccessoryAttributeBuilder builder = new AccessoryAttributeBuilder(reference);
            Accessory accessory = AccessoriesAPI.getOrDefaultAccessory((class_1799)stack);
            if (accessory != null) {
                accessory.getDynamicModifiers(stack, reference, builder);
            }
            if (!builder.getAttributeModifiers(false).isEmpty()) {
                return TriState.TRUE;
            }
            return TriState.DEFAULT;
        }));
        DEFAULT_TRINKET = new WrappedAccessory(AccessoriesAPI.defaultAccessory());
    }

    private static final class SafeSlotBasedPredicate
    implements EntityBasedPredicate {
        private static final Logger LOGGER = LogUtils.getLogger();
        private boolean hasErrored = false;
        private final class_2960 location;
        private final Function3<class_1799, SlotReference, class_1309, TriState> trinketPredicate;

        public SafeSlotBasedPredicate(class_2960 location, Function3<class_1799, SlotReference, class_1309, TriState> trinketPredicate) {
            this.location = location;
            this.trinketPredicate = trinketPredicate;
        }

        public TriState isValid(class_1937 level, @Nullable class_1309 entity, io.wispforest.accessories.api.slot.SlotType slotType, int slot, class_1799 stack) {
            if (this.hasErrored) {
                return TriState.DEFAULT;
            }
            try {
                return (TriState)this.trinketPredicate.apply((Object)stack, (Object)new SlotReference(new CursedTrinketInventory(slotType, level.method_8608()), slot), (Object)entity);
            }
            catch (Exception e) {
                this.hasErrored = true;
                LOGGER.warn("Unable to handle Trinket Slot Predicate converted to Accessories Slot Predicate due to fundamental incompatibility, issues may be present with it! [Slot: {}, Predicate ID: {}]", new Object[]{slotType.name(), this.location, e});
                return TriState.DEFAULT;
            }
        }
    }

    private static final class CursedTrinketInventory
    extends TrinketInventory {
        public CursedTrinketInventory(io.wispforest.accessories.api.slot.SlotType slotType, boolean isClientSide) {
            super(WrappedSlotType.of(slotType, isClientSide), null, inv -> {});
        }
    }
}

