/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.trinkets.api;

import dev.emi.trinkets.api.TrinketEnums;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class SlotType {
    private final String group;
    private final String name;
    private final int order;
    private final int amount;
    private final class_2960 icon;
    private final Set<class_2960> quickMovePredicates;
    private final Set<class_2960> validatorPredicates;
    private final Set<class_2960> tooltipPredicates;
    private final TrinketEnums.DropRule dropRule;

    public SlotType(String group, String name, int order, int amount, class_2960 icon, Set<class_2960> quickMovePredicates, Set<class_2960> validatorPredicates, Set<class_2960> tooltipPredicates, TrinketEnums.DropRule dropRule) {
        this.group = group;
        this.name = name;
        this.order = order;
        this.amount = amount;
        this.icon = icon;
        this.quickMovePredicates = quickMovePredicates;
        this.validatorPredicates = validatorPredicates;
        this.tooltipPredicates = tooltipPredicates;
        this.dropRule = dropRule;
    }

    public String getGroup() {
        return this.group;
    }

    public String getName() {
        return this.name;
    }

    public int getOrder() {
        return this.order;
    }

    public int getAmount() {
        return this.amount;
    }

    public class_2960 getIcon() {
        return this.icon;
    }

    public Set<class_2960> getQuickMovePredicates() {
        return this.quickMovePredicates;
    }

    public Set<class_2960> getValidatorPredicates() {
        return this.validatorPredicates;
    }

    public Set<class_2960> getTooltipPredicates() {
        return this.tooltipPredicates;
    }

    public TrinketEnums.DropRule getDropRule() {
        return this.dropRule;
    }

    public class_5250 getTranslation() {
        return class_2561.method_43471((String)("trinkets.slot." + this.group + "." + this.name));
    }

    public void write(class_2487 data) {
        class_2487 tag = new class_2487();
        tag.method_10582("Group", this.getGroup());
        tag.method_10582("Name", this.getName());
        tag.method_10569("Order", this.getOrder());
        tag.method_10569("Amount", this.getAmount());
        tag.method_10582("Icon", this.getIcon().toString());
        class_2499 quickMovePredicateList = new class_2499();
        for (class_2960 class_29602 : this.getQuickMovePredicates()) {
            quickMovePredicateList.add((Object)class_2519.method_23256((String)class_29602.toString()));
        }
        tag.method_10566("QuickMovePredicates", (class_2520)quickMovePredicateList);
        class_2499 validatorPredicateList = new class_2499();
        for (class_2960 id : this.getValidatorPredicates()) {
            validatorPredicateList.add((Object)class_2519.method_23256((String)id.toString()));
        }
        tag.method_10566("ValidatorPredicates", (class_2520)validatorPredicateList);
        class_2499 class_24992 = new class_2499();
        for (class_2960 id : this.getTooltipPredicates()) {
            class_24992.add((Object)class_2519.method_23256((String)id.toString()));
        }
        tag.method_10566("TooltipPredicates", (class_2520)class_24992);
        tag.method_10582("DropRule", this.getDropRule().toString());
        data.method_10566("SlotData", (class_2520)tag);
    }

    public static SlotType read(class_2487 data) {
        class_2487 slotData = data.method_10562("SlotData");
        String group = slotData.method_10558("Group");
        String name = slotData.method_10558("Name");
        int order = slotData.method_10550("Order");
        int amount = slotData.method_10550("Amount");
        class_2960 icon = class_2960.method_60654((String)slotData.method_10558("Icon"));
        class_2499 quickMoveList = slotData.method_10554("QuickMovePredicates", 8);
        HashSet<class_2960> quickMovePredicates = new HashSet<class_2960>();
        for (class_2520 tag : quickMoveList) {
            quickMovePredicates.add(class_2960.method_60654((String)tag.method_10714()));
        }
        class_2499 validatorList = slotData.method_10554("ValidatorPredicates", 8);
        HashSet<class_2960> validatorPredicates = new HashSet<class_2960>();
        for (class_2520 tag : validatorList) {
            validatorPredicates.add(class_2960.method_60654((String)tag.method_10714()));
        }
        class_2499 tooltipList = slotData.method_10554("TooltipPredicates", 8);
        HashSet<class_2960> tooltipPredicates = new HashSet<class_2960>();
        for (class_2520 tag : tooltipList) {
            tooltipPredicates.add(class_2960.method_60654((String)tag.method_10714()));
        }
        String dropRuleName = slotData.method_10558("DropRule");
        TrinketEnums.DropRule dropRule = TrinketEnums.DropRule.DEFAULT;
        if (TrinketEnums.DropRule.has(dropRuleName)) {
            dropRule = TrinketEnums.DropRule.valueOf(dropRuleName);
        }
        return new SlotType(group, name, order, amount, icon, quickMovePredicates, validatorPredicates, tooltipPredicates, dropRule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SlotType slotType = (SlotType)o;
        return this.getGroup().equals(slotType.getGroup()) && this.getName().equals(slotType.getName());
    }

    public int hashCode() {
        return Objects.hash(this.getGroup(), this.getName());
    }

    public String getId() {
        return this.getGroup() + "/" + this.getName();
    }
}

