/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.exclusiveitem.client;

import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7225;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_918;
import net.minecraft.class_9209;
import net.pixeldreamstudios.exclusiveitem.client.ClaimConfirmationScreen;
import net.pixeldreamstudios.exclusiveitem.client.ClientExclusiveItemStorage;
import org.joml.Vector3f;

public class ReclaimScreen
extends class_437 {
    private static final class_2960 BG_TEXTURE = class_2960.method_60655((String)"exclusive-item", (String)"textures/gui/background.png");
    private static final class_2960 BACK_BUTTON = class_2960.method_60655((String)"exclusive-item", (String)"textures/gui/back.png");
    private static final class_2960 NEXT_BUTTON = class_2960.method_60655((String)"exclusive-item", (String)"textures/gui/next.png");
    private final boolean isGravityGlitch = Math.random() < 0.05;
    private final Vector3f[] itemPositions = new Vector3f[12];
    private static final int TEXTURE_WIDTH = 324;
    private static final int TEXTURE_HEIGHT = 200;
    private float glowAlpha = 0.4f;
    private boolean increasing = true;
    private final long startTime = System.currentTimeMillis();
    private int currentPage = 0;
    private final Vector3f[] rotationAxes = new Vector3f[12];
    private final float[] angularSpeeds = new float[12];
    private final float[] tiltOffsets = new float[12];
    private boolean initializedOffsets = false;
    private final float[] itemVY = new float[12];
    private final float[] itemVX = new float[12];
    private static final int TILE_SIZE = 16;
    private static final int FADE_DURATION = 500;
    private static final int STAGGER_RANGE = 800;
    private static final int FADE_GRID_COLS = (int)Math.ceil(20.25);
    private static final int FADE_GRID_ROWS = (int)Math.ceil(12.5);
    private long[][] tileRevealTime = new long[FADE_GRID_ROWS][FADE_GRID_COLS];
    private boolean doIntroAnimation = true;

    public ReclaimScreen() {
        this(true);
    }

    public ReclaimScreen(boolean doIntroAnimation) {
        super((class_2561)class_2561.method_43470((String)"Reclaim Exclusive Items"));
        this.doIntroAnimation = doIntroAnimation;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        this.glowAlpha = this.increasing ? Math.min(this.glowAlpha + delta * 0.015f, 0.6f) : Math.max(this.glowAlpha - delta * 0.015f, 0.3f);
        this.increasing = !(this.glowAlpha >= 0.6f) && this.glowAlpha <= 0.3f;
        int x = (this.field_22789 - 324) / 2;
        int y = (this.field_22790 - 200) / 2;
        context.method_25294(0, 0, this.field_22789, this.field_22790, -1442840576);
        context.method_51422(1.0f, 1.0f, 1.0f, 0.95f);
        context.method_25290(BG_TEXTURE, x, y, 0.0f, 0.0f, 324, 200, 324, 200);
        context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        if (this.doIntroAnimation) {
            this.renderIntroTileFade(context, x, y);
        }
        int thickness = 2;
        int glowOuter = this.applyAlpha(-13382401, this.glowAlpha);
        int glowInner = this.applyAlpha(-14527113, this.glowAlpha);
        context.method_25296(x - thickness, y - thickness, x + 324 + thickness, y, glowOuter, glowInner);
        context.method_25296(x - thickness, y + 200, x + 324 + thickness, y + 200 + thickness, glowInner, glowOuter);
        context.method_25296(x - thickness, y, x, y + 200, glowOuter, glowInner);
        context.method_25296(x + 324, y, x + 324 + thickness, y + 200, glowInner, glowOuter);
        List<class_1799> full = ClientExclusiveItemStorage.get();
        int itemsPerPage = 12;
        int totalPages = Math.max(1, (int)Math.ceil((float)full.size() / (float)itemsPerPage));
        this.currentPage = class_3532.method_15340((int)this.currentPage, (int)0, (int)(totalPages - 1));
        int from = Math.min(this.currentPage * itemsPerPage, full.size());
        int to = Math.min((this.currentPage + 1) * itemsPerPage, full.size());
        List<class_1799> items = full.subList(from, to);
        if (!this.initializedOffsets) {
            for (int i = 0; i < this.rotationAxes.length; ++i) {
                Vector3f axis;
                float xAxis = (float)(Math.random() * 2.0 - 1.0);
                float yAxis = (float)(Math.random() * 2.0 - 1.0);
                float zAxis = (float)(Math.random() * 2.0 - 1.0);
                this.rotationAxes[i] = axis = new Vector3f(xAxis, yAxis, zAxis).normalize();
                this.angularSpeeds[i] = (float)(Math.random() * (double)0.025f + (double)0.0125f);
                this.tiltOffsets[i] = (float)(Math.random() * Math.PI * 2.0);
                if (!this.isGravityGlitch) continue;
                int col = i % 4;
                int row = i / 4;
                int gridX = x + col * 81 + 16;
                int gridY = y + row * 66 + 16;
                this.itemPositions[i] = new Vector3f((float)gridX, (float)gridY, 0.0f);
                this.itemVY[i] = (float)(-Math.random() * 3.0);
                this.itemVX[i] = (float)((Math.random() - 0.5) * 1.5);
            }
            this.initializedOffsets = true;
        }
        int cols = 4;
        int rows = 3;
        int cellW = 324 / cols;
        int cellH = 200 / rows;
        long time = System.currentTimeMillis() % 100000L;
        class_1799 hoveredItem = null;
        int hoveredX = 0;
        int hoveredY = 0;
        int hoveredW = 0;
        int hoveredH = 0;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols && index < items.size(); ++index, ++col) {
                class_1799 item = items.get(index);
                int cellX = x + col * cellW;
                int cellY = y + row * cellH;
                int right = cellX + (col == cols - 1 ? 324 - cellW * (cols - 1) : cellW);
                int bottom = cellY + (row == rows - 1 ? 200 - cellH * (rows - 1) : cellH);
                boolean isHovered = mouseX >= cellX && mouseX < right && mouseY >= cellY && mouseY < bottom;
                int renderX = x + col * cellW + (cellW - 16) / 2;
                int renderY = y + row * cellH + (cellH - 16) / 2;
                if (this.isGravityGlitch) {
                    Vector3f pos = this.itemPositions[index];
                    float vy = this.itemVY[index];
                    float vx = this.itemVX[index];
                    float gravity = 0.45f;
                    vy += gravity;
                    pos.x += vx;
                    if (Math.abs(vx *= 0.98f) < 0.01f) {
                        vx = 0.0f;
                    }
                    float rightBound = x + 324 - 16;
                    if (pos.x < (float)x) {
                        pos.x = x;
                        vx *= -0.5f;
                    } else if (pos.x > rightBound) {
                        pos.x = rightBound;
                        vx *= -0.5f;
                    }
                    float newY = pos.y + vy;
                    float maxY = y + 200 - 18;
                    float friction = 0.75f;
                    if (newY > maxY) {
                        newY = maxY;
                        if (Math.abs(vy *= -friction) < 0.5f) {
                            vy = 0.0f;
                        }
                    }
                    for (int j = 0; j < index; ++j) {
                        float top;
                        if (this.itemPositions[j] == null) continue;
                        Vector3f other = this.itemPositions[j];
                        if (!(Math.abs(pos.x - other.x) < 16.0f) || !(Math.abs(newY - other.y) < 16.0f) || !(newY > (top = other.y - 16.0f))) continue;
                        newY = top;
                        if (!(Math.abs(vy *= -friction) < 0.5f)) continue;
                        vy = 0.0f;
                    }
                    pos.y = newY;
                    this.itemVY[index] = vy;
                    this.itemVX[index] = vx;
                    this.renderFloatingItem(item, context, (int)pos.x, (int)pos.y, delta, (float)time / 16.0f, this.rotationAxes[index], this.angularSpeeds[index], this.tiltOffsets[index], isHovered);
                } else {
                    this.renderFloatingItem(item, context, renderX, renderY, delta, (float)time / 16.0f, this.rotationAxes[index], this.angularSpeeds[index], this.tiltOffsets[index], isHovered);
                }
                if (!isHovered) continue;
                hoveredItem = item;
                hoveredX = cellX;
                hoveredY = cellY;
                hoveredW = right - cellX;
                hoveredH = bottom - cellY;
            }
        }
        if (this.isGravityGlitch) {
            context.method_25300(this.field_22793, "\u00a7oOops... they fell again", this.field_22789 / 2, y - 10, 0xAAAAFF);
        }
        int btnW = 30;
        int btnH = 30;
        int leftX = x - btnW - 5;
        int rightX = x + 324 + 5;
        int btnY = y + 100 - btnH / 2;
        float scalePulse = 1.0f + 0.05f * class_3532.method_15374((float)((float)(System.currentTimeMillis() - this.startTime) / 150.0f));
        if (this.currentPage > 0) {
            boolean hoverLeft = mouseX >= leftX && mouseX < leftX + btnW && mouseY >= btnY && mouseY < btnY + btnH;
            context.method_51422(1.0f, 1.0f, 1.0f, hoverLeft ? 1.0f : 0.7f);
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)leftX + (float)btnW / 2.0f, (float)btnY + (float)btnH / 2.0f, 0.0f);
            matrices.method_22905(scalePulse, scalePulse, 1.0f);
            matrices.method_46416((float)(-btnW) / 2.0f, (float)(-btnH) / 2.0f, 0.0f);
            context.method_25290(BACK_BUTTON, 0, 0, 0.0f, 0.0f, btnW, btnH, btnW, btnH);
            matrices.method_22909();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (this.currentPage < totalPages - 1) {
            boolean hoverRight = mouseX >= rightX && mouseX < rightX + btnW && mouseY >= btnY && mouseY < btnY + btnH;
            context.method_51422(1.0f, 1.0f, 1.0f, hoverRight ? 1.0f : 0.7f);
            class_4587 matrices = context.method_51448();
            matrices.method_22903();
            matrices.method_46416((float)rightX + (float)btnW / 2.0f, (float)btnY + (float)btnH / 2.0f, 0.0f);
            matrices.method_22905(scalePulse, scalePulse, 1.0f);
            matrices.method_46416((float)(-btnW) / 2.0f, (float)(-btnH) / 2.0f, 0.0f);
            context.method_25290(NEXT_BUTTON, 0, 0, 0.0f, 0.0f, btnW, btnH, btnW, btnH);
            matrices.method_22909();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        }
        if (hoveredItem != null) {
            context.method_25294(hoveredX, hoveredY, hoveredX + hoveredW, hoveredY + hoveredH, 0x55FFFFFF);
            context.method_51434(this.field_22793, hoveredItem.method_7950(new class_1792.class_9635(this){

                public class_7225.class_7874 method_59527() {
                    return null;
                }

                public float method_59531() {
                    return 0.0f;
                }

                public class_22 method_59529(class_9209 mapIdComponent) {
                    return null;
                }
            }, (class_1657)class_310.method_1551().field_1724, (class_1836)(class_310.method_1551().field_1690.field_1827 ? class_1836.field_41071 : class_1836.field_41070)), mouseX, mouseY);
        }
    }

    private void renderIntroTileFade(class_332 context, int x, int y) {
        long elapsed = System.currentTimeMillis() - this.startTime;
        for (int row = 0; row < FADE_GRID_ROWS; ++row) {
            for (int col = 0; col < FADE_GRID_COLS; ++col) {
                int color;
                long tileStart;
                long tileElapsed;
                int tileLeft = x + col * 16;
                int tileTop = y + row * 16;
                int tileRight = Math.min(tileLeft + 16, x + 324);
                int tileBottom = Math.min(tileTop + 16, y + 200);
                if (this.tileRevealTime[row][col] == 0L) {
                    float verticalBias = (float)(FADE_GRID_ROWS - row) / (float)FADE_GRID_ROWS;
                    int delay = (int)(Math.random() * 800.0 * (double)verticalBias);
                    this.tileRevealTime[row][col] = this.startTime + (long)delay;
                }
                if ((tileElapsed = elapsed - ((tileStart = this.tileRevealTime[row][col]) - this.startTime)) < 0L) {
                    color = -16777216;
                } else {
                    if (tileElapsed >= 500L) continue;
                    float alpha = 1.0f - (float)tileElapsed / 500.0f;
                    int a = (int)(alpha * 255.0f) & 0xFF;
                    color = a << 24;
                }
                context.method_25294(tileLeft, tileTop, tileRight, tileBottom, color);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int x = (this.field_22789 - 324) / 2;
        int y = (this.field_22790 - 200) / 2;
        int btnW = 25;
        int btnH = 25;
        int leftX = x - btnW - 5;
        int rightX = x + 324 + 5;
        int btnY = y + 100 - btnH / 2;
        if (this.currentPage > 0 && mouseX >= (double)leftX && mouseX < (double)(leftX + btnW) && mouseY >= (double)btnY && mouseY < (double)(btnY + btnH)) {
            this.currentPage = Math.max(0, this.currentPage - 1);
            this.initializedOffsets = false;
            return true;
        }
        int totalPages = (int)Math.ceil((double)ClientExclusiveItemStorage.get().size() / 12.0);
        if (this.currentPage < totalPages - 1 && mouseX >= (double)rightX && mouseX < (double)(rightX + btnW) && mouseY >= (double)btnY && mouseY < (double)(btnY + btnH)) {
            this.currentPage = Math.min(totalPages - 1, this.currentPage + 1);
            this.initializedOffsets = false;
            return true;
        }
        List<class_1799> full = ClientExclusiveItemStorage.get();
        int itemsPerPage = 12;
        int from = Math.min(this.currentPage * itemsPerPage, full.size());
        int to = Math.min((this.currentPage + 1) * itemsPerPage, full.size());
        List<class_1799> items = full.subList(from, to);
        int cols = 4;
        int rows = 3;
        int cellW = 324 / cols;
        int cellH = 200 / rows;
        int startX = (this.field_22789 - 324) / 2;
        int startY = (this.field_22790 - 200) / 2;
        int index = 0;
        for (int row = 0; row < rows; ++row) {
            for (int col = 0; col < cols && index < items.size(); ++index, ++col) {
                int cellX = startX + col * cellW;
                int cellY = startY + row * cellH;
                int right = cellX + (col == cols - 1 ? 324 - cellW * (cols - 1) : cellW);
                int bottom = cellY + (row == rows - 1 ? 200 - cellH * (rows - 1) : cellH);
                if (!(mouseX >= (double)cellX) || !(mouseX < (double)right) || !(mouseY >= (double)cellY) || !(mouseY < (double)bottom)) continue;
                class_1799 clickedItem = items.get(index);
                class_310.method_1551().method_1507((class_437)new ClaimConfirmationScreen(clickedItem.method_7972()));
                return true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    private void renderFloatingItem(class_1799 stack, class_332 context, int x, int y, float tickDelta, float time, Vector3f axis, float speed, float bobOffset, boolean isHovered) {
        class_310 client = class_310.method_1551();
        class_918 renderer = client.method_1480();
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416((float)(x + 8), (float)(y + 8), 150.0f);
        matrices.method_22905(24.0f, -24.0f, 24.0f);
        if (isHovered) {
            float bobbing = class_3532.method_15374((float)((time + tickDelta + bobOffset) / 12.0f)) * 0.05f;
            matrices.method_46416(0.0f, -bobbing, 0.0f);
        }
        float angle = time * speed * 60.0f % 360.0f;
        matrices.method_22907(class_7833.method_46356((Vector3f)axis).rotationDegrees(angle));
        renderer.method_23178(stack, class_811.field_4317, 0xF000F0, class_4608.field_21444, matrices, (class_4597)context.method_51450(), null, 0);
        matrices.method_22909();
    }

    private int applyAlpha(int color, float alpha) {
        int a = (int)(alpha * 255.0f) & 0xFF;
        return a << 24 | color & 0xFFFFFF;
    }

    public boolean method_25421() {
        return false;
    }
}

