/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.exclusiveitem;

import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.pixeldreamstudios.exclusiveitem.ExclusiveItemUtil;

public class CooldownHandler {
    private static final Map<UUID, Map<UUID, Integer>> cooldownTimers = new WeakHashMap<UUID, Map<UUID, Integer>>();
    private static final int COOLDOWN_TICKS = 200;

    public static void register() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_1799 main = player.method_6047();
                if (ExclusiveItemUtil.isExclusiveItem(main) && !ExclusiveItemUtil.isOwner(main, (class_1657)player)) {
                    UUID playerId = player.method_5667();
                    UUID itemId = ExclusiveItemUtil.getExclusiveID(main);
                    if (itemId == null) continue;
                    cooldownTimers.putIfAbsent(playerId, new WeakHashMap());
                    Map<UUID, Integer> playerCooldowns = cooldownTimers.get(playerId);
                    int ticksLeft = playerCooldowns.getOrDefault(itemId, 0);
                    if (ticksLeft <= 0) {
                        player.method_7357().method_7906(main.method_7909(), 200);
                        playerCooldowns.put(itemId, 200);
                        continue;
                    }
                    playerCooldowns.put(itemId, ticksLeft - 1);
                    continue;
                }
                cooldownTimers.remove(player.method_5667());
            }
        });
    }
}

