/*
 * Decompiled with CFR 0.152.
 */
package com.tom.storagemod.util;

import com.google.common.collect.MapMaker;
import com.tom.storagemod.inventory.IChangeTrackerAccess;
import com.tom.storagemod.inventory.IInventoryAccess;
import com.tom.storagemod.inventory.InventoryCableNetwork;
import com.tom.storagemod.inventory.InventoryChangeTracker;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1937;

public class WorldStates {
    public static Map<Storage<ItemVariant>, IInventoryAccess.IInventoryChangeTracker> trackers = new MapMaker().weakKeys().weakValues().makeMap();
    public static Map<class_1937, InventoryCableNetwork> cableNetworks = new HashMap<class_1937, InventoryCableNetwork>();

    public static void clearWorldStates() {
        trackers.clear();
        cableNetworks.clear();
    }

    public static IInventoryAccess.IInventoryChangeTracker getTracker(Storage<ItemVariant> h) {
        if (h instanceof IChangeTrackerAccess) {
            IChangeTrackerAccess a = (IChangeTrackerAccess)h;
            return a.tracker();
        }
        IInventoryAccess.IInventoryChangeTracker ct = trackers.computeIfAbsent(h, InventoryChangeTracker::new);
        if (ct instanceof InventoryChangeTracker) {
            InventoryChangeTracker c = (InventoryChangeTracker)ct;
            c.refresh(h);
        }
        return ct;
    }
}

