/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.data;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksExpected;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.ChunkTeamData;
import dev.ftb.mods.ftbchunks.api.ClaimResult;
import dev.ftb.mods.ftbchunks.api.FTBChunksProperties;
import dev.ftb.mods.ftbchunks.api.event.ClaimedChunkEvent;
import dev.ftb.mods.ftbchunks.data.AllyMode;
import dev.ftb.mods.ftbchunks.data.ChunkSyncInfo;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkImpl;
import dev.ftb.mods.ftbchunks.data.ClaimedChunkManagerImpl;
import dev.ftb.mods.ftbchunks.data.ForceLoadMode;
import dev.ftb.mods.ftbchunks.data.PartyLimitMode;
import dev.ftb.mods.ftbchunks.data.TeamMemberData;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftbchunks.net.SendManyChunksPacket;
import dev.ftb.mods.ftbchunks.util.DimensionFilter;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import dev.ftb.mods.ftblibrary.snbt.SNBT;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftbteams.api.Team;
import dev.ftb.mods.ftbteams.api.TeamManager;
import dev.ftb.mods.ftbteams.api.TeamRank;
import dev.ftb.mods.ftbteams.api.property.PrivacyMode;
import dev.ftb.mods.ftbteams.api.property.PrivacyProperty;
import dev.ftb.mods.ftbteams.api.property.TeamProperty;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class ChunkTeamDataImpl
implements ChunkTeamData {
    private final ClaimedChunkManagerImpl manager;
    private final Team team;
    private final Path file;
    private boolean shouldSave;
    private int maxClaimChunks;
    private int maxForceLoadChunks;
    private int extraClaimChunks;
    private int extraForceLoadChunks;
    private Boolean canForceLoadChunks;
    private final Map<UUID, TeamMemberData> memberData;
    private int prevChunkX = Integer.MAX_VALUE;
    private int prevChunkZ = Integer.MAX_VALUE;
    private String lastChunkID = "";
    private long lastLoginTime;
    private Set<String> fakePlayerNameCache;
    private Collection<ClaimedChunkImpl> claimedChunkCache;
    private Collection<ClaimedChunkImpl> forcedChunkCache;
    private final Map<UUID, PreventedAccess> preventedAccess = new HashMap<UUID, PreventedAccess>();

    public ChunkTeamDataImpl(ClaimedChunkManagerImpl manager, Path file, Team team) {
        this.manager = manager;
        this.file = file;
        this.team = team;
        this.shouldSave = false;
        this.maxClaimChunks = -1;
        this.maxForceLoadChunks = -1;
        this.extraClaimChunks = 0;
        this.extraForceLoadChunks = 0;
        this.lastLoginTime = 0L;
        this.memberData = new HashMap<UUID, TeamMemberData>();
    }

    public String toString() {
        return this.team.getId().toString();
    }

    @Override
    public ClaimedChunkManagerImpl getManager() {
        return this.manager;
    }

    public Path getFile() {
        return this.file;
    }

    @Override
    public TeamManager getTeamManager() {
        return this.manager.getTeamManager();
    }

    @Override
    public Team getTeam() {
        return this.team;
    }

    public UUID getTeamId() {
        return this.team.getId();
    }

    @Override
    public void setExtraClaimChunks(int extraClaimChunks) {
        this.extraClaimChunks = extraClaimChunks;
    }

    @Override
    public void setExtraForceLoadChunks(int extraForceLoadChunks) {
        this.extraForceLoadChunks = extraForceLoadChunks;
    }

    public Collection<ClaimedChunkImpl> getClaimedChunks() {
        if (this.claimedChunkCache == null) {
            this.claimedChunkCache = this.manager.getAllClaimedChunks().stream().filter(chunk -> chunk.getTeamData() == this).collect(Collectors.toList());
        }
        return this.claimedChunkCache;
    }

    public Collection<ClaimedChunkImpl> getForceLoadedChunks() {
        if (this.forcedChunkCache == null) {
            this.forcedChunkCache = this.manager.getAllClaimedChunks().stream().filter(chunk -> chunk.getTeamData() == this && chunk.isForceLoaded()).collect(Collectors.toList());
        }
        return this.forcedChunkCache;
    }

    public Collection<ClaimedChunkImpl> getOriginalClaims(UUID playerID) {
        if (!this.memberData.containsKey(playerID)) {
            return Collections.emptyList();
        }
        ArrayList<ClaimedChunkImpl> res = new ArrayList<ClaimedChunkImpl>();
        for (ChunkDimPos cdp : this.memberData.get(playerID).getOriginalClaims()) {
            ClaimedChunkImpl cc = this.manager.getChunk(cdp);
            if (cc == null || cc.getTeamData() != this) continue;
            res.add(this.manager.getChunk(cdp));
        }
        return res;
    }

    @Override
    public ClaimResult claim(class_2168 source, ChunkDimPos pos, boolean checkOnly) {
        ClaimedChunkImpl chunk = this.manager.getChunk(pos);
        if (chunk != null) {
            return ClaimResult.StandardProblem.ALREADY_CLAIMED;
        }
        if (!DimensionFilter.isDimensionOK((class_5321<class_1937>)pos.dimension())) {
            return ClaimResult.StandardProblem.DIMENSION_FORBIDDEN;
        }
        if (!this.team.isServerTeam() && this.getClaimedChunks().size() >= this.getMaxClaimChunks()) {
            return ClaimResult.StandardProblem.NOT_ENOUGH_POWER;
        }
        chunk = new ClaimedChunkImpl(this, pos);
        ClaimResult result = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_CLAIM.invoker()).before(source, chunk).object();
        if (result == null) {
            result = chunk;
        }
        if (checkOnly || !result.isSuccess()) {
            return result;
        }
        chunk.setClaimedTime(System.currentTimeMillis());
        this.manager.registerClaim(pos, chunk);
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_CLAIM.invoker()).after(source, chunk);
        this.markDirty();
        return chunk;
    }

    @Override
    public ClaimResult unclaim(class_2168 source, ChunkDimPos pos, boolean checkOnly, boolean adminOverride) {
        ClaimedChunkImpl chunk = this.manager.getChunk(pos);
        if (chunk == null) {
            return ClaimResult.StandardProblem.NOT_CLAIMED;
        }
        if (!(chunk.getTeamData() == this || adminOverride && source.method_9259(2) || source.method_9211().method_3724())) {
            return ClaimResult.StandardProblem.NOT_OWNER;
        }
        ClaimResult result = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNCLAIM.invoker()).before(source, chunk).object();
        if (result == null) {
            result = chunk;
        }
        if (checkOnly || !result.isSuccess()) {
            return result;
        }
        chunk.unclaim(source, true);
        this.markDirty();
        return chunk;
    }

    @Override
    public ClaimResult forceLoad(class_2168 source, ChunkDimPos pos, boolean checkOnly, boolean adminOverride) {
        ClaimedChunkImpl chunk = this.manager.getChunk(pos);
        if (chunk == null) {
            return ClaimResult.StandardProblem.NOT_CLAIMED;
        }
        if (!(chunk.getTeamData() == this || adminOverride && source.method_9259(2) || source.method_9211().method_3724())) {
            return ClaimResult.StandardProblem.NOT_OWNER;
        }
        if (chunk.isForceLoaded()) {
            return ClaimResult.StandardProblem.ALREADY_LOADED;
        }
        if (!this.team.isServerTeam() && this.getForceLoadedChunks().size() >= this.getMaxForceLoadChunks()) {
            return ClaimResult.StandardProblem.NOT_ENOUGH_POWER;
        }
        ClaimResult result = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_LOAD.invoker()).before(source, chunk).object();
        if (result == null) {
            result = chunk;
        }
        if (checkOnly || !result.isSuccess()) {
            return result;
        }
        chunk.setForceLoadedTime(System.currentTimeMillis());
        ((ClaimedChunkEvent.After)ClaimedChunkEvent.AFTER_LOAD.invoker()).after(source, chunk);
        chunk.getTeamData().markDirty();
        chunk.sendUpdateToAll();
        return chunk;
    }

    @Override
    public ClaimResult unForceLoad(class_2168 source, ChunkDimPos pos, boolean checkOnly, boolean adminOverride) {
        ClaimedChunkImpl chunk = this.manager.getChunk(pos);
        if (chunk == null) {
            return ClaimResult.StandardProblem.NOT_CLAIMED;
        }
        if (!(chunk.getTeamData() == this || adminOverride && source.method_9259(2) || source.method_9211().method_3724() || source.method_9228() instanceof class_3222 && this.isTeamMember(source.method_9228().method_5667()))) {
            return ClaimResult.StandardProblem.NOT_OWNER;
        }
        if (!chunk.isForceLoaded()) {
            return ClaimResult.StandardProblem.NOT_LOADED;
        }
        ClaimResult result = (ClaimResult)((ClaimedChunkEvent.Before)ClaimedChunkEvent.BEFORE_UNLOAD.invoker()).before(source, chunk).object();
        if (result == null) {
            result = chunk;
        }
        if (checkOnly || !result.isSuccess()) {
            return result;
        }
        chunk.unload(source);
        return chunk;
    }

    public void markDirty() {
        this.shouldSave = true;
        this.team.markDirty();
    }

    @Override
    public boolean isTeamMember(UUID playerId) {
        return playerId.equals(this.getTeamId()) || this.team.getMembers().contains(playerId);
    }

    @Override
    public boolean isAlly(UUID playerId) {
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_ALL || this.team.getRankForPlayer(playerId).isMemberOrBetter()) {
            return true;
        }
        if (FTBChunksWorldConfig.ALLY_MODE.get() == AllyMode.FORCED_NONE) {
            return false;
        }
        return this.team.getRankForPlayer(playerId) == TeamRank.ALLY;
    }

    @Override
    public boolean canPlayerUse(class_3222 player, PrivacyProperty property) {
        PrivacyMode mode = (PrivacyMode)this.team.getProperty((TeamProperty)property);
        if (mode == PrivacyMode.PUBLIC) {
            return true;
        }
        if (PlayerHooks.isFake((class_1657)player)) {
            return this.canFakePlayerUse((class_1657)player, mode);
        }
        if (mode == PrivacyMode.ALLIES) {
            return this.isAlly(player.method_5667());
        }
        return this.team.getRankForPlayer(player.method_5667()).isMemberOrBetter();
    }

    private boolean canFakePlayerUse(class_1657 player, PrivacyMode mode) {
        boolean checkById;
        if (((Boolean)this.team.getProperty((TeamProperty)FTBChunksProperties.ALLOW_ALL_FAKE_PLAYERS)).booleanValue()) {
            return mode == PrivacyMode.ALLIES;
        }
        boolean bl = checkById = (Boolean)this.team.getProperty((TeamProperty)FTBChunksProperties.ALLOW_FAKE_PLAYERS_BY_ID) != false && player.method_5667() != null;
        if (mode == PrivacyMode.ALLIES) {
            return checkById && this.isAlly(player.method_5667()) || this.fakePlayerMatches(player.method_7334());
        }
        if (mode == PrivacyMode.PRIVATE) {
            return checkById && this.team.getRankForPlayer(player.method_5667()).isMemberOrBetter();
        }
        return false;
    }

    private boolean fakePlayerMatches(GameProfile profile) {
        return profile.getName() != null && this.getCachedFakePlayerNames().contains(profile.getName().toLowerCase(Locale.ROOT)) || profile.getId() != null && this.getCachedFakePlayerNames().contains(profile.getId().toString().toLowerCase(Locale.ROOT));
    }

    private Set<String> getCachedFakePlayerNames() {
        if (this.fakePlayerNameCache == null) {
            this.fakePlayerNameCache = ((List)this.team.getProperty((TeamProperty)FTBChunksProperties.ALLOW_NAMED_FAKE_PLAYERS)).stream().map(s -> s.toLowerCase(Locale.ROOT)).collect(Collectors.toSet());
        }
        return this.fakePlayerNameCache;
    }

    public void clearFakePlayerNameCache() {
        this.fakePlayerNameCache = null;
    }

    public SNBTCompoundTag serializeNBT() {
        SNBTCompoundTag tag = new SNBTCompoundTag();
        tag.method_10569("max_claim_chunks", this.getMaxClaimChunks());
        tag.method_10569("max_force_load_chunks", this.getMaxForceLoadChunks());
        if (this.extraClaimChunks > 0 && !this.team.isPartyTeam()) {
            tag.method_10569("extra_claim_chunks", this.extraClaimChunks);
        }
        if (this.extraForceLoadChunks > 0 && !this.team.isPartyTeam()) {
            tag.method_10569("extra_force_load_chunks", this.extraForceLoadChunks);
        }
        tag.method_10544("last_login_time", this.lastLoginTime);
        class_2487 chunksTag = new class_2487();
        for (ClaimedChunkImpl chunk : this.getClaimedChunks()) {
            String key = chunk.getPos().dimension().method_29177().toString();
            class_2499 chunksListTag = chunksTag.method_10554(key, 10);
            if (chunksListTag.isEmpty()) {
                chunksTag.method_10566(key, (class_2520)chunksListTag);
            }
            chunksListTag.add((Object)chunk.serializeNBT());
        }
        tag.method_10566("chunks", (class_2520)chunksTag);
        class_2487 memberTag = new class_2487();
        this.memberData.forEach((id, data) -> memberTag.method_10566(id.toString(), (class_2520)data.serializeNBT()));
        if (!memberTag.method_33133()) {
            tag.method_10566("member_data", (class_2520)memberTag);
        }
        if (!this.preventedAccess.isEmpty()) {
            SNBTCompoundTag p = new SNBTCompoundTag();
            this.preventedAccess.forEach((id, element) -> p.method_10566(id.toString(), (class_2520)PreventedAccess.CODEC.encodeStart((DynamicOps)class_2509.field_11560, element).result().orElseThrow()));
            tag.method_10566("prevented_access", (class_2520)p);
        }
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.maxClaimChunks = tag.method_10550("max_claim_chunks");
        this.maxForceLoadChunks = tag.method_10550("max_force_load_chunks");
        this.extraClaimChunks = tag.method_10550("extra_claim_chunks");
        this.extraForceLoadChunks = tag.method_10550("extra_force_load_chunks");
        this.lastLoginTime = tag.method_10537("last_login_time");
        this.canForceLoadChunks = null;
        this.claimedChunkCache = null;
        this.forcedChunkCache = null;
        class_2487 chunksTag = tag.method_10562("chunks");
        for (Object key : chunksTag.method_10541()) {
            class_5321 dimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_12829((String)key));
            class_2499 chunksListTag = chunksTag.method_10554((String)key, 10);
            for (int i = 0; i < chunksListTag.size(); ++i) {
                ClaimedChunkImpl chunk = ClaimedChunkImpl.deserializeNBT(this, (class_5321<class_1937>)dimKey, chunksListTag.method_10602(i));
                this.manager.registerClaim(chunk.getPos(), chunk);
            }
        }
        this.memberData.clear();
        class_2487 memberTag = tag.method_10562("member_data");
        for (String key : memberTag.method_10541()) {
            try {
                UUID id = UUID.fromString(key);
                if (id == class_156.field_25140) continue;
                this.memberData.put(id, TeamMemberData.deserializeNBT(memberTag.method_10562(key)));
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
        }
        this.preventedAccess.clear();
        if (tag.method_10545("prevented_access")) {
            class_2487 p = tag.method_10562("prevented_access");
            for (String key : p.method_10541()) {
                this.preventedAccess.put(UUID.fromString(key), (PreventedAccess)PreventedAccess.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)p.method_10562(key)).result().orElseThrow());
            }
            this.prunePreventedLog();
        }
    }

    @Override
    public int getExtraClaimChunks() {
        if (this.extraClaimChunks > 0 && this.team.isPartyTeam()) {
            FTBChunks.LOGGER.info("found non-zero extra_claim_chunks={} in party team {}: transferring to owner {}", (Object)this.extraClaimChunks, (Object)this.getTeamId(), (Object)this.team.getOwner());
            ChunkTeamDataImpl personalTeam = ClaimedChunkManagerImpl.getInstance().getPersonalData(this.team.getOwner());
            personalTeam.extraClaimChunks = this.extraClaimChunks;
            this.extraClaimChunks = 0;
            this.markDirty();
            personalTeam.markDirty();
        }
        return this.extraClaimChunks;
    }

    @Override
    public int getExtraForceLoadChunks() {
        if (this.extraForceLoadChunks > 0 && this.team.isPartyTeam()) {
            FTBChunks.LOGGER.info("found non-zero extra_force_load_chunks={} in party team {}: transferring to owner {}", (Object)this.extraForceLoadChunks, (Object)this.getTeamId(), (Object)this.team.getOwner());
            ChunkTeamDataImpl personalTeam = ClaimedChunkManagerImpl.getInstance().getPersonalData(this.team.getOwner());
            personalTeam.extraForceLoadChunks = this.extraForceLoadChunks;
            this.extraForceLoadChunks = 0;
            this.markDirty();
            personalTeam.markDirty();
        }
        return this.extraForceLoadChunks;
    }

    public boolean setForceLoadMember(UUID id, boolean val) {
        if (val == this.getTeamMemberData(id).isOfflineForceLoader()) {
            return false;
        }
        this.getTeamMemberData(id).setOfflineForceLoader(val);
        FTBChunks.LOGGER.debug("team {}: set force load member {} = {}", (Object)this.team.getId(), (Object)id, (Object)val);
        this.markDirty();
        this.canForceLoadChunks = null;
        this.manager.clearForceLoadedCache();
        return true;
    }

    @NotNull
    private TeamMemberData getTeamMemberData(UUID id) {
        if (id.equals(class_156.field_25140)) {
            FTBChunks.LOGGER.warn("attempt to get member data for nil UUID");
            new RuntimeException().printStackTrace();
            return TeamMemberData.defaultData();
        }
        return this.memberData.computeIfAbsent(id, k -> TeamMemberData.defaultData());
    }

    public void updateChunkTickets(boolean load) {
        this.getClaimedChunks().forEach(chunk -> {
            class_3218 level;
            if (chunk.isForceLoaded() && (level = this.manager.getMinecraftServer().method_3847(chunk.getPos().dimension())) != null) {
                FTBChunksExpected.addChunkToForceLoaded(level, "ftbchunks", this.getTeamId(), chunk.getPos().x(), chunk.getPos().z(), load);
            }
        });
    }

    public void saveNow() {
        if (this.shouldSave && SNBT.write((Path)this.file, (class_2487)this.serializeNBT())) {
            this.shouldSave = false;
        }
    }

    @Override
    public boolean canDoOfflineForceLoading() {
        if (this.canForceLoadChunks == null) {
            this.canForceLoadChunks = switch ((ForceLoadMode)((Object)FTBChunksWorldConfig.FORCE_LOAD_MODE.get())) {
                case ForceLoadMode.ALWAYS -> true;
                case ForceLoadMode.NEVER -> false;
                default -> this.hasForceLoadMembers();
            };
        }
        return this.canForceLoadChunks;
    }

    private boolean hasForceLoadMembers() {
        return this.memberData.values().stream().anyMatch(TeamMemberData::isOfflineForceLoader);
    }

    @Override
    public boolean canExplosionsDamageTerrain() {
        return (Boolean)this.team.getProperty((TeamProperty)FTBChunksProperties.ALLOW_EXPLOSIONS);
    }

    @Override
    public boolean allowMobGriefing() {
        return (Boolean)this.team.getProperty((TeamProperty)FTBChunksProperties.ALLOW_MOB_GRIEFING);
    }

    @Override
    public boolean allowPVP() {
        return (Boolean)this.team.getProperty((TeamProperty)FTBChunksProperties.ALLOW_PVP);
    }

    public void setLastLoginTime(long when) {
        this.lastLoginTime = when;
        this.markDirty();
    }

    @Override
    public long getLastLoginTime() {
        if (this.lastLoginTime == 0L) {
            this.setLastLoginTime(System.currentTimeMillis());
        }
        return this.lastLoginTime;
    }

    @Override
    public boolean shouldHideClaims() {
        return this.getTeam().getProperty((TeamProperty)FTBChunksProperties.CLAIM_VISIBILITY) != PrivacyMode.PUBLIC;
    }

    public void syncChunksToPlayer(class_3222 recipient) {
        this.chunksByDimension().forEach((dimension, chunkPackets) -> {
            if (!chunkPackets.isEmpty()) {
                new SendManyChunksPacket((class_5321<class_1937>)dimension, this.getTeamId(), (List<ChunkSyncInfo>)chunkPackets).sendToPlayer(recipient, this);
            }
        });
    }

    public void syncChunksToAll(MinecraftServer server) {
        this.chunksByDimension().forEach((dimension, chunkPackets) -> {
            if (!chunkPackets.isEmpty()) {
                new SendManyChunksPacket((class_5321<class_1937>)dimension, this.getTeamId(), (List<ChunkSyncInfo>)chunkPackets).sendToAll(server, this);
            }
        });
    }

    private Map<class_5321<class_1937>, List<ChunkSyncInfo>> chunksByDimension() {
        long now = System.currentTimeMillis();
        return this.getClaimedChunks().stream().collect(Collectors.groupingBy(c -> c.getPos().dimension(), Collectors.mapping(c -> ChunkSyncInfo.create(now, c.getPos().x(), c.getPos().z(), c), Collectors.toList())));
    }

    @Override
    public int getMaxClaimChunks() {
        return this.maxClaimChunks;
    }

    @Override
    public int getMaxForceLoadChunks() {
        return this.maxForceLoadChunks;
    }

    public void updateLimits() {
        this.updateMemberLimitData(!this.memberData.isEmpty());
        int prevMaxClaimed = this.maxClaimChunks;
        int prevMaxForced = this.maxForceLoadChunks;
        if (!this.team.isPartyTeam()) {
            TeamMemberData m2 = this.getTeamMemberData(this.getTeam().getId());
            this.maxClaimChunks = m2.getMaxClaims();
            this.maxForceLoadChunks = m2.getMaxForceLoads();
        } else {
            switch ((PartyLimitMode)((Object)FTBChunksWorldConfig.PARTY_LIMIT_MODE.get())) {
                case OWNER: {
                    TeamMemberData m3 = this.getTeamMemberData(this.getTeam().getOwner());
                    this.maxClaimChunks = m3.getMaxClaims();
                    this.maxForceLoadChunks = m3.getMaxForceLoads();
                    break;
                }
                case SUM: {
                    this.maxForceLoadChunks = 0;
                    this.maxClaimChunks = 0;
                    this.memberData.values().forEach(m -> {
                        this.maxClaimChunks += m.getMaxClaims();
                        this.maxForceLoadChunks += m.getMaxForceLoads();
                    });
                    break;
                }
                case LARGEST: {
                    this.maxForceLoadChunks = 0;
                    this.maxClaimChunks = 0;
                    for (TeamMemberData m4 : this.memberData.values()) {
                        this.maxClaimChunks = Math.max(m4.getMaxClaims(), this.maxClaimChunks);
                        this.maxForceLoadChunks = Math.max(m4.getMaxForceLoads(), this.maxForceLoadChunks);
                    }
                    break;
                }
                case AVERAGE: {
                    this.maxForceLoadChunks = 0;
                    this.maxClaimChunks = 0;
                    this.memberData.values().forEach(m -> {
                        this.maxClaimChunks += m.getMaxClaims();
                        this.maxForceLoadChunks += m.getMaxForceLoads();
                    });
                    if (this.memberData.isEmpty()) break;
                    this.maxClaimChunks /= this.memberData.size();
                    this.maxForceLoadChunks /= this.memberData.size();
                }
            }
        }
        if ((Integer)FTBChunksWorldConfig.HARD_TEAM_CLAIM_LIMIT.get() > 0) {
            this.maxClaimChunks = Math.min(this.maxClaimChunks, (Integer)FTBChunksWorldConfig.HARD_TEAM_CLAIM_LIMIT.get());
        }
        if ((Integer)FTBChunksWorldConfig.HARD_TEAM_FORCE_LIMIT.get() > 0) {
            this.maxForceLoadChunks = Math.min(this.maxForceLoadChunks, (Integer)FTBChunksWorldConfig.HARD_TEAM_FORCE_LIMIT.get());
        }
        if (this.maxClaimChunks != prevMaxClaimed || this.maxForceLoadChunks != prevMaxForced) {
            SendGeneralDataPacket.send((ChunkTeamData)this, this.getTeam().getOnlineMembers());
        }
        this.markDirty();
    }

    private void updateMemberLimitData(boolean onlinePlayersOnly) {
        HashSet members = new HashSet(this.team.getMembers());
        for (class_3222 p : this.team.getOnlineMembers()) {
            Team playerTeam = this.getTeamManager().getPlayerTeamForPlayerID(p.method_5667()).orElse(null);
            TeamMemberData m = this.getTeamMemberData(p.method_5667());
            if (playerTeam != null) {
                ChunkTeamDataImpl personalData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(playerTeam);
                m.setMaxClaims(FTBChunksWorldConfig.getMaxClaimedChunks(personalData, p));
                m.setMaxForceLoads(FTBChunksWorldConfig.getMaxForceLoadedChunks(personalData, p));
            } else {
                m.setMaxClaims((Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get());
                m.setMaxForceLoads((Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get());
            }
            members.remove(p.method_5667());
        }
        if (!onlinePlayersOnly) {
            for (UUID id : members) {
                int maxF;
                int maxC;
                TeamMemberData m = this.getTeamMemberData(id);
                Team playerTeam = this.getTeamManager().getPlayerTeamForPlayerID(id).orElse(null);
                if (playerTeam != null) {
                    ChunkTeamDataImpl personalData = ClaimedChunkManagerImpl.getInstance().getOrCreateData(playerTeam);
                    maxC = (Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get() + personalData.getExtraClaimChunks();
                    maxF = (Integer)FTBChunksWorldConfig.MAX_FORCE_LOADED_CHUNKS.get() + personalData.getExtraForceLoadChunks();
                } else {
                    maxC = (Integer)FTBChunksWorldConfig.MAX_CLAIMED_CHUNKS.get();
                    maxF = (Integer)FTBChunksWorldConfig.MAX_FORCE_LOADED_CHUNKS.get();
                }
                m.setMaxClaims(maxC);
                m.setMaxForceLoads(maxF);
            }
        }
        this.markDirty();
    }

    public void addMemberData(class_3222 player, ChunkTeamDataImpl otherTeam) {
        if (otherTeam.team.isPlayerTeam()) {
            this.memberData.put(otherTeam.getTeamId(), TeamMemberData.fromPlayerData(player, otherTeam));
            this.markDirty();
        }
    }

    public void deleteMemberData(UUID playerId) {
        if (this.memberData.remove(playerId) != null) {
            this.markDirty();
        }
    }

    private boolean hasChunkChanged(ClaimedChunkImpl chunk) {
        String s;
        String string = s = chunk == null ? "-" : chunk.getTeamData().getTeamId().toString();
        if (!this.lastChunkID.equals(s)) {
            this.lastChunkID = s;
            return true;
        }
        return false;
    }

    public void checkForChunkChange(class_1657 player, int chunkX, int chunkZ) {
        if (this.prevChunkX != chunkX || this.prevChunkZ != chunkZ) {
            ClaimedChunkImpl chunk = ClaimedChunkManagerImpl.getInstance().getChunk(new ChunkDimPos((class_1297)player));
            if (this.hasChunkChanged(chunk)) {
                if (chunk != null) {
                    player.method_7353(chunk.getTeamData().getTeam().getColoredName(), true);
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"wilderness").method_27692(class_124.field_1077), true);
                }
            }
            this.prevChunkX = chunkX;
            this.prevChunkZ = chunkZ;
        }
    }

    public void clearClaimCaches() {
        this.claimedChunkCache = null;
        this.forcedChunkCache = null;
    }

    @Override
    public void checkMemberForceLoading(UUID playerId) {
        class_3222 player;
        if (this.isTeamMember(playerId) && (player = this.manager.getMinecraftServer().method_3760().method_14602(playerId)) != null && this.setForceLoadMember(playerId, FTBChunksWorldConfig.canPlayerOfflineForceload(player))) {
            this.updateLimits();
        }
    }

    public void logPreventedAccess(class_3222 player, long when) {
        this.preventedAccess.put(player.method_5667(), new PreventedAccess(player.method_7334().getName(), when));
        this.markDirty();
    }

    private void prunePreventedLog() {
        HashSet toRemove = new HashSet();
        long now = System.currentTimeMillis();
        long max = (long)((Integer)FTBChunksWorldConfig.MAX_PREVENTED_LOG_AGE.get()).intValue() * 86400L * 1000L;
        this.preventedAccess.forEach((id, el) -> {
            if (now - el.when() > max) {
                toRemove.add(id);
            }
        });
        if (!toRemove.isEmpty()) {
            toRemove.forEach(this.preventedAccess::remove);
            this.markDirty();
        }
    }

    private record PreventedAccess(String name, long when) {
        public static final Codec<PreventedAccess> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(PreventedAccess::name), (App)Codec.LONG.fieldOf("when").forGetter(PreventedAccess::when)).apply((Applicative)instance, PreventedAccess::new));
    }
}

