/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client.gui;

import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.gui.SliceCreationGUI;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityIcons;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.ToggleableButton;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.misc.AbstractGroupedButtonListScreen;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class EntityIconSettingsScreen
extends AbstractGroupedButtonListScreen<class_1311, class_1299<?>> {
    private final boolean showCreationButton;

    public EntityIconSettingsScreen(boolean showCreationButton) {
        super((class_2561)class_2561.method_43471((String)"ftbchunks.gui.entity_icon_settings"));
        this.showCreationButton = showCreationButton;
    }

    protected List<AbstractGroupedButtonListScreen.GroupData<class_1311, class_1299<?>>> getGroups() {
        ArrayList groups = new ArrayList();
        for (class_1311 mobCategory : class_1311.values()) {
            ArrayList<class_1299> entityTypes = new ArrayList<class_1299>();
            for (class_1299 entityType : class_7923.field_41177) {
                if (entityType.method_5891() != mobCategory || !EntityIcons.canTypeRenderer(entityType)) continue;
                entityTypes.add(entityType);
            }
            groups.add(new AbstractGroupedButtonListScreen.GroupData((Object)mobCategory, false, (class_2561)class_2561.method_43471((String)("mob_category." + mobCategory.method_6133())), entityTypes));
        }
        return groups;
    }

    protected AbstractGroupedButtonListScreen.RowPanel createRowPanel(Panel panel, class_1299<?> value) {
        return new RowPanel(panel, value);
    }

    private class RowPanel
    extends AbstractGroupedButtonListScreen.RowPanel {
        private TextField nameField;
        private SimpleButton hideButton;
        private SimpleButton createButton;
        private final Icon icon;
        private final class_5321<class_1299<?>> resourceKey;

        public RowPanel(Panel panel, class_1299<?> entityType) {
            super((AbstractGroupedButtonListScreen)EntityIconSettingsScreen.this, panel, entityType);
            this.icon = EntityIcons.getIcon(entityType);
            this.resourceKey = class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)class_7923.field_41177.method_10221(entityType));
            this.setHeight(18);
        }

        public void addWidgets() {
            boolean hiddenState = ((Map)FTBChunksClientConfig.ENTITY_ICON.get()).getOrDefault(this.resourceKey, true);
            this.hideButton = new ToggleableButton((Panel)this, hiddenState, Icons.ACCEPT, Icons.ACCEPT_GRAY, (hideButton, hidden) -> {
                ((Map)FTBChunksClientConfig.ENTITY_ICON.get()).put(this.resourceKey, hidden);
                FTBChunksClientConfig.saveConfig();
            });
            this.add((Widget)this.hideButton);
            if (EntityIconSettingsScreen.this.showCreationButton) {
                boolean isDynamicTexture = EntityIcons.IS_USING_NEW_JSON.getOrDefault(this.value, false);
                Icon icon = isDynamicTexture ? Icons.BOOK_RED : Icons.BOOK;
                this.createButton = new SimpleButton((Panel)this, (class_2561)class_2561.method_43471((String)"ftbchunks.gui.open_creation_gui"), icon, (widget, button) -> new SliceCreationGUI((class_1299)this.value).openGui());
                this.add((Widget)this.createButton);
            }
            final EntityIcons.EntityIconSettings entityIconSettings = EntityIcons.getSettings((class_1299)this.value).orElseThrow();
            this.nameField = new TextField((Panel)this){

                public void draw(class_332 graphics, Theme theme, int x, int y, int w, int h) {
                    graphics.method_51448().method_22903();
                    graphics.method_51448().method_46416((float)(x - 16), (float)(y - 2), 0.0f);
                    graphics.method_51448().method_22905(0.75f, 0.75f, 0.0f);
                    RowPanel.this.icon.draw(graphics, 0, 0, entityIconSettings.widthHeight().width(), entityIconSettings.widthHeight().height());
                    graphics.method_51448().method_22909();
                    super.draw(graphics, theme, x, y, w, h);
                }

                public void addMouseOverText(TooltipList list) {
                    list.add((class_2561)class_2561.method_43470((String)((class_1299)RowPanel.this.value).arch$registryName().toString()));
                }
            }.setTrim().addFlags(2);
            this.add((Widget)this.nameField);
        }

        public void alignWidgets() {
        }

        public void setWidth(int newWidth) {
            super.setWidth(newWidth);
            if (newWidth <= 0) {
                return;
            }
            int farRight = newWidth - 8;
            int yOff = (this.height - EntityIconSettingsScreen.this.getTheme().getFontHeight()) / 2 + 1;
            double size = 16.0;
            this.hideButton.setForceButtonSize(false);
            this.hideButton.setPosAndSize(farRight - 8, 1, (int)size, (int)size);
            if (EntityIconSettingsScreen.this.showCreationButton) {
                this.createButton.setPosAndSize(farRight - 8 - (int)size, 1, (int)size, (int)size);
            }
            this.nameField.setPos(17, yOff);
            this.nameField.setText((class_2561)class_2561.method_43471((String)((class_1299)this.value).method_5882()));
            this.nameField.setHeight(EntityIconSettingsScreen.this.getTheme().getFontHeight() + 2);
        }
    }
}

