/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks.client;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientPlayerEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientReloadShadersEvent;
import dev.architectury.event.events.client.ClientScreenInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.hooks.client.screen.ScreenAccess;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftbchunks.ColorMapLoader;
import dev.ftb.mods.ftbchunks.FTBChunks;
import dev.ftb.mods.ftbchunks.FTBChunksWorldConfig;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftbchunks.api.client.FTBChunksClientAPI;
import dev.ftb.mods.ftbchunks.api.client.event.MapIconEvent;
import dev.ftb.mods.ftbchunks.api.client.icon.MapIcon;
import dev.ftb.mods.ftbchunks.api.client.icon.MapType;
import dev.ftb.mods.ftbchunks.api.client.icon.WaypointIcon;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapContext;
import dev.ftb.mods.ftbchunks.api.client.minimap.MinimapInfoComponent;
import dev.ftb.mods.ftbchunks.api.client.waypoint.Waypoint;
import dev.ftb.mods.ftbchunks.client.ClientTaskQueue;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientAPIImpl;
import dev.ftb.mods.ftbchunks.client.FTBChunksClientConfig;
import dev.ftb.mods.ftbchunks.client.MinimapBlurMode;
import dev.ftb.mods.ftbchunks.client.MinimapPosition;
import dev.ftb.mods.ftbchunks.client.PointerIconMode;
import dev.ftb.mods.ftbchunks.client.VisibleClientPlayers;
import dev.ftb.mods.ftbchunks.client.fabric.FTBChunksClientImpl;
import dev.ftb.mods.ftbchunks.client.gui.AddWaypointOverlay;
import dev.ftb.mods.ftbchunks.client.gui.ChunkScreen;
import dev.ftb.mods.ftbchunks.client.gui.LargeMapScreen;
import dev.ftb.mods.ftbchunks.client.gui.PointerIcon;
import dev.ftb.mods.ftbchunks.client.gui.WaypointEditorScreen;
import dev.ftb.mods.ftbchunks.client.map.ChunkUpdateTask;
import dev.ftb.mods.ftbchunks.client.map.MapDimension;
import dev.ftb.mods.ftbchunks.client.map.MapManager;
import dev.ftb.mods.ftbchunks.client.map.MapRegion;
import dev.ftb.mods.ftbchunks.client.map.MapRegionData;
import dev.ftb.mods.ftbchunks.client.map.MapTask;
import dev.ftb.mods.ftbchunks.client.map.RegionSyncKey;
import dev.ftb.mods.ftbchunks.client.map.UpdateChunkFromServerTask;
import dev.ftb.mods.ftbchunks.client.map.WaypointImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointManagerImpl;
import dev.ftb.mods.ftbchunks.client.map.WaypointType;
import dev.ftb.mods.ftbchunks.client.map.color.ColorUtils;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityIcons;
import dev.ftb.mods.ftbchunks.client.mapicon.EntityMapIcon;
import dev.ftb.mods.ftbchunks.client.mapicon.InWorldMapIcon;
import dev.ftb.mods.ftbchunks.client.mapicon.MapIconComparator;
import dev.ftb.mods.ftbchunks.client.mapicon.TrackedPlayerMapIcon;
import dev.ftb.mods.ftbchunks.client.minimap.components.BiomeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.DebugComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.FPSComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.GameTimeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.PlayerPosInfoComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.RealTimeComponent;
import dev.ftb.mods.ftbchunks.client.minimap.components.ZoneInfoComponent;
import dev.ftb.mods.ftbchunks.data.ChunkSyncInfo;
import dev.ftb.mods.ftbchunks.net.PartialPackets;
import dev.ftb.mods.ftbchunks.net.SendGeneralDataPacket;
import dev.ftb.mods.ftblibrary.config.ColorConfig;
import dev.ftb.mods.ftblibrary.config.ConfigFromString;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.FaceIcon;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.math.XZ;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.ModalPanel;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.util.client.ClientUtils;
import dev.ftb.mods.ftbteams.api.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_1011;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2626;
import net.minecraft.class_2637;
import net.minecraft.class_2672;
import net.minecraft.class_2680;
import net.minecraft.class_276;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_4076;
import net.minecraft.class_4184;
import net.minecraft.class_4208;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5912;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_7833;
import net.minecraft.class_9779;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public enum FTBChunksClient {
    INSTANCE;

    public static final ExecutorService MAP_EXECUTOR;
    public static final class_2960 WAYPOINT_BEAM;
    private static final class_2960 BUTTON_ID_MAP;
    private static final class_2960 BUTTON_ID_CLAIM;
    public static final class_2960 CIRCLE_MASK;
    public static final class_2960 CIRCLE_BORDER;
    public static final class_2960 SQUARE_MASK;
    public static final class_2960 SQUARE_BORDER;
    public static final class_2960 PLAYER;
    public static final class_2960[] COMPASS;
    public class_304 openMapKey;
    public class_304 toggleMinimapKey;
    public class_304 openClaimManagerKey;
    public class_304 zoomInKey;
    public class_304 zoomOutKey;
    public class_304 addWaypointKey;
    public class_304 waypointManagerKey;
    private final Map<UUID, TrackedPlayerMapIcon> longRangePlayerTracker = new HashMap<UUID, TrackedPlayerMapIcon>();
    private long taskQueueTicks = 0L;
    private final Map<class_1923, IntOpenHashSet> rerenderCache = new HashMap<class_1923, IntOpenHashSet>();
    private int minimapTextureId = -1;
    private int currentPlayerChunkX;
    private int currentPlayerChunkZ;
    private double currentPlayerX;
    private double currentPlayerY;
    private double currentPlayerZ;
    private double prevPlayerX;
    private double prevPlayerY;
    private double prevPlayerZ;
    private int renderedDebugCount = 0;
    private boolean updateMinimapScheduled = false;
    private SendGeneralDataPacket.GeneralChunkData generalChunkData;
    private long nextRegionSave = 0L;
    private double prevZoom = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
    private long lastZoomTime = 0L;
    private final List<MapIcon> mapIcons = new ArrayList<MapIcon>();
    private final List<InWorldMapIcon> inWorldMapIcons = new ArrayList<InWorldMapIcon>();
    private long lastMapIconUpdate = 0L;
    private Matrix4f worldMatrix;
    private class_243 cameraPos;
    private final List<MinimapInfoComponent> sortedComponents = new LinkedList<MinimapInfoComponent>();
    private static double vanillaEffectsOffsetX;

    public void init() {
        if (class_310.method_1551() == null) {
            return;
        }
        this.maybeMigrateClientConfig();
        FTBChunksAPI._initClient(new FTBChunksClientAPIImpl());
        this.registerKeys();
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new EntityIcons());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)new ColorMapLoader());
        ClientPlayerEvent.CLIENT_PLAYER_QUIT.register(this::loggedOut);
        CustomClickEvent.EVENT.register(this::customClick);
        ClientRawInputEvent.KEY_PRESSED.register(this::keyPressed);
        ClientScreenInputEvent.KEY_PRESSED_PRE.register(this::keyPressed);
        ClientGuiEvent.RENDER_HUD.register(this::renderHud);
        ClientGuiEvent.INIT_PRE.register(this::screenOpened);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        TeamEvent.CLIENT_PROPERTIES_CHANGED.register(this::teamPropertiesChanged);
        MapIconEvent.LARGE_MAP.register(this::mapIcons);
        MapIconEvent.MINIMAP.register(this::mapIcons);
        ClientReloadShadersEvent.EVENT.register(this::reloadShaders);
        FTBChunksClient.registerPlatform();
        FTBChunksClientAPI clientApi = FTBChunksAPI.clientApi();
        clientApi.registerMinimapComponent(new PlayerPosInfoComponent());
        clientApi.registerMinimapComponent(new ZoneInfoComponent());
        clientApi.registerMinimapComponent(new BiomeComponent());
        clientApi.registerMinimapComponent(new GameTimeComponent());
        clientApi.registerMinimapComponent(new RealTimeComponent());
        clientApi.registerMinimapComponent(new FPSComponent());
        clientApi.registerMinimapComponent(new DebugComponent());
        ClientLifecycleEvent.CLIENT_STARTED.register(this::clientStarted);
    }

    private void maybeMigrateClientConfig() {
        Path oldConfig = Platform.getGameFolder().resolve("local/ftbchunks/client-config.snbt");
        Path newConfig = Platform.getConfigFolder().resolve("ftbchunks-client.snbt");
        if (Files.exists(oldConfig, new LinkOption[0]) && !Files.exists(newConfig, new LinkOption[0])) {
            try {
                Files.move(oldConfig, newConfig, new CopyOption[0]);
                FTBChunks.LOGGER.info("migrated {} to {}", (Object)oldConfig, (Object)newConfig);
            }
            catch (IOException e) {
                FTBChunks.LOGGER.error("can't migrate {} to {}: {}", (Object)oldConfig, (Object)newConfig, (Object)e.getMessage());
            }
        }
    }

    private void clientStarted(class_310 minecraft) {
        this.setupComponents();
    }

    private void registerKeys() {
        this.openMapKey = new class_304("key.ftbchunks.map", class_3675.class_307.field_1668, 77, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)this.openMapKey);
        this.toggleMinimapKey = new class_304("key.ftbchunks.toggle_minimap", class_3675.class_307.field_1668, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)this.toggleMinimapKey);
        this.openClaimManagerKey = new class_304("key.ftbchunks.claim_manager", class_3675.class_307.field_1668, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)this.openClaimManagerKey);
        this.zoomInKey = new class_304("key.ftbchunks.minimap.zoomIn", class_3675.class_307.field_1668, 61, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)this.zoomInKey);
        this.zoomOutKey = new class_304("key.ftbchunks.minimap.zoomOut", class_3675.class_307.field_1668, 45, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)this.zoomOutKey);
        this.addWaypointKey = new class_304("key.ftbchunks.add_waypoint", class_3675.class_307.field_1668, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)this.addWaypointKey);
        this.waypointManagerKey = new class_304("key.ftbchunks.waypoint_manager", class_3675.class_307.field_1668, -1, "key.categories.ftbchunks");
        KeyMappingRegistry.register((class_304)this.waypointManagerKey);
    }

    public Set<class_1923> getPendingRerender() {
        return this.rerenderCache.keySet();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerPlatform() {
        FTBChunksClientImpl.registerPlatform();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean doesKeybindMatch(class_304 keyMapping, int keyCode, int scanCode, int modifiers) {
        void var3_3;
        void var2_2;
        void var1_1;
        return FTBChunksClientImpl.doesKeybindMatch(keyMapping, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    public static boolean doesKeybindMatch(class_304 keyMapping, Key key) {
        return FTBChunksClient.doesKeybindMatch(keyMapping, key.keyCode, key.scanCode, key.modifiers.modifiers);
    }

    public void openGui() {
        LargeMapScreen.openMap();
    }

    public void scheduleMinimapUpdate() {
        this.updateMinimapScheduled = true;
    }

    public void handlePlayerLogin(UUID serverId) {
        FTBChunks.LOGGER.info("Loading FTB Chunks client data from world {}", (Object)serverId);
        MapManager.startUp(serverId);
        this.scheduleMinimapUpdate();
        this.renderedDebugCount = 0;
        ChunkUpdateTask.init();
    }

    public void loggedOut(@Nullable class_746 player) {
        MapManager.shutdown();
    }

    public void updateGeneralData(SendGeneralDataPacket.GeneralChunkData chunkData) {
        this.generalChunkData = chunkData;
    }

    public void updateChunksFromServer(class_5321<class_1937> dimId, UUID teamId, Collection<ChunkSyncInfo> chunkSyncInfoList) {
        MapManager.getInstance().ifPresent(manager -> {
            MapDimension dimension = manager.getDimension(dimId);
            Date now = new Date();
            chunkSyncInfoList.forEach(chunkSyncInfo -> ClientTaskQueue.queue(new UpdateChunkFromServerTask(dimension, (ChunkSyncInfo)chunkSyncInfo, teamId, now)));
        });
    }

    public void syncRegionFromServer(RegionSyncKey key, int offset, int total, byte[] data) {
        PartialPackets.REGION.read(key, offset, total, data);
    }

    public void handlePlayerDeath(class_4208 pos, int deathNumber) {
        if (((Boolean)FTBChunksClientConfig.DEATH_WAYPOINTS.get()).booleanValue() && FTBChunksWorldConfig.playerHasMapStage((class_1657)class_310.method_1551().field_1724)) {
            MapManager.getInstance().ifPresent(manager -> {
                MapDimension dimension = manager.getDimension((class_5321<class_1937>)pos.comp_2207());
                for (WaypointImpl w : dimension.getWaypointManager()) {
                    if (!w.isDeathpoint()) continue;
                    w.setHidden(true);
                    w.refreshIcon();
                }
                WaypointImpl deathPoint = new WaypointImpl(WaypointType.DEATH, dimension, pos.comp_2208()).setName("Death #" + deathNumber).setColor(0xFF0000);
                dimension.getWaypointManager().add(deathPoint);
            });
        }
    }

    public void handleBlockColorRequest() {
        class_310 mc = class_310.method_1551();
        mc.method_20493(() -> {
            mc.method_1507(null);
            new Thread(() -> {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                mc.method_20493(() -> {
                    class_239 patt0$temp = mc.field_1765;
                    if (patt0$temp instanceof class_3965) {
                        class_3965 hitResult = (class_3965)patt0$temp;
                        if (mc.field_1687 != null && mc.field_1724 != null) {
                            class_2960 id = FTBChunks.BLOCK_REGISTRY.getId((Object)mc.field_1687.method_8320(hitResult.method_17777()).method_26204());
                            class_1041 window = mc.method_22683();
                            try (class_1011 image = class_318.method_1663((class_276)mc.method_1522());){
                                int col = image.method_4315(image.method_4307() / 2 - (int)(2.0 * window.method_4495()), image.method_4323() / 2 - (int)(2.0 * window.method_4495()));
                                String s = String.format("\"%s\": \"#%06X\"", id.method_12832(), ColorUtils.convertFromNative(col) & 0xFFFFFF);
                                mc.field_1724.method_7353((class_2561)class_2561.method_43470((String)(id.method_12836() + " - " + s)).method_27696(class_2583.field_24360.method_27706(class_124.field_1065).method_10958(new class_2558(class_2558.class_2559.field_21462, s)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43470((String)"Click to copy")))), false);
                            }
                        }
                    }
                });
            }, "Color getter").start();
        });
    }

    public void syncLoadedChunkViewFromServer(class_5321<class_1937> dimension, Long2IntMap chunks) {
        MapManager.getInstance().ifPresent(manager -> {
            manager.getDimension(dimension).updateLoadedChunkView(chunks);
            manager.updateAllRegions(false);
        });
    }

    public boolean skipBlock(class_2680 state) {
        class_2960 id = FTBChunks.BLOCK_REGISTRY.getId((Object)state.method_26204());
        return id == null || ColorMapLoader.getBlockColor(id).isIgnored();
    }

    public EventResult customClick(CustomClickEvent event) {
        if (FTBChunksWorldConfig.playerHasMapStage((class_1657)class_310.method_1551().field_1724)) {
            if (event.id().equals((Object)BUTTON_ID_MAP)) {
                this.openGui();
                return EventResult.interruptTrue();
            }
            if (event.id().equals((Object)BUTTON_ID_CLAIM)) {
                ChunkScreen.openChunkScreen();
                return EventResult.interruptTrue();
            }
        }
        return EventResult.pass();
    }

    public EventResult keyPressed(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        if (action != 1 || client.field_1755 != null || !FTBChunksWorldConfig.playerHasMapStage((class_1657)client.field_1724) || class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)292)) {
            return EventResult.pass();
        }
        if (FTBChunksClient.doesKeybindMatch(this.openMapKey, keyCode, scanCode, modifiers)) {
            this.openGui();
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.toggleMinimapKey, keyCode, scanCode, modifiers)) {
            FTBChunksClientConfig.MINIMAP_ENABLED.set((Object)((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get() == false ? 1 : 0));
            FTBChunksClientConfig.saveConfig();
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.openClaimManagerKey, keyCode, scanCode, modifiers)) {
            try {
                ChunkScreen.openChunkScreen();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return EventResult.interruptTrue();
        }
        if (FTBChunksClient.doesKeybindMatch(this.zoomInKey, keyCode, scanCode, modifiers)) {
            return this.changeZoom(true);
        }
        if (FTBChunksClient.doesKeybindMatch(this.zoomOutKey, keyCode, scanCode, modifiers)) {
            return this.changeZoom(false);
        }
        if (FTBChunksClient.doesKeybindMatch(this.addWaypointKey, keyCode, scanCode, modifiers)) {
            return this.addQuickWaypoint();
        }
        if (FTBChunksClient.doesKeybindMatch(this.waypointManagerKey, keyCode, scanCode, modifiers)) {
            new WaypointEditorScreen().openGui();
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public EventResult keyPressed(class_310 client, class_437 screen, int keyCode, int scanCode, int modifiers) {
        LargeMapScreen gui;
        if (FTBChunksClient.doesKeybindMatch(this.openMapKey, keyCode, scanCode, modifiers) && Platform.isFabric() && (gui = (LargeMapScreen)((Object)ClientUtils.getCurrentGuiAs(LargeMapScreen.class))) != null && !gui.anyModalPanelOpen()) {
            gui.closeGui(false);
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    private EventResult addQuickWaypoint() {
        StringConfig name = new StringConfig();
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return EventResult.pass();
        }
        return MapManager.getInstance().map(arg_0 -> FTBChunksClient.lambda$addQuickWaypoint$7(name, (class_1657)player, arg_0)).orElse(EventResult.pass());
    }

    private EventResult changeZoom(boolean zoomIn) {
        double zoomFactor;
        double zoom = this.prevZoom = ((Double)FTBChunksClientConfig.MINIMAP_ZOOM.get()).doubleValue();
        double d = zoomFactor = zoomIn ? 1.0 : -1.0;
        zoom = zoom + zoomFactor > 4.0 ? 4.0 : (zoom + zoomFactor < 1.0 ? 1.0 : (zoom += zoomFactor));
        this.lastZoomTime = System.currentTimeMillis();
        FTBChunksClientConfig.MINIMAP_ZOOM.set(Double.valueOf(zoom));
        return EventResult.interruptTrue();
    }

    public float getZoom() {
        double z = (Double)FTBChunksClientConfig.MINIMAP_ZOOM.get();
        if (this.prevZoom != z) {
            long max = (long)(400.0 / z);
            long t = class_3532.method_53062((long)(System.currentTimeMillis() - this.lastZoomTime), (long)0L, (long)max);
            if (t == max) {
                this.lastZoomTime = 0L;
                return (float)z;
            }
            return (float)class_3532.method_16436((double)((double)t / (double)max), (double)this.prevZoom, (double)z);
        }
        return (float)z;
    }

    public int generateTextureId(int w, int h) {
        int textureId = TextureUtil.generateTextureId();
        TextureUtil.prepareImage((int)textureId, (int)w, (int)h);
        return textureId;
    }

    public void renderHud(class_332 graphics, class_9779 tickDelta) {
        float scale;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 == null || mc.field_1687 == null || MapManager.getInstance().isEmpty() || MapDimension.getCurrent().isEmpty()) {
            return;
        }
        float partialTicks = tickDelta.method_60637(false);
        double playerX = class_3532.method_16436((double)partialTicks, (double)this.prevPlayerX, (double)this.currentPlayerX);
        double playerY = class_3532.method_16436((double)partialTicks, (double)this.prevPlayerY, (double)this.currentPlayerY);
        double playerZ = class_3532.method_16436((double)partialTicks, (double)this.prevPlayerZ, (double)this.currentPlayerZ);
        double guiScale = mc.method_22683().method_4495();
        int scaledWidth = mc.method_22683().method_4486();
        int scaledHeight = mc.method_22683().method_4502();
        MapDimension dim = MapDimension.getCurrent().get();
        if (dim.dimension != mc.field_1687.method_27983()) {
            MapDimension.clearCurrentDimension();
            dim = MapDimension.getCurrent().orElseThrow();
            this.longRangePlayerTracker.clear();
        }
        long now = System.currentTimeMillis();
        if (this.nextRegionSave == 0L || now >= this.nextRegionSave) {
            this.nextRegionSave = now + 60000L;
            MapManager.getInstance().ifPresent(MapManager::saveAllRegions);
        }
        if (this.minimapTextureId == -1) {
            this.minimapTextureId = this.generateTextureId(240, 240);
            this.scheduleMinimapUpdate();
        }
        float zoom0 = this.getZoom();
        float zoom = zoom0 / 3.5f;
        MinimapBlurMode blurMode = (MinimapBlurMode)((Object)FTBChunksClientConfig.MINIMAP_BLUR_MODE.get());
        boolean minimapBlur = blurMode == MinimapBlurMode.AUTO ? zoom0 < 1.5f : blurMode == MinimapBlurMode.ON;
        int filter = minimapBlur ? 9729 : 9728;
        RenderSystem.bindTextureForSetup((int)this.minimapTextureId);
        RenderSystem.texParameter((int)3553, (int)10241, (int)filter);
        RenderSystem.texParameter((int)3553, (int)10240, (int)filter);
        int cx = class_3532.method_15357((double)playerX) >> 4;
        int cz = class_3532.method_15357((double)playerZ) >> 4;
        if (cx != this.currentPlayerChunkX || cz != this.currentPlayerChunkZ) {
            this.scheduleMinimapUpdate();
        }
        if (this.updateMinimapScheduled) {
            this.updateMinimapScheduled = false;
            for (int mz = 0; mz < 15; ++mz) {
                for (int mx = 0; mx < 15; ++mx) {
                    int ox = cx + mx - 7;
                    int oz = cz + mz - 7;
                    MapRegion region = dim.getRegion(XZ.regionFromChunk((int)ox, (int)oz));
                    region.getRenderedMapImage().method_22619(0, mx * 16, mz * 16, (ox & 0x1F) * 16, (oz & 0x1F) * 16, 16, 16, minimapBlur, false, false, false);
                }
            }
            this.currentPlayerChunkX = cx;
            this.currentPlayerChunkZ = cz;
        }
        if (mc.field_1690.field_1842 || mc.method_53526().method_53536() || !((Boolean)FTBChunksClientConfig.MINIMAP_ENABLED.get()).booleanValue() || (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get() == 0 || !FTBChunksWorldConfig.shouldShowMinimap((class_1657)mc.field_1724)) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PROPORTIONAL.get()).booleanValue()) {
            scale = (float)(4.0 / guiScale);
            scale *= (float)scaledWidth / 10.0f / (scale * 64.0f) * ((Double)FTBChunksClientConfig.MINIMAP_SCALE.get()).floatValue();
        } else {
            scale = (float)((Double)FTBChunksClientConfig.MINIMAP_SCALE.get() * 4.0 / guiScale);
        }
        boolean rotationLocked = (Boolean)FTBChunksClientConfig.MINIMAP_LOCKED_NORTH.get() != false || (Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false;
        float minimapRotation = (rotationLocked ? 180.0f : -mc.field_1724.method_36454()) % 360.0f;
        int size = (int)(64.0 * (double)scale);
        double halfSizeD = (double)size / 2.0;
        float halfSizeF = (float)size / 2.0f;
        MinimapPosition minimapPosition = (MinimapPosition)((Object)FTBChunksClientConfig.MINIMAP_POSITION.get());
        int x = minimapPosition.getX(scaledWidth, size);
        int y = minimapPosition.getY(scaledHeight, size);
        int offsetX = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_X.get();
        int offsetY = (Integer)FTBChunksClientConfig.MINIMAP_OFFSET_Y.get();
        MinimapPosition.MinimapOffsetConditional offsetConditional = (MinimapPosition.MinimapOffsetConditional)FTBChunksClientConfig.MINIMAP_POSITION_OFFSET_CONDITION.get();
        if (offsetConditional.test(minimapPosition)) {
            x += minimapPosition.posX == 0 ? offsetX : -offsetX;
            y -= minimapPosition.posY > 1 ? offsetY : -offsetY;
        }
        vanillaEffectsOffsetX = !mc.field_1724.method_6026().isEmpty() && y <= 50 && x + size > scaledWidth - 50 ? (double)(-(scaledWidth - x) - 5) : 0.0;
        float border = 0.0f;
        int alpha = (Integer)FTBChunksClientConfig.MINIMAP_VISIBILITY.get();
        class_289 tessellator = class_289.method_1348();
        class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        RenderSystem.enableDepthTest();
        class_4587 poseStack = graphics.method_51448();
        poseStack.method_22903();
        poseStack.method_22904(0.0, (double)y + halfSizeD, 0.0);
        boolean textAboveMinimap = (Boolean)FTBChunksClientConfig.TEXT_ABOVE_MINIMAP.get();
        int componentsHeight = this.getMinimapComponentsTotalHeight(mc, dim, playerX, playerY, playerZ);
        if (textAboveMinimap) {
            renderY = y - componentsHeight;
            if (renderY <= 0) {
                offset = -renderY + 1;
                poseStack.method_46416(0.0f, (float)offset, 0.0f);
                y += offset;
            }
            poseStack.method_22903();
            poseStack.method_46416(0.0f, (float)(-componentsHeight), 0.0f);
            this.drawMinimapComponents(mc, dim, playerX, playerY, playerZ, scaledHeight, x, (int)(-halfSizeF) - 1, 0, halfSizeD, poseStack, graphics);
            poseStack.method_22909();
        } else {
            renderY = y + size + componentsHeight;
            if (renderY >= scaledHeight) {
                offset = -componentsHeight - 1;
                poseStack.method_46416(0.0f, (float)offset, 0.0f);
                y += offset;
            }
        }
        poseStack.method_22904((double)x + halfSizeD, 0.0, 490.0);
        Matrix4f m = poseStack.method_23760().method_23761();
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_MASK : CIRCLE_MASK));
        buffer.method_22918(m, -halfSizeF + border, -halfSizeF + border, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f);
        buffer.method_22918(m, -halfSizeF + border, halfSizeF - border, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f);
        buffer.method_22918(m, halfSizeF - border, halfSizeF - border, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f);
        buffer.method_22918(m, halfSizeF - border, -halfSizeF + border, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        poseStack.method_22907(class_7833.field_40718.rotationDegrees(minimapRotation + 180.0f));
        RenderSystem.depthFunc((int)518);
        float halfSizeBorderF = halfSizeF - border;
        float offX = 0.5f + (float)((MathUtils.mod((double)playerX, (double)16.0) / 16.0 - 0.5) / 15.0);
        float offZ = 0.5f + (float)((MathUtils.mod((double)playerZ, (double)16.0) / 16.0 - 0.5) / 15.0);
        float zws = 2.0f / (15.0f * zoom);
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (int)this.minimapTextureId);
        buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22918(m, -halfSizeBorderF, -halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX - zws, offZ - zws);
        buffer.method_22918(m, -halfSizeBorderF, halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX - zws, offZ + zws);
        buffer.method_22918(m, halfSizeBorderF, halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX + zws, offZ + zws);
        buffer.method_22918(m, halfSizeBorderF, -halfSizeBorderF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(offX + zws, offZ - zws);
        class_286.method_43433((class_9801)buffer.method_60800());
        RenderSystem.disableDepthTest();
        RenderSystem.depthFunc((int)515);
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34543);
        RenderSystem.setShaderTexture((int)0, (class_2960)((Boolean)FTBChunksClientConfig.SQUARE_MINIMAP.get() != false ? SQUARE_BORDER : CIRCLE_BORDER));
        buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
        buffer.method_22918(m, -halfSizeF, -halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 0.0f);
        buffer.method_22918(m, -halfSizeF, halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(0.0f, 1.0f);
        buffer.method_22918(m, halfSizeF, halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 1.0f);
        buffer.method_22918(m, halfSizeF, -halfSizeF, 0.0f).method_1336(255, 255, 255, alpha).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)buffer.method_60800());
        if (((Boolean)FTBChunksClientConfig.MINIMAP_RETICLE.get()).booleanValue()) {
            RenderSystem.setShader(class_757::method_34540);
            buffer = tessellator.method_60827(class_293.class_5596.field_29344, class_290.field_1576);
            buffer.method_22918(m, -halfSizeF, 0.0f, 0.0f).method_1336(0, 0, 0, 30);
            buffer.method_22918(m, halfSizeF, 0.0f, 0.0f).method_1336(0, 0, 0, 30);
            buffer.method_22918(m, 0.0f, -halfSizeF, 0.0f).method_1336(0, 0, 0, 30);
            buffer.method_22918(m, 0.0f, halfSizeF, 0.0f).method_1336(0, 0, 0, 30);
            class_286.method_43433((class_9801)buffer.method_60800());
        }
        poseStack.method_22909();
        m = poseStack.method_23760().method_23761();
        if (((Boolean)FTBChunksClientConfig.MINIMAP_COMPASS.get()).booleanValue()) {
            this.drawMinimapCompassPoints(minimapRotation, size, halfSizeD, x, y, tessellator, buffer, m);
        }
        if (this.lastMapIconUpdate == 0L || now - this.lastMapIconUpdate >= (long)((Integer)FTBChunksClientConfig.MINIMAP_ICON_UPDATE_TIMER.get()).intValue()) {
            this.lastMapIconUpdate = now;
            this.mapIcons.clear();
            ((Consumer)MapIconEvent.MINIMAP.invoker()).accept(new MapIconEvent(dim.dimension, this.mapIcons, MapType.MINIMAP));
            if (this.mapIcons.size() >= 2) {
                this.mapIcons.sort(new MapIconComparator(mc.field_1724.method_19538(), tickDelta.method_60637(false)));
            }
        }
        for (MapIcon icon : this.mapIcons) {
            double distance;
            class_243 pos = icon.getPos(tickDelta.method_60637(false));
            double d = (distance = MathUtils.dist((double)playerX, (double)playerZ, (double)pos.field_1352, (double)pos.field_1350)) * (double)scale * (double)zoom;
            if (!icon.isVisible(MapType.MINIMAP, distance, d > halfSizeD)) continue;
            if (d > halfSizeD) {
                d = halfSizeD;
            }
            double angle = Math.atan2(playerZ - pos.field_1350, playerX - pos.field_1352) + (double)minimapRotation * Math.PI / 180.0;
            double ws = (double)size / (32.0 / icon.getIconScale(MapType.MINIMAP));
            double wx = (double)x + halfSizeD + Math.cos(angle) * d;
            double wy = (double)y + halfSizeD + Math.sin(angle) * d;
            float wsf = (float)(ws * 2.0);
            poseStack.method_22903();
            poseStack.method_22904(wx - ws, wy - ws - (icon.isIconOnEdge(MapType.MINIMAP, d >= halfSizeD) ? ws / 2.0 : 0.0), 0.0);
            poseStack.method_22905(wsf, wsf, 1.0f);
            icon.draw(MapType.MINIMAP, graphics, 0, 0, 1, 1, d >= halfSizeD, 255);
            poseStack.method_22909();
        }
        if (rotationLocked || ((Boolean)FTBChunksClientConfig.SHOW_PLAYER_WHEN_UNLOCKED.get()).booleanValue()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)PLAYER);
            poseStack.method_22903();
            poseStack.method_22904((double)x + halfSizeD, (double)y + halfSizeD, 0.0);
            if (rotationLocked) {
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(mc.field_1724.method_36454() + 180.0f));
            }
            poseStack.method_22905((float)size / 16.0f, (float)size / 16.0f, 1.0f);
            m = poseStack.method_23760().method_23761();
            PointerIconMode mode = (PointerIconMode)((Object)FTBChunksClientConfig.POINTER_ICON_MODE_MINIMAP.get());
            if (mode.showPointer()) {
                RenderSystem.setShader(class_757::method_34543);
                buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
                buffer.method_22918(m, -1.0f, -1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(0.0f, 0.0f);
                buffer.method_22918(m, -1.0f, 1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(0.0f, 1.0f);
                buffer.method_22918(m, 1.0f, 1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(1.0f, 1.0f);
                buffer.method_22918(m, 1.0f, -1.0f, 0.0f).method_1336(255, 255, 255, 200).method_22913(1.0f, 0.0f);
                class_286.method_43433((class_9801)buffer.method_60800());
            }
            if (mode.showFace()) {
                if (mode.showPointer()) {
                    poseStack.method_22905(0.75f, 0.75f, 0.75f);
                    poseStack.method_46416(0.0f, 0.32f, 0.0f);
                }
                poseStack.method_46416(-0.5f, -0.5f, 0.0f);
                new EntityMapIcon((class_1297)mc.field_1724, (Icon)FaceIcon.getFace((GameProfile)mc.field_1724.method_7334())).draw(MapType.MINIMAP, graphics, 0, 0, 1, 1, false, 255);
            }
            poseStack.method_22909();
        }
        if (!textAboveMinimap) {
            this.drawMinimapComponents(mc, dim, playerX, playerY, playerZ, scaledHeight, x, y, size, halfSizeD, poseStack, graphics);
        }
        RenderSystem.enableDepthTest();
        if (this.worldMatrix != null && ((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            this.drawInWorldIcons(mc, graphics, tickDelta, playerX, playerY, playerZ, scaledWidth, scaledHeight);
        }
    }

    private int getMinimapComponentsTotalHeight(class_310 mc, MapDimension dim, double playerX, double playerY, double playerZ) {
        MinimapContext context = new MinimapContext(mc, mc.field_1724, dim, XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ), new class_243(playerX, playerY, playerZ), (Map)FTBChunksClientConfig.MINIMAP_SETTINGS.get());
        int sum = 0;
        for (MinimapInfoComponent c : this.sortedComponents) {
            if (!c.shouldRender(context)) continue;
            sum += c.height(context);
        }
        return sum;
    }

    private void drawMinimapComponents(class_310 mc, MapDimension dim, double playerX, double playerY, double playerZ, int scaledHeight, int x, int y, int size, double halfSizeD, class_4587 poseStack, class_332 graphics) {
        MinimapContext context = new MinimapContext(mc, mc.field_1724, dim, XZ.of((int)this.currentPlayerChunkX, (int)this.currentPlayerChunkZ), new class_243(playerX, playerY, playerZ), (Map)FTBChunksClientConfig.MINIMAP_SETTINGS.get());
        float fontScale = ((Double)FTBChunksClientConfig.MINIMAP_FONT_SCALE.get()).floatValue();
        int yOffset = 0;
        for (MinimapInfoComponent component : this.sortedComponents) {
            if (!component.shouldRender(context)) continue;
            int height = component.height(context);
            boolean isBottom = y + size + height >= scaledHeight;
            float yOff = isBottom ? (float)(-height - yOffset) : (float)size + 2.0f + (float)yOffset;
            poseStack.method_22903();
            poseStack.method_22904((double)x + halfSizeD, (double)((float)y + yOff), 0.0);
            poseStack.method_22905(fontScale, fontScale, 1.0f);
            component.render(context, graphics, mc.field_1772);
            poseStack.method_22909();
            yOffset += height;
        }
    }

    private void drawMinimapCompassPoints(float minimapRotation, int size, double halfSizeD, int minimapX, int minimapY, class_289 tessellator, class_287 buffer, Matrix4f m) {
        double d = (double)size / 2.2;
        float ws = (float)size / 32.0f;
        for (int face = 0; face < 4; ++face) {
            double angle = ((double)minimapRotation + 180.0 - (double)face * 90.0) * Math.PI / 180.0;
            float wx = (float)((double)minimapX + halfSizeD + Math.cos(angle) * d);
            float wy = (float)((double)minimapY + halfSizeD + Math.sin(angle) * d);
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderTexture((int)0, (class_2960)COMPASS[face]);
            buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1575);
            buffer.method_22918(m, wx - ws, wy - ws, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 0.0f);
            buffer.method_22918(m, wx - ws, wy + ws, 0.0f).method_1336(255, 255, 255, 255).method_22913(0.0f, 1.0f);
            buffer.method_22918(m, wx + ws, wy + ws, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 1.0f);
            buffer.method_22918(m, wx + ws, wy - ws, 0.0f).method_1336(255, 255, 255, 255).method_22913(1.0f, 0.0f);
            class_286.method_43433((class_9801)buffer.method_60800());
        }
    }

    private void drawInWorldIcons(class_310 mc, class_332 graphics, class_9779 tickDelta, double playerX, double playerY, double playerZ, int scaledWidth, int scaledHeight) {
        GuiHelper.setupDrawing();
        float scaledWidth2 = (float)scaledWidth / 2.0f;
        float scaledHeight2 = (float)scaledHeight / 2.0f;
        InWorldMapIcon focusedIcon = null;
        for (MapIcon icon : this.mapIcons) {
            class_243 pos = icon.getPos(tickDelta.method_60637(false));
            double playerDist = MathUtils.dist((double)pos.field_1352, (double)pos.field_1351, (double)pos.field_1350, (double)playerX, (double)playerY, (double)playerZ);
            if (!icon.isVisible(MapType.WORLD_ICON, playerDist, false)) continue;
            Vector4f v = new Vector4f((float)(pos.field_1352 - this.cameraPos.field_1352), (float)(pos.field_1351 - this.cameraPos.field_1351), (float)(pos.field_1350 - this.cameraPos.field_1350), 1.0f);
            double lookAngle = mc.field_1724.method_5720().method_1026(new class_243((double)v.x(), (double)v.y(), (double)v.z()).method_1029());
            if (!(lookAngle > 0.0)) continue;
            this.worldMatrix.transform(v);
            v.div(v.w());
            float ix = scaledWidth2 + v.x() * scaledWidth2;
            float iy = scaledHeight2 - v.y() * scaledHeight2;
            double mouseDist = MathUtils.dist((double)ix, (double)iy, (double)scaledWidth2, (double)scaledHeight2);
            InWorldMapIcon inWorldMapIcon = new InWorldMapIcon(icon, ix, iy, playerDist, mouseDist);
            if (mouseDist <= 5.0 * (Double)FTBChunksClientConfig.WAYPOINT_FOCUS_DISTANCE.get() && (focusedIcon == null || focusedIcon.distanceToMouse() > mouseDist)) {
                focusedIcon = inWorldMapIcon;
            }
            this.inWorldMapIcons.add(inWorldMapIcon);
        }
        double fadeStart = (Double)FTBChunksClientConfig.WAYPOINT_DOT_FADE_DISTANCE.get();
        double fadeMin = fadeStart * 2.0 / 3.0;
        for (InWorldMapIcon icon : this.inWorldMapIcons) {
            if (!(icon.distanceToPlayer() > fadeMin)) continue;
            int iconAlpha = icon.distanceToPlayer() < fadeStart ? (int)(255.0 * ((icon.distanceToPlayer() - fadeMin) / (fadeStart - fadeMin))) : 255;
            float minSize = 0.25f;
            float maxSize = (float)((double)minSize * (Double)FTBChunksClientConfig.WAYPOINT_FOCUS_SCALE.get());
            if (iconAlpha <= 0) continue;
            float iconScale = class_3532.method_16439((float)((50.0f - Math.min((float)icon.distanceToMouse(), 50.0f)) / 50.0f), (float)minSize, (float)maxSize);
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            poseStack.method_46416(icon.x(), icon.y(), icon == focusedIcon ? 50.0f : -100.0f);
            poseStack.method_22905(iconScale, iconScale, 1.0f);
            icon.icon().draw(MapType.WORLD_ICON, graphics, -8, -8, 16, 16, icon != focusedIcon, iconAlpha);
            poseStack.method_22909();
        }
        this.inWorldMapIcons.clear();
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableDepthTest();
    }

    public void renderWorldLast(class_4587 poseStack, Matrix4f projectionMatrix, Matrix4f modelViewMatrix, class_4184 camera, class_9779 tickDelta) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || MapManager.getInstance().isEmpty() || mc.field_1687 == null || mc.field_1724 == null || MapDimension.getCurrent().isEmpty() || !FTBChunksWorldConfig.playerHasMapStage((class_1657)mc.field_1724)) {
            return;
        }
        this.worldMatrix = new Matrix4f((Matrix4fc)projectionMatrix);
        this.worldMatrix.mul((Matrix4fc)modelViewMatrix);
        this.cameraPos = camera.method_19326();
        if (!((Boolean)FTBChunksClientConfig.IN_WORLD_WAYPOINTS.get()).booleanValue()) {
            return;
        }
        List<WaypointIcon> visibleWaypoints = this.findVisibleWaypoints((class_1657)mc.field_1724, tickDelta);
        if (visibleWaypoints.isEmpty()) {
            return;
        }
        class_243 cameraPos = camera.method_19326();
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_1921 renderType = class_1921.method_23592((class_2960)WAYPOINT_BEAM, (boolean)true);
        class_4588 depthBuffer = mc.method_22940().method_23000().getBuffer(renderType);
        float y1 = (float)(cameraPos.field_1351 + 30.0);
        float y2 = y1 + 70.0f;
        int yMin = mc.field_1687.method_31607();
        for (WaypointIcon waypoint : visibleWaypoints) {
            FTBChunksClient.drawWaypointBeacon(poseStack, cameraPos, depthBuffer, y1, y2, yMin, waypoint);
        }
        poseStack.method_22909();
        mc.method_22940().method_23000().method_22994(renderType);
    }

    private static void drawWaypointBeacon(class_4587 poseStack, class_243 cameraPos, class_4588 depthBuffer, float y1, float y2, int yMin, WaypointIcon waypoint) {
        class_243 pos = waypoint.getPos(1.0f);
        int alpha = waypoint.getAlpha();
        double angle = Math.atan2(cameraPos.field_1350 - pos.field_1350, cameraPos.field_1352 - pos.field_1352) * 180.0 / Math.PI;
        int r = waypoint.getColor().redi();
        int g = waypoint.getColor().greeni();
        int b = waypoint.getColor().bluei();
        poseStack.method_22903();
        poseStack.method_22904(pos.field_1352, 0.0, pos.field_1350);
        poseStack.method_22907(class_7833.field_40716.rotationDegrees((float)(-angle - 135.0)));
        float s = 0.6f;
        Matrix4f m = poseStack.method_23760().method_23761();
        depthBuffer.method_22918(m, -s, (float)yMin, s).method_1336(r, g, b, alpha).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        depthBuffer.method_22918(m, -s, y1, s).method_1336(r, g, b, alpha).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        depthBuffer.method_22918(m, s, y1, -s).method_1336(r, g, b, alpha).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        depthBuffer.method_22918(m, s, (float)yMin, -s).method_1336(r, g, b, alpha).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        depthBuffer.method_22918(m, -s, y1, s).method_1336(r, g, b, alpha).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        depthBuffer.method_22918(m, -s, y2, s).method_1336(r, g, b, 0).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        depthBuffer.method_22918(m, s, y2, -s).method_1336(r, g, b, 0).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        depthBuffer.method_22918(m, s, y1, -s).method_1336(r, g, b, alpha).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(0xF000F0).method_60831(poseStack.method_23760(), 0.0f, 1.0f, 0.0f);
        poseStack.method_22909();
    }

    private List<WaypointIcon> findVisibleWaypoints(class_1657 player, class_9779 tickDelta) {
        return MapManager.getInstance().map(manager -> {
            ArrayList<MapIcon> visibleWaypoints = new ArrayList<MapIcon>();
            double fadeOutDistance = (Double)FTBChunksClientConfig.WAYPOINT_BEACON_FADE_DISTANCE.get();
            double fadeOutDistanceP = fadeOutDistance * 2.0 / 3.0;
            MapDimension dim = manager.getDimension((class_5321<class_1937>)player.method_37908().method_27983());
            for (Waypoint waypoint : dim.getWaypointManager()) {
                double distance;
                if (waypoint.isHidden() || !((distance = Math.sqrt(waypoint.getDistanceSq((class_1297)player))) > fadeOutDistanceP) || !(distance <= (Double)FTBChunksClientConfig.WAYPOINT_MAX_DISTANCE.get())) continue;
                int alpha = 150;
                if (distance < fadeOutDistance) {
                    alpha = (int)((double)alpha * ((distance - fadeOutDistanceP) / (fadeOutDistance - fadeOutDistanceP)));
                }
                if (alpha <= 0) continue;
                waypoint.getMapIcon().setAlpha(alpha);
                visibleWaypoints.add(waypoint.getMapIcon());
            }
            visibleWaypoints.sort(new MapIconComparator(player.method_19538(), tickDelta.method_60637(false)));
            return visibleWaypoints;
        }).orElse(List.of());
    }

    private EventResult screenOpened(class_437 screen, ScreenAccess access) {
        if (screen instanceof class_433) {
            this.nextRegionSave = System.currentTimeMillis() + 60000L;
            MapManager.getInstance().ifPresent(MapManager::saveAllRegions);
        }
        return EventResult.pass();
    }

    private void clientTick(class_310 mc) {
        if (mc.field_1687 == null) {
            return;
        }
        MapManager.getInstance().ifPresent(manager -> {
            int releaseInterval;
            if (mc.field_1724 != null) {
                this.prevPlayerX = this.currentPlayerX;
                this.prevPlayerY = this.currentPlayerY;
                this.prevPlayerZ = this.currentPlayerZ;
                this.currentPlayerX = mc.field_1724.method_23317();
                this.currentPlayerY = mc.field_1724.method_23318();
                this.currentPlayerZ = mc.field_1724.method_23321();
            }
            class_1937 level = (class_1937)Objects.requireNonNull(mc.field_1687);
            if (this.taskQueueTicks % (long)((Integer)FTBChunksClientConfig.RERENDER_QUEUE_TICKS.get()).intValue() == 0L) {
                this.runRerenderTasks(level, (MapManager)manager);
            }
            if (this.taskQueueTicks % (long)((Integer)FTBChunksClientConfig.TASK_QUEUE_TICKS.get()).intValue() == 0L) {
                ClientTaskQueue.runQueuedTasks();
            }
            if ((releaseInterval = ((Integer)FTBChunksClientConfig.REGION_RELEASE_TIME.get()).intValue()) > 0 && level.method_8510() % ((long)releaseInterval * 20L) == 0L) {
                manager.releaseStaleRegionData((long)releaseInterval * 1000L);
            }
            if (mc.field_1755 == null) {
                manager.checkForRegionPurge();
            }
            ++this.taskQueueTicks;
        });
    }

    private void runRerenderTasks(class_1937 level, MapManager manager) {
        if (!this.rerenderCache.isEmpty()) {
            this.rerenderCache.forEach((chunkPos, blocks) -> {
                class_2791 chunkAccess = level.method_8402(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_12803, false);
                if (chunkAccess != null) {
                    this.queueOrExecute(new ChunkUpdateTask(manager, level, chunkAccess, (class_1923)chunkPos, blocks.toIntArray()));
                }
            });
            this.rerenderCache.clear();
        }
    }

    private void teamPropertiesChanged(ClientTeamPropertiesChangedEvent event) {
        MapManager.getInstance().ifPresent(manager -> manager.updateAllRegions(false));
    }

    private void mapIcons(MapIconEvent event) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1687 == null || mc.field_1724 == null) {
            return;
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_WAYPOINTS.get()).booleanValue()) {
            MapDimension.getCurrent().ifPresent(mapDimension -> {
                for (Waypoint w : mapDimension.getWaypointManager()) {
                    if (w.isHidden() && event.getMapType().isMinimap()) continue;
                    event.add(w.getMapIcon());
                }
            });
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_ENTITIES.get()).booleanValue()) {
            for (class_1297 entity : mc.field_1687.method_18112()) {
                if (!EntityIcons.shouldEntityRender(entity, (class_1657)mc.field_1724)) continue;
                Icon icon2 = EntityIcons.getIcon(entity);
                Optional<EntityIcons.EntityIconSettings> settings = EntityIcons.getSettings(entity.method_5864());
                if (settings.isEmpty()) continue;
                EntityIcons.WidthHeight wh = settings.get().widthHeight();
                if (icon2.isEmpty()) continue;
                if (((Boolean)FTBChunksClientConfig.ONLY_SURFACE_ENTITIES.get()).booleanValue() && !mc.field_1687.method_8597().comp_643()) {
                    MapDimension.getCurrent().ifPresent(mapDimension -> {
                        int z;
                        int x = class_3532.method_15357((double)entity.method_23317());
                        MapRegion region = mapDimension.getRegion(XZ.regionFromBlock((int)x, (int)(z = class_3532.method_15357((double)entity.method_23321()))));
                        MapRegionData data = region.getData();
                        if (data != null) {
                            short y = data.height[(x & 0x1FF) + (z & 0x1FF) * 512];
                            if (entity.method_23318() >= (double)(y - 10)) {
                                event.add(new EntityMapIcon(entity, icon2, wh));
                            }
                        }
                    });
                    continue;
                }
                event.add(new EntityMapIcon(entity, icon2, wh));
            }
        }
        if (((Boolean)FTBChunksClientConfig.MINIMAP_PLAYER_HEADS.get()).booleanValue()) {
            if (mc.field_1687.method_18456().size() > 1) {
                for (class_742 player : mc.field_1687.method_18456()) {
                    if (player == mc.field_1724 || player.method_5756((class_1657)mc.field_1724) || !VisibleClientPlayers.isPlayerVisible((class_1657)player)) continue;
                    if (this.longRangePlayerTracker.remove(player.method_5667()) != null) {
                        LargeMapScreen.refreshIconsIfOpen();
                    }
                    event.add(new EntityMapIcon((class_1297)player, (Icon)FaceIcon.getFace((GameProfile)player.method_7334())));
                }
            }
            this.longRangePlayerTracker.forEach((id, icon) -> event.add((MapIcon)icon));
        }
        if (!event.getMapType().isMinimap()) {
            PointerIconMode pointerIconMode = (PointerIconMode)((Object)FTBChunksClientConfig.POINTER_ICON_MODE.get());
            if (pointerIconMode.showFace()) {
                event.add(new EntityMapIcon((class_1297)mc.field_1724, (Icon)FaceIcon.getFace((GameProfile)mc.field_1724.method_7334())));
            }
            if (pointerIconMode.showPointer()) {
                event.add(new PointerIcon());
            }
        }
    }

    void refreshMinimapIcons() {
        this.lastMapIconUpdate = 0L;
    }

    private void reloadShaders(class_5912 resourceProvider, ClientReloadShadersEvent.ShadersSink sink) {
    }

    public void rerender(class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        IntOpenHashSet set = this.rerenderCache.get(chunkPos);
        if (set == null) {
            set = new IntOpenHashSet();
            this.rerenderCache.put(chunkPos, set);
        }
        if (set.add((pos.method_10263() & 0xF) + (pos.method_10260() & 0xF) * 16) && ((Boolean)FTBChunksClientConfig.DEBUG_INFO.get()).booleanValue()) {
            ++this.renderedDebugCount;
        }
    }

    public void handlePacket(class_2637 p) {
        short[] positions;
        class_4076 sectionPos = p.field_26345;
        for (short position : positions = p.field_26346) {
            this.rerender(sectionPos.method_30557(position));
        }
    }

    public void handlePacket(class_2672 p) {
        class_2791 chunkAccess;
        MapManager manager = MapManager.getInstance().orElse(null);
        class_638 level = class_310.method_1551().field_1687;
        if (level != null && (chunkAccess = level.method_8402(p.method_11523(), p.method_11524(), class_2806.field_12803, false)) != null) {
            this.queueOrExecute(new ChunkUpdateTask(manager, (class_1937)level, chunkAccess, new class_1923(p.method_11523(), p.method_11524())));
        }
    }

    public void queueOrExecute(MapTask task) {
        MAP_EXECUTOR.execute(task);
    }

    public void handlePacket(class_2626 p) {
        this.rerender(p.method_11309());
    }

    public void maybeClearDeathpoint(class_1657 player) {
        int maxDist = (Integer)FTBChunksClientConfig.DEATH_WAYPOINT_AUTOREMOVE_DISTANCE.get();
        MapManager.getInstance().ifPresent(manager -> {
            if (maxDist > 0 && class_310.method_1551().field_1755 == null) {
                WaypointManagerImpl wpm = manager.getDimension((class_5321<class_1937>)player.method_37908().method_27983()).getWaypointManager();
                wpm.getNearestDeathpoint(player).ifPresent(wp -> {
                    if (wp.getDistanceSq((class_1297)player) < (double)(maxDist * maxDist)) {
                        wpm.remove((WaypointImpl)wp);
                        wpm.getNearestDeathpoint(player).ifPresent(wp1 -> wp1.setHidden(false));
                        player.method_7353((class_2561)class_2561.method_43469((String)"ftbchunks.deathpoint_removed", (Object[])new Object[]{wp.getName()}).method_27692(class_124.field_1054), true);
                    }
                });
            }
        });
    }

    public void updateTrackedPlayerPos(GameProfile profile, class_2338 pos) {
        boolean changed = false;
        if (pos == null) {
            changed = this.longRangePlayerTracker.remove(profile.getId()) != null;
        } else {
            TrackedPlayerMapIcon icon = this.longRangePlayerTracker.get(profile.getId());
            if (icon == null) {
                this.longRangePlayerTracker.put(profile.getId(), new TrackedPlayerMapIcon(profile, class_243.method_24953((class_2382)pos), FaceIcon.getFace((GameProfile)profile)));
                changed = true;
            } else {
                icon.setPos(class_243.method_24953((class_2382)pos));
            }
        }
        if (changed) {
            LargeMapScreen.refreshIconsIfOpen();
        }
    }

    public List<class_2561> getChunkSummary() {
        if (this.generalChunkData == null) {
            return List.of();
        }
        ArrayList<class_2561> list = new ArrayList<class_2561>(4);
        list.add((class_2561)class_2561.method_43471((String)"ftbchunks.gui.claimed"));
        int claimed = this.generalChunkData.claimed();
        int maxClaim = this.generalChunkData.maxClaimChunks();
        list.add((class_2561)class_2561.method_43470((String)(claimed + " / " + maxClaim)).method_27692(claimed > maxClaim ? class_124.field_1061 : (claimed == maxClaim ? class_124.field_1054 : class_124.field_1060)));
        list.add((class_2561)class_2561.method_43471((String)"ftbchunks.gui.force_loaded"));
        int loaded = this.generalChunkData.loaded();
        int maxLoaded = this.generalChunkData.maxForceLoadChunks();
        list.add((class_2561)class_2561.method_43470((String)(loaded + " / " + maxLoaded)).method_27692(loaded > maxLoaded ? class_124.field_1061 : (loaded == maxLoaded ? class_124.field_1054 : class_124.field_1060)));
        return list;
    }

    public SendGeneralDataPacket.GeneralChunkData getGeneralChunkData() {
        return this.generalChunkData;
    }

    public int getMinimapTextureId() {
        return this.minimapTextureId;
    }

    public static Waypoint addWaypoint(String name, class_4208 position, int color) {
        return FTBChunksAPI.clientApi().getWaypointManager((class_5321<class_1937>)position.comp_2207()).map(mgr -> {
            Waypoint wp = mgr.addWaypointAt(position.comp_2208(), name);
            wp.setColor(color);
            return wp;
        }).orElse(null);
    }

    public void setupComponents() {
        this.sortedComponents.clear();
        this.computeOrderedComponents();
    }

    private void computeOrderedComponents() {
        Map componentMap = FTBChunksAPI.clientApi().getMinimapComponents().stream().collect(Collectors.toMap(MinimapInfoComponent::id, Function.identity()));
        List order = ((List)FTBChunksClientConfig.MINIMAP_INFO_ORDER.get()).stream().map(class_2960::method_60654).collect(Collectors.toList());
        boolean save = false;
        for (class_2960 location : componentMap.keySet()) {
            if (order.contains(location)) continue;
            order.add(location);
            save = true;
        }
        if (save) {
            FTBChunksClientConfig.MINIMAP_INFO_ORDER.set(order.stream().map(class_2960::toString).collect(Collectors.toList()));
            FTBChunksClientConfig.saveConfig();
        }
        for (class_2960 id : order) {
            MinimapInfoComponent minimapInfoComponent = (MinimapInfoComponent)componentMap.get(id);
            if (minimapInfoComponent == null || !FTBChunksAPI.clientApi().isMinimapComponentEnabled(minimapInfoComponent)) continue;
            this.sortedComponents.add(minimapInfoComponent);
        }
    }

    public static double getVanillaEffectsOffsetX() {
        return vanillaEffectsOffsetX;
    }

    public int getRenderedDebugCount() {
        return this.renderedDebugCount;
    }

    private static /* synthetic */ EventResult lambda$addQuickWaypoint$7(StringConfig name, class_1657 player, MapManager manager) {
        WaypointAddScreen screen = new WaypointAddScreen(name, player);
        screen.openGuiLater();
        return EventResult.interruptTrue();
    }

    static {
        MAP_EXECUTOR = Executors.newSingleThreadExecutor();
        WAYPOINT_BEAM = FTBChunksAPI.rl("textures/waypoint_beam.png");
        BUTTON_ID_MAP = FTBChunksAPI.rl("open_gui");
        BUTTON_ID_CLAIM = FTBChunksAPI.rl("open_claim_gui");
        CIRCLE_MASK = FTBChunksAPI.rl("textures/circle_mask.png");
        CIRCLE_BORDER = FTBChunksAPI.rl("textures/circle_border.png");
        SQUARE_MASK = FTBChunksAPI.rl("textures/square_mask.png");
        SQUARE_BORDER = FTBChunksAPI.rl("textures/square_border.png");
        PLAYER = FTBChunksAPI.rl("textures/player.png");
        COMPASS = new class_2960[]{FTBChunksAPI.rl("textures/compass_e.png"), FTBChunksAPI.rl("textures/compass_n.png"), FTBChunksAPI.rl("textures/compass_w.png"), FTBChunksAPI.rl("textures/compass_s.png")};
    }

    public static class WaypointAddScreen
    extends BaseScreen {
        private final StringConfig name;
        private final class_4208 waypointLocation;
        private final ColorConfig color;
        private final boolean override;

        public WaypointAddScreen(StringConfig name, class_4208 waypointLocation, Color4I color, boolean override) {
            this.name = name;
            this.waypointLocation = waypointLocation;
            this.setHeight(35);
            this.color = new ColorConfig();
            this.color.setValue((Object)color);
            this.override = override;
        }

        public WaypointAddScreen(StringConfig name, class_4208 waypointLocation) {
            this(name, waypointLocation, Color4I.hsb((float)MathUtils.RAND.nextFloat(), (float)1.0f, (float)1.0f), false);
        }

        public WaypointAddScreen(StringConfig name, class_1657 player) {
            this(name, new class_4208(player.method_37908().method_27983(), player.method_24515()));
        }

        public void drawBackground(class_332 graphics, Theme theme, int x, int y, int w, int h) {
        }

        public void addWidgets() {
            AddWaypointOverlay.GlobalPosConfig globalPosConfig = new AddWaypointOverlay.GlobalPosConfig();
            globalPosConfig.setValue(this.waypointLocation);
            class_5250 title = class_2561.method_43471((String)("ftbchunks.gui." + (this.override ? "edit_waypoint" : "add_waypoint")));
            AddWaypointOverlay overlay = new AddWaypointOverlay(this, (Panel)this, (class_2561)title, globalPosConfig, (ConfigFromString)this.name, this.color, set -> {
                if (set && !((String)this.name.getValue()).isEmpty()) {
                    if (this.override) {
                        FTBChunksAPI.clientApi().getWaypointManager((class_5321<class_1937>)this.waypointLocation.comp_2207()).ifPresent(mgr -> mgr.removeWaypointAt(this.waypointLocation.comp_2208()));
                    }
                    Waypoint wp = FTBChunksClient.addWaypoint((String)this.name.getValue(), (class_4208)globalPosConfig.getValue(), ((Color4I)this.color.getValue()).rgba());
                    class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"ftbchunks.waypoint_added", (Object[])new Object[]{class_2561.method_43470((String)wp.getName()).method_27692(class_124.field_1054)}), true);
                }
            }){

                public void onClosed() {
                    this.closeGui();
                }
            };
            overlay.setWidth(this.width);
            this.pushModalPanel((ModalPanel)overlay);
        }
    }
}

