/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.mojang.logging.LogUtils;
import dev.ftb.mods.ftbchunks.client.gui.EntityIconSettingsScreen;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_151;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntityTypeBoolMapValue
extends BaseValue<Map<class_5321<class_1299<?>>, Boolean>> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public EntityTypeBoolMapValue(@Nullable SNBTConfig c, String n, Map<class_5321<class_1299<?>>, Boolean> def) {
        super(c, n, def);
        super.set(new HashMap(def));
    }

    public void write(SNBTCompoundTag tag) {
        Map map = (Map)this.get();
        SNBTCompoundTag mapTag = new SNBTCompoundTag();
        for (Map.Entry entry : map.entrySet()) {
            mapTag.method_10556(((class_5321)entry.getKey()).method_29177().toString(), ((Boolean)entry.getValue()).booleanValue());
        }
        tag.method_10566(this.key, (class_2520)mapTag);
    }

    public void read(SNBTCompoundTag tag) {
        HashMap<class_5321, Boolean> map = new HashMap<class_5321, Boolean>();
        SNBTCompoundTag compound = tag.getCompound(this.key);
        for (String key : compound.method_10541()) {
            try {
                class_2960 parse = class_2960.method_60654((String)key);
                map.put(class_5321.method_29179((class_5321)class_7924.field_41266, (class_2960)parse), compound.method_10577(key));
            }
            catch (class_151 e) {
                LOGGER.error("Failed to parse {} skipping", (Object)key, (Object)e);
            }
        }
        this.set(map);
    }

    public void createClientConfig(ConfigGroup group) {
        group.add(this.key, (ConfigValue)new EntityTypeBoolMapConfigValue(), (Object)((Map)this.get()), stringBooleanMap -> {}, (Object)((Map)this.defaultValue));
    }

    public static class EntityTypeBoolMapConfigValue
    extends ConfigValue<Map<class_5321<class_1299<?>>, Boolean>> {
        public void onClicked(Widget clickedWidget, MouseButton button, ConfigCallback callback) {
            new EntityIconSettingsScreen(false).openGui();
        }

        public class_2561 getStringForGUI(@Nullable Map<class_5321<class_1299<?>>, Boolean> v) {
            if (v == null) {
                return super.getStringForGUI(null);
            }
            int enabled = 0;
            int disabled = 0;
            for (class_5321<class_1299<?>> entityTypeResourceKey : v.keySet()) {
                class_1299 entityType = (class_1299)class_7923.field_41177.method_29107(entityTypeResourceKey);
                if (entityType == null) continue;
                if (v.get(entityTypeResourceKey).booleanValue()) {
                    ++enabled;
                    continue;
                }
                ++disabled;
            }
            return class_2561.method_43469((String)"ftbchunks.gui.enabled_disabled_count", (Object[])new Object[]{enabled, disabled});
        }
    }
}

