/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.weather;

import cn.leolezury.eternalstarlight.common.registry.ESWeathers;
import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import cn.leolezury.eternalstarlight.common.weather.WeatherInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class Weathers
extends class_18 {
    private static final String TAG_WEATHERS = "weathers";
    private final class_3218 serverLevel;
    private final List<WeatherInstance> weathers = new ArrayList<WeatherInstance>();

    public Weathers(class_3218 serverLevel) {
        this.serverLevel = serverLevel;
        ESWeathers.WEATHERS.registry().forEach(weather -> {
            WeatherInstance instance = new WeatherInstance(serverLevel, (AbstractWeather)weather);
            this.weathers.add(instance);
        });
    }

    public List<WeatherInstance> getWeathers() {
        return this.weathers;
    }

    public Optional<WeatherInstance> getActiveWeather() {
        for (WeatherInstance instance : this.getWeathers()) {
            if (!instance.active) continue;
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public void setActiveWeather(AbstractWeather weather, int duration) {
        for (WeatherInstance instance : this.getWeathers()) {
            if (!instance.active && instance.getWeather() == weather) {
                instance.start();
                instance.currentDuration = duration;
            }
            if (!instance.active || instance.getWeather() == weather) continue;
            instance.stop();
        }
        this.method_80();
    }

    public void clearAllWeathers(int duration) {
        for (WeatherInstance instance : this.getWeathers()) {
            instance.stop();
            instance.ticksUntilNext = duration;
        }
        this.method_80();
    }

    public static class_18.class_8645<Weathers> factory(class_3218 serverLevel) {
        return new class_18.class_8645(() -> new Weathers(serverLevel), (compoundTag, lookup) -> Weathers.load(serverLevel, compoundTag), null);
    }

    public void tick() {
        ArrayList<WeatherInstance> canStartWeathers = new ArrayList<WeatherInstance>();
        boolean hasActive = false;
        for (WeatherInstance instance : this.weathers) {
            if (instance.tick()) {
                canStartWeathers.add(instance);
            }
            hasActive = hasActive || instance.active;
        }
        if (!hasActive && !canStartWeathers.isEmpty()) {
            ((WeatherInstance)canStartWeathers.get(this.serverLevel.method_8409().method_43048(canStartWeathers.size()))).start();
        }
        this.method_80();
    }

    public static Weathers load(class_3218 serverLevel, class_2487 compoundTag) {
        Weathers weathersData = new Weathers(serverLevel);
        if (compoundTag.method_10573(TAG_WEATHERS, 10)) {
            class_2487 weathersTag = compoundTag.method_10562(TAG_WEATHERS);
            ESWeathers.WEATHERS.registry().forEach(weather -> {
                WeatherInstance instance = new WeatherInstance(serverLevel, (AbstractWeather)weather);
                String id = Objects.requireNonNull(ESWeathers.WEATHERS.registry().method_10221(weather)).toString();
                if (weathersTag.method_10573(id, 10)) {
                    instance.load(weathersTag.method_10562(id));
                }
                weathersData.weathers.add(instance);
            });
        }
        return weathersData;
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        class_2487 weathersTag = new class_2487();
        for (WeatherInstance instance : this.weathers) {
            String id = Objects.requireNonNull(ESWeathers.WEATHERS.registry().method_10221((Object)instance.getWeather())).toString();
            class_2487 weatherTag = new class_2487();
            instance.save(weatherTag);
            weathersTag.method_10566(id, (class_2520)weatherTag);
        }
        compoundTag.method_10566(TAG_WEATHERS, (class_2520)weathersTag);
        return compoundTag;
    }
}

