/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.weather;

import cn.leolezury.eternalstarlight.common.weather.AbstractWeather;
import net.minecraft.class_2487;
import net.minecraft.class_3218;

public class WeatherInstance {
    private static final String TAG_ACTIVE = "active";
    private static final String TAG_WEATHER_TICKS = "weather_ticks";
    private static final String TAG_DURATION = "duration";
    private static final String TAG_INTERVAL_TICKS = "interval_ticks";
    private static final String TAG_INTERVAL = "interval";
    private final class_3218 serverLevel;
    private final AbstractWeather weather;
    public boolean active;
    public int ticksSinceStarted;
    public int currentDuration;
    public int ticksUntilNext;
    public int currentInterval;

    public AbstractWeather getWeather() {
        return this.weather;
    }

    public WeatherInstance(class_3218 serverLevel, AbstractWeather weather) {
        this.serverLevel = serverLevel;
        this.weather = weather;
        this.active = false;
        this.ticksUntilNext = this.currentInterval = weather.weatherProperties().interval().method_35008(serverLevel.method_8409());
    }

    public void load(class_2487 compoundTag) {
        this.active = compoundTag.method_10577(TAG_ACTIVE);
        this.ticksSinceStarted = compoundTag.method_10550(TAG_WEATHER_TICKS);
        this.currentDuration = compoundTag.method_10550(TAG_DURATION);
        this.ticksUntilNext = compoundTag.method_10550(TAG_INTERVAL_TICKS);
        this.currentInterval = compoundTag.method_10550(TAG_INTERVAL);
    }

    public void save(class_2487 compoundTag) {
        compoundTag.method_10556(TAG_ACTIVE, this.active);
        compoundTag.method_10569(TAG_WEATHER_TICKS, this.ticksSinceStarted);
        compoundTag.method_10569(TAG_DURATION, this.currentDuration);
        compoundTag.method_10569(TAG_INTERVAL_TICKS, this.ticksUntilNext);
        compoundTag.method_10569(TAG_INTERVAL, this.currentInterval);
    }

    public void start() {
        this.weather.onStart(this.serverLevel);
        this.active = true;
        this.ticksSinceStarted = 0;
        this.ticksUntilNext = 0;
        this.currentDuration = this.weather.weatherProperties().duration().method_35008(this.serverLevel.method_8409());
    }

    public void stop() {
        this.weather.onStop(this.serverLevel, this.ticksSinceStarted);
        this.active = false;
        this.ticksSinceStarted = 0;
        this.ticksUntilNext = this.currentInterval = this.weather.weatherProperties().interval().method_35008(this.serverLevel.method_8409());
    }

    public boolean tick() {
        if (this.active) {
            ++this.ticksSinceStarted;
            this.ticksUntilNext = 0;
            if (this.ticksSinceStarted <= this.currentDuration && this.weather.canContinue(this.serverLevel, this.ticksSinceStarted)) {
                this.weather.serverTick(this.serverLevel, this.ticksSinceStarted);
            } else {
                this.stop();
            }
        } else {
            --this.ticksUntilNext;
            if (this.ticksUntilNext <= 0) {
                this.ticksSinceStarted = 0;
                this.ticksUntilNext = 0;
                return this.weather.canStart(this.serverLevel);
            }
        }
        return false;
    }
}

