/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.util.ESMathUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4608;

public class TrailEffect {
    private static final int MAX_CAPACITY = 65536;
    private final ArrayList<TrailPoint> verticalPoints = new ArrayList();
    private final ArrayList<TrailPoint> horizontalPoints = new ArrayList();
    private final ArrayList<TrailPoint> verticalRenderPoints = new ArrayList();
    private final ArrayList<TrailPoint> horizontalRenderPoints = new ArrayList();
    private final float width;
    private float oldLength;
    private float length;

    public ArrayList<TrailPoint> getVerticalRenderPoints() {
        return this.verticalRenderPoints;
    }

    public ArrayList<TrailPoint> getHorizontalRenderPoints() {
        return this.horizontalRenderPoints;
    }

    public float getWidth() {
        return this.width;
    }

    public float getLength() {
        return this.length;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public TrailEffect(float width, int length) {
        this.width = width;
        this.length = length;
    }

    private List<TrailPoint> getPoints(boolean vertical) {
        return vertical ? this.verticalPoints : this.horizontalPoints;
    }

    public void update(TrailPoint point, boolean vertical) {
        if (this.getPoints(vertical).isEmpty() || this.getPoints(vertical).getFirst().center().method_1022(point.center()) > 0.1) {
            this.getPoints(vertical).addFirst(point);
        }
        if (this.getPoints(vertical).size() > 65536) {
            this.getPoints(vertical).removeLast();
        }
    }

    public void update(class_243 pos, class_243 delta) {
        this.oldLength = this.length;
        float yaw = ESMathUtil.positionToYaw(delta);
        float pitch = ESMathUtil.positionToPitch(delta);
        class_243 upper = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch - 90.0f, yaw);
        class_243 lower = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch + 90.0f, yaw);
        this.update(new TrailPoint(upper, lower), true);
        class_243 offset = upper.method_1020(lower).method_1036(delta).method_1029().method_1021((double)(this.width / 2.0f));
        class_243 upper1 = pos.method_1019(offset);
        class_243 lower1 = pos.method_1019(offset.method_1021(-1.0));
        this.update(new TrailPoint(upper1, lower1), false);
    }

    public void prepareRender(class_243 pos, class_243 delta, float partialTicks) {
        float yaw = ESMathUtil.positionToYaw(delta);
        float pitch = ESMathUtil.positionToPitch(delta);
        class_243 upper = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch - 90.0f, yaw);
        class_243 lower = ESMathUtil.rotationToPosition(pos, this.width / 2.0f, pitch + 90.0f, yaw);
        this.verticalRenderPoints.clear();
        this.verticalRenderPoints.addAll(this.verticalPoints);
        this.prepare(new TrailPoint(upper, lower), true, partialTicks);
        class_243 offset = upper.method_1020(lower).method_1036(delta).method_1029().method_1021((double)(this.width / 2.0f));
        class_243 upper1 = pos.method_1019(offset);
        class_243 lower1 = pos.method_1019(offset.method_1021(-1.0));
        this.horizontalRenderPoints.clear();
        this.horizontalRenderPoints.addAll(this.horizontalPoints);
        this.prepare(new TrailPoint(upper1, lower1), false, partialTicks);
    }

    private void prepare(TrailPoint point, boolean vertical, float partialTicks) {
        ArrayList<TrailPoint> points = vertical ? this.verticalRenderPoints : this.horizontalRenderPoints;
        ArrayList<TrailPoint> modified = new ArrayList<TrailPoint>();
        points.addFirst(point);
        float totalLength = 0.0f;
        float renderLength = class_3532.method_16439((float)partialTicks, (float)this.oldLength, (float)this.length);
        for (int i = 0; i < points.size() - 1; ++i) {
            TrailPoint from = points.get(i);
            TrailPoint to = points.get(i + 1);
            float distance = (float)from.center().method_1022(to.center());
            if (!((totalLength += distance) > renderLength)) continue;
            points.set(i + 1, this.interpolateTrailPoint((totalLength - renderLength) / distance, to, from));
            modified.addAll(points.subList(0, i + 2));
            totalLength = renderLength;
            break;
        }
        if (!modified.isEmpty()) {
            points.clear();
            points.addAll(modified);
        }
        float currentLength = 0.0f;
        for (int i = 0; i < points.size() - 1; ++i) {
            TrailPoint from = points.get(i);
            TrailPoint to = points.get(i + 1);
            float distance = (float)from.center().method_1022(to.center());
            points.set(i, points.get(i).withWidth((totalLength - currentLength) * (this.width / totalLength)));
            currentLength += distance;
        }
        if (points.size() > 1) {
            points.set(points.size() - 1, points.getLast().withWidth(0.01f));
        }
    }

    private TrailPoint interpolateTrailPoint(float progress, TrailPoint first, TrailPoint second) {
        return new TrailPoint(ESMathUtil.lerpVec(progress, first.upper(), second.upper()), ESMathUtil.lerpVec(progress, first.lower(), second.lower()));
    }

    @Environment(value=EnvType.CLIENT)
    public void render(class_4588 consumer, class_4587 stack, boolean vertical, float r, float g, float b, float a, int light) {
        ArrayList<TrailPoint> points;
        ArrayList<TrailPoint> arrayList = points = vertical ? this.verticalRenderPoints : this.horizontalRenderPoints;
        if (points.size() >= 2) {
            for (int i = 0; i < points.size() - 1; ++i) {
                TrailPoint from = points.get(i);
                TrailPoint to = points.get(i + 1);
                class_4587.class_4665 pose = stack.method_23760();
                consumer.method_56824(pose, (float)from.upper().field_1352, (float)from.upper().field_1351, (float)from.upper().field_1350).method_22915(r, g, b, i == 0 ? 0.0f : a).method_22913(0.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_56824(pose, (float)to.upper().field_1352, (float)to.upper().field_1351, (float)to.upper().field_1350).method_22915(r, g, b, a).method_22913(1.0f, 0.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_56824(pose, (float)to.lower().field_1352, (float)to.lower().field_1351, (float)to.lower().field_1350).method_22915(r, g, b, a).method_22913(1.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
                consumer.method_56824(pose, (float)from.lower().field_1352, (float)from.lower().field_1351, (float)from.lower().field_1350).method_22915(r, g, b, i == 0 ? 0.0f : a).method_22913(0.0f, 1.0f).method_22922(class_4608.field_21444).method_60803(light).method_60831(pose, 0.0f, 1.0f, 0.0f);
            }
        }
    }

    public record TrailPoint(class_243 upper, class_243 lower) {
        public class_243 center() {
            return this.lower().method_1019(this.upper().method_1020(this.lower()).method_1021(0.5));
        }

        public float width() {
            return (float)this.upper().method_1022(this.lower());
        }

        public TrailPoint withWidth(float width) {
            class_243 center = this.center();
            class_243 upperVec = this.upper().method_1020(center);
            class_243 lowerVec = this.lower().method_1020(center);
            return new TrailPoint(center.method_1019(upperVec.method_1029().method_1021((double)(width / 2.0f))), center.method_1019(lowerVec.method_1029().method_1021((double)(width / 2.0f))));
        }
    }
}

