/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.util;

import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.SpellCooldown;
import java.util.Optional;
import net.minecraft.class_1309;

public class ESSpellUtil {
    public static int getCooldownFor(class_1309 entity, AbstractSpell spell) {
        SpellCaster caster;
        Optional<SpellCooldown> cooldown;
        if (entity instanceof SpellCaster && (cooldown = (caster = (SpellCaster)entity).getESSpellCooldowns().stream().filter(c -> c.getSpell() == spell).findFirst()).isPresent()) {
            return cooldown.get().getCooldown();
        }
        return 0;
    }

    public static void setCooldownFor(class_1309 entity, AbstractSpell spell, int cooldown) {
        if (entity instanceof SpellCaster) {
            SpellCaster caster = (SpellCaster)entity;
            caster.addESSpellCooldown(spell, cooldown);
        }
    }

    public static void tickSpells(class_1309 entity) {
        if (entity instanceof SpellCaster) {
            SpellCaster caster = (SpellCaster)entity;
            caster.getESSpellCooldowns().forEach(SpellCooldown::tick);
            caster.getESSpellCooldowns().removeIf(c -> c.getCooldown() <= 0);
            if (caster.getESSpellData().hasSpell()) {
                caster.setESSpellData(caster.getESSpellData().increaseTick());
                AbstractSpell spell = caster.getESSpellData().spell();
                if (!entity.method_37908().field_9236) {
                    int preparationTicks = spell.spellProperties().preparationTicks();
                    int spellTicks = spell.spellProperties().spellTicks();
                    int useTicks = caster.getESSpellData().castTicks();
                    if (!spell.canContinueToCast(entity, useTicks) || !caster.getESSpellSource().canContinue(entity)) {
                        spell.stop(entity, useTicks - preparationTicks);
                    }
                    if (useTicks <= preparationTicks + spellTicks) {
                        spell.tick(entity, useTicks);
                    } else {
                        spell.stop(entity, useTicks - preparationTicks);
                    }
                }
            }
        }
    }
}

