/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.mixin;

import cn.leolezury.eternalstarlight.common.entity.interfaces.Grappling;
import cn.leolezury.eternalstarlight.common.entity.interfaces.GrapplingOwner;
import cn.leolezury.eternalstarlight.common.entity.interfaces.SpellCaster;
import cn.leolezury.eternalstarlight.common.network.UpdateSpellDataPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.spell.AbstractSpell;
import cn.leolezury.eternalstarlight.common.spell.SpellCastData;
import cn.leolezury.eternalstarlight.common.spell.SpellCooldown;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.ref.LocalBooleanRef;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1657.class})
public abstract class PlayerMixin
implements SpellCaster,
GrapplingOwner {
    @Unique
    private SpellCastData spellCastData = SpellCastData.getDefault();
    @Unique
    private SpellCastData.SpellSource spellSource = e -> false;
    @Unique
    private ArrayList<SpellCooldown> spellCooldowns = new ArrayList();
    @Unique
    private class_1297 grappling;
    @Unique
    private boolean originalEnoughAttackStrength;

    @Shadow
    @NotNull
    public abstract class_1799 method_59958();

    @Inject(method={"hurtCurrentlyUsedShield"}, at={@At(value="HEAD")})
    private void damageShield(float amount, CallbackInfo callBackInfo) {
        class_1657 player = (class_1657)this;
        class_1799 useItem = player.method_6030();
        if (useItem.method_31573(ESTags.Items.GREATSWORDS)) {
            useItem.method_7970(Math.max((int)(amount / 5.0f), 1), (class_1309)player, player.method_6058() == class_1268.field_5808 ? class_1304.field_6173 : class_1304.field_6171);
            player.method_6021();
            player.method_7357().method_7906(useItem.method_7909(), 100);
        }
    }

    @Inject(method={"disableShield"}, at={@At(value="HEAD")}, cancellable=true)
    private void disableShield(CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        class_1799 useItem = player.method_6030();
        if (useItem.method_31573(ESTags.Items.GREATSWORDS)) {
            ci.cancel();
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;isSprinting()Z", ordinal=0)})
    private void attackCheckHammerStrength(class_1297 entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.method_59958().method_31573(ESTags.Items.HAMMERS)) {
            localRef.set(true);
        }
    }

    @Inject(method={"attack"}, at={@At(value="FIELD", target="Lnet/minecraft/world/entity/player/Player;walkDist:F", opcode=180)})
    private void attackBeforeScytheSweepCheck(class_1297 entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.method_59958().method_31573(ESTags.Items.SCYTHES)) {
            this.originalEnoughAttackStrength = localRef.get();
            localRef.set(true);
        }
    }

    @Inject(method={"attack"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;getItemInHand(Lnet/minecraft/world/InteractionHand;)Lnet/minecraft/world/item/ItemStack;")})
    private void attackAfterScytheSweepCheck(class_1297 entity, CallbackInfo ci, @Local(ordinal=0) LocalBooleanRef localRef) {
        if (this.method_59958().method_31573(ESTags.Items.SCYTHES)) {
            localRef.set(this.originalEnoughAttackStrength);
        }
    }

    @Inject(method={"aiStep"}, at={@At(value="TAIL")})
    private void aiStep(CallbackInfo ci) {
        Grappling grappling1;
        class_1297 class_12972;
        class_1657 player = (class_1657)this;
        if (this.grappling != null && (class_12972 = this.grappling) instanceof Grappling && (grappling1 = (Grappling)class_12972).reachedTarget() && grappling1.shouldPull()) {
            player.method_38785();
            if (!player.method_37908().field_9236) {
                float length = grappling1.length();
                double d = this.grappling.method_19538().method_1020(player.method_33571()).method_1033();
                if (d > (double)length) {
                    double e = d / (double)length * 0.1;
                    boolean crouch = player.method_18276();
                    player.method_45319(this.grappling.method_19538().method_1020(player.method_33571()).method_1021(1.0 / d).method_18805(e, e * 1.1, e).method_1021(crouch ? 0.6 : (player.method_24828() ? 1.8 : 1.0)));
                    player.field_6037 = true;
                }
            }
        }
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void addAdditionalSaveData(class_2487 compoundTag, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        Optional cooldowns = SpellCooldown.LIST_CODEC.encodeStart((DynamicOps)player.method_56673().method_57093((DynamicOps)class_2509.field_11560), this.spellCooldowns).resultOrPartial();
        cooldowns.ifPresent(tag -> compoundTag.method_10566("eternal_starlight:spell_cooldowns", tag));
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void readAdditionalSaveData(class_2487 compoundTag, CallbackInfo ci) {
        class_1657 player = (class_1657)this;
        class_2520 tag = compoundTag.method_10580("eternal_starlight:spell_cooldowns");
        if (tag != null) {
            this.spellCooldowns = SpellCooldown.LIST_CODEC.parse((DynamicOps)player.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)tag).resultOrPartial().orElse(new ArrayList());
        }
    }

    @Override
    public SpellCastData getESSpellData() {
        return this.spellCastData;
    }

    @Override
    public void setESSpellData(SpellCastData data) {
        class_1937 class_19372;
        class_1657 player = (class_1657)this;
        if (!player.method_37908().field_9236 && (class_19372 = player.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.spellCastData.spell() != data.spell() || this.spellCastData.hasSpell() != data.hasSpell() || this.spellCastData.strength() != data.strength()) {
                ESPlatform.INSTANCE.sendToTrackingClients(serverLevel, (class_1297)player, new UpdateSpellDataPacket(player.method_5628(), data));
            }
        }
        this.spellCastData = data;
    }

    @Override
    public SpellCastData.SpellSource getESSpellSource() {
        return this.spellSource;
    }

    @Override
    public void setESSpellSource(SpellCastData.SpellSource spellSource) {
        this.spellSource = spellSource;
    }

    @Override
    public class_1297 getESGrappling() {
        return this.grappling;
    }

    @Override
    public void setESGrappling(class_1297 grappling) {
        this.grappling = grappling;
    }

    @Override
    public ArrayList<SpellCooldown> getESSpellCooldowns() {
        return this.spellCooldowns;
    }

    @Override
    public void setESSpellCooldowns(ArrayList<SpellCooldown> cooldowns) {
        this.spellCooldowns = cooldowns;
    }

    @Override
    public void addESSpellCooldown(AbstractSpell spell, int cooldown) {
        if (this.spellCooldowns.stream().noneMatch(c -> c.getSpell() == spell)) {
            this.spellCooldowns.add(new SpellCooldown(spell, cooldown));
        } else {
            this.spellCooldowns.stream().filter(c -> c.getSpell() == spell).findFirst().ifPresent(c -> c.setCooldown(cooldown));
        }
    }
}

