/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.EternalStarlight;
import cn.leolezury.eternalstarlight.common.block.PungencyFruitVinesBlock;
import cn.leolezury.eternalstarlight.common.block.entity.DryingRackBlockEntity;
import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.data.ESLootTables;
import cn.leolezury.eternalstarlight.common.entity.projectile.ThrownSpear;
import cn.leolezury.eternalstarlight.common.item.combat.SeedsLauncherItem;
import cn.leolezury.eternalstarlight.common.item.combat.SpearItem;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESBlocks;
import cn.leolezury.eternalstarlight.common.registry.ESCriteriaTriggers;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESItems;
import cn.leolezury.eternalstarlight.common.registry.ESMobEffects;
import cn.leolezury.eternalstarlight.common.registry.ESParticles;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import cn.leolezury.eternalstarlight.common.util.ESBookUtil;
import cn.leolezury.eternalstarlight.common.util.ESTags;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1367;
import net.minecraft.class_1376;
import net.minecraft.class_1380;
import net.minecraft.class_1381;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_14;
import net.minecraft.class_1400;
import net.minecraft.class_1405;
import net.minecraft.class_1408;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1811;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3489;
import net.minecraft.class_3730;
import net.minecraft.class_4051;
import net.minecraft.class_4174;
import net.minecraft.class_4215;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5253;
import net.minecraft.class_5354;
import net.minecraft.class_5398;
import net.minecraft.class_5425;
import net.minecraft.class_5534;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6019;
import net.minecraft.class_6025;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import net.minecraft.class_9282;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public class Stranghoul
extends class_1588
implements class_5354,
class_6025,
class_1603 {
    private static final String TAG_HOME_X = "home_x";
    private static final String TAG_HOME_Y = "home_y";
    private static final String TAG_HOME_Z = "home_z";
    private static final String TAG_BABY = "baby";
    private static final String TAG_GROWTH_TICKS = "growth_ticks";
    private static final String TAG_BREED_COOLDOWN = "breed_cooldown";
    private static final String TAG_ADMIRATION_TICKS = "admiration_ticks";
    private static final String TAG_HIRER = "hirer";
    private static final String TAG_HIRED_TICKS_LEFT = "hired_ticks_left";
    private static final class_2960 SPEED_MODIFIER_BABY_ID = class_2960.method_60656((String)"baby");
    private static final class_1322 SPEED_MODIFIER_BABY = new class_1322(SPEED_MODIFIER_BABY_ID, 0.2, class_1322.class_1323.field_6330);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)20, (int)39);
    private int remainingPersistentAngerTime;
    @Nullable
    private UUID persistentAngerTarget;
    public class_2338 homePos = class_2338.field_10980;
    private int growthTicks;
    private int breedCooldown = 24000;
    private int admirationTicks;
    private boolean makingLove = false;
    @Nullable
    private class_1309 hirer;
    @Nullable
    private UUID hirerId;
    private int hiredTicksLeft;
    private boolean hiredEatAnim = false;
    protected static final class_2940<Boolean> EATING = class_2945.method_12791(Stranghoul.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> BARTERING = class_2945.method_12791(Stranghoul.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> HIRER_ID = class_2945.method_12791(Stranghoul.class, (class_2941)class_2943.field_13327);
    protected static final class_2940<Boolean> BABY = class_2945.method_12791(Stranghoul.class, (class_2941)class_2943.field_13323);

    @Nullable
    public class_1309 getHirer() {
        if (this.method_37908().field_9236) {
            class_1309 living;
            int id = this.getHirerId();
            class_1297 class_12972 = this.method_37908().method_8469(id);
            return class_12972 instanceof class_1309 ? (living = (class_1309)class_12972) : null;
        }
        return this.hirer;
    }

    public void setHirer(@Nullable class_1309 hirer) {
        if (hirer != null) {
            this.hirerId = hirer.method_5667();
            if (!this.method_37908().field_9236) {
                this.setHirerId(hirer.method_5628());
            }
        } else if (!this.method_37908().field_9236) {
            this.setHirerId(-1);
        }
        this.hirer = hirer;
    }

    public boolean isHired() {
        return this.getHirer() != null;
    }

    public boolean isEating() {
        return (Boolean)this.method_5841().method_12789(EATING);
    }

    public void setEating(boolean eating) {
        this.method_5841().method_12778(EATING, (Object)eating);
    }

    public boolean isBartering() {
        return (Boolean)this.method_5841().method_12789(BARTERING);
    }

    public void setBartering(boolean bartering) {
        this.method_5841().method_12778(BARTERING, (Object)bartering);
    }

    public int getHirerId() {
        return (Integer)this.method_5841().method_12789(HIRER_ID);
    }

    public void setHirerId(int hirerId) {
        this.method_5841().method_12778(HIRER_ID, (Object)hirerId);
    }

    public boolean method_6109() {
        return (Boolean)this.method_5841().method_12789(BABY);
    }

    public void method_7217(boolean baby) {
        class_1324 instance;
        this.method_5841().method_12778(BABY, (Object)baby);
        if (!this.method_37908().field_9236 && (instance = this.method_5996(class_5134.field_23719)) != null) {
            instance.method_6200(SPEED_MODIFIER_BABY.comp_2447());
            if (baby) {
                instance.method_26835(SPEED_MODIFIER_BABY);
            }
        }
    }

    public void setEquipmentsOnGrownUp() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_5425) {
            class_5425 serverLevel = (class_5425)class_19372;
            class_1266 difficulty = this.method_37908().method_8404(this.method_24515());
            this.method_5964(this.method_59922(), difficulty);
            this.method_5984(serverLevel, this.method_59922(), difficulty);
        }
    }

    public Stranghoul(class_1299<? extends Stranghoul> entityType, class_1937 level) {
        super(entityType, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(EATING, (Object)false).method_56912(BARTERING, (Object)false).method_56912(HIRER_ID, (Object)-1).method_56912(BABY, (Object)false);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new EatGoal());
        this.field_6201.method_6277(2, (class_1352)new SeedsLauncherAttackGoal());
        this.field_6201.method_6277(3, (class_1352)new SpearAttackGoal());
        this.field_6201.method_6277(4, (class_1352)new class_1380((class_1588)this, 1.0, 20, 15.0f));
        this.field_6201.method_6277(5, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(6, (class_1352)new FollowHirerGoal());
        this.field_6201.method_6277(7, (class_1352)new BreedGoal(this));
        this.field_6201.method_6277(8, (class_1352)new GoToWantedItemGoal());
        this.field_6201.method_6277(9, (class_1352)new GoHomeGoal());
        this.field_6201.method_6277(10, (class_1352)new PlantCropGoal());
        this.field_6201.method_6277(12, (class_1352)new CropGoal());
        this.field_6201.method_6277(12, (class_1352)new DryRottenFleshGoal());
        this.field_6201.method_6277(13, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f){

            public boolean method_6264() {
                return super.method_6264() && !Stranghoul.this.isBartering();
            }
        });
        this.field_6201.method_6277(14, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(15, (class_1352)new class_1376((class_1308)this));
        this.field_6185.method_6277(0, (class_1352)new HirerHurtByTargetGoal());
        this.field_6185.method_6277(1, (class_1352)new HirerHurtTargetGoal());
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(3, (class_1352)new class_1400((class_1308)this, class_1309.class, true, living -> living.method_5864().method_20210(ESTags.EntityTypes.STRANGHOUL_PREYS) && !living.method_5864().method_20210(ESTags.EntityTypes.STRANGHOUL_CANNOT_HUNT)));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1657.class, true, living -> !this.isHired() && (double)(living.method_6032() / living.method_6063()) < 0.15));
        this.field_6185.method_6277(5, (class_1352)new class_5398((class_1308)this, false));
    }

    public void method_7105(class_1309 target, float distanceFactor) {
        class_1792 class_17922 = this.method_6047().method_7909();
        if (class_17922 instanceof SeedsLauncherItem) {
            SeedsLauncherItem launcherItem = (SeedsLauncherItem)class_17922;
            if (this.method_5829().method_1014(6.0).method_994(target.method_5829())) {
                projectile = this.method_18808(this.method_6047());
                launcherItem.performShooting(this.method_37908(), (class_1309)this, (class_1799)projectile, class_1268.field_5808);
            }
        } else {
            projectile = this.method_6047().method_7909();
            if (projectile instanceof SpearItem) {
                SpearItem spearItem = (SpearItem)projectile;
                ThrownSpear spear = spearItem.createSpear(this.method_37908(), (class_1309)this, this.method_23317(), this.method_23320() - 0.1, this.method_23321(), this.method_6047());
                double x = target.method_23317() - this.method_23317();
                double y = target.method_23323(0.3333333333333333) - spear.method_23318();
                double z = target.method_23321() - this.method_23321();
                double dist = Math.sqrt(x * x + z * z);
                spear.method_7485(x, y + dist * (double)0.2f, z, 1.6f, 14 - this.method_37908().method_8407().method_5461() * 4);
                this.method_37908().method_8649((class_1297)spear);
            } else {
                class_1799 bow = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102));
                class_1799 projectile = this.method_18808(bow);
                class_1665 arrow = class_1675.method_18813((class_1309)this, (class_1799)projectile, (float)distanceFactor, (class_1799)bow);
                double x = target.method_23317() - this.method_23317();
                double y = target.method_23323(0.3333333333333333) - arrow.method_23318();
                double z = target.method_23321() - this.method_23321();
                double dist = Math.sqrt(x * x + z * z);
                arrow.method_7485(x, y + dist * (double)0.2f, z, 1.6f, (float)(14 - this.method_37908().method_8407().method_5461() * 4));
                this.method_5783(ESSoundEvents.STRANGHOUL_SHOOT.get(), 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
                this.method_37908().method_8649((class_1297)arrow);
            }
        }
    }

    public class_1799 method_18808(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1811) {
            class_1811 weaponItem = (class_1811)class_17922;
            Predicate predicate = weaponItem.method_20310();
            class_1799 heldProjectile = class_1811.method_18815((class_1309)this, (Predicate)predicate);
            return heldProjectile.method_7960() ? (weaponItem instanceof SeedsLauncherItem ? ESItems.PUNGENCY_FRUIT_SEEDS.get().method_7854() : ESItems.MALARITE_ARROW.get().method_7854()) : heldProjectile;
        }
        return class_1799.field_8037;
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.stranghoul.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.stranghoul.armor()).method_26868(class_5134.field_23721, ESConfig.INSTANCE.mobsConfig.stranghoul.attackDamage()).method_26868(class_5134.field_23717, ESConfig.INSTANCE.mobsConfig.stranghoul.followRange()).method_26868(class_5134.field_23719, 0.3);
    }

    public void method_5837(class_3222 serverPlayer) {
        super.method_5837(serverPlayer);
        ESBookUtil.unlock(serverPlayer, EternalStarlight.id("stranghoul"));
    }

    protected void method_5964(class_5819 random, class_1266 difficulty) {
        if (random.method_43057() < 0.3f && this.method_6118(class_1304.field_6169).method_7960()) {
            this.method_5673(class_1304.field_6169, this.dyedLeatherArmor(class_1802.field_8267, random));
        }
        if (random.method_43057() < 0.3f && this.method_6118(class_1304.field_6174).method_7960()) {
            this.method_5673(class_1304.field_6174, this.dyedLeatherArmor(class_1802.field_8577, random));
        }
        if (random.method_43057() < 0.3f && this.method_6118(class_1304.field_6172).method_7960()) {
            this.method_5673(class_1304.field_6172, this.dyedLeatherArmor(class_1802.field_8570, random));
        }
        if (random.method_43057() < 0.3f && this.method_6118(class_1304.field_6166).method_7960()) {
            this.method_5673(class_1304.field_6166, this.dyedLeatherArmor(class_1802.field_8370, random));
        }
        if (this.method_6047().method_7960()) {
            class_7923.field_41178.method_56159(ESTags.Items.STRANGHOUL_CAN_USE, random).ifPresent(item -> this.method_5673(class_1304.field_6173, new class_1799(item)));
        }
    }

    private class_1799 dyedLeatherArmor(class_1792 item, class_5819 random) {
        class_1799 stack = item.method_7854();
        stack.method_57379(class_9334.field_49644, (Object)new class_9282(class_5253.class_5254.method_48780((float)random.method_43057(), (int)class_5253.class_5254.method_57173((int)117, (int)135, (int)137), (int)class_5253.class_5254.method_57173((int)48, (int)55, (int)56)), true));
        return stack;
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.homePos = this.method_24515();
        if (this.field_5974.method_43057() < 0.1f) {
            this.method_7217(true);
        }
        if (!this.method_6109()) {
            this.method_5964(this.method_59922(), difficulty);
            this.method_5984(level, this.method_59922(), difficulty);
        }
        this.breedCooldown = this.field_5974.method_43051(24000, 36000);
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            class_1542 itemEntity2;
            Object serverLevel;
            class_1937 class_19372;
            if (this.method_5968() != null && !this.method_5968().method_5805()) {
                this.method_5980(null);
            }
            if (this.hirer == null && this.hirerId != null && (class_19372 = this.method_37908()) instanceof class_3218) {
                serverLevel = (class_3218)class_19372;
                class_1297 class_12972 = serverLevel.method_14190(this.hirerId);
                if (class_12972 instanceof class_1309) {
                    class_1309 livingEntity;
                    this.hirer = livingEntity = (class_1309)class_12972;
                }
                if (this.hirer == null) {
                    this.hirerId = null;
                }
            }
            if (this.method_5805() && !this.field_6272 && !this.hiredEatAnim && ESPlatform.INSTANCE.canEntityGrief(this.method_37908(), (class_1297)this)) {
                for (class_1542 itemEntity2 : this.method_37908().method_18467(class_1542.class, this.method_5829().method_1009(2.0, 1.0, 2.0))) {
                    if (itemEntity2.method_31481() || itemEntity2.method_6983().method_7960() || itemEntity2.method_6977() || itemEntity2.method_24921() == this || (!itemEntity2.method_6983().method_31573(ESTags.Items.STRANGHOUL_FOOD) || this.method_6079().method_57826(class_9334.field_50075) || this.method_6079().method_31573(ESTags.Items.STRANGHOUL_CURRENCIES)) && (this.method_5968() != null || this.method_6109() || this.isEating() || !itemEntity2.method_6983().method_31573(ESTags.Items.STRANGHOUL_CURRENCIES) || this.method_6079().method_31573(ESTags.Items.STRANGHOUL_CURRENCIES))) continue;
                    this.method_5775(this.method_6079());
                    this.method_5673(class_1304.field_6171, itemEntity2.method_6983());
                    itemEntity2.method_31472();
                }
            }
            if (this.method_6109()) {
                ++this.growthTicks;
                if (this.growthTicks > 24000) {
                    this.growthTicks = 0;
                    this.method_7217(false);
                    this.addHappyParticles();
                    this.setEquipmentsOnGrownUp();
                }
            } else {
                --this.breedCooldown;
                this.breedCooldown = Math.max(this.breedCooldown, 0);
            }
            --this.hiredTicksLeft;
            this.hiredTicksLeft = Math.max(this.hiredTicksLeft, 0);
            if (this.hiredTicksLeft == 0) {
                this.setHirer(null);
            }
            if (this.method_6079().method_31573(ESTags.Items.STRANGHOUL_CURRENCIES) && this.method_5968() == null && (itemEntity2 = this.method_37908()) instanceof class_3218) {
                serverLevel = (class_3218)itemEntity2;
                ++this.admirationTicks;
                if (this.admirationTicks >= 60) {
                    class_52 lootTable = serverLevel.method_8503().method_58576().method_58295(ESLootTables.GAMEPLAY_STRANGHOUL_BARTERING);
                    ObjectArrayList items = lootTable.method_51878(new class_8567.class_8568((class_3218)serverLevel).method_51874(class_181.field_1226, (Object)this).method_51875(class_173.field_22403));
                    class_243 pos = class_5534.method_31527((class_1314)this, (int)4, (int)2);
                    List players = this.method_37908().method_18464(class_4051.method_36626(), (class_1309)this, this.method_5829().method_1014(4.0));
                    players.sort(Comparator.comparingDouble(p -> p.method_5739((class_1297)this)));
                    if (!players.isEmpty()) {
                        pos = ((class_1657)players.getFirst()).method_19538();
                    }
                    if (pos == null) {
                        pos = this.method_19538();
                    }
                    for (class_1799 item : items) {
                        class_4215.method_19949((class_1309)this, (class_1799)item, (class_243)pos.method_1031(0.0, 1.0, 0.0));
                    }
                    this.admirationTicks = 0;
                    this.method_6079().method_57008(1, (class_1309)this);
                    this.method_6104(class_1268.field_5810);
                }
                this.setBartering(true);
            } else {
                this.admirationTicks = 0;
                this.setBartering(false);
            }
        }
    }

    public boolean method_5722(class_1297 entity) {
        class_6025 ownable;
        class_1309 hirer = this.getHirer();
        return super.method_5722(entity) || entity instanceof Stranghoul || hirer != null && (hirer.method_5722(entity) || hirer == entity || entity instanceof class_6025 && (ownable = (class_6025)entity).method_6139() != null && ownable.method_6139().equals(this.method_6139()));
    }

    protected class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_31573(ESTags.Items.STRANGHOUL_HIRING_FOOD) && !this.isHired() && !this.method_6109() && this.method_5968() == null) {
            this.setHirer((class_1309)player);
            this.hiredTicksLeft = 24000;
            this.hiredEatAnim = true;
            this.method_5775(this.method_6079());
            this.method_5673(class_1304.field_6171, stack.method_46651(1));
            this.method_5971();
            stack.method_57008(1, (class_1309)player);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                ESCriteriaTriggers.HIRE_STRANGHOUL.get().method_9141(serverPlayer);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (stack.method_31573(ESTags.Items.STRANGHOUL_CURRENCIES) && !this.method_6109() && this.method_6079().method_7960() && this.method_5968() == null) {
            this.method_5673(class_1304.field_6171, stack.method_46651(1));
            stack.method_57008(1, (class_1309)player);
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        if (this.isHired() && player == this.getHirer()) {
            if (stack.method_31573(class_3489.field_48297)) {
                if (!this.method_37908().field_9236) {
                    player.method_6122(hand, this.method_6118(class_1304.field_6169).method_7972());
                    this.method_5673(class_1304.field_6169, stack.method_7972());
                    this.method_25939(class_1304.field_6169);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (stack.method_31573(class_3489.field_48296)) {
                if (!this.method_37908().field_9236) {
                    player.method_6122(hand, this.method_6118(class_1304.field_6174).method_7972());
                    this.method_5673(class_1304.field_6174, stack.method_7972());
                    this.method_25939(class_1304.field_6174);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (stack.method_31573(class_3489.field_48295)) {
                if (!this.method_37908().field_9236) {
                    player.method_6122(hand, this.method_6118(class_1304.field_6172).method_7972());
                    this.method_5673(class_1304.field_6172, stack.method_7972());
                    this.method_25939(class_1304.field_6172);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (stack.method_31573(class_3489.field_48294)) {
                if (!this.method_37908().field_9236) {
                    player.method_6122(hand, this.method_6118(class_1304.field_6166).method_7972());
                    this.method_5673(class_1304.field_6166, stack.method_7972());
                    this.method_25939(class_1304.field_6166);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (stack.method_57826(class_9334.field_50075)) {
                if (!this.method_37908().field_9236) {
                    player.method_6122(hand, this.method_6079().method_7972());
                    this.method_5673(class_1304.field_6171, stack.method_7972());
                    this.method_25939(class_1304.field_6171);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            if (!stack.method_7960()) {
                if (!this.method_37908().field_9236) {
                    player.method_6122(hand, this.method_6047().method_7972());
                    this.method_5673(class_1304.field_6173, stack.method_7972());
                    this.method_25939(class_1304.field_6173);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
            for (class_1304 slot : class_1304.values()) {
                if (this.method_6118(slot).method_7960()) continue;
                if (!this.method_37908().field_9236) {
                    player.method_6122(hand, this.method_6118(slot).method_7972());
                    this.method_5673(slot, class_1799.field_8037);
                }
                return class_1269.method_29236((boolean)this.method_37908().field_9236);
            }
        }
        return super.method_5992(player, hand);
    }

    public boolean canBreed() {
        return !this.makingLove && this.breedCooldown <= 0 && !this.isHired() && !this.method_6109() && this.method_37908().method_22335(this.method_24515(), 0) < 12 && this.method_37908().method_18467(Stranghoul.class, this.method_5829().method_1014(10.0)).stream().filter(Stranghoul::method_6109).count() < 5L;
    }

    public final boolean unableToMoveToHirer() {
        return this.method_5765() || this.method_60954() || this.method_35057() != null && this.method_35057().method_7325();
    }

    public void tryToTeleportToHirer() {
        class_1309 livingEntity = this.getHirer();
        if (livingEntity != null) {
            this.teleportToAroundBlockPos(livingEntity.method_24515());
        }
    }

    private void teleportToAroundBlockPos(class_2338 blockPos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.field_5974.method_39332(-3, 3);
            int k = this.field_5974.method_39332(-3, 3);
            if (Math.abs(j) < 2 && Math.abs(k) < 2) continue;
            int l = this.field_5974.method_39332(-1, 1);
            if (!this.maybeTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + l, blockPos.method_10260() + k)) continue;
            return;
        }
    }

    private boolean maybeTeleportTo(int i, int j, int k) {
        if (!this.canTeleportTo(new class_2338(i, j, k))) {
            return false;
        }
        this.method_5808((float)i + 0.5f, j, (float)k + 0.5f, this.method_36454(), this.method_36455());
        this.field_6189.method_6340();
        return true;
    }

    private boolean canTeleportTo(class_2338 blockPos) {
        class_7 pathType = class_14.method_57625((class_1308)this, (class_2338)blockPos);
        if (pathType != class_7.field_12) {
            return false;
        }
        class_2680 blockState = this.method_37908().method_8320(blockPos.method_10074());
        if (blockState.method_26204() instanceof class_2397) {
            return false;
        }
        class_2338 blockPos2 = blockPos.method_10059((class_2382)this.method_24515());
        return this.method_37908().method_8587((class_1297)this, this.method_5829().method_996(blockPos2));
    }

    public void addHappyParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (int i = 0; i < 5; ++i) {
                double d = this.method_59922().method_43059() * 0.02;
                double e = this.method_59922().method_43059() * 0.02;
                double f = this.method_59922().method_43059() * 0.02;
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((class_2394)class_2398.field_11211, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f));
            }
        }
    }

    public void addAlliedParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (int i = 0; i < 5; ++i) {
                double d = this.method_59922().method_43059() * 0.02;
                double e = this.method_59922().method_43059() * 0.02;
                double f = this.method_59922().method_43059() * 0.02;
                ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((class_2394)ESParticles.ALLIED.get(), this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f));
            }
        }
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1309 living;
        class_1297 class_12972 = source.method_5526();
        return super.method_5643(source, (float)(class_12972 instanceof class_1309 && (living = (class_1309)class_12972).method_59958().method_31573(ESTags.Items.STRANGHOUL_VULNERABLE_TO) ? 2 : 1) * amount);
    }

    public boolean method_6049(class_1293 instance) {
        return !instance.method_55654(class_1294.field_5903) && !instance.method_55654(ESMobEffects.TEARY.asHolder()) && super.method_6049(instance);
    }

    public void method_5674(class_2940<?> accessor) {
        super.method_5674(accessor);
        if (BABY.equals(accessor)) {
            this.method_18382();
        }
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.method_29517(compoundTag);
        compoundTag.method_10569(TAG_HOME_X, this.homePos.method_10263());
        compoundTag.method_10569(TAG_HOME_Y, this.homePos.method_10264());
        compoundTag.method_10569(TAG_HOME_Z, this.homePos.method_10260());
        compoundTag.method_10556(TAG_BABY, this.method_6109());
        compoundTag.method_10569(TAG_GROWTH_TICKS, this.growthTicks);
        compoundTag.method_10569(TAG_BREED_COOLDOWN, this.breedCooldown);
        compoundTag.method_10569(TAG_ADMIRATION_TICKS, this.admirationTicks);
        if (this.hirer != null) {
            compoundTag.method_25927(TAG_HIRER, this.hirer.method_5667());
        }
        compoundTag.method_10569(TAG_HIRED_TICKS_LEFT, this.hiredTicksLeft);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.method_29512(this.method_37908(), compoundTag);
        this.homePos = new class_2338(compoundTag.method_10550(TAG_HOME_X), compoundTag.method_10550(TAG_HOME_Y), compoundTag.method_10550(TAG_HOME_Z));
        if (compoundTag.method_10573(TAG_BABY, 1)) {
            this.method_7217(compoundTag.method_10577(TAG_BABY));
        }
        this.growthTicks = compoundTag.method_10550(TAG_GROWTH_TICKS);
        this.breedCooldown = compoundTag.method_10550(TAG_BREED_COOLDOWN);
        this.admirationTicks = compoundTag.method_10550(TAG_ADMIRATION_TICKS);
        if (compoundTag.method_25928(TAG_HIRER)) {
            this.hirerId = compoundTag.method_25926(TAG_HIRER);
        }
        this.hiredTicksLeft = compoundTag.method_10550(TAG_HIRED_TICKS_LEFT);
    }

    @Nullable
    protected class_3414 method_5994() {
        return ESSoundEvents.STRANGHOUL_AMBIENT.get();
    }

    protected class_3414 method_6011(class_1282 source) {
        return ESSoundEvents.STRANGHOUL_HURT.get();
    }

    protected class_3414 method_6002() {
        return ESSoundEvents.STRANGHOUL_DEATH.get();
    }

    public int method_29507() {
        return this.remainingPersistentAngerTime;
    }

    public void method_29514(int i) {
        this.remainingPersistentAngerTime = i;
    }

    @Nullable
    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(@Nullable UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.method_59922()));
    }

    @Nullable
    public UUID method_6139() {
        return this.hirerId;
    }

    public static boolean checkStranghoulSpawnRules(class_1299<? extends Stranghoul> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return Stranghoul.method_20681(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random) && ESConfig.INSTANCE.mobsConfig.stranghoul.canSpawn();
    }

    private class EatGoal
    extends class_1352 {
        private int eatTicks = 0;

        private EatGoal() {
        }

        public void method_6269() {
            this.eatTicks = 0;
            if (!Stranghoul.this.method_6079().method_57826(class_9334.field_50075)) {
                class_7923.field_41178.method_56159(ESTags.Items.STRANGHOUL_FOOD, Stranghoul.this.field_5974).ifPresent(item -> {
                    Stranghoul.this.method_5775(Stranghoul.this.method_6079());
                    Stranghoul.this.method_5673(class_1304.field_6171, new class_1799(item));
                });
            }
            if (Stranghoul.this.method_6079().method_57826(class_9334.field_50075)) {
                Stranghoul.this.setEating(true);
            }
        }

        public void method_6268() {
            class_1937 class_19372;
            ++this.eatTicks;
            class_1799 food = Stranghoul.this.method_6079();
            if (this.eatTicks == 32) {
                class_4174 foodProperties = (class_4174)food.method_57824(class_9334.field_50075);
                if (foodProperties != null) {
                    Stranghoul.this.method_6025((float)foodProperties.comp_2491() + foodProperties.comp_2492() * 3.0f);
                }
                Stranghoul.this.method_60492(Stranghoul.this.method_37908(), food);
            }
            if (this.eatTicks % 4 == 0 && (class_19372 = Stranghoul.this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                if (!food.method_7960()) {
                    for (int i = 0; i < (this.eatTicks == 32 ? 16 : 5); ++i) {
                        class_243 vec3 = new class_243((double)(Stranghoul.this.field_5974.method_43057() - 0.5f) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
                        vec3 = vec3.method_1037((float)((double)(-Stranghoul.this.method_36455()) * (Math.PI / 180)));
                        vec3 = vec3.method_1024((float)((double)(-Stranghoul.this.method_5791()) * (Math.PI / 180)));
                        double d0 = (double)(-Stranghoul.this.field_5974.method_43057()) * 0.6 - 0.3;
                        class_243 vec31 = new class_243((double)(Stranghoul.this.field_5974.method_43057() - 0.5f) * 0.3, d0, 0.6);
                        vec31 = vec31.method_1037((float)((double)(-Stranghoul.this.method_36455()) * (Math.PI / 180)));
                        vec31 = vec31.method_1024((float)((double)(-Stranghoul.this.method_5791()) * (Math.PI / 180)));
                        vec31 = vec31.method_1031(Stranghoul.this.method_23317(), Stranghoul.this.method_23320(), Stranghoul.this.method_23321());
                        ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket((class_2394)new class_2392(class_2398.field_11218, food), vec31.field_1352, vec31.field_1351, vec31.field_1350, vec3.field_1352, vec3.field_1351 + 0.05, vec3.field_1350));
                    }
                }
                Stranghoul.this.method_5783(Stranghoul.this.method_18869(food), 0.5f + 0.5f * (float)Stranghoul.this.field_5974.method_43048(2), (Stranghoul.this.field_5974.method_43057() - Stranghoul.this.field_5974.method_43057()) * 0.2f + 1.0f);
            }
        }

        public void method_6270() {
            Stranghoul.this.setEating(false);
            if (Stranghoul.this.hiredEatAnim) {
                Stranghoul.this.hiredEatAnim = false;
                Stranghoul.this.addAlliedParticles();
            }
        }

        public boolean method_38846() {
            return true;
        }

        public boolean method_6264() {
            if (Stranghoul.this.hiredEatAnim) {
                return true;
            }
            return Stranghoul.this.field_5974.method_43048(EatGoal.method_38848((int)80)) == 0 && (Stranghoul.this.method_6032() / Stranghoul.this.method_6063() < 0.4f || Stranghoul.this.method_6079().method_57826(class_9334.field_50075) && Stranghoul.this.method_6032() < Stranghoul.this.method_6063());
        }

        public boolean method_6266() {
            return Stranghoul.this.method_6079().method_57826(class_9334.field_50075) && this.eatTicks <= 32;
        }
    }

    class SeedsLauncherAttackGoal
    extends class_1381 {
        public SeedsLauncherAttackGoal() {
            super((class_1603)Stranghoul.this, 1.0, 30, 5.0f);
        }

        public boolean method_6264() {
            return super.method_6264() && Stranghoul.this.method_6047().method_7909() instanceof SeedsLauncherItem;
        }

        public void method_6269() {
            super.method_6269();
            Stranghoul.this.method_19540(true);
        }

        public void method_6270() {
            super.method_6270();
            Stranghoul.this.method_19540(false);
        }
    }

    class SpearAttackGoal
    extends class_1381 {
        public SpearAttackGoal() {
            super((class_1603)Stranghoul.this, 1.0, 40, 10.0f);
        }

        public boolean method_6264() {
            return super.method_6264() && Stranghoul.this.method_6047().method_7909() instanceof SpearItem;
        }

        public void method_6269() {
            super.method_6269();
            Stranghoul.this.method_19540(true);
            Stranghoul.this.method_6019(class_1268.field_5808);
        }

        public void method_6270() {
            super.method_6270();
            Stranghoul.this.method_6021();
            Stranghoul.this.method_19540(false);
        }
    }

    public class FollowHirerGoal
    extends class_1352 {
        @Nullable
        private class_1309 hirer;
        private final class_1408 navigation;
        private int timeToRecalcPath;
        private float oldWaterCost;

        public FollowHirerGoal() {
            this.navigation = Stranghoul.this.method_5942();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            class_1309 livingEntity = Stranghoul.this.getHirer();
            if (livingEntity == null) {
                return false;
            }
            if (Stranghoul.this.unableToMoveToHirer()) {
                return false;
            }
            if (Stranghoul.this.method_5858((class_1297)livingEntity) < 100.0) {
                return false;
            }
            this.hirer = livingEntity;
            return true;
        }

        public boolean method_6266() {
            if (this.navigation.method_6357()) {
                return false;
            }
            if (this.hirer == null) {
                return false;
            }
            if (Stranghoul.this.unableToMoveToHirer()) {
                return false;
            }
            return !(Stranghoul.this.method_5858((class_1297)this.hirer) <= 4.0);
        }

        public void method_6269() {
            this.timeToRecalcPath = 0;
            this.oldWaterCost = Stranghoul.this.method_5944(class_7.field_18);
            Stranghoul.this.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.hirer = null;
            this.navigation.method_6340();
            Stranghoul.this.method_5941(class_7.field_18, this.oldWaterCost);
        }

        public void method_6268() {
            boolean shouldTeleport;
            boolean bl = shouldTeleport = this.hirer != null && Stranghoul.this.method_5858((class_1297)this.hirer) >= 144.0;
            if (!shouldTeleport && this.hirer != null) {
                Stranghoul.this.method_5988().method_6226((class_1297)this.hirer, 10.0f, (float)Stranghoul.this.method_5978());
            }
            if (--this.timeToRecalcPath <= 0) {
                this.timeToRecalcPath = this.method_38847(10);
                if (shouldTeleport) {
                    Stranghoul.this.tryToTeleportToHirer();
                } else if (this.hirer != null) {
                    this.navigation.method_6335((class_1297)this.hirer, 1.0);
                }
            }
        }
    }

    private class BreedGoal
    extends class_1352 {
        private static final class_4051 PARTNER_TARGETING = class_4051.method_36626().method_18418(8.0).method_36627();
        protected final Stranghoul stranghoul;
        protected final class_1937 level;
        @Nullable
        protected Stranghoul partner;
        private int loveTime;

        public BreedGoal(Stranghoul stranghoul) {
            this.stranghoul = stranghoul;
            this.level = stranghoul.method_37908();
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            if (this.stranghoul.method_59922().method_43048(BreedGoal.method_38848((int)80)) != 0 || !this.stranghoul.canBreed()) {
                return false;
            }
            this.partner = this.getFreePartner();
            return this.partner != null;
        }

        public boolean method_6266() {
            return this.partner != null && this.partner.method_5805() && this.loveTime < 60;
        }

        public void method_6269() {
            this.stranghoul.makingLove = true;
            if (this.partner != null) {
                this.partner.makingLove = true;
            }
        }

        public void method_6270() {
            this.stranghoul.makingLove = false;
            if (this.partner != null) {
                this.partner.makingLove = false;
            }
            this.partner = null;
            this.loveTime = 0;
        }

        public void method_6268() {
            if (this.partner != null) {
                this.stranghoul.method_5988().method_6226((class_1297)this.partner, 10.0f, (float)this.stranghoul.method_5978());
                this.stranghoul.method_5942().method_6335((class_1297)this.partner, 1.0);
                ++this.loveTime;
                if (this.loveTime >= this.method_38847(60) && this.stranghoul.method_5858((class_1297)this.partner) < 9.0) {
                    Stranghoul baby = new Stranghoul(ESEntities.STRANGHOUL.get(), this.level);
                    baby.method_7217(true);
                    baby.method_5808(this.stranghoul.method_23317(), this.stranghoul.method_23318(), this.stranghoul.method_23321(), 0.0f, 0.0f);
                    class_1937 class_19372 = this.level;
                    if (class_19372 instanceof class_3218) {
                        class_3218 serverLevel = (class_3218)class_19372;
                        baby.method_5943((class_5425)serverLevel, this.level.method_8404(baby.method_24515()), class_3730.field_16466, null);
                    }
                    this.level.method_8649((class_1297)baby);
                    baby.addHappyParticles();
                    this.stranghoul.breedCooldown = 24000;
                    this.partner.breedCooldown = 24000;
                    this.loveTime = 60;
                }
            }
        }

        @Nullable
        private Stranghoul getFreePartner() {
            List<Stranghoul> list = this.level.method_18466(Stranghoul.class, PARTNER_TARGETING, (class_1309)this.stranghoul, this.stranghoul.method_5829().method_1014(8.0)).stream().filter(Stranghoul::canBreed).sorted(Comparator.comparingDouble(s -> s.method_5739((class_1297)this.stranghoul))).toList();
            return list.isEmpty() ? null : list.getFirst();
        }

        public boolean method_38846() {
            return true;
        }
    }

    private class GoToWantedItemGoal
    extends class_1352 {
        private class_1542 wantedItem;

        public GoToWantedItemGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            List<class_1542> items;
            if (Stranghoul.this.method_6109()) {
                return false;
            }
            if (Stranghoul.this.method_59922().method_43048(GoToWantedItemGoal.method_38848((int)80)) == 0 && !Stranghoul.this.method_6079().method_31573(ESTags.Items.STRANGHOUL_CURRENCIES) && !(items = Stranghoul.this.method_37908().method_18467(class_1542.class, Stranghoul.this.method_5829().method_1014(15.0)).stream().filter(i -> i.method_6983().method_31573(ESTags.Items.STRANGHOUL_CURRENCIES) && Stranghoul.this.method_6057((class_1297)i)).sorted(Comparator.comparingDouble(i -> i.method_5739((class_1297)Stranghoul.this))).toList()).isEmpty()) {
                this.wantedItem = items.getFirst();
                return true;
            }
            return false;
        }

        public boolean method_6266() {
            return this.wantedItem != null && this.wantedItem.method_5805();
        }

        public void method_6270() {
            this.wantedItem = null;
        }

        public void method_6268() {
            if (this.wantedItem != null) {
                Stranghoul.this.method_5988().method_6226((class_1297)this.wantedItem, 10.0f, (float)Stranghoul.this.method_5978());
                Stranghoul.this.method_5942().method_6335((class_1297)this.wantedItem, 1.0);
            }
        }

        public boolean method_38846() {
            return true;
        }
    }

    private class GoHomeGoal
    extends class_1352 {
        private int tryTicks = 0;

        public GoHomeGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return Stranghoul.this.method_59922().method_43048(GoHomeGoal.method_38848((int)120)) == 0 && !Stranghoul.this.method_24515().method_19771((class_2382)Stranghoul.this.homePos, 20.0);
        }

        public boolean method_6266() {
            return !Stranghoul.this.method_24515().method_19771((class_2382)Stranghoul.this.homePos, 10.0) && this.tryTicks < 600;
        }

        public void method_6270() {
            this.tryTicks = 0;
        }

        public void method_6268() {
            ++this.tryTicks;
            Stranghoul.this.method_5942().method_6337((double)Stranghoul.this.homePos.method_10263() + 0.5, (double)Stranghoul.this.homePos.method_10264() + 0.5, (double)Stranghoul.this.homePos.method_10260() + 0.5, 1.0);
        }

        public boolean method_38846() {
            return true;
        }
    }

    private class PlantCropGoal
    extends class_1367 {
        public PlantCropGoal() {
            super((class_1314)Stranghoul.this, 1.0, 20, 15);
        }

        public boolean method_6264() {
            if (Stranghoul.this.isHired() || !ESPlatform.INSTANCE.canEntityGrief(Stranghoul.this.method_37908(), (class_1297)Stranghoul.this)) {
                return false;
            }
            return Stranghoul.this.method_6047().method_31573(class_3489.field_42613) && !Stranghoul.this.isBartering() && super.method_6264();
        }

        public void method_6268() {
            class_2338 cropPos;
            class_1937 level;
            class_2680 blockState;
            super.method_6268();
            if (this.method_6295() && (blockState = (level = Stranghoul.this.method_37908()).method_8320(cropPos = this.field_6512.method_10084())).method_26215()) {
                level.method_8501(cropPos, ESBlocks.PUNGENCY_FRUIT_VINES.get().method_9564());
                level.method_43276((class_6880)class_5712.field_28733, cropPos, class_5712.class_7397.method_43285((class_1297)Stranghoul.this));
                Stranghoul.this.method_6104(class_1268.field_5808);
                Stranghoul.this.addHappyParticles();
            }
        }

        public double method_6291() {
            return 2.5;
        }

        protected boolean method_6296(class_4538 level, class_2338 pos) {
            class_2680 state = level.method_8320(pos);
            return ESBlocks.PUNGENCY_FRUIT_VINES.get().canPlaceSeeds(state, (class_1922)level, pos) && level.method_8320(pos.method_10084()).method_26215();
        }
    }

    private class CropGoal
    extends class_1367 {
        public CropGoal() {
            super((class_1314)Stranghoul.this, 1.0, 20, 15);
        }

        public boolean method_6264() {
            if (Stranghoul.this.isHired() || !ESPlatform.INSTANCE.canEntityGrief(Stranghoul.this.method_37908(), (class_1297)Stranghoul.this)) {
                return false;
            }
            return Stranghoul.this.method_6047().method_31573(class_3489.field_42613) && !Stranghoul.this.isBartering() && super.method_6264();
        }

        public void method_6268() {
            class_1937 level;
            class_2680 blockState;
            super.method_6268();
            if (this.method_6295() && (blockState = (level = Stranghoul.this.method_37908()).method_8320(this.field_6512)).method_27852((class_2248)ESBlocks.PUNGENCY_FRUIT_VINES.get()) && (Integer)blockState.method_11654((class_2769)PungencyFruitVinesBlock.field_10835) == 7 && ESPlatform.INSTANCE.postEntityDestroyBlockEvent(level, this.field_6512, (class_1297)Stranghoul.this)) {
                level.method_8651(this.field_6512, true, (class_1297)Stranghoul.this);
                Stranghoul.this.method_6104(class_1268.field_5808);
                Stranghoul.this.addHappyParticles();
            }
        }

        public double method_6291() {
            return 2.5;
        }

        protected boolean method_6296(class_4538 level, class_2338 pos) {
            class_2680 state = level.method_8320(pos);
            return state.method_27852((class_2248)ESBlocks.PUNGENCY_FRUIT_VINES.get()) && (Integer)state.method_11654((class_2769)PungencyFruitVinesBlock.field_10835) == 7;
        }
    }

    private class DryRottenFleshGoal
    extends class_1367 {
        public DryRottenFleshGoal() {
            super((class_1314)Stranghoul.this, 1.0, 20, 15);
        }

        public boolean method_6264() {
            if (Stranghoul.this.isHired() || !ESPlatform.INSTANCE.canEntityGrief(Stranghoul.this.method_37908(), (class_1297)Stranghoul.this)) {
                return false;
            }
            return Stranghoul.this.method_6079().method_31574(class_1802.field_8511) && !Stranghoul.this.isBartering() && super.method_6264();
        }

        public boolean method_6266() {
            return Stranghoul.this.method_6079().method_31574(class_1802.field_8511) && super.method_6266();
        }

        public void method_6268() {
            class_1937 level;
            super.method_6268();
            if (this.method_6295() && this.method_6296((class_4538)(level = Stranghoul.this.method_37908()), this.field_6512)) {
                class_2586 class_25862 = level.method_8321(this.field_6512);
                if (class_25862 instanceof DryingRackBlockEntity) {
                    DryingRackBlockEntity entity = (DryingRackBlockEntity)class_25862;
                    entity.setItem(Stranghoul.this.method_6079().method_46651(1));
                    Stranghoul.this.method_6079().method_57008(1, (class_1309)Stranghoul.this);
                }
                Stranghoul.this.method_6104(class_1268.field_5810);
                Stranghoul.this.addHappyParticles();
            }
        }

        public double method_6291() {
            return 2.5;
        }

        protected boolean method_6296(class_4538 level, class_2338 pos) {
            DryingRackBlockEntity entity;
            class_2586 class_25862;
            return level.method_8320(pos).method_27852((class_2248)ESBlocks.DRYING_RACK.get()) && (class_25862 = level.method_8321(pos)) instanceof DryingRackBlockEntity && ((entity = (DryingRackBlockEntity)class_25862).getItem().method_7960() || entity.getItem().method_31574(ESItems.ROTTEN_FLESH_JERKY.get()) || entity.getItem().method_31574(class_1802.field_8745));
        }
    }

    private class HirerHurtByTargetGoal
    extends class_1405 {
        private class_1309 hirerLastHurtBy;
        private int timestamp;

        public HirerHurtByTargetGoal() {
            super((class_1308)Stranghoul.this, false);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (Stranghoul.this.isHired()) {
                class_1309 living = Stranghoul.this.getHirer();
                if (living == null) {
                    return false;
                }
                this.hirerLastHurtBy = living.method_6065();
                int i = living.method_6117();
                return i != this.timestamp && this.method_6328(this.hirerLastHurtBy, class_4051.field_18092);
            }
            return false;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.hirerLastHurtBy);
            class_1309 living = Stranghoul.this.getHirer();
            if (living != null) {
                this.timestamp = living.method_6117();
            }
            super.method_6269();
        }
    }

    public class HirerHurtTargetGoal
    extends class_1405 {
        private class_1309 hirerLastHurt;
        private int timestamp;

        public HirerHurtTargetGoal() {
            super((class_1308)Stranghoul.this, false);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (Stranghoul.this.isHired()) {
                class_1309 livingEntity = Stranghoul.this.getHirer();
                if (livingEntity == null) {
                    return false;
                }
                this.hirerLastHurt = livingEntity.method_6052();
                int i = livingEntity.method_6083();
                return i != this.timestamp && this.method_6328(this.hirerLastHurt, class_4051.field_18092);
            }
            return false;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.hirerLastHurt);
            class_1309 livingEntity = Stranghoul.this.getHirer();
            if (livingEntity != null) {
                this.timestamp = livingEntity.method_6083();
            }
            super.method_6269();
        }
    }
}

