/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.entity.living.monster;

import cn.leolezury.eternalstarlight.common.config.ESConfig;
import cn.leolezury.eternalstarlight.common.entity.living.monster.TinyCreteor;
import cn.leolezury.eternalstarlight.common.network.ParticlePacket;
import cn.leolezury.eternalstarlight.common.particle.ExplosionShockParticleOptions;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import cn.leolezury.eternalstarlight.common.registry.ESEntities;
import cn.leolezury.eternalstarlight.common.registry.ESSoundEvents;
import java.util.Collection;
import java.util.EnumSet;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1366;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1538;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4582;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import net.minecraft.class_7094;

public class Creteor
extends class_1588
implements class_4582 {
    private static final String TAG_ACTIVATED = "activated";
    private static final String TAG_IGNITED = "ignited";
    private static final String TAG_POWERED = "powered";
    private static final String TAG_SWELL = "swell";
    private static final String TAG_SPIN_TICKS = "spin_ticks";
    public class_7094 idleAnimationState = new class_7094();
    protected static final class_2940<Boolean> ACTIVATED = class_2945.method_12791(Creteor.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> IGNITED = class_2945.method_12791(Creteor.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Boolean> POWERED = class_2945.method_12791(Creteor.class, (class_2941)class_2943.field_13323);
    protected static final class_2940<Integer> SWELL = class_2945.method_12791(Creteor.class, (class_2941)class_2943.field_13327);
    public int oldSwell;
    public int spinTicks;
    public float rollAngle;
    public float prevRollAngle;
    public float spin;
    public float prevSpin;

    public boolean isActivated() {
        return (Boolean)this.method_5841().method_12789(ACTIVATED);
    }

    public void setActivated(boolean activated) {
        this.method_5841().method_12778(ACTIVATED, (Object)activated);
    }

    public boolean isIgnited() {
        return (Boolean)this.method_5841().method_12789(IGNITED);
    }

    public void setIgnited(boolean ignited) {
        this.method_5841().method_12778(IGNITED, (Object)ignited);
    }

    public boolean method_6872() {
        return (Boolean)this.method_5841().method_12789(POWERED);
    }

    public void setPowered(boolean powered) {
        this.method_5841().method_12778(POWERED, (Object)powered);
    }

    public int getSwell() {
        return (Integer)this.method_5841().method_12789(SWELL);
    }

    public void setSwell(int swell) {
        this.method_5841().method_12778(SWELL, (Object)swell);
    }

    public Creteor(class_1299<? extends Creteor> type, class_1937 level) {
        super(type, level);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ACTIVATED, (Object)false).method_56912(IGNITED, (Object)false).method_56912(POWERED, (Object)false).method_56912(SWELL, (Object)0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(0, (class_1352)new CreteorDoNothingGoal());
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(3, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6185.method_6277(0, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(1, (class_1352)new class_1400<class_1657>((class_1308)this, class_1657.class, true){

            public boolean method_6264() {
                return super.method_6264() && Creteor.this.isActivated();
            }
        });
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, ESConfig.INSTANCE.mobsConfig.creteor.maxHealth()).method_26868(class_5134.field_23724, ESConfig.INSTANCE.mobsConfig.creteor.armor()).method_26868(class_5134.field_23721, ESConfig.INSTANCE.mobsConfig.creteor.attackDamage()).method_26868(class_5134.field_23717, ESConfig.INSTANCE.mobsConfig.creteor.followRange()).method_26868(class_5134.field_23719, 0.3);
    }

    public void method_6007() {
        super.method_6007();
        this.oldSwell = this.getSwell();
        this.spinTicks = this.getSwell() < 80 ? 0 : ++this.spinTicks;
        if (!this.method_37908().field_9236) {
            if ((this.method_5968() != null || this.isIgnited()) && !this.isActivated()) {
                this.setActivated(true);
            }
            if (this.getSwell() < 80) {
                class_1309 target = this.method_5968();
                if (this.isIgnited()) {
                    this.setSwell(this.getSwell() + 1);
                } else if (target == null) {
                    this.setSwell(this.getSwell() - 1);
                } else if (this.method_5858((class_1297)target) > 25.0) {
                    this.setSwell(this.getSwell() - 1);
                } else if (!this.method_5985().method_6369((class_1297)target)) {
                    this.setSwell(this.getSwell() - 1);
                } else {
                    this.setSwell(this.getSwell() + 1);
                }
                this.setSwell(class_3532.method_15340((int)this.getSwell(), (int)0, (int)80));
            } else {
                this.method_5875(true);
                this.field_6037 = true;
                if (this.spinTicks <= 40) {
                    this.method_18799(new class_243(0.0, 0.1, 0.0));
                } else {
                    this.method_18799(class_243.field_1353);
                }
                if (this.spinTicks == 1) {
                    this.method_43077(ESSoundEvents.CRETEOR_CHARGE.get());
                }
                if (this.spinTicks > 80) {
                    this.explode();
                }
            }
        } else {
            this.idleAnimationState.method_41324(this.field_6012);
            this.prevRollAngle = this.rollAngle;
            this.rollAngle += (float)(this.method_19538().method_1020(new class_243(this.field_6038, this.field_5971, this.field_5989)).method_1033() / 0.011538461782038212);
            this.rollAngle = class_3532.method_15393((float)this.rollAngle);
            if (!this.isActivated()) {
                this.rollAngle = 0.0f;
            }
            this.prevSpin = this.spin;
            if (this.getSwell() >= 80) {
                this.spin += 90.0f;
            }
        }
    }

    public void method_18799(class_243 vec3) {
        super.method_18799(this.isActivated() ? vec3 : new class_243(0.0, vec3.field_1351, 0.0));
    }

    public float getSwellProgress(float partialTick) {
        if (this.getSwell() < 80) {
            return class_3532.method_16439((float)partialTick, (float)this.oldSwell, (float)this.getSwell()) / 160.0f;
        }
        return Math.min((float)(this.spinTicks + 80) + partialTick, 160.0f) / 160.0f;
    }

    public void method_5800(class_3218 serverLevel, class_1538 lightningBolt) {
        super.method_5800(serverLevel, lightningBolt);
        this.setPowered(true);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (!this.isActivated()) {
            this.setActivated(true);
        }
        return super.method_5643(source, amount);
    }

    protected class_1269 method_5992(class_1657 player, class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (itemStack.method_31573(class_3489.field_41662)) {
            class_3414 soundEvent = itemStack.method_31574(class_1802.field_8814) ? class_3417.field_15013 : class_3417.field_15145;
            this.method_37908().method_43128(player, this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, this.method_5634(), 1.0f, this.field_5974.method_43057() * 0.4f + 0.8f);
            if (!this.method_37908().field_9236) {
                this.setIgnited(true);
                if (!itemStack.method_7963()) {
                    itemStack.method_7934(1);
                } else {
                    itemStack.method_7970(1, (class_1309)player, Creteor.method_56079((class_1268)interactionHand));
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, interactionHand);
    }

    private void explode() {
        if (!this.method_37908().field_9236) {
            float f = this.method_6872() ? 2.0f : 1.0f;
            this.field_6272 = true;
            this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), 3.0f * f, class_1937.class_7867.field_40890);
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                for (int i = 0; i < 25; ++i) {
                    class_243 speed = new class_243((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)).method_1029();
                    ESPlatform.INSTANCE.sendToAllClients(serverLevel, new ParticlePacket(ExplosionShockParticleOptions.AETHERSENT, this.method_33571().field_1352 + speed.field_1352 * 1.2, this.method_33571().field_1351 + speed.field_1351 * 1.2, this.method_33571().field_1350 + speed.field_1350 * 1.2, speed.field_1352, speed.field_1351, speed.field_1350));
                }
            }
            this.method_43077(ESSoundEvents.CRETEOR_EXPLODE.get());
            this.spawnLingeringCloud();
            this.method_60699(class_1297.class_5529.field_26998);
            this.method_31472();
            if (ESConfig.INSTANCE.mobsConfig.tinyCreteor.canSpawn()) {
                int splitCount = this.method_59922().method_43051(2, 5);
                for (int i = 0; i < splitCount; ++i) {
                    TinyCreteor tinyCreteor = new TinyCreteor(ESEntities.TINY_CRETEOR.get(), this.method_37908());
                    tinyCreteor.method_33574(this.method_19538().method_1031(0.0, (double)(this.method_17682() / 2.0f), 0.0));
                    tinyCreteor.setPowered(this.method_6872());
                    tinyCreteor.method_5980(this.method_5968());
                    this.method_37908().method_8649((class_1297)tinyCreteor);
                    tinyCreteor.field_6037 = true;
                    tinyCreteor.method_18799(new class_243((double)((this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.1f), (double)(this.method_59922().method_43057() * 0.05f), (double)((this.method_59922().method_43057() - this.method_59922().method_43057()) * 0.1f)));
                }
            }
        }
    }

    private void spawnLingeringCloud() {
        Collection collection = this.method_6026();
        if (!collection.isEmpty()) {
            class_1295 areaEffectCloud = new class_1295(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321());
            areaEffectCloud.method_5603(2.5f);
            areaEffectCloud.method_5609(-0.5f);
            areaEffectCloud.method_5595(10);
            areaEffectCloud.method_5604(areaEffectCloud.method_5605() / 2);
            areaEffectCloud.method_5596(-areaEffectCloud.method_5599() / (float)areaEffectCloud.method_5605());
            for (class_1293 mobEffectInstance : collection) {
                areaEffectCloud.method_5610(new class_1293(mobEffectInstance));
            }
            this.method_37908().method_8649((class_1297)areaEffectCloud);
        }
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        super.method_5712(blockPos, blockState);
        this.method_43077(ESSoundEvents.CRETEOR_ROLL.get());
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return ESSoundEvents.CRETEOR_HURT.get();
    }

    protected class_3414 method_6002() {
        return ESSoundEvents.CRETEOR_DEATH.get();
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556(TAG_ACTIVATED, this.isActivated());
        compoundTag.method_10556(TAG_IGNITED, this.isIgnited());
        compoundTag.method_10556(TAG_POWERED, this.method_6872());
        compoundTag.method_10569(TAG_SWELL, this.getSwell());
        compoundTag.method_10569(TAG_SPIN_TICKS, this.spinTicks);
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setActivated(compoundTag.method_10577(TAG_ACTIVATED));
        this.setIgnited(compoundTag.method_10577(TAG_IGNITED));
        this.setPowered(compoundTag.method_10577(TAG_POWERED));
        this.setSwell(compoundTag.method_10550(TAG_SWELL));
        this.spinTicks = compoundTag.method_10550(TAG_SPIN_TICKS);
    }

    public static boolean checkCreteorSpawnRules(class_1299<? extends Creteor> type, class_1936 level, class_3730 spawnType, class_2338 pos, class_5819 random) {
        return Creteor.method_20681(type, (class_1936)level, (class_3730)spawnType, (class_2338)pos, (class_5819)random) && ESConfig.INSTANCE.mobsConfig.creteor.canSpawn();
    }

    class CreteorDoNothingGoal
    extends class_1352 {
        public CreteorDoNothingGoal() {
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407, class_1352.class_4134.field_18406));
        }

        public boolean method_6264() {
            return !Creteor.this.isActivated();
        }
    }
}

