/*
 * Decompiled with CFR 0.152.
 */
package cn.leolezury.eternalstarlight.common.client.gui.screen;

import cn.leolezury.eternalstarlight.common.client.gui.screen.widget.CrestButton;
import cn.leolezury.eternalstarlight.common.client.gui.screen.widget.CrestPageButton;
import cn.leolezury.eternalstarlight.common.client.shader.ESShaders;
import cn.leolezury.eternalstarlight.common.crest.Crest;
import cn.leolezury.eternalstarlight.common.network.UpdateCrestsPacket;
import cn.leolezury.eternalstarlight.common.platform.ESPlatform;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1041;
import net.minecraft.class_2561;
import net.minecraft.class_284;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_5944;
import net.minecraft.class_9801;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public class CrestSelectionScreen
extends class_437 {
    private final List<CrestButton> crestButtons = new ArrayList<CrestButton>();
    private final List<Crest.Instance> ownedCrests;
    private List<Crest.Instance> crests;
    private CrestButton selectedCrestButton;
    private CrestPageButton nextPage;
    private CrestPageButton previousPage;
    private Crest.Instance selectedCrest;
    private int selected;
    private int tickCount;

    public CrestSelectionScreen(List<Crest.Instance> crests, List<Crest.Instance> ownedCrests) {
        super((class_2561)class_2561.method_43473());
        this.crests = crests;
        this.ownedCrests = ownedCrests;
    }

    protected void method_25426() {
        this.previousPage = (CrestPageButton)this.method_37063((class_364)new CrestPageButton(this.field_22789 / 4 - 24, this.field_22790 / 2 - 12 - 50, 48, 24, false, (class_2561)class_2561.method_43473(), button -> this.previousPage()));
        this.nextPage = (CrestPageButton)this.method_37063((class_364)new CrestPageButton(this.field_22789 / 4 - 24, this.field_22790 / 2 - 12 + 50, 48, 24, true, (class_2561)class_2561.method_43473(), button -> this.nextPage()));
        List<Crest.Instance> crests = this.crests == null ? this.crestButtons.stream().map(CrestButton::getCrest).toList() : this.crests;
        this.crestButtons.clear();
        for (int i = 0; i < 5; ++i) {
            int ordinal = i;
            CrestButton crestButton = (CrestButton)this.method_37063((class_364)new CrestButton((int)((float)this.field_22789 / 9.0f * 5.0f), (int)((float)this.field_22790 / 2.0f), 72, 72, true, (class_2561)class_2561.method_43473(), button -> this.cancelCrest(ordinal)).setCrest(i >= crests.size() ? null : crests.get(i)));
            this.crestButtons.add(crestButton);
        }
        this.selectedCrestButton = (CrestButton)this.method_37063((class_364)new CrestButton(this.field_22789 / 4 - 36, this.field_22790 / 2 - 36, 72, 72, (class_2561)class_2561.method_43473(), button -> this.selectCrest()));
        this.updateGui();
        this.crests = null;
    }

    public void method_25393() {
        for (CrestButton button : this.crestButtons) {
            button.tick();
        }
        this.selectedCrestButton.tick();
        this.nextPage.tick();
        this.previousPage.tick();
        this.updateGui();
        ++this.tickCount;
    }

    public void updateGui() {
        if (!this.ownedCrests.isEmpty()) {
            this.nextPage.field_22763 = this.selected < this.ownedCrests.size() - 1;
            this.previousPage.field_22763 = this.selected > 0;
            this.selectedCrest = this.ownedCrests.get(this.selected);
            this.selectedCrestButton.setCrest(this.selectedCrest);
        } else {
            this.nextPage.field_22763 = false;
            this.previousPage.field_22763 = false;
            this.selectedCrest = null;
            this.selectedCrestButton.setCrest(null);
            this.selectedCrestButton.field_22763 = false;
        }
        List<CrestButton> notEmptyButtons = this.crestButtons.stream().filter(crestButton -> !crestButton.isEmpty()).toList();
        for (int n = 0; n < notEmptyButtons.size(); ++n) {
            CrestButton crestButton2 = this.crestButtons.get(n);
            crestButton2.setOrbitCenter((float)this.field_22789 / 9.0f * 5.0f, (float)this.field_22790 / 2.0f);
            crestButton2.setAngle(360.0f / (float)notEmptyButtons.size() * (float)n + (float)this.tickCount);
        }
    }

    private void previousPage() {
        if (this.selected > 0) {
            --this.selected;
            this.updateGui();
        }
    }

    private void nextPage() {
        if (this.selected < this.ownedCrests.size() - 1) {
            ++this.selected;
            this.updateGui();
        }
    }

    private void cancelCrest(int ordinal) {
        if (!this.crestButtons.get(ordinal).isEmpty()) {
            ArrayList<Crest.Instance> crests = new ArrayList<Crest.Instance>();
            this.crestButtons.get(ordinal).setCrest(null);
            for (CrestButton crestButton : this.crestButtons) {
                if (crestButton.isEmpty()) continue;
                crests.add(crestButton.getCrest());
            }
            for (int i = 0; i < this.crestButtons.size(); ++i) {
                CrestButton crestButton;
                crestButton = this.crestButtons.get(i);
                crestButton.setCrest(i >= crests.size() ? null : (Crest.Instance)crests.get(i));
            }
        }
    }

    private void selectCrest() {
        if (((Crest)this.selectedCrest.crest().comp_349()).attributeModifiers().isEmpty() && ((Crest)this.selectedCrest.crest().comp_349()).effects().isEmpty()) {
            return;
        }
        if (this.crestButtons.stream().anyMatch(crestButton -> !crestButton.isEmpty() && ((Crest)crestButton.getCrest().crest().comp_349()).type() == ((Crest)this.selectedCrest.crest().comp_349()).type())) {
            return;
        }
        for (CrestButton crestButton2 : this.crestButtons) {
            if (!crestButton2.isEmpty()) continue;
            crestButton2.setCrest(this.selectedCrest);
            return;
        }
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        int x = window.method_4486();
        int y = window.method_4502();
        Matrix4f matrix4f = guiGraphics.method_51448().method_23760().method_23761();
        class_5944 instance = ESShaders.getCrestSelectionGui();
        if (instance != null) {
            class_284 tickUniform = instance.method_34582("TickCount");
            class_284 ratioUniform = instance.method_34582("Ratio");
            if (tickUniform != null) {
                tickUniform.method_1251((float)this.tickCount + class_310.method_1551().method_60646().method_60637(class_310.method_1551().field_1687 != null && class_310.method_1551().field_1687.method_54719().method_54751()));
            }
            if (ratioUniform != null) {
                ratioUniform.method_1251((float)y / (float)x);
            }
        }
        RenderSystem.setShader(ESShaders::getCrestSelectionGui);
        class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 0.0f);
        bufferBuilder.method_22918(matrix4f, 0.0f, (float)y, 0.0f).method_22913(0.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, (float)x, (float)y, 0.0f).method_22913(1.0f, 1.0f);
        bufferBuilder.method_22918(matrix4f, (float)x, 0.0f, 0.0f).method_22913(1.0f, 0.0f);
        class_286.method_43433((class_9801)bufferBuilder.method_60800());
        super.method_25394(guiGraphics, i, j, f);
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
    }

    public void method_25419() {
        super.method_25419();
        ArrayList<Crest.Instance> newCrests = new ArrayList<Crest.Instance>();
        for (CrestButton button : this.crestButtons) {
            if (button.isEmpty()) continue;
            newCrests.add(button.getCrest());
        }
        ESPlatform.INSTANCE.sendToServer(new UpdateCrestsPacket(new Crest.Set(newCrests)));
    }
}

