/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.frqnny.mostructures.init.Structures;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2382;
import net.minecraft.class_5321;
import net.minecraft.class_5381;
import net.minecraft.class_5699;
import net.minecraft.class_6872;
import net.minecraft.class_6873;
import net.minecraft.class_6874;
import net.minecraft.class_6875;
import net.minecraft.class_6880;
import net.minecraft.class_7059;
import net.minecraft.class_7869;
import net.minecraft.class_7924;

public class ModStructurePlacement
extends class_6872 {
    public static final MapCodec<ModStructurePlacement> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_2382.method_39677((int)16).optionalFieldOf("locate_offset", (Object)class_2382.field_11176).forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).method_41642()), (App)class_6874.class_7154.field_37786.optionalFieldOf("frequency_reduction_method", (Object)class_6874.class_7154.field_37782).forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).method_41643()), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("frequency", (Object)Float.valueOf(1.0f)).forGetter(rec$ -> Float.valueOf(((ModStructurePlacement)((Object)((Object)((Object)rec$)))).method_41644())), (App)class_5699.field_33441.fieldOf("salt").forGetter(rec$ -> ((ModStructurePlacement)((Object)((Object)((Object)rec$)))).method_41645()), (App)class_5381.method_31192((class_5321)class_7924.field_41248, (Codec)class_7059.field_37195, (boolean)false).listOf().fieldOf("structure_set_to_avoid").orElse(new ArrayList(20)).forGetter(config -> config.structureSetToAvoid), (App)Codec.intRange((int)0, (int)4096).fieldOf("spacing").forGetter(ModStructurePlacement::method_41632), (App)Codec.intRange((int)0, (int)4096).fieldOf("separation").forGetter(ModStructurePlacement::method_41633), (App)class_6873.field_36423.optionalFieldOf("spread_type", (Object)class_6873.field_36421).forGetter(ModStructurePlacement::method_41634)).apply((Applicative)instance, ModStructurePlacement::new));
    public final List<class_6880<class_7059>> structureSetToAvoid;
    private final class_6873 spreadType;
    private int spacing;
    private int separation;
    private boolean activated = true;

    public ModStructurePlacement(class_2382 locateOffset, class_6874.class_7154 frequencyReductionMethod, float frequency, int salt, List<class_6880<class_7059>> structureSetToAvoid, int spacing, int separation, class_6873 spreadType) {
        super(locateOffset, frequencyReductionMethod, frequency, salt, Optional.empty(), spacing, separation, spreadType);
        this.spacing = spacing;
        this.separation = separation;
        this.spreadType = spreadType;
        this.structureSetToAvoid = structureSetToAvoid;
    }

    public static boolean isStructureSetNearby(class_7869 calculator, class_6880<class_7059> structureSetEntry, int centerChunkX, int centerChunkZ, int chunkCount) {
        for (int i = centerChunkX - chunkCount; i <= centerChunkX + chunkCount; ++i) {
            for (int j = centerChunkZ - chunkCount; j <= centerChunkZ + chunkCount; ++j) {
                ModStructurePlacement structurePlacement;
                class_6874 placement = ((class_7059)structureSetEntry.comp_349()).comp_511();
                if (!(placement instanceof ModStructurePlacement ? (structurePlacement = (ModStructurePlacement)placement).shouldGenerateNoExclusionCheck(calculator, i, j) : placement.method_41639(calculator, i, j))) continue;
                return true;
            }
        }
        return false;
    }

    public void setActivated(boolean activated) {
        this.activated = activated;
    }

    public int method_41632() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        this.spacing = spacing;
    }

    public int method_41633() {
        return this.separation;
    }

    public void setSeparation(int separation) {
        this.separation = separation;
    }

    public class_6873 method_41634() {
        return this.spreadType;
    }

    public boolean method_41639(class_7869 calculator, int chunkX, int chunkZ) {
        return this.activated && super.method_41639(calculator, chunkX, chunkZ) && this.exclusionZoneCheck(calculator, chunkX, chunkZ);
    }

    public boolean shouldGenerateNoExclusionCheck(class_7869 calculator, int chunkX, int chunkZ) {
        return this.activated && super.method_41639(calculator, chunkX, chunkZ);
    }

    public boolean exclusionZoneCheck(class_7869 calculator, int chunkX, int chunkZ) {
        if (!this.structureSetToAvoid.isEmpty()) {
            for (class_6880<class_7059> entry : this.structureSetToAvoid) {
                if (!ModStructurePlacement.isStructureSetNearby(calculator, entry, chunkX, chunkZ, 4)) continue;
                return false;
            }
        }
        return true;
    }

    public class_6875<?> method_40166() {
        return (class_6875)Structures.TYPE.get();
    }
}

