/*
 * Decompiled with CFR 0.152.
 */
package io.github.frqnny.mostructures.structure;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.frqnny.mostructures.init.Structures;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_5434;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_5868;
import net.minecraft.class_6122;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7151;
import net.minecraft.class_8889;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;

public class ModStructure
extends class_3195 {
    public static final MapCodec<ModStructure> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_3195.class_7302.field_38430.forGetter(feature -> feature.field_38429), (App)class_3785.field_24954.fieldOf("start_pool").forGetter(structure -> structure.startPool), (App)class_2960.field_25139.optionalFieldOf("start_jigsaw_name").forGetter(structure -> structure.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(structure -> structure.size), (App)class_6122.field_31540.fieldOf("start_height").forGetter(structure -> structure.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(structure -> structure.useExpansionHack), (App)class_2902.class_2903.field_24772.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.intRange((int)-1, (int)100).fieldOf("heightRange").orElse((Object)-1).forGetter(structure -> structure.heightRange), (App)Codec.list((Codec)class_8889.field_46825).optionalFieldOf("pool_aliases", List.of()).forGetter(structure -> structure.poolAliasBindings), (App)class_9778.field_51952.optionalFieldOf("dimension_padding", (Object)class_5434.field_51911).forGetter(structure -> structure.dimensionPadding), (App)class_9822.field_52239.optionalFieldOf("liquid_settings", (Object)class_5434.field_52235).forGetter(jigsawStructure -> jigsawStructure.liquidSettings)).apply((Applicative)instance, ModStructure::new));
    public final class_6880<class_3785> startPool;
    public final int heightRange;
    private final Optional<class_2960> startJigsawName;
    private final int size;
    private final class_6122 startHeight;
    private final boolean useExpansionHack;
    private final Optional<class_2902.class_2903> projectStartToHeightmap;
    private final int maxDistanceFromCenter;
    private final List<class_8889> poolAliasBindings;
    private final class_9778 dimensionPadding;
    private final class_9822 liquidSettings;

    public ModStructure(class_3195.class_7302 config, class_6880<class_3785> startPool, Optional<class_2960> startJigsawName, int size, class_6122 startHeight, boolean useExpansionHack, Optional<class_2902.class_2903> projectStartToHeightmap, int maxDistanceFromCenter, int heightRange, List<class_8889> poolAliasBindings, class_9778 dimensionPadding, class_9822 liquidSettings) {
        super(config);
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.heightRange = heightRange;
        this.poolAliasBindings = poolAliasBindings;
        this.dimensionPadding = dimensionPadding;
        this.liquidSettings = liquidSettings;
    }

    public Optional<class_3195.class_7150> method_38676(class_3195.class_7149 context) {
        if (this.canGenerate(context.comp_562(), context.comp_568(), context.comp_569(), context.comp_564())) {
            class_1923 chunkPos = context.comp_568();
            int y = this.startHeight.method_35391((class_5819)context.comp_566(), new class_5868(context.comp_562(), context.comp_569()));
            class_2338 blockPos = new class_2338(chunkPos.method_8326(), y, chunkPos.method_8328());
            return class_3778.method_30419((class_3195.class_7149)context, this.startPool, this.startJigsawName, (int)this.size, (class_2338)blockPos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter, (class_8891)class_8891.create(this.poolAliasBindings, (class_2338)blockPos, (long)context.comp_567()), (class_9778)this.dimensionPadding, (class_9822)this.liquidSettings);
        }
        return Optional.empty();
    }

    public boolean canGenerate(class_2794 chunkGenerator, class_1923 pos, class_5539 world, class_7138 noiseConfig) {
        int heightRange = this.heightRange;
        if (heightRange != -1) {
            int maxTerrainHeight = Integer.MIN_VALUE;
            int minTerrainHeight = Integer.MAX_VALUE;
            for (int curChunkX = pos.field_9181 - 2; curChunkX <= pos.field_9181 + 2; ++curChunkX) {
                for (int curChunkZ = pos.field_9180 - 2; curChunkZ <= pos.field_9180 + 2; ++curChunkZ) {
                    int height = chunkGenerator.method_16397((curChunkX << 4) + 7, (curChunkZ << 4) + 7, class_2902.class_2903.field_13194, world, noiseConfig);
                    maxTerrainHeight = Math.max(maxTerrainHeight, height);
                    minTerrainHeight = Math.min(minTerrainHeight, height);
                }
            }
            return maxTerrainHeight - minTerrainHeight <= heightRange;
        }
        return true;
    }

    public class_7151<?> method_41618() {
        return (class_7151)Structures.GENERIC.get();
    }
}

