/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.networking;

import cx.rain.mc.nbtedit.NBTEdit;
import cx.rain.mc.nbtedit.NBTEditPlatform;
import cx.rain.mc.nbtedit.networking.NetworkingHelper;
import cx.rain.mc.nbtedit.networking.packet.common.BlockEntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.EntityEditingPacket;
import cx.rain.mc.nbtedit.networking.packet.common.ItemStackEditingPacket;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import net.minecraft.class_7225;

public class NetworkEditingHelper {
    public static void editBlockEntity(class_3222 player, class_2338 pos) {
        player.method_5682().execute(() -> {
            if (!NetworkingHelper.checkReadPermission(player)) {
                return;
            }
            if (!NetworkingHelper.checkPosLoaded(player, pos)) {
                return;
            }
            NBTEdit.getInstance().getLogger().debug("Player {} requested BlockEntity at {} {} {}.", new Object[]{player.method_5477().getString(), pos.method_10263(), pos.method_10264(), pos.method_10260()});
            class_2586 blockEntity = player.method_51469().method_8321(pos);
            if (blockEntity == null) {
                player.method_5671().method_9213((class_2561)class_2561.method_43471((String)"message.nbtedit.target_is_not_block_entity").method_27692(class_124.field_1061));
                return;
            }
            player.method_43496((class_2561)class_2561.method_43469((String)"message.nbtedit.editing.block_entity", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_27692(class_124.field_1060));
            class_2487 tag = blockEntity.method_38242((class_7225.class_7874)player.method_5682().method_30611());
            NBTEditPlatform.getNetworking().sendTo(player, new BlockEntityEditingPacket(tag, NBTEditPlatform.getPermission().isReadOnly(player), pos));
        });
    }

    public static void editEntity(class_3222 player, UUID entityUuid) {
        player.method_5682().execute(() -> {
            if (!NetworkingHelper.checkReadPermission(player)) {
                return;
            }
            class_1297 entity = player.method_51469().method_14190(entityUuid);
            assert (entity != null);
            if (entity instanceof class_1657 && entity != player && !NetworkingHelper.checkEditOnPlayerPermission(player)) {
                NBTEdit.getInstance().getLogger().info("Player {} tried to use nbtedit on a player which is not allowed.", (Object)player.method_5477().getString());
                return;
            }
            NBTEdit.getInstance().getLogger().debug("Player {} is editing entity {}.", (Object)player.method_5477().getString(), player == entity ? "themself" : entity.method_5667());
            player.method_43496((class_2561)class_2561.method_43469((String)"message.nbtedit.editing.entity", (Object[])new Object[]{entityUuid.toString()}).method_27692(class_124.field_1060));
            class_2487 tag = new class_2487();
            if (entity instanceof class_1657) {
                entity.method_5647(tag);
            } else {
                entity.method_5786(tag);
            }
            NBTEditPlatform.getNetworking().sendTo(player, new EntityEditingPacket(tag, NBTEditPlatform.getPermission().isReadOnly(player), entity.method_5667(), entity.method_5628()));
        });
    }

    public static void editItemStack(class_3222 player, class_1799 stack) {
        player.method_5682().execute(() -> {
            if (!NetworkingHelper.checkReadPermission(player)) {
                return;
            }
            if (stack.method_7960()) {
                player.method_43496((class_2561)class_2561.method_43470((String)"message.nbtedit.nothing_to_edit").method_27692(class_124.field_1061));
                return;
            }
            NBTEdit.getInstance().getLogger().debug("Player {} is editing ItemStack named {}.", (Object)player.method_5477().getString(), (Object)stack.method_7954().getString());
            player.method_43496((class_2561)class_2561.method_43469((String)"message.nbtedit.editing.item_stack", (Object[])new Object[]{stack.method_7954().getString()}).method_27692(class_124.field_1060));
            class_2487 tag = (class_2487)stack.method_57375((class_7225.class_7874)player.method_5682().method_30611());
            NBTEditPlatform.getNetworking().sendTo(player, new ItemStackEditingPacket(tag, NBTEditPlatform.getPermission().isReadOnly(player), stack));
        });
    }
}

