/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.editor;

import cx.rain.mc.nbtedit.editor.AccessibilityHelper;
import cx.rain.mc.nbtedit.editor.EditorButton;
import cx.rain.mc.nbtedit.editor.NbtTree;
import cx.rain.mc.nbtedit.gui.component.AbstractComponent;
import cx.rain.mc.nbtedit.gui.editor.NbtTreeView;
import java.time.Duration;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;

public class NbtTreeViewNode
extends AbstractComponent {
    public static final class_2960 WIDGET_TEXTURE = class_2960.method_60655((String)"nbtedit", (String)"textures/gui/widgets.png");
    public static final class_2960 ARROW_RIGHT = class_2960.method_60655((String)"nbtedit", (String)"editor/arrow_right");
    public static final class_2960 ARROW_DOWN = class_2960.method_60655((String)"nbtedit", (String)"editor/arrow_down");
    public static final class_2960 ARROW_RIGHT_HIGHLIGHTED = class_2960.method_60655((String)"nbtedit", (String)"editor/arrow_right_highlighted");
    public static final class_2960 ARROW_DOWN_HIGHLIGHTED = class_2960.method_60655((String)"nbtedit", (String)"editor/arrow_down_highlighted");
    private final NbtTreeView treeView;
    private final NbtTree.Node<?> node;

    public NbtTreeViewNode(int x, int y, NbtTree.Node<?> node, @NotNull NbtTreeView parent) {
        Objects.requireNonNull(class_310.method_1551().field_1772);
        super(x, y, 0, 9, (class_2561)class_2561.method_43473());
        this.treeView = parent;
        this.node = node;
        this.method_25355(AccessibilityHelper.buildText(node));
        this.method_25358(this.getMinecraft().field_1772.method_27525((class_5348)this.method_25369()) + 12);
    }

    @Override
    public void initialize() {
        super.initialize();
        this.method_47400(AccessibilityHelper.buildTooltip((class_1657)this.getMinecraft().field_1724, this.node));
        this.method_47402(Duration.ofMillis(200L));
    }

    @Override
    public NbtTreeView getParent() {
        return this.treeView;
    }

    public NbtTree.Node<?> getNode() {
        return this.node;
    }

    public boolean isMouseInsideText(double mouseX, double mouseY) {
        return mouseX >= (double)this.method_46426() && mouseY >= (double)this.method_46427() && mouseX < (double)(this.method_46426() + this.method_25368()) && mouseY < (double)(this.method_46427() + this.method_25364());
    }

    public boolean isMouseInsideSpoiler(double mouseX, double mouseY) {
        return mouseX >= (double)(this.method_46426() - 9) && mouseY >= (double)this.method_46427() && mouseX < (double)this.method_46426() && mouseY < (double)(this.method_46427() + this.method_25364());
    }

    protected void method_47399(class_6382 narration) {
        narration.method_37034(class_6381.field_33788, AccessibilityHelper.buildNarration(this.node));
    }

    public void method_48579(class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        int color;
        boolean isSelected = this.getParent().getFocusedNode() != null && this.getParent().getFocusedNode() == this.getNode();
        boolean isTextHover = this.isMouseInsideText(mouseX, mouseY);
        boolean isSpoilerHover = this.isMouseInsideSpoiler(mouseX, mouseY);
        int n = isSelected ? -2039584 : (isTextHover ? -96 : (color = this.node.hasParent() ? -2039584 : -6250336));
        if (isSelected) {
            graphics.method_25294(this.method_46426() + 11, this.method_46427(), this.method_46426() + this.method_25368(), this.method_46427() + this.method_25364(), Integer.MIN_VALUE);
        }
        class_2960 arrowSprite = this.node.shouldShowChildren() ? (isSpoilerHover ? ARROW_DOWN_HIGHLIGHTED : ARROW_DOWN) : (isSpoilerHover ? ARROW_RIGHT_HIGHLIGHTED : ARROW_RIGHT);
        if (this.node.hasChild()) {
            graphics.method_52706(arrowSprite, this.method_46426() - 9, this.method_46427(), 9, this.method_25364());
        }
        class_2960 tagSprite = EditorButton.ofTag(this.node.getTag()).getSprite();
        graphics.method_52706(tagSprite, this.method_46426() + 1, this.method_46427(), 9, this.method_25364());
        graphics.method_27535(this.getMinecraft().field_1772, this.method_25369(), this.method_46426() + 11, this.method_46427() + (this.method_25364() - 8) / 2, color);
    }

    protected boolean method_25361(double mouseX, double mouseY) {
        return this.field_22763 && this.field_22764 && this.method_25405(mouseX, mouseY);
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.isMouseInsideText(mouseX, mouseY) || this.isMouseInsideSpoiler(mouseX, mouseY);
    }

    public void method_25348(double mouseX, double mouseY) {
        if (this.isMouseInsideSpoiler(mouseX, mouseY)) {
            this.node.setShowChildren(!this.node.shouldShowChildren());
            this.getParent().update(true);
        }
        if (this.isMouseInsideText(mouseX, mouseY)) {
            this.getParent().method_25395(this);
            this.getParent().update(true);
        }
        super.method_25348(mouseX, mouseY);
    }
}

