/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.gui.component;

import cx.rain.mc.nbtedit.gui.component.AbstractComposedComponent;
import cx.rain.mc.nbtedit.gui.component.IComponent;
import cx.rain.mc.nbtedit.gui.component.ScrollBar;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_6382;

public class ScrollableViewport
extends AbstractComposedComponent {
    private final int scrollBarWidth;
    private ScrollBar verticalScrollBar = null;
    private ScrollBar horizontalScrollBar = null;
    private int contentWidth = 0;
    private int contentHeight = 0;

    public ScrollableViewport(int x, int y, int width, int height, int scrollBarWidth) {
        super(x, y, width, height, (class_2561)class_2561.method_43473());
        this.scrollBarWidth = scrollBarWidth;
    }

    @Override
    public void update() {
        super.update();
        this.createChildren();
    }

    @Override
    protected void createChildren() {
        this.contentWidth = 0;
        this.contentHeight = 0;
        for (IComponent c : this.getChildren()) {
            int cw = c.method_46426() + c.method_25368();
            int ch = c.method_46427() + c.method_25364();
            if (this.contentWidth < cw) {
                this.contentWidth = cw;
            }
            if (this.contentHeight >= ch) continue;
            this.contentHeight = ch;
        }
        if (this.contentHeight > this.method_25364()) {
            int amount = this.verticalScrollBar != null ? this.verticalScrollBar.getScrollAmount() : 0;
            this.verticalScrollBar = new ScrollBar(this.method_46426() + this.method_25368() - this.getScrollBarWidth(), this.method_46427(), this.getScrollBarWidth(), this.method_25364(), d -> {}, this.contentHeight);
            this.verticalScrollBar.setScrollAmount(amount);
        }
        if (this.contentWidth > this.method_25368()) {
            int amount = this.horizontalScrollBar != null ? this.horizontalScrollBar.getScrollAmount() : 0;
            this.horizontalScrollBar = new ScrollBar(this.method_46426(), this.method_46427() + this.method_25364() - this.getScrollBarWidth(), this.method_25368() - (this.shouldShowVerticalBar() ? this.getScrollBarWidth() : 0), this.getScrollBarWidth(), d -> {}, this.contentWidth, true);
            this.horizontalScrollBar.setScrollAmount(amount);
        }
    }

    public boolean shouldShowVerticalBar() {
        return this.contentHeight > this.method_25364() && this.verticalScrollBar != null;
    }

    public boolean shouldShowHorizontalBar() {
        return this.contentWidth > this.method_25368() && this.horizontalScrollBar != null;
    }

    @Override
    protected void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int maskedMouseX = mouseX > this.method_46426() && mouseX < this.method_46426() + this.method_25368() ? mouseX - this.method_46426() : -1;
        int maskedMouseY = mouseY > this.method_46427() && mouseY < this.method_46427() + this.method_25364() ? mouseY - this.method_46427() : -1;
        int maxX = this.method_46426() + this.method_25368() - (this.shouldShowVerticalBar() ? this.getScrollBarWidth() : 0);
        int maxY = this.method_46427() + this.method_25364() - (this.shouldShowHorizontalBar() ? this.getScrollBarWidth() : 0);
        guiGraphics.method_44379(this.method_46426(), this.method_46427(), maxX, maxY);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_22904((double)(this.method_46426() - this.getScrollXOffset()), (double)(this.method_46427() - this.getScrollYOffset()), 0.0);
        super.method_48579(guiGraphics, maskedMouseX, maskedMouseY, partialTick);
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_44380();
        if (this.shouldShowVerticalBar()) {
            this.verticalScrollBar.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
        if (this.shouldShowHorizontalBar()) {
            this.horizontalScrollBar.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        }
    }

    protected void method_47399(class_6382 narrationElementOutput) {
    }

    public int getScrollBarWidth() {
        return this.scrollBarWidth;
    }

    public int getScrollXOffset() {
        return this.shouldShowHorizontalBar() ? this.horizontalScrollBar.getScrollAmount() : 0;
    }

    public void setScrollXOffset(int value) {
        if (this.shouldShowHorizontalBar()) {
            this.horizontalScrollBar.setScrollAmount(value);
        }
    }

    public int getScrollYOffset() {
        return this.shouldShowVerticalBar() ? this.verticalScrollBar.getScrollAmount() : 0;
    }

    public void setScrollYOffset(int value) {
        if (this.shouldShowVerticalBar()) {
            this.verticalScrollBar.setScrollAmount(value);
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.method_25405(mouseX, mouseY)) {
            return this.verticalScrollBar.method_25402(mouseX, mouseY, button);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.method_25405(mouseX, mouseY)) {
            return this.horizontalScrollBar.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX - (double)this.method_46426() + (double)this.getScrollXOffset(), mouseY - (double)this.method_46427() + (double)this.getScrollYOffset(), button);
    }

    @Override
    public boolean method_25406(double mouseX, double mouseY, int button) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.method_25405(mouseX, mouseY)) {
            return this.verticalScrollBar.method_25406(mouseX, mouseY, button);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.method_25405(mouseX, mouseY)) {
            return this.horizontalScrollBar.method_25406(mouseX, mouseY, button);
        }
        return super.method_25406(mouseX - (double)this.method_46426() + (double)this.getScrollXOffset(), mouseY - (double)this.method_46427() + (double)this.getScrollYOffset(), button);
    }

    @Override
    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.isDragging() && dragY != 0.0) {
            return this.verticalScrollBar.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.isDragging() && dragX != 0.0) {
            return this.horizontalScrollBar.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        return super.method_25403(mouseX - (double)this.method_46426() + (double)this.getScrollXOffset(), mouseY - (double)this.method_46427() + (double)this.getScrollYOffset(), button, dragX, dragY);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.shouldShowVerticalBar() && scrollY != 0.0) {
            return this.verticalScrollBar.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        if (this.shouldShowHorizontalBar() && scrollX != 0.0) {
            return this.horizontalScrollBar.method_25401(mouseX, mouseY, scrollX, scrollY);
        }
        return super.method_25401(mouseX - (double)this.method_46426() + (double)this.getScrollXOffset(), mouseY - (double)this.method_46427() + (double)this.getScrollYOffset(), scrollX, scrollY);
    }

    @Override
    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        if (this.shouldShowVerticalBar() && this.verticalScrollBar.method_25367()) {
            return this.verticalScrollBar.method_16803(keyCode, scanCode, modifiers);
        }
        if (this.shouldShowHorizontalBar() && this.horizontalScrollBar.method_25367()) {
            return this.horizontalScrollBar.method_16803(keyCode, scanCode, modifiers);
        }
        return super.method_16803(keyCode, scanCode, modifiers);
    }
}

