/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import cx.rain.mc.nbtedit.editor.NbtTree;
import java.util.Locale;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2489;
import net.minecraft.class_2491;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class NodeParser {
    public static String getString(NbtTree.Node<?> node) {
        Object tag = node.getTag();
        if (tag instanceof class_2481) {
            class_2481 b = (class_2481)tag;
            return Byte.toString(b.method_10698());
        }
        if (tag instanceof class_2516) {
            class_2516 s = (class_2516)tag;
            return Short.toString(s.method_10696());
        }
        if (tag instanceof class_2497) {
            class_2497 i = (class_2497)tag;
            return Integer.toString(i.method_10701());
        }
        if (tag instanceof class_2503) {
            class_2503 l = (class_2503)tag;
            return Long.toString(l.method_10699());
        }
        if (tag instanceof class_2494) {
            class_2494 f = (class_2494)tag;
            return Float.toString(f.method_10700());
        }
        if (tag instanceof class_2489) {
            class_2489 d = (class_2489)tag;
            return Double.toString(d.method_10697());
        }
        if (tag instanceof class_2519) {
            class_2519 s = (class_2519)tag;
            return s.method_10714();
        }
        if (tag instanceof class_2479) {
            class_2479 ba = (class_2479)tag;
            StringBuilder s = new StringBuilder();
            for (byte b : ba.method_10521()) {
                s.append(b).append(", ");
            }
            return s.toString();
        }
        if (tag instanceof class_2495) {
            class_2495 ia = (class_2495)tag;
            StringBuilder s = new StringBuilder();
            for (int i : ia.method_10588()) {
                s.append(i).append(", ");
            }
            return s.toString();
        }
        if (tag instanceof class_2501) {
            class_2501 la = (class_2501)tag;
            StringBuilder s = new StringBuilder();
            for (long l : la.method_10615()) {
                s.append(l).append(", ");
            }
            return s.toString();
        }
        return "";
    }

    public static <T extends class_2520> class_2520 getTag(NbtTree.Node<T> node, String value) {
        T tag = node.getTag();
        try {
            if (tag instanceof class_2481) {
                return class_2481.method_23233((byte)NodeParser.parseByte(value));
            }
            if (tag instanceof class_2516) {
                return class_2516.method_23254((short)NodeParser.parseShort(value));
            }
            if (tag instanceof class_2497) {
                return class_2497.method_23247((int)NodeParser.parseInt(value));
            }
            if (tag instanceof class_2503) {
                return class_2503.method_23251((long)NodeParser.parseLong(value));
            }
            if (tag instanceof class_2494) {
                return class_2494.method_23244((float)NodeParser.parseFloat(value));
            }
            if (tag instanceof class_2489) {
                return class_2489.method_23241((double)NodeParser.parseDouble(value));
            }
            if (tag instanceof class_2479) {
                return new class_2479(NodeParser.parseByteArray(value));
            }
            if (tag instanceof class_2495) {
                return new class_2495(NodeParser.parseIntArray(value));
            }
            if (tag instanceof class_2501) {
                return new class_2501(NodeParser.parseLongArray(value));
            }
            if (tag instanceof class_2519) {
                return class_2519.method_23256((String)value);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return class_2491.field_21033;
    }

    public static byte parseByte(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("b")) {
                c = c.substring(0, c.length() - 1);
            }
            return Byte.parseByte(c);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static short parseShort(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("s")) {
                c = c.substring(0, c.length() - 1);
            }
            return Short.parseShort(c);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static int parseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public static long parseLong(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("l")) {
                c = c.substring(0, c.length() - 1);
            }
            return Long.parseLong(c);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
    }

    public static float parseFloat(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("f")) {
                c = c.substring(0, c.length() - 1);
            }
            return Float.parseFloat(c);
        }
        catch (NumberFormatException e) {
            return 0.0f;
        }
    }

    public static double parseDouble(String s) {
        try {
            String c = s.toLowerCase(Locale.ROOT);
            if (c.endsWith("d")) {
                c = c.substring(0, c.length() - 1);
            }
            return Double.parseDouble(c);
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public static byte[] parseByteArray(String s) {
        try {
            String[] input = s.split(",");
            byte[] arr = new byte[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].toLowerCase(Locale.ROOT).strip();
                if (c.endsWith("b")) {
                    c = c.substring(0, c.length() - 1);
                }
                arr[i] = NodeParser.parseByte(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            return new byte[]{0};
        }
    }

    public static int[] parseIntArray(String s) {
        try {
            String[] input = s.split(",");
            int[] arr = new int[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].strip();
                arr[i] = NodeParser.parseInt(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            return new int[]{0};
        }
    }

    public static long[] parseLongArray(String s) throws NumberFormatException {
        try {
            String[] input = s.split(",");
            long[] arr = new long[input.length];
            for (int i = 0; i < input.length; ++i) {
                String c = input[i].toLowerCase(Locale.ROOT).strip();
                if (c.endsWith("l")) {
                    c = c.substring(0, c.length() - 1);
                }
                arr[i] = NodeParser.parseInt(c);
            }
            return arr;
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Not a valid long array");
        }
    }
}

