/*
 * Decompiled with CFR 0.152.
 */
package cx.rain.mc.nbtedit.editor;

import com.google.common.base.Strings;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2479;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2501;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2522;

public class NbtTree {
    private final Node<class_2487> rootNode;

    private NbtTree(Node<class_2487> root) {
        this.rootNode = root;
    }

    public static NbtTree root(class_2487 tag) {
        return new NbtTree(Node.root(tag));
    }

    public class_2487 toCompound() {
        return this.compoundNodeToTag(this.rootNode);
    }

    public Node<class_2487> getRoot() {
        return this.rootNode;
    }

    private class_2487 compoundNodeToTag(Node<?> node) {
        class_2487 tag = new class_2487();
        for (Node<class_2520> child : node.getChildren()) {
            String name = child.getName();
            class_2520 childTag = child.getTag();
            if (childTag instanceof class_2487) {
                tag.method_10566(name, (class_2520)this.compoundNodeToTag(child));
                continue;
            }
            if (childTag instanceof class_2499) {
                tag.method_10566(name, (class_2520)this.listNodeToTag(child));
                continue;
            }
            tag.method_10566(name, childTag);
        }
        return tag;
    }

    private class_2499 listNodeToTag(Node<?> node) {
        class_2499 tag = new class_2499();
        for (Node<class_2520> child : node.getChildren()) {
            class_2520 childTag = child.getTag();
            if (childTag instanceof class_2487) {
                tag.add((Object)this.compoundNodeToTag(child));
                continue;
            }
            if (childTag instanceof class_2499) {
                tag.add((Object)this.listNodeToTag(child));
                continue;
            }
            tag.add((Object)childTag);
        }
        return tag;
    }

    public static class Node<T extends class_2520> {
        private String name;
        private T nbtTag;
        private Node<? extends class_2520> parent = null;
        private final List<Node<class_2520>> children = new ArrayList<Node<class_2520>>();
        private boolean shouldShowChildren = false;
        public static final String TAG_NAME = "name";
        public static final String TAG_TYPE = "type";
        public static final String TAG_LIST_TYPE = "elementType";
        public static final String TAG_VALUE = "value";

        private Node(T tag) {
            this("", tag);
        }

        private Node(String name, T tag) {
            this(name, tag, null);
        }

        private Node(String name, T tag, Node<?> parentTag) {
            this.name = name;
            this.nbtTag = tag;
            this.parent = parentTag;
            this.walkThough((class_2520)tag);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public T getTag() {
            return this.nbtTag;
        }

        public void setTag(class_2520 tag) {
            this.nbtTag = tag;
        }

        private void walkThough(class_2520 tag) {
            if (tag instanceof class_2487) {
                class_2487 compound = (class_2487)tag;
                for (Map.Entry entry : compound.field_11515.entrySet()) {
                    this.newChild((String)entry.getKey(), (class_2520)entry.getValue());
                }
            }
            if (tag instanceof class_2499) {
                class_2499 list = (class_2499)tag;
                for (class_2520 item : list.field_11550) {
                    this.newChild(item);
                }
            }
        }

        public static <T extends class_2520> Node<T> root(T tag) {
            return new Node<T>(tag);
        }

        protected Node<class_2520> newChild(class_2520 tag) {
            return this.newChild("", tag);
        }

        public Node<class_2520> newChild(String name, class_2520 tag) {
            Node<class_2520> newChild = new Node<class_2520>(name, tag, this);
            this.children.add(newChild);
            return newChild;
        }

        public void addChild(Node<T> node) {
            this.children.add(node);
            node.setParent(this);
        }

        private void setParent(Node<T> parent) {
            this.parent = parent;
        }

        public void removeChild(int index) {
            this.children.remove(index);
        }

        public void removeChild(Node<?> node) {
            this.children.remove(node);
        }

        public boolean hasChild() {
            return !this.children.isEmpty();
        }

        public List<Node<class_2520>> getChildren() {
            return this.children;
        }

        public boolean hasParent() {
            return this.parent != null;
        }

        public boolean isRoot() {
            return !this.hasParent();
        }

        public Node<?> getParent() {
            return this.parent;
        }

        public boolean shouldShowChildren() {
            return this.shouldShowChildren;
        }

        public void setShowChildren(boolean value) {
            this.shouldShowChildren = value;
            if (!value) {
                for (Node<class_2520> c : this.getChildren()) {
                    c.setShowChildren(false);
                }
            }
        }

        public String getAsString() {
            String name = this.getName();
            T tag = this.getTag();
            if (tag instanceof class_2487) {
                return (Strings.isNullOrEmpty((String)name) ? "(CompoundTag)" : name) + ": ";
            }
            if (tag instanceof class_2499) {
                return (Strings.isNullOrEmpty((String)name) ? "(ListTag)" : name) + ": ";
            }
            String s = tag.method_10714();
            return Strings.isNullOrEmpty((String)name) ? s : name + ": " + s;
        }

        public static Node<class_2520> fromString(String data) {
            try {
                class_2487 tag = class_2522.method_10718((String)data);
                String name = tag.method_10558(TAG_NAME);
                byte type = tag.method_10571(TAG_TYPE);
                class_2479 t = switch (type) {
                    case 1 -> class_2481.method_23233((byte)tag.method_10571(TAG_VALUE));
                    case 2 -> class_2516.method_23254((short)tag.method_10568(TAG_VALUE));
                    case 3 -> class_2497.method_23247((int)tag.method_10550(TAG_VALUE));
                    case 4 -> class_2503.method_23251((long)tag.method_10537(TAG_VALUE));
                    case 5 -> class_2494.method_23244((float)tag.method_10583(TAG_VALUE));
                    case 6 -> class_2489.method_23241((double)tag.method_10574(TAG_VALUE));
                    case 7 -> new class_2479(tag.method_10547(TAG_VALUE));
                    case 8 -> class_2519.method_23256((String)tag.method_10558(TAG_VALUE));
                    case 9 -> tag.method_10554(TAG_VALUE, (int)tag.method_10571(TAG_LIST_TYPE));
                    case 10 -> tag.method_10562(TAG_VALUE);
                    case 11 -> new class_2495(tag.method_10561(TAG_VALUE));
                    case 12 -> new class_2501(tag.method_10565(TAG_VALUE));
                    default -> throw new IllegalStateException("Unexpected value: " + type);
                };
                return new Node<class_2479>(name, t);
            }
            catch (CommandSyntaxException | IllegalStateException ignored) {
                return null;
            }
        }

        public String asString() {
            class_2487 tag = new class_2487();
            tag.method_10582(TAG_NAME, this.name);
            tag.method_10566(TAG_VALUE, this.nbtTag);
            tag.method_10567(TAG_TYPE, this.nbtTag.method_10711());
            T t = this.nbtTag;
            if (t instanceof class_2499) {
                class_2499 listTag = (class_2499)t;
                tag.method_10567(TAG_LIST_TYPE, listTag.method_10601());
            }
            return tag.method_10714();
        }
    }
}

