/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl.temperature.effect;

import com.github.thedeathlycow.thermoo.api.temperature.effects.ConfiguredTemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6885;

public class TemperatureEffectManager {
    public static final TemperatureEffectManager INSTANCE = new TemperatureEffectManager();
    private final Map<class_5321<class_1299<?>>, Set<EntityTypeCacheEntry>> entityTypeCache = new IdentityHashMap();
    private final Map<class_2960, ConfiguredTemperatureEffect<?>> registry = new HashMap();

    @Deprecated
    public Collection<ConfiguredTemperatureEffect<?>> getEffectsForEntity(class_1309 entity) {
        return this.getEffectsEntriesForEntity(entity).stream().map(EntityTypeCacheEntry::effect).collect(Collectors.toUnmodifiableSet());
    }

    public Set<EntityTypeCacheEntry> getEffectsEntriesForEntity(class_1309 entity) {
        class_1299 type = entity.method_5864();
        class_6880.class_6883 entityTypeEntry = type.method_40124();
        class_5321 entityTypeKey = entityTypeEntry.method_40237();
        Set effects = this.entityTypeCache.computeIfAbsent(entityTypeKey, ignored -> {
            if (Thermoo.LOGGER.isDebugEnabled()) {
                Thermoo.LOGGER.debug("Computing temperature effects for {}", (Object)entityTypeKey);
            }
            return this.registry.entrySet().stream().filter(entry -> {
                class_6885<class_1299<?>> allowedTypes = ((ConfiguredTemperatureEffect)entry.getValue()).entityTypes();
                return allowedTypes.method_40247() == 0 || type.method_53125(allowedTypes);
            }).map(EntityTypeCacheEntry::new).collect(Collectors.toUnmodifiableSet());
        });
        if (Thermoo.LOGGER.isDebugEnabled()) {
            Object[] effectIds = (class_2960[])effects.stream().map(entry -> entry.id).toArray(class_2960[]::new);
            Thermoo.LOGGER.debug("Available Temperature Effects for {}: {}", (Object)entityTypeKey, (Object)Arrays.toString(effectIds));
        }
        return effects;
    }

    public ConfiguredTemperatureEffect<?> getEffect(class_2960 id) {
        return this.registry.getOrDefault(id, null);
    }

    public Collection<ConfiguredTemperatureEffect<?>> getAllEffects() {
        return this.registry.values();
    }

    void updateRegistry(Map<class_2960, ConfiguredTemperatureEffect<?>> effectsRegistry) {
        this.clearCache();
        this.registry.clear();
        this.registry.putAll(effectsRegistry);
        int numEffects = this.registry.size();
        Thermoo.LOGGER.info("Loaded {} temperature effect{}", (Object)numEffects, (Object)(numEffects == 1 ? "" : "s"));
    }

    private void clearCache() {
        this.entityTypeCache.clear();
        Thermoo.LOGGER.info("Clearing Entity Type to Temperature Effect cache");
    }

    private TemperatureEffectManager() {
    }

    public record EntityTypeCacheEntry(class_2960 id, ConfiguredTemperatureEffect<?> effect) {
        public EntityTypeCacheEntry(Map.Entry<class_2960, ConfiguredTemperatureEffect<?>> mapEntry) {
            this(mapEntry.getKey(), mapEntry.getValue());
        }
    }
}

