/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.impl.temperature.effect;

import com.github.thedeathlycow.thermoo.api.ThermooRegistryKeys;
import com.github.thedeathlycow.thermoo.api.temperature.effects.ConfiguredTemperatureEffect;
import com.github.thedeathlycow.thermoo.impl.Thermoo;
import com.github.thedeathlycow.thermoo.impl.temperature.effect.TemperatureEffectManager;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.fabric.api.resource.conditions.v1.ResourceCondition;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6903;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_7924;

public class TemperatureEffectLoader
implements SimpleSynchronousResourceReloadListener {
    public static final String DIRECTORY = "thermoo/temperature_effect";
    public static final class_2960 ID = Thermoo.id("temperature_effects");
    private final Map<class_2960, ConfiguredTemperatureEffect<?>> globalEffects = new HashMap();
    private final Map<class_5321<class_1299<?>>, Set<ConfiguredTemperatureEffect<?>>> entityTypeToEffect = new IdentityHashMap();
    private final class_6903<JsonElement> ops;

    public TemperatureEffectLoader(class_7225.class_7874 lookup) {
        this.ops = class_6903.method_46632((DynamicOps)JsonOps.INSTANCE, (class_7225.class_7874)lookup);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public void method_14491(class_3300 manager) {
        HashMap updatedRegistry = new HashMap();
        class_7654 resourceFinder = class_7654.method_45114((String)DIRECTORY);
        Map foundResources = resourceFinder.method_45116(manager);
        for (Map.Entry allResources : foundResources.entrySet()) {
            class_2960 effectID = resourceFinder.method_45115((class_2960)allResources.getKey());
            for (class_3298 resource : (List)allResources.getValue()) {
                try {
                    BufferedReader reader = resource.method_43039();
                    try {
                        this.loadEffect(updatedRegistry, effectID, reader);
                    }
                    finally {
                        if (reader == null) continue;
                        reader.close();
                    }
                }
                catch (Exception e) {
                    Thermoo.LOGGER.error("An error occurred while loading temperature effect {}: {}", allResources.getKey(), (Object)e);
                }
            }
        }
        TemperatureEffectManager.INSTANCE.updateRegistry(updatedRegistry);
    }

    private void loadEffect(Map<class_2960, ConfiguredTemperatureEffect<?>> updatedRegistry, class_2960 id, BufferedReader reader) {
        JsonElement json = JsonParser.parseReader((Reader)reader);
        if (json.isJsonObject() && this.objectMatchesConditions(id, json.getAsJsonObject())) {
            ConfiguredTemperatureEffect<?> existingEffect;
            ConfiguredTemperatureEffect effect = (ConfiguredTemperatureEffect)((Pair)ConfiguredTemperatureEffect.CODEC.decode(this.ops, (Object)json).getOrThrow()).getFirst();
            boolean overridden = false;
            if (updatedRegistry.containsKey(id) && (existingEffect = updatedRegistry.get(id)).loadingPriority() > effect.loadingPriority()) {
                overridden = true;
            }
            if (!overridden) {
                updatedRegistry.put(id, effect);
            } else {
                Thermoo.LOGGER.debug("Temperature Effect {} tried to load, but was overridden by a higher priority effect with the same ID.", (Object)id);
            }
        } else {
            Thermoo.LOGGER.debug("Temperature Effect {} not loaded, as its resource conditions were not met.", (Object)id);
        }
    }

    private boolean objectMatchesConditions(class_2960 key, JsonObject json) {
        if (json.has("fabric:load_conditions")) {
            DataResult conditions = ResourceCondition.CONDITION_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("fabric:load_conditions"));
            if (conditions.isSuccess()) {
                boolean matched = ((ResourceCondition)conditions.getOrThrow()).test(null);
                if (Thermoo.LOGGER.isDebugEnabled()) {
                    String verdict = matched ? "Allowed" : "Rejected";
                    Thermoo.LOGGER.debug("{} resource of type {} with id {}", new Object[]{verdict, class_7924.method_60915(ThermooRegistryKeys.TEMPERATURE_EFFECT), key});
                }
                return matched;
            }
            Thermoo.LOGGER.error("Failed to parse resource conditions for file of type {} with id {}, skipping: {}", new Object[]{class_7924.method_60915(ThermooRegistryKeys.TEMPERATURE_EFFECT), key, ((DataResult.Error)conditions.error().get()).message()});
        }
        return true;
    }

    private void partitionRegistry(Map<class_2960, ConfiguredTemperatureEffect<?>> registry, Map<class_2960, ConfiguredTemperatureEffect<?>> globalEffects, Map<class_5321<class_1299<?>>, Set<ConfiguredTemperatureEffect<?>>> typeEffects) {
        registry.forEach((key, value) -> value.entityType().ifPresentOrElse(entityType -> typeEffects.computeIfAbsent(entityType.method_40124().method_40237(), eid -> new HashSet()).add(value), () -> globalEffects.put((class_2960)key, (ConfiguredTemperatureEffect<?>)value)));
    }
}

