/*
 * Decompiled with CFR 0.152.
 */
package com.github.thedeathlycow.thermoo.api.util;

import com.github.thedeathlycow.thermoo.api.util.TemperatureUnit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class TemperatureRecord
implements Comparable<TemperatureRecord> {
    public static final Codec<TemperatureRecord> UNIT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("value").forGetter(TemperatureRecord::value), (App)TemperatureUnit.CODEC.fieldOf("unit").forGetter(TemperatureRecord::unit)).apply((Applicative)instance, TemperatureRecord::new));
    public static final Codec<TemperatureRecord> CODEC = Codec.either((Codec)Codec.DOUBLE, UNIT_CODEC).xmap(either -> (TemperatureRecord)either.map(TemperatureRecord::new, temperatureRecord -> temperatureRecord), Either::right);
    private final double value;
    private final TemperatureUnit unit;

    public TemperatureRecord(double value, TemperatureUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public TemperatureRecord(double value) {
        this(value, TemperatureUnit.CELSIUS);
    }

    public double value() {
        return this.value;
    }

    public TemperatureUnit unit() {
        return this.unit;
    }

    public TemperatureRecord sum(TemperatureRecord other) {
        double shift = other.valueInUnit(this.unit());
        return new TemperatureRecord(this.value() + shift, this.unit());
    }

    @Contract(value="_->new")
    public TemperatureRecord add(TemperatureRecord other) {
        double shift = this.unit().getAbsoluteUnit().convertTemperature(other.value(), other.unit().getAbsoluteUnit());
        return new TemperatureRecord(this.value() + shift, this.unit());
    }

    public double valueInUnit(TemperatureUnit unit) {
        return unit.convertTemperature(this);
    }

    public TemperatureRecord convertToUnit(TemperatureUnit unit) {
        if (this.unit == unit) {
            return this;
        }
        return new TemperatureRecord(this.valueInUnit(unit), unit);
    }

    public boolean equals(TemperatureRecord other, double tolerance) {
        double otherValue = other.valueInUnit(this.unit);
        return Math.abs(this.value - otherValue) <= tolerance;
    }

    public boolean equals(Object o) {
        double otherCelsius;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemperatureRecord that = (TemperatureRecord)o;
        double thisCelsius = this.unit.toCelsius(this.value);
        return Double.compare(thisCelsius, otherCelsius = that.unit.toCelsius(that.value)) == 0;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.unit.toCelsius(this.value), TemperatureUnit.CELSIUS});
    }

    public String toString() {
        return "TemperatureRecord{value=" + this.value + ", unit=" + String.valueOf((Object)this.unit) + "}";
    }

    public boolean strictEquals(TemperatureRecord other, double tolerance) {
        return other.unit == this.unit && Math.abs(this.value - other.value) <= tolerance;
    }

    public boolean strictEquals(TemperatureRecord other) {
        return other.unit == this.unit && Double.compare(other.value, this.value) == 0;
    }

    @Override
    public int compareTo(@NotNull TemperatureRecord other) {
        double otherValue = other.valueInUnit(this.unit());
        return Double.compare(this.value, otherValue);
    }
}

