/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.utils.Env;
import dev.architectury.utils.EnvExecutor;
import dev.ftb.mods.ftbteams.FTBTeamsAPIImpl;
import dev.ftb.mods.ftbteams.api.FTBTeamsAPI;
import dev.ftb.mods.ftbteams.api.event.TeamCollectPropertiesEvent;
import dev.ftb.mods.ftbteams.api.event.TeamEvent;
import dev.ftb.mods.ftbteams.api.event.TeamManagerEvent;
import dev.ftb.mods.ftbteams.api.property.TeamProperties;
import dev.ftb.mods.ftbteams.client.FTBTeamsClient;
import dev.ftb.mods.ftbteams.data.FTBTeamsCommands;
import dev.ftb.mods.ftbteams.data.TeamManagerImpl;
import dev.ftb.mods.ftbteams.net.FTBTeamsNet;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FTBTeams {
    public static final Logger LOGGER = LogManager.getLogger((String)"FTB Teams");

    public FTBTeams() {
        FTBTeamsAPI._init(FTBTeamsAPIImpl.INSTANCE);
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverAboutToStart);
        CommandRegistrationEvent.EVENT.register(this::registerCommands);
        LifecycleEvent.SERVER_STOPPED.register(this::serverStopped);
        LifecycleEvent.SERVER_LEVEL_SAVE.register(this::worldSaved);
        TeamEvent.COLLECT_PROPERTIES.register(this::teamConfig);
        PlayerEvent.PLAYER_JOIN.register(this::playerLoggedIn);
        PlayerEvent.PLAYER_QUIT.register(this::playerLoggedOut);
        EnvExecutor.runInEnv((Env)Env.CLIENT, () -> FTBTeamsClient::init);
        FTBTeamsNet.register();
    }

    private void serverAboutToStart(MinecraftServer server) {
        TeamManagerImpl.INSTANCE = new TeamManagerImpl(server);
        ((Consumer)TeamManagerEvent.CREATED.invoker()).accept(new TeamManagerEvent(TeamManagerImpl.INSTANCE));
        TeamManagerImpl.INSTANCE.load();
    }

    private void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext, class_2170.class_5364 selection) {
        new FTBTeamsCommands().register(dispatcher);
    }

    private void serverStopped(MinecraftServer server) {
        ((Consumer)TeamManagerEvent.DESTROYED.invoker()).accept(new TeamManagerEvent(TeamManagerImpl.INSTANCE));
        TeamManagerImpl.INSTANCE = null;
    }

    private void worldSaved(class_3218 level) {
        if (TeamManagerImpl.INSTANCE != null) {
            TeamManagerImpl.INSTANCE.saveNow();
        }
    }

    private void teamConfig(TeamCollectPropertiesEvent event) {
        event.add(TeamProperties.DISPLAY_NAME);
        event.add(TeamProperties.DESCRIPTION);
        event.add(TeamProperties.COLOR);
        event.add(TeamProperties.FREE_TO_JOIN);
        event.add(TeamProperties.MAX_MSG_HISTORY_SIZE);
    }

    private void playerLoggedIn(class_3222 player) {
        if (TeamManagerImpl.INSTANCE != null) {
            TeamManagerImpl.INSTANCE.playerLoggedIn(player, player.method_5667(), player.method_5820());
        }
    }

    private void playerLoggedOut(class_3222 player) {
        if (TeamManagerImpl.INSTANCE != null) {
            TeamManagerImpl.INSTANCE.playerLoggedOut(player);
        }
    }
}

