/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.dungeonz.DungeonzMain;
import net.dungeonz.access.ServerPlayerAccess;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.dungeon.DungeonPlacementHandler;
import net.dungeonz.init.DimensionInit;
import net.dungeonz.network.DungeonServerPacket;
import net.dungeonz.util.InventoryHelper;
import net.levelz.access.LevelManagerAccess;
import net.levelz.level.LevelManager;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5454;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8567;
import net.minecraft.server.MinecraftServer;
import net.partyaddon.access.GroupManagerAccess;
import net.partyaddon.group.GroupManager;
import org.jetbrains.annotations.Nullable;

public class DungeonHelper {
    @Nullable
    public static Dungeon getCurrentDungeon(class_3222 playerEntity) {
        if (playerEntity != null && playerEntity.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD && ((ServerPlayerAccess)playerEntity).getOldServerWorld() != null) {
            class_2586 blockEntity = ((ServerPlayerAccess)playerEntity).getOldServerWorld().method_8321(((ServerPlayerAccess)playerEntity).getDungeonPortalBlockPos());
            if (blockEntity == null) {
                return null;
            }
            if (blockEntity instanceof DungeonPortalEntity) {
                DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)blockEntity;
                return dungeonPortalEntity.getDungeon();
            }
        }
        return null;
    }

    @Nullable
    public static DungeonPortalEntity getDungeonPortalEntity(class_3222 playerEntity) {
        if (((ServerPlayerAccess)playerEntity).getOldServerWorld() != null) {
            class_2586 blockEntity = ((ServerPlayerAccess)playerEntity).getOldServerWorld().method_8321(((ServerPlayerAccess)playerEntity).getDungeonPortalBlockPos());
            if (blockEntity == null) {
                return null;
            }
            if (blockEntity instanceof DungeonPortalEntity) {
                DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)blockEntity;
                return dungeonPortalEntity;
            }
        }
        return null;
    }

    public static Map<String, List<class_1799>> getRequiredItemStackList(Dungeon dungeon) {
        HashMap<String, List<class_1799>> requiredItemStackList = new HashMap<String, List<class_1799>>();
        for (Map.Entry<String, HashMap<Integer, Integer>> entry : dungeon.getDifficultyRequiredItemCountMap().entrySet()) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (Map.Entry<Integer, Integer> itemIdEntry : entry.getValue().entrySet()) {
                stacks.add(new class_1799((class_1935)class_7923.field_41178.method_10200(itemIdEntry.getKey().intValue()), itemIdEntry.getValue().intValue()));
            }
            requiredItemStackList.put(entry.getKey(), stacks);
        }
        return requiredItemStackList;
    }

    public static Map<String, List<class_1799>> getPossibleLootItemStackMap(Dungeon dungeon, MinecraftServer server) {
        HashMap<String, List<class_1799>> possibleLootItemStackMap = new HashMap<String, List<class_1799>>();
        for (Map.Entry<String, String> entry : dungeon.getDifficultyBossLootTableMap().entrySet()) {
            class_52 lootTable = server.method_58576().method_58295(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60654((String)entry.getValue())));
            class_8567.class_8568 builder = new class_8567.class_8568(server.method_30002()).method_51874(class_181.field_24424, (Object)((class_3222)server.method_30002().method_18456().get(server.method_30002().method_8409().method_43048(server.method_30002().method_18456().size()))).method_19538());
            class_1277 inventory = new class_1277(27);
            lootTable.method_329((class_1263)inventory, builder.method_51875(class_173.field_1179), server.method_30002().method_8409().method_43055());
            ArrayList<class_1799> itemStacks = new ArrayList<class_1799>();
            for (int i = 0; i < inventory.method_5439(); ++i) {
                if (inventory.method_5438(i).method_7960()) continue;
                if (inventory.method_5438(i).method_7986()) {
                    inventory.method_5438(i).method_7974(0);
                }
                boolean contains = false;
                for (class_1799 itemStack : itemStacks) {
                    if (!class_1799.method_7984((class_1799)itemStack, (class_1799)inventory.method_5438(i))) continue;
                    itemStack.method_7933(inventory.method_5438(i).method_7947());
                    contains = true;
                    break;
                }
                if (contains) continue;
                itemStacks.add(inventory.method_5438(i));
            }
            possibleLootItemStackMap.put(entry.getKey(), itemStacks);
        }
        return possibleLootItemStackMap;
    }

    public static void teleportDungeon(class_3222 player, class_2338 dungeonPortalPos, @Nullable UUID requiredMinGroupUuid) {
        class_2586 class_25862;
        if (player.method_37908().method_8321(dungeonPortalPos) != null && (class_25862 = player.method_37908().method_8321(dungeonPortalPos)) instanceof DungeonPortalEntity) {
            DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)class_25862;
            if (player.method_37908().method_27983() == DimensionInit.DUNGEON_WORLD) {
                class_3218 oldWorld = ((ServerPlayerAccess)player).getOldServerWorld();
                if (oldWorld != null) {
                    player.method_5731(DungeonPlacementHandler.leave(player, oldWorld));
                    return;
                }
            } else {
                class_3218 dungeonWorld = player.method_37908().method_8503().method_3847(DimensionInit.DUNGEON_WORLD);
                if (dungeonWorld == null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)"Failed to find world, was it registered?"), false);
                    return;
                }
                if (dungeonPortalEntity.getDungeon() != null) {
                    if (dungeonPortalEntity.getDungeonPlayerCount() + dungeonPortalEntity.getDeadDungeonPlayerUUIDs().size() < dungeonPortalEntity.getMaxGroupSize()) {
                        LevelManager levelManager;
                        if (dungeonPortalEntity.isOnCooldown((int)dungeonWorld.method_8510())) {
                            player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_cooldown"), false);
                            return;
                        }
                        if (dungeonPortalEntity.getDungeonPlayerCount() > 0 && dungeonPortalEntity.getPrivateGroup()) {
                            if (DungeonzMain.isPartyAddonLoaded) {
                                GroupManager groupManager = ((GroupManagerAccess)player).getGroupManager();
                                if (groupManager.getGroupPlayerIdList().isEmpty() || !groupManager.getGroupPlayerIdList().contains(dungeonPortalEntity.getDungeonPlayerUuids().get(0))) {
                                    player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_private"), false);
                                    return;
                                }
                            } else {
                                player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_private"), false);
                                return;
                            }
                        }
                        if (!player.method_7337() && DungeonHelper.getRequiredItemStackList(dungeonPortalEntity.getDungeon()).containsKey(dungeonPortalEntity.getDifficulty())) {
                            if (InventoryHelper.hasRequiredItemStacks(player.method_31548(), DungeonHelper.getRequiredItemStackList(dungeonPortalEntity.getDungeon()).get(dungeonPortalEntity.getDifficulty()))) {
                                InventoryHelper.decrementRequiredItemStacks(player.method_31548(), DungeonHelper.getRequiredItemStackList(dungeonPortalEntity.getDungeon()).get(dungeonPortalEntity.getDifficulty()));
                            } else {
                                player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.missing"), false);
                                return;
                            }
                        }
                        if (!dungeonPortalEntity.getWaitingUuids().isEmpty() && dungeonPortalEntity.getWaitingUuids().contains(player.method_5667())) {
                            player.method_7346();
                            return;
                        }
                        if (DungeonzMain.isLevelZLoaded && (levelManager = ((LevelManagerAccess)player).getLevelManager()).getOverallLevel() < dungeonPortalEntity.getRequiredLevel()) {
                            player.method_7353((class_2561)class_2561.method_43469((String)"text.dungeonz.required_level", (Object[])new Object[]{dungeonPortalEntity.getRequiredLevel()}), false);
                            return;
                        }
                        if (dungeonPortalEntity.getDungeonPlayerCount() <= 0 && requiredMinGroupUuid != null && dungeonPortalEntity.getMinGroupSize() > 1) {
                            dungeonPortalEntity.addWaitingUuid(requiredMinGroupUuid);
                            if (dungeonPortalEntity.getMinGroupSize() > dungeonPortalEntity.getWaitingUuids().size()) {
                                player.method_7353((class_2561)class_2561.method_43469((String)"text.dungeonz.dungeon_min_group_size", (Object[])new Object[]{dungeonPortalEntity.getMinGroupSize() - dungeonPortalEntity.getWaitingUuids().size()}), false);
                                return;
                            }
                            if (dungeonPortalEntity.getdungeonTeleportCountdown() <= 0) {
                                dungeonPortalEntity.startDungeonTeleportCountdown(dungeonWorld);
                                player.method_7346();
                            }
                        } else if (dungeonPortalEntity.getDungeonPlayerCount() <= 0 && dungeonPortalEntity.getdungeonTeleportCountdown() <= 0) {
                            dungeonPortalEntity.addWaitingUuid(requiredMinGroupUuid);
                            dungeonPortalEntity.startDungeonTeleportCountdown(dungeonWorld);
                            player.method_7346();
                        } else if (dungeonPortalEntity.getdungeonTeleportCountdown() > 0) {
                            dungeonPortalEntity.addWaitingUuid(requiredMinGroupUuid);
                            player.method_7346();
                        } else if (!dungeonPortalEntity.getDeadDungeonPlayerUUIDs().contains(player.method_5667()) || dungeonPortalEntity.getDungeon().isRespawnAllowed()) {
                            DungeonHelper.teleportPlayer(player, dungeonWorld, dungeonPortalEntity, dungeonPortalPos);
                        } else {
                            player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dead_player"), false);
                            player.method_7346();
                        }
                    } else {
                        player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_full"), false);
                    }
                } else {
                    player.method_7353((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_missing"), false);
                }
            }
        }
    }

    public static void teleportPlayer(class_3222 serverPlayerEntity, class_3218 dungeonWorld, DungeonPortalEntity dungeonPortalEntity, class_2338 dungeonPortalPos) {
        class_3222 playerEntity = (class_3222)serverPlayerEntity.method_5731(DungeonPlacementHandler.enter(serverPlayerEntity, dungeonWorld, serverPlayerEntity.method_51469(), dungeonPortalEntity, dungeonPortalPos, dungeonPortalEntity.getDifficulty(), dungeonPortalEntity.getDisableEffects()));
        DungeonServerPacket.writeS2CDungeonInfoPacket(playerEntity, dungeonPortalEntity.getDungeon().getBreakableBlockIdList(), dungeonPortalEntity.getDungeon().getplaceableBlockIdList(), dungeonPortalEntity.getDungeon().isElytraAllowed());
    }

    public static void teleportOutOfDungeon(class_3222 player) {
        class_3218 oldWorld = ((ServerPlayerAccess)player).getOldServerWorld();
        if (oldWorld != null) {
            player.method_5731(DungeonPlacementHandler.leave(player, oldWorld));
        } else {
            class_243 spawnPos = null;
            if (player.method_26280() != null) {
                spawnPos = new class_243((double)player.method_26280().method_10263(), (double)player.method_26280().method_10264(), (double)player.method_26280().method_10260());
            } else {
                player.method_5731(player.method_60590(true, class_5454.field_52245));
            }
            player.method_5731(new class_5454(player.field_13995.method_3847(player.method_26281()), spawnPos, new class_243(0.0, 0.0, 0.0), 0.0f, 0.0f, class_5454.field_52245));
        }
    }
}

