/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.network;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.dungeonz.access.ClientPlayerAccess;
import net.dungeonz.access.InGameHudAccess;
import net.dungeonz.block.entity.DungeonGateEntity;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.block.screen.DungeonGateOpScreen;
import net.dungeonz.block.screen.DungeonPortalOpScreen;
import net.dungeonz.block.screen.DungeonPortalScreen;
import net.dungeonz.block.screen.DungeonPortalScreenHandler;
import net.dungeonz.init.SoundInit;
import net.dungeonz.item.screen.DungeonCompassScreen;
import net.dungeonz.network.packet.DungeonCompassPacket;
import net.dungeonz.network.packet.DungeonCompassScreenPacket;
import net.dungeonz.network.packet.DungeonDifficultyPacket;
import net.dungeonz.network.packet.DungeonEffectPacket;
import net.dungeonz.network.packet.DungeonGatePacket;
import net.dungeonz.network.packet.DungeonInfoPacket;
import net.dungeonz.network.packet.DungeonOpScreenPacket;
import net.dungeonz.network.packet.DungeonSyncGatePacket;
import net.dungeonz.network.packet.DungeonSyncScreenPacket;
import net.dungeonz.network.packet.DungeonTeleportCountdownPacket;
import net.dungeonz.network.packet.DungeonTeleportPacket;
import net.dungeonz.network.packet.DungeonTypePacket;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1703;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class DungeonClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(DungeonInfoPacket.PACKET_ID, (payload, context) -> {
            List<Integer> breakableBlockIdList = payload.breakableBlockIdList();
            List<Integer> placeableBlockIdList = payload.placeableBlockIdList();
            boolean allowElytra = payload.allowElytra();
            context.client().execute(() -> ((ClientPlayerAccess)context.player()).setClientDungeonInfo(breakableBlockIdList, placeableBlockIdList, allowElytra));
        });
        ClientPlayNetworking.registerGlobalReceiver(DungeonSyncScreenPacket.PACKET_ID, (payload, context) -> {
            class_2338 dungeonPortalPos = payload.blockPos();
            String difficulty = payload.difficulty();
            context.client().execute(() -> {
                class_2586 patt0$temp;
                if (context.client().field_1687.method_8321(dungeonPortalPos) != null && (patt0$temp = context.client().field_1687.method_8321(dungeonPortalPos)) instanceof DungeonPortalEntity) {
                    class_1703 patt2$temp;
                    DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)patt0$temp;
                    dungeonPortalEntity.setDifficulty(difficulty);
                    class_437 patt1$temp = context.client().field_1755;
                    if (patt1$temp instanceof DungeonPortalScreen) {
                        DungeonPortalScreen dungeonPortalScreen = (DungeonPortalScreen)patt1$temp;
                        dungeonPortalScreen.difficultyButton.setText((class_2561)class_2561.method_43471((String)("dungeonz.difficulty." + difficulty)));
                    }
                    if ((patt2$temp = context.client().field_1724.field_7512) instanceof DungeonPortalScreenHandler) {
                        DungeonPortalScreenHandler dungeonPortalScreenHandler = (DungeonPortalScreenHandler)patt2$temp;
                        dungeonPortalScreenHandler.getDungeonPortalEntity().setDifficulty(difficulty);
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(DungeonOpScreenPacket.PACKET_ID, (payload, context) -> {
            class_2338 portalOrGatePos = payload.blockPos();
            String dungeonTypeOrBlockId = payload.blockIdOrDungeonType();
            String difficultyOrParticleId = payload.particleEffectOrDifficulty();
            String unlockItemId = payload.unlockItem();
            context.client().execute(() -> {
                if (context.client().field_1687.method_8321(portalOrGatePos) != null) {
                    class_2586 patt0$temp = context.client().field_1687.method_8321(portalOrGatePos);
                    if (patt0$temp instanceof DungeonPortalEntity) {
                        DungeonPortalEntity dungeonPortalEntity = (DungeonPortalEntity)patt0$temp;
                        dungeonPortalEntity.setDungeonType(dungeonTypeOrBlockId);
                        dungeonPortalEntity.setDifficulty(difficultyOrParticleId);
                        context.client().method_1507((class_437)new DungeonPortalOpScreen(portalOrGatePos));
                    } else {
                        class_2586 patt1$temp = context.client().field_1687.method_8321(portalOrGatePos);
                        if (patt1$temp instanceof DungeonGateEntity) {
                            DungeonGateEntity dungeonGateEntity = (DungeonGateEntity)patt1$temp;
                            dungeonGateEntity.setBlockId(class_2960.method_60654((String)dungeonTypeOrBlockId));
                            dungeonGateEntity.setParticleEffectId(difficultyOrParticleId);
                            dungeonGateEntity.setUnlockItemId(unlockItemId);
                            context.client().method_1507((class_437)new DungeonGateOpScreen(portalOrGatePos));
                        }
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(DungeonCompassScreenPacket.PACKET_ID, (payload, context) -> {
            String dungeonType = payload.dungeonType();
            List<String> dungeonIds = payload.dungeonIdList();
            context.client().execute(() -> context.client().method_1507((class_437)new DungeonCompassScreen(dungeonType, dungeonIds)));
        });
        ClientPlayNetworking.registerGlobalReceiver(DungeonSyncGatePacket.PACKET_ID, (payload, context) -> {
            Set<class_2338> dungeonGatesPosList = payload.dungeonGatesPosList();
            String blockId = payload.blockId();
            String particleId = payload.particleEffect();
            String unlockItemId = payload.unlockItem();
            context.client().execute(() -> {
                for (class_2338 pos : dungeonGatesPosList) {
                    class_2586 patt0$temp;
                    if (context.client().field_1687.method_8321(pos) == null || !((patt0$temp = context.client().field_1687.method_8321(pos)) instanceof DungeonGateEntity)) continue;
                    DungeonGateEntity dungeonGateEntity = (DungeonGateEntity)patt0$temp;
                    dungeonGateEntity.setBlockId(class_2960.method_60654((String)blockId));
                    dungeonGateEntity.setParticleEffectId(particleId);
                    dungeonGateEntity.setUnlockItemId(unlockItemId);
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(DungeonTeleportCountdownPacket.PACKET_ID, (payload, context) -> {
            int dungeonTeleportCountdown = payload.countdownTicks();
            context.client().execute(() -> {
                ((InGameHudAccess)context.client().field_1705).setDungeonCountdownTicks(dungeonTeleportCountdown);
                context.player().method_5783(SoundInit.DUNGEON_COUNTDOWN_EVENT, 1.0f, 1.0f);
            });
        });
    }

    public static void writeC2SChangeDifficultyPacket(class_310 client, class_2338 portalBlockPos) {
        ClientPlayNetworking.send((class_8710)new DungeonDifficultyPacket(portalBlockPos));
    }

    public static void writeC2SChangeEffectsPacket(class_310 client, class_2338 portalBlockPos, boolean disableEffects) {
        ClientPlayNetworking.send((class_8710)new DungeonEffectPacket(portalBlockPos, disableEffects));
    }

    public static void writeC2SChangePrivateGroupPacket(class_310 client, class_2338 portalBlockPos, boolean privateGroup) {
        ClientPlayNetworking.send((class_8710)new DungeonEffectPacket(portalBlockPos, privateGroup));
    }

    public static void writeC2SDungeonTeleportPacket(class_310 client, class_2338 portalBlockPos, @Nullable UUID requiredMinGroupUuid) {
        ClientPlayNetworking.send((class_8710)new DungeonTeleportPacket(portalBlockPos, requiredMinGroupUuid != null, requiredMinGroupUuid));
    }

    public static void writeC2SSetDungeonTypePacket(class_310 client, String dungeonType, String defaultDifficulty, class_2338 portalBlockPos) {
        ClientPlayNetworking.send((class_8710)new DungeonTypePacket(portalBlockPos, dungeonType, defaultDifficulty));
    }

    public static void writeC2SSetGateBlockPacket(class_310 client, String blockId, String particleId, String unlockItemId, class_2338 portalBlockPos) {
        ClientPlayNetworking.send((class_8710)new DungeonGatePacket(portalBlockPos, blockId, particleId, unlockItemId));
    }

    public static void writeC2SSetDungeonCompassPacket(class_310 client, String dungeonType) {
        ClientPlayNetworking.send((class_8710)new DungeonCompassPacket(dungeonType));
    }
}

