/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.dungeon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.dungeonz.DungeonzMain;
import net.dungeonz.access.BossEntityAccess;
import net.dungeonz.access.ServerPlayerAccess;
import net.dungeonz.block.DungeonGateBlock;
import net.dungeonz.block.entity.DungeonGateEntity;
import net.dungeonz.block.entity.DungeonPortalEntity;
import net.dungeonz.block.entity.DungeonSpawnerEntity;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.init.BlockInit;
import net.dungeonz.init.TagInit;
import net.dungeonz.util.InventoryHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1676;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3230;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3730;
import net.minecraft.class_3778;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_4076;
import net.minecraft.class_5134;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5434;
import net.minecraft.class_5454;
import net.minecraft.class_5539;
import net.minecraft.class_5688;
import net.minecraft.class_5819;
import net.minecraft.class_6626;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8891;
import net.minecraft.class_9778;
import net.minecraft.class_9822;
import net.minecraft.server.MinecraftServer;
import net.rpgdifficulty.api.MobStrengthener;
import org.jetbrains.annotations.Nullable;

public class DungeonPlacementHandler {
    public static class_5454 enter(class_3222 serverPlayerEntity, class_3218 dungeonWorld, class_3218 oldWorld, DungeonPortalEntity portalEntity, class_2338 portalPos, String difficulty, boolean disableEffects) {
        class_2338.class_2339 playerBlockPos = serverPlayerEntity.method_24515().method_25503();
        if (oldWorld.method_8320((class_2338)playerBlockPos).method_27852(BlockInit.DUNGEON_PORTAL) || oldWorld.method_8320(playerBlockPos.method_10074()).method_27852(BlockInit.DUNGEON_PORTAL)) {
            if (oldWorld.method_8320((class_2338)playerBlockPos).method_27852(BlockInit.DUNGEON_PORTAL)) {
                playerBlockPos = playerBlockPos.method_10084();
            }
            for (int i = 0; i < 4; ++i) {
                if (oldWorld.method_8320(playerBlockPos.method_10079(class_2350.method_10139((int)i), 1).method_10086(0)).method_26215() && oldWorld.method_8320(playerBlockPos.method_10079(class_2350.method_10139((int)i), 1).method_10086(1)).method_26215()) {
                    playerBlockPos = playerBlockPos.method_10079(class_2350.method_10139((int)i), 1);
                    break;
                }
                if (i != 3) continue;
                class_243 vec3d = serverPlayerEntity.method_60590(true, class_5454.field_52245).comp_2821();
                playerBlockPos = class_2338.method_49637((double)vec3d.method_10216(), (double)vec3d.method_10214(), (double)vec3d.method_10215());
            }
        }
        ((ServerPlayerAccess)serverPlayerEntity).setDungeonInfo(oldWorld, portalPos, (class_2338)playerBlockPos);
        if (disableEffects) {
            serverPlayerEntity.method_6012();
        }
        portalEntity.joinDungeon(serverPlayerEntity.method_5667());
        return new class_5454(dungeonWorld, class_243.method_24954((class_2382)new class_2338(0, 0, 0).method_10069(portalPos.method_10263() * 16, 100, portalPos.method_10260() * 16)).method_1031(0.5, 0.0, 0.5), class_243.field_1353, 0.0f, 0.0f, class_5454.field_52245);
    }

    public static class_5454 leave(class_3222 serverPlayerEntity, class_3218 serverWorld) {
        if (serverWorld.method_8321(((ServerPlayerAccess)serverPlayerEntity).getDungeonPortalBlockPos()) != null) {
            ((DungeonPortalEntity)serverWorld.method_8321(((ServerPlayerAccess)serverPlayerEntity).getDungeonPortalBlockPos())).leaveDungeon(serverPlayerEntity.method_5667());
        }
        return new class_5454(serverWorld, class_243.method_24954((class_2382)((ServerPlayerAccess)serverPlayerEntity).getDungeonSpawnBlockPos()).method_1031(0.5, 0.0, 0.5), class_243.field_1353, serverWorld.field_9229.method_43057() * 360.0f, 0.0f, class_5454.field_52245);
    }

    public static void generateDungeonStructure(class_3218 world, class_2338 pos, DungeonPortalEntity portalEntity) {
        class_2378 registry = world.method_30349().method_30530(class_7924.field_41249);
        class_6880.class_6883 registryEntry = registry.method_40290(class_5321.method_29179((class_5321)class_7924.field_41249, (class_2960)portalEntity.getDungeon().getStructurePoolId()));
        DungeonPlacementHandler.generate(world, portalEntity, portalEntity.getDungeon(), (class_6880<class_3785>)registryEntry, class_2960.method_60654((String)"dungeonz:spawn"), 64, pos, false);
    }

    private static boolean generate(class_3218 world, DungeonPortalEntity portalEntity, Dungeon dungeon, class_6880<class_3785> structurePool, class_2960 id, int size, class_2338 pos, boolean keepJigsaws) {
        class_2794 chunkGenerator = world.method_14178().method_12129();
        class_3485 structureTemplateManager = world.method_14183();
        class_5138 structureAccessor = world.method_27056();
        class_5819 random = world.method_8409();
        class_3195.class_7149 context = new class_3195.class_7149(world.method_30349(), chunkGenerator, chunkGenerator.method_12098(), world.method_14178().method_41248(), structureTemplateManager, world.method_8412(), new class_1923(pos), (class_5539)world, registryEntry -> true);
        Optional optional = class_3778.method_30419((class_3195.class_7149)context, structurePool, Optional.of(id), (int)size, (class_2338)pos, (boolean)false, Optional.empty(), (int)512, (class_8891)class_8891.field_46826, (class_9778)class_5434.field_51911, (class_9822)class_5434.field_52235);
        if (optional.isPresent()) {
            HashMap<Integer, ArrayList<class_2338>> blockIdPosMap = new HashMap<Integer, ArrayList<class_2338>>();
            ArrayList<class_2338> chestPosList = new ArrayList<class_2338>();
            ArrayList<class_2338> exitPosList = new ArrayList<class_2338>();
            ArrayList<class_2338> gatePosList = new ArrayList<class_2338>();
            HashMap<class_2338, Integer> movingBlockMap = new HashMap<class_2338, Integer>();
            HashMap<class_2338, DungeonPortalEntity.Powered> poweredBlockMap = new HashMap<class_2338, DungeonPortalEntity.Powered>();
            HashMap<class_2338, Integer> spawnerPosEntityIdMap = new HashMap<class_2338, Integer>();
            class_2248 exitBlock = (class_2248)class_7923.field_41175.method_10200(dungeon.getExitBlockId());
            class_2248 bossLootBlock = (class_2248)class_7923.field_41175.method_10200(dungeon.getBossLootBlockId());
            class_6626 structurePiecesCollector = ((class_3195.class_7150)optional.get()).method_44019();
            for (class_3443 structurePiece : structurePiecesCollector.method_38714().comp_132()) {
                if (!(structurePiece instanceof class_3790)) continue;
                class_3790 poolStructurePiece = (class_3790)structurePiece;
                poolStructurePiece.method_27236((class_5281)world, structureAccessor, chunkGenerator, random, class_3341.method_14665(), pos, keepJigsaws);
                portalEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35415(), poolStructurePiece.method_14935().method_35416(), poolStructurePiece.method_14935().method_35417());
                portalEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35418(), poolStructurePiece.method_14935().method_35419(), poolStructurePiece.method_14935().method_35420());
                for (int i = poolStructurePiece.method_14935().method_35415(); i <= poolStructurePiece.method_14935().method_35418(); ++i) {
                    for (int u = poolStructurePiece.method_14935().method_35416(); u <= poolStructurePiece.method_14935().method_35419(); ++u) {
                        for (int o = poolStructurePiece.method_14935().method_35417(); o <= poolStructurePiece.method_14935().method_35420(); ++o) {
                            class_2338 checkPos = new class_2338(i, u, o);
                            class_2680 state = world.method_8320(checkPos);
                            if (state.method_26215()) continue;
                            int blockId = class_7923.field_41175.method_10206((Object)state.method_26204());
                            if (dungeon.containsBlockId(blockId)) {
                                if (!blockIdPosMap.containsKey(blockId)) {
                                    ArrayList<class_2338> newList = new ArrayList<class_2338>();
                                    newList.add(checkPos);
                                    blockIdPosMap.put(blockId, newList);
                                    continue;
                                }
                                blockIdPosMap.get(blockId).add(checkPos);
                                continue;
                            }
                            if (dungeon.getBossBlockId() == blockId) {
                                portalEntity.setBossBlockPos(checkPos);
                                continue;
                            }
                            if (state.method_27852(class_2246.field_10034) || state.method_27852(class_2246.field_16328) || state.method_27852(class_2246.field_10380)) {
                                chestPosList.add(checkPos);
                                continue;
                            }
                            if (state.method_27852(exitBlock)) {
                                exitPosList.add(checkPos);
                                continue;
                            }
                            if (state.method_27852(bossLootBlock)) {
                                portalEntity.setBossLootBlockPos(checkPos);
                                continue;
                            }
                            if (state.method_27852(BlockInit.DUNGEON_SPAWNER)) {
                                spawnerPosEntityIdMap.put(checkPos, ((DungeonSpawnerEntity)world.method_8321(checkPos)).getLogic().getEntityId());
                                continue;
                            }
                            if (state.method_27852(BlockInit.DUNGEON_GATE)) {
                                gatePosList.add(checkPos);
                                if (world.method_8321(checkPos) == null || ((DungeonGateEntity)world.method_8321(checkPos)).getUnlockItem() != null) continue;
                                DungeonGateEntity dungeonGateEntity = (DungeonGateEntity)world.method_8321(checkPos);
                                dungeonGateEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35415(), poolStructurePiece.method_14935().method_35416(), poolStructurePiece.method_14935().method_35417());
                                dungeonGateEntity.addDungeonEdge(poolStructurePiece.method_14935().method_35418(), poolStructurePiece.method_14935().method_35419(), poolStructurePiece.method_14935().method_35420());
                                dungeonGateEntity.method_5431();
                                continue;
                            }
                            if (state.method_26204() instanceof class_5688) {
                                movingBlockMap.put(checkPos, blockId);
                                continue;
                            }
                            if (!state.method_28498((class_2769)class_2741.field_12484)) continue;
                            poweredBlockMap.put(checkPos, new DungeonPortalEntity.Powered(blockId, (Boolean)state.method_11654((class_2769)class_2741.field_12484), state.method_28498((class_2769)class_2741.field_12481) ? ((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10161() : 0));
                        }
                    }
                }
            }
            portalEntity.setChestPosList(chestPosList);
            portalEntity.setExitPosList(exitPosList);
            portalEntity.setMovingBlockMap(movingBlockMap);
            portalEntity.setPoweredBlockMap(poweredBlockMap);
            portalEntity.setBlockMap(blockIdPosMap);
            portalEntity.setSpawnerPosEntityIdMap(spawnerPosEntityIdMap);
            portalEntity.setGatePosList(gatePosList);
            portalEntity.method_5431();
            return true;
        }
        return false;
    }

    public static void prepareDungeon(class_3218 dungeonWorld, DungeonPortalEntity portalEntity) {
        ArrayList<class_1923> chunkPosList = new ArrayList<class_1923>();
        for (int i = 0; i < portalEntity.getDungeonEdgeList().size() / 6; ++i) {
            int x1 = portalEntity.getDungeonEdgeList().get(6 * i);
            int z1 = portalEntity.getDungeonEdgeList().get(2 + 6 * i);
            int x2 = portalEntity.getDungeonEdgeList().get(3 + 6 * i);
            int z2 = portalEntity.getDungeonEdgeList().get(5 + 6 * i);
            int xCount = Math.abs(x1 - x2) / 16 + ((x1 - x2) % 16 == 0 ? 0 : 1);
            int zCount = Math.abs(z1 - z2) / 16 + ((z1 - z2) % 16 == 0 ? 0 : 1);
            for (int u = 0; u < xCount; ++u) {
                for (int o = 0; o < zCount; ++o) {
                    class_1923 chunkPos = new class_1923(class_4076.method_18675((int)(x1 + 16 * u)), class_4076.method_18675((int)(z1 + 16 * o)));
                    if (chunkPosList.contains(chunkPos)) continue;
                    chunkPosList.add(chunkPos);
                }
            }
        }
        for (class_1923 chunkPos : chunkPosList) {
            dungeonWorld.method_14178().method_17297(class_3230.field_19280, chunkPos, 1, (Object)chunkPos.method_8323());
        }
    }

    public static void refreshDungeon(MinecraftServer server, class_3218 world, DungeonPortalEntity portalEntity, Dungeon dungeon, String difficulty, boolean luck) {
        int i;
        for (int u = 0; u < portalEntity.getDungeonEdgeList().size() / 6; ++u) {
            List entities = world.method_8335(null, new class_238((double)portalEntity.getDungeonEdgeList().get(6 * u).intValue(), (double)portalEntity.getDungeonEdgeList().get(1 + 6 * u).intValue(), (double)portalEntity.getDungeonEdgeList().get(2 + 6 * u).intValue(), (double)portalEntity.getDungeonEdgeList().get(3 + 6 * u).intValue(), (double)portalEntity.getDungeonEdgeList().get(4 + 6 * u).intValue(), (double)portalEntity.getDungeonEdgeList().get(5 + 6 * u).intValue()));
            for (class_1297 entity : entities) {
                if (entity instanceof class_3222 || !(entity instanceof class_1309) && !(entity instanceof class_1542) && !(entity instanceof class_1676)) continue;
                entity.method_31472();
            }
        }
        portalEntity.setDifficulty(difficulty);
        for (Map.Entry<Integer, ArrayList<class_2338>> entry : portalEntity.getBlockMap().entrySet()) {
            for (int j = 0; j < entry.getValue().size(); ++j) {
                if (dungeon.getBlockIdBlockReplacementMap().get(entry.getKey()) != -1) {
                    if (dungeon.getBlockIdBlockReplacementMap().get(entry.getKey()) == 0) {
                        world.method_8650(entry.getValue().get(j), false);
                    } else {
                        world.method_8652(entry.getValue().get(j), ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(entry.getKey()).intValue())).method_9564(), 3);
                    }
                }
                if (!(world.method_8409().method_43057() <= dungeon.getBlockIdEntitySpawnChanceMap().get(entry.getKey()).get(difficulty).floatValue())) continue;
                class_1308 mobEntity = DungeonPlacementHandler.createMob(world, dungeon.getBlockIdEntityMap().get(entry.getKey()).get(world.method_8409().method_43048(dungeon.getBlockIdEntityMap().get(entry.getKey()).size())), null);
                mobEntity.method_5943((class_5425)world, world.method_8404(entry.getValue().get(j)), class_3730.field_16474, null);
                mobEntity.method_5971();
                DungeonPlacementHandler.strengthenMob(mobEntity, dungeon, difficulty, false);
                dungeon.getBlockIdBlockReplacementMap().get(entry.getKey());
                mobEntity.method_5725(entry.getValue().get(j), 360.0f * world.method_8409().method_43057(), 0.0f);
                world.method_8649((class_1297)mobEntity);
            }
        }
        class_1308 bossEntity = DungeonPlacementHandler.createMob(world, dungeon.getBossEntityType(), dungeon.getBossNbtCompound());
        bossEntity.method_5943((class_5425)world, world.method_8404(portalEntity.getBossBlockPos()), class_3730.field_16474, null);
        bossEntity.method_5971();
        ((BossEntityAccess)bossEntity).setBoss(portalEntity.method_11016(), portalEntity.method_10997().method_27983().method_29177().toString());
        DungeonPlacementHandler.strengthenMob(bossEntity, dungeon, difficulty, true);
        if (dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossBlockId()) != -1) {
            if (dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossBlockId()) == 0) {
                world.method_8650(portalEntity.getBossBlockPos(), false);
            } else {
                world.method_8652(portalEntity.getBossBlockPos(), ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossBlockId()).intValue())).method_9564(), 3);
            }
        }
        bossEntity.method_5725(portalEntity.getBossBlockPos(), 360.0f * world.method_8409().method_43057(), 0.0f);
        world.method_8649((class_1297)bossEntity);
        for (i = 0; i < portalEntity.getChestPosList().size(); ++i) {
            String string = dungeon.getDifficultyLootTableIdMap().get(difficulty).get(world.method_8409().method_43048(dungeon.getDifficultyLootTableIdMap().get(difficulty).size()));
            InventoryHelper.fillInventoryWithLoot(server, world, portalEntity.getChestPosList().get(i), string, luck);
        }
        for (i = 0; i < portalEntity.getExitPosList().size(); ++i) {
            world.method_8652(portalEntity.getExitPosList().get(i), dungeon.getBlockIdBlockReplacementMap().containsKey(dungeon.getExitBlockId()) && dungeon.getBlockIdBlockReplacementMap().get(dungeon.getExitBlockId()) != -1 ? ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(dungeon.getExitBlockId()).intValue())).method_9564() : ((class_2248)class_7923.field_41175.method_10200(dungeon.getExitBlockId())).method_9564(), 3);
        }
        for (i = 0; i < portalEntity.getGatePosList().size(); ++i) {
            world.method_8501(portalEntity.getGatePosList().get(i), (class_2680)world.method_8320(portalEntity.getGatePosList().get(i)).method_28493((class_2769)DungeonGateBlock.ENABLED));
        }
        world.method_8652(portalEntity.getBossLootBlockPos(), dungeon.getBlockIdBlockReplacementMap().containsKey(dungeon.getBossLootBlockId()) && dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossLootBlockId()) != -1 ? ((class_2248)class_7923.field_41175.method_10200(dungeon.getBlockIdBlockReplacementMap().get(dungeon.getBossLootBlockId()).intValue())).method_9564() : ((class_2248)class_7923.field_41175.method_10200(dungeon.getBossLootBlockId())).method_9564(), 3);
        for (Map.Entry<class_2338, Integer> entry : portalEntity.getSpawnerPosEntityIdMap().entrySet()) {
            world.method_8652(entry.getKey(), BlockInit.DUNGEON_SPAWNER.method_9564(), 3);
            ((DungeonSpawnerEntity)world.method_8321(entry.getKey())).getLogic().setDungeonInfo(dungeon, difficulty, dungeon.getSpawnerEntityIdMap().containsKey(entry.getValue()) ? dungeon.getSpawnerEntityIdMap().get(entry.getValue()) : 0, (class_1299)class_7923.field_41177.method_10200(entry.getValue().intValue()));
        }
        for (Map.Entry<class_2338, Integer> entry : portalEntity.getReplaceBlockIdMap().entrySet()) {
            world.method_8652(entry.getKey(), ((class_2248)class_7923.field_41175.method_10200(entry.getValue().intValue())).method_9564(), 3);
        }
        for (Map.Entry<class_2338, Object> entry : portalEntity.getPoweredBlockMap().entrySet()) {
            class_2680 blockState = (class_2680)((class_2248)class_7923.field_41175.method_10200(((DungeonPortalEntity.Powered)entry.getValue()).getBlockId())).method_9564().method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(((DungeonPortalEntity.Powered)entry.getValue()).getPowered()));
            boolean hasFacing = blockState.method_28498((class_2769)class_2741.field_12481);
            if (hasFacing) {
                blockState = (class_2680)blockState.method_11657((class_2769)class_2741.field_12481, (Comparable)class_2350.method_10139((int)((DungeonPortalEntity.Powered)entry.getValue()).getFacing()));
            }
            world.method_8652(entry.getKey(), blockState, 3);
            world.method_8452(entry.getKey(), world.method_8320(entry.getKey()).method_26204());
            if (!hasFacing) continue;
            world.method_8452(entry.getKey().method_10093(((class_2350)world.method_8320(entry.getKey()).method_11654((class_2769)class_2741.field_12481)).method_10153()), world.method_8320(entry.getKey()).method_26204());
        }
        ArrayList<class_2338> freshPlacedBlockPoses = new ArrayList<class_2338>();
        for (Map.Entry<class_2338, Integer> entry : portalEntity.getMovingBlockMap().entrySet()) {
            class_2248 block = (class_2248)class_7923.field_41175.method_10200(entry.getValue().intValue());
            if (world.method_8320(entry.getKey()).method_27852(block)) continue;
            for (int i3 = 1; i3 < 50; ++i3) {
                class_2338 checkPos = entry.getKey().method_10087(i3);
                if (freshPlacedBlockPoses.contains(checkPos) || !world.method_8320(checkPos).method_27852(block)) continue;
                world.method_8650(checkPos, false);
                break;
            }
            world.method_8652(entry.getKey(), ((class_2248)class_7923.field_41175.method_10200(entry.getValue().intValue())).method_9564(), 3);
            freshPlacedBlockPoses.add(entry.getKey());
        }
        portalEntity.getDungeonPlayerUuids().clear();
        portalEntity.getDeadDungeonPlayerUUIDs().clear();
        portalEntity.method_5431();
    }

    @Nullable
    private static class_1308 createMob(class_3218 world, class_1299<?> type, @Nullable class_2487 nbt) {
        class_2487 nbtCompound;
        class_1308 mobEntity;
        try {
            class_1297 entity = type.method_5883((class_1937)world);
            if (!(entity instanceof class_1308)) {
                throw new IllegalStateException("Trying to spawn a non-mob: " + String.valueOf(class_7923.field_41177.method_10221(type)));
            }
            mobEntity = (class_1308)entity;
        }
        catch (Exception exception) {
            DungeonzMain.LOGGER.warn("Failed to create mob", (Throwable)exception);
            return null;
        }
        if (nbt != null) {
            nbtCompound = mobEntity.method_5647(new class_2487());
            nbtCompound.method_10543(nbt);
            mobEntity.method_5651(nbtCompound);
        }
        if (mobEntity.method_5864().method_20210(TagInit.IMMUNE_TO_ZOMBIFICATION)) {
            nbtCompound = mobEntity.method_5647(new class_2487());
            nbtCompound.method_10556("IsImmuneToZombification", true);
            mobEntity.method_5651(nbtCompound);
        }
        return mobEntity;
    }

    public static void strengthenMob(class_1308 mobEntity, Dungeon dungeon, String difficulty, boolean isBossEntity) {
        double mobHealth = mobEntity.method_45325(class_5134.field_23716);
        double mobDamage = 0.0;
        double mobProtection = 0.0;
        boolean hasAttackDamageAttribute = mobEntity.method_6127().method_45331(class_5134.field_23721);
        boolean hasArmorAttribute = mobEntity.method_6127().method_45331(class_5134.field_23724);
        if (hasAttackDamageAttribute) {
            mobDamage = mobEntity.method_45325(class_5134.field_23721);
        }
        if (hasArmorAttribute) {
            mobProtection = mobEntity.method_45325(class_5134.field_23724);
        }
        float strengthFactor = 0.0f;
        strengthFactor = isBossEntity ? dungeon.getDifficultyBossModificatorMap().get(difficulty).floatValue() : dungeon.getDifficultyMobModificatorMap().get(difficulty).floatValue();
        mobHealth *= (double)strengthFactor;
        mobDamage *= (double)strengthFactor;
        mobProtection *= (double)strengthFactor;
        mobHealth = (double)Math.round(mobHealth * 100.0) / 100.0;
        mobDamage = (double)Math.round(mobDamage * 100.0) / 100.0;
        mobProtection = (double)Math.round(mobProtection * 100.0) / 100.0;
        mobEntity.method_5996(class_5134.field_23716).method_6192(mobHealth);
        mobEntity.method_6025(mobEntity.method_6063());
        if (hasAttackDamageAttribute) {
            mobEntity.method_5996(class_5134.field_23721).method_6192(mobDamage);
        }
        if (hasArmorAttribute) {
            mobEntity.method_5996(class_5134.field_23724).method_6192(mobProtection);
        }
        if (DungeonzMain.isRpgDifficultyLoaded) {
            MobStrengthener.setMobHealthMultiplier((class_1308)mobEntity, (float)strengthFactor);
        }
    }
}

