/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.block.entity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.dungeonz.block.screen.DungeonPortalScreenHandler;
import net.dungeonz.dungeon.Dungeon;
import net.dungeonz.dungeon.DungeonPlacementHandler;
import net.dungeonz.init.BlockInit;
import net.dungeonz.init.ConfigInit;
import net.dungeonz.init.CriteriaInit;
import net.dungeonz.init.DimensionInit;
import net.dungeonz.init.SoundInit;
import net.dungeonz.network.DungeonServerPacket;
import net.dungeonz.network.packet.DungeonPortalPacket;
import net.dungeonz.util.DungeonHelper;
import net.dungeonz.util.InventoryHelper;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2640;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3914;
import net.minecraft.class_4051;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DungeonPortalEntity
extends class_2640
implements ExtendedScreenHandlerFactory<DungeonPortalPacket> {
    private class_2561 title = class_2561.method_43471((String)"container.dungeon_portal");
    private String dungeonType = "";
    private String difficulty = "";
    private boolean dungeonStructureGenerated = false;
    private List<UUID> dungeonPlayerUuids = new ArrayList<UUID>();
    private List<UUID> deadDungeonPlayerUuids = new ArrayList<UUID>();
    private int maxGroupSize = 0;
    private int minGroupSize = 0;
    private List<UUID> waitingUuids = new ArrayList<UUID>();
    private int requiredLevel = 0;
    private int cooldownTime = 0;
    private int autoKickTime = 0;
    private boolean disableEffects = false;
    private boolean privateGroup = false;
    private HashMap<Integer, ArrayList<class_2338>> blockBlockPosMap = new HashMap();
    private List<class_2338> chestPosList = new ArrayList<class_2338>();
    private List<class_2338> exitPosList = new ArrayList<class_2338>();
    private List<class_2338> gatePosList = new ArrayList<class_2338>();
    private Map<class_2338, Integer> movingBlockMap = new HashMap<class_2338, Integer>();
    private Map<class_2338, Powered> poweredBlockMap = new HashMap<class_2338, Powered>();
    private class_2338 bossBlockPos = new class_2338(0, 0, 0);
    private class_2338 bossLootBlockPos = new class_2338(0, 0, 0);
    private HashMap<class_2338, Integer> spawnerPosEntityIdMap = new HashMap();
    private HashMap<class_2338, Integer> replacePosBlockIdMap = new HashMap();
    private List<Integer> dungeonEdgeList = new ArrayList<Integer>();
    private int dungeonTeleportCountdown = 0;

    public DungeonPortalEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.DUNGEON_PORTAL_ENTITY, pos, state);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        int[] bossLootPos;
        int[] bossPos;
        int i2;
        super.method_11014(nbt, registryLookup);
        this.dungeonType = nbt.method_10558("DungeonType");
        this.difficulty = nbt.method_10558("Difficulty");
        this.dungeonStructureGenerated = nbt.method_10577("DungeonStructureGenerated");
        this.dungeonPlayerUuids.clear();
        for (i2 = 0; i2 < nbt.method_10550("DungeonPlayerCount"); ++i2) {
            this.dungeonPlayerUuids.add(nbt.method_25926("PlayerUUID" + i2));
        }
        this.deadDungeonPlayerUuids.clear();
        for (i2 = 0; i2 < nbt.method_10550("DeadDungeonPlayerCount"); ++i2) {
            this.deadDungeonPlayerUuids.add(nbt.method_25926("DeadPlayerUUID" + i2));
        }
        this.maxGroupSize = nbt.method_10550("MaxGroupSize");
        this.minGroupSize = nbt.method_10550("MinGroupSize");
        this.requiredLevel = nbt.method_10550("RequiredLevel");
        this.cooldownTime = nbt.method_10550("CooldownTime");
        this.autoKickTime = nbt.method_10550("AutoKickTime");
        this.disableEffects = nbt.method_10577("DisableEffects");
        this.privateGroup = nbt.method_10577("PrivateGroup");
        this.blockBlockPosMap.clear();
        if (nbt.method_10550("BlockMapSize") > 0) {
            for (i2 = 0; i2 < nbt.method_10550("BlockMapSize"); ++i2) {
                ArrayList<class_2338> posList = new ArrayList<class_2338>();
                for (int u = 0; u < nbt.method_10550("BlockListSize" + i2); ++u) {
                    int[] blockPos = nbt.method_10561("BlockPos" + i2 + u);
                    posList.add(new class_2338(blockPos[0], blockPos[1], blockPos[2]));
                }
                this.blockBlockPosMap.put(nbt.method_10550("BlockId" + i2), posList);
            }
        }
        if ((bossPos = nbt.method_10561("BossPos")).length > 0) {
            this.bossBlockPos = new class_2338(bossPos[0], bossPos[1], bossPos[2]);
        }
        if ((bossLootPos = nbt.method_10561("BossLootPos")).length > 0) {
            this.bossLootBlockPos = new class_2338(bossLootPos[0], bossLootPos[1], bossLootPos[2]);
        }
        if (nbt.method_10550("ChestListSize") > 0) {
            this.chestPosList.clear();
            for (i = 0; i < nbt.method_10550("ChestListSize"); ++i) {
                int[] chestPos = nbt.method_10561("ChestPos" + i);
                this.chestPosList.add(new class_2338(chestPos[0], chestPos[1], chestPos[2]));
            }
        }
        if (nbt.method_10550("ExitListSize") > 0) {
            this.exitPosList.clear();
            for (i = 0; i < nbt.method_10550("ExitListSize"); ++i) {
                int[] exitPos = nbt.method_10561("ExitPos" + i);
                this.exitPosList.add(new class_2338(exitPos[0], exitPos[1], exitPos[2]));
            }
        }
        if (nbt.method_10550("SpawnerMapSize") > 0) {
            this.spawnerPosEntityIdMap.clear();
            for (i = 0; i < nbt.method_10550("SpawnerListSize"); ++i) {
                int[] spawnerPos = nbt.method_10561("SpawnerPos" + i);
                this.spawnerPosEntityIdMap.put(new class_2338(spawnerPos[0], spawnerPos[1], spawnerPos[2]), spawnerPos[3]);
            }
        }
        if (nbt.method_10550("ReplacePosSize") > 0) {
            this.replacePosBlockIdMap.clear();
            for (i = 0; i < nbt.method_10550("ReplacePosSize"); ++i) {
                int[] replacePos = nbt.method_10561("ReplacePos" + i);
                this.replacePosBlockIdMap.put(new class_2338(replacePos[0], replacePos[1], replacePos[2]), replacePos[3]);
            }
        }
        if (nbt.method_10550("MovingPosSize") > 0) {
            this.movingBlockMap.clear();
            for (i = 0; i < nbt.method_10550("MovingPosSize"); ++i) {
                int[] movingPos = nbt.method_10561("MovingPos" + i);
                this.movingBlockMap.put(new class_2338(movingPos[0], movingPos[1], movingPos[2]), movingPos[3]);
            }
        }
        if (nbt.method_10550("PoweredPosSize") > 0) {
            this.poweredBlockMap.clear();
            for (i = 0; i < nbt.method_10550("PoweredPosSize"); ++i) {
                int[] poweredPos = nbt.method_10561("PoweredPos" + i);
                boolean isPowered = poweredPos[4] == 1;
                this.poweredBlockMap.put(new class_2338(poweredPos[0], poweredPos[1], poweredPos[2]), new Powered(poweredPos[3], isPowered, poweredPos[5]));
            }
        }
        if (nbt.method_10550("DungeonEdgeSize") > 0) {
            this.dungeonEdgeList.clear();
            for (i = 0; i < nbt.method_10550("DungeonEdgeSize") / 3; ++i) {
                int[] dungeonEdgePos = nbt.method_10561("DungeonEdge" + i);
                this.dungeonEdgeList.add(dungeonEdgePos[0]);
                this.dungeonEdgeList.add(dungeonEdgePos[1]);
                this.dungeonEdgeList.add(dungeonEdgePos[2]);
            }
        }
        if (nbt.method_10550("GateListSize") > 0) {
            this.gatePosList.clear();
            for (i = 0; i < nbt.method_10550("GateListSize"); ++i) {
                int[] gatePos = nbt.method_10561("GatePos" + i);
                this.gatePosList.add(new class_2338(gatePos[0], gatePos[1], gatePos[2]));
            }
        }
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        int i;
        super.method_11007(nbt, registryLookup);
        nbt.method_10582("DungeonType", this.dungeonType);
        nbt.method_10582("Difficulty", this.difficulty);
        nbt.method_10556("DungeonStructureGenerated", this.dungeonStructureGenerated);
        nbt.method_10569("DungeonPlayerCount", this.dungeonPlayerUuids.size());
        for (i = 0; i < this.dungeonPlayerUuids.size(); ++i) {
            nbt.method_25927("PlayerUUID" + i, this.dungeonPlayerUuids.get(i));
        }
        nbt.method_10569("DeadDungeonPlayerCount", this.deadDungeonPlayerUuids.size());
        for (i = 0; i < this.deadDungeonPlayerUuids.size(); ++i) {
            nbt.method_25927("DeadPlayerUUID" + i, this.deadDungeonPlayerUuids.get(i));
        }
        nbt.method_10569("MaxGroupSize", this.maxGroupSize);
        nbt.method_10569("MinGroupSize", this.minGroupSize);
        nbt.method_10569("RequiredLevel", this.requiredLevel);
        nbt.method_10569("CooldownTime", this.cooldownTime);
        nbt.method_10569("AutoKickTime", this.autoKickTime);
        nbt.method_10556("DisableEffects", this.disableEffects);
        nbt.method_10556("PrivateGroup", this.privateGroup);
        nbt.method_10569("BlockMapSize", this.blockBlockPosMap.size());
        if (!this.blockBlockPosMap.isEmpty()) {
            int blockCount = 0;
            for (Map.Entry<Integer, ArrayList<class_2338>> entry : this.blockBlockPosMap.entrySet()) {
                nbt.method_10569("BlockId" + blockCount, entry.getKey().intValue());
                nbt.method_10569("BlockListSize" + blockCount, entry.getValue().size());
                for (int i2 = 0; i2 < entry.getValue().size(); ++i2) {
                    nbt.method_10572("BlockPos" + blockCount + i2, List.of(Integer.valueOf(entry.getValue().get(i2).method_10263()), Integer.valueOf(entry.getValue().get(i2).method_10264()), Integer.valueOf(entry.getValue().get(i2).method_10260())));
                }
                ++blockCount;
            }
        }
        nbt.method_10572("BossPos", List.of(Integer.valueOf(this.bossBlockPos.method_10263()), Integer.valueOf(this.bossBlockPos.method_10264()), Integer.valueOf(this.bossBlockPos.method_10260())));
        nbt.method_10572("BossLootPos", List.of(Integer.valueOf(this.bossLootBlockPos.method_10263()), Integer.valueOf(this.bossLootBlockPos.method_10264()), Integer.valueOf(this.bossLootBlockPos.method_10260())));
        nbt.method_10569("ChestListSize", this.chestPosList.size());
        if (!this.chestPosList.isEmpty()) {
            for (i = 0; i < this.chestPosList.size(); ++i) {
                nbt.method_10572("ChestPos" + i, List.of(Integer.valueOf(this.chestPosList.get(i).method_10263()), Integer.valueOf(this.chestPosList.get(i).method_10264()), Integer.valueOf(this.chestPosList.get(i).method_10260())));
            }
        }
        nbt.method_10569("ExitListSize", this.exitPosList.size());
        if (!this.exitPosList.isEmpty()) {
            for (i = 0; i < this.exitPosList.size(); ++i) {
                nbt.method_10572("ExitPos" + i, List.of(Integer.valueOf(this.exitPosList.get(i).method_10263()), Integer.valueOf(this.exitPosList.get(i).method_10264()), Integer.valueOf(this.exitPosList.get(i).method_10260())));
            }
        }
        nbt.method_10569("SpawnerMapSize", this.spawnerPosEntityIdMap.size());
        if (!this.spawnerPosEntityIdMap.isEmpty()) {
            Iterator<Map.Entry<class_2338, Integer>> iterator = this.spawnerPosEntityIdMap.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry<class_2338, Integer> entry = iterator.next();
                nbt.method_10572("SpawnerPos" + count, List.of(Integer.valueOf(entry.getKey().method_10263()), Integer.valueOf(entry.getKey().method_10264()), Integer.valueOf(entry.getKey().method_10260()), entry.getValue()));
                ++count;
            }
        }
        nbt.method_10569("ReplacePosSize", this.replacePosBlockIdMap.size());
        if (!this.replacePosBlockIdMap.isEmpty()) {
            Iterator<Map.Entry<class_2338, Integer>> iterator = this.replacePosBlockIdMap.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry<class_2338, Integer> entry = iterator.next();
                nbt.method_10572("ReplacePos" + count, List.of(Integer.valueOf(entry.getKey().method_10263()), Integer.valueOf(entry.getKey().method_10264()), Integer.valueOf(entry.getKey().method_10260()), entry.getValue()));
                ++count;
            }
        }
        nbt.method_10569("MovingPosSize", this.movingBlockMap.size());
        if (!this.movingBlockMap.isEmpty()) {
            Iterator<Map.Entry<class_2338, Integer>> iterator = this.movingBlockMap.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry<class_2338, Integer> entry = iterator.next();
                nbt.method_10572("MovingPos" + count, List.of(Integer.valueOf(entry.getKey().method_10263()), Integer.valueOf(entry.getKey().method_10264()), Integer.valueOf(entry.getKey().method_10260()), entry.getValue()));
                ++count;
            }
        }
        nbt.method_10569("PoweredPosSize", this.poweredBlockMap.size());
        if (!this.poweredBlockMap.isEmpty()) {
            Iterator<Map.Entry<class_2338, Powered>> iterator = this.poweredBlockMap.entrySet().iterator();
            int count = 0;
            while (iterator.hasNext()) {
                Map.Entry<class_2338, Powered> entry = iterator.next();
                int isPowered = entry.getValue().getPowered() ? 1 : 0;
                nbt.method_10572("PoweredPos" + count, List.of(Integer.valueOf(entry.getKey().method_10263()), Integer.valueOf(entry.getKey().method_10264()), Integer.valueOf(entry.getKey().method_10260()), Integer.valueOf(entry.getValue().getBlockId()), Integer.valueOf(isPowered), Integer.valueOf(entry.getValue().getFacing())));
                ++count;
            }
        }
        nbt.method_10569("DungeonEdgeSize", this.dungeonEdgeList.size());
        if (!this.dungeonEdgeList.isEmpty()) {
            for (int i3 = 0; i3 < this.dungeonEdgeList.size() / 3; ++i3) {
                nbt.method_10572("DungeonEdge" + i3, List.of(this.dungeonEdgeList.get(3 * i3), this.dungeonEdgeList.get(1 + 3 * i3), this.dungeonEdgeList.get(2 + 3 * i3)));
            }
        }
        nbt.method_10569("GateListSize", this.gatePosList.size());
        if (!this.gatePosList.isEmpty()) {
            for (int i4 = 0; i4 < this.gatePosList.size(); ++i4) {
                nbt.method_10572("GatePos" + i4, List.of(Integer.valueOf(this.gatePosList.get(i4).method_10263()), Integer.valueOf(this.gatePosList.get(i4).method_10264()), Integer.valueOf(this.gatePosList.get(i4).method_10260())));
            }
        }
    }

    public static void clientTick(class_1937 world, class_2338 pos, class_2680 state, DungeonPortalEntity blockEntity) {
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, DungeonPortalEntity blockEntity) {
        int i;
        if (blockEntity.getDungeonPlayerCount() > 0) {
            if (blockEntity.autoKickTime == 0) {
                blockEntity.autoKickTime = (int)world.method_8510() + 432000;
            } else if (blockEntity.autoKickTime < (int)world.method_8510()) {
                if (blockEntity.getDungeon() != null) {
                    blockEntity.setCooldownTime(blockEntity.getDungeon().getCooldown() + (int)blockEntity.method_10997().method_8510());
                    for (i = 0; i < blockEntity.getDungeonPlayerUuids().size(); ++i) {
                        class_3222 player = (class_3222)world.method_18470(blockEntity.getDungeonPlayerUuids().get(i));
                        if (DungeonHelper.getCurrentDungeon(player) == null) continue;
                        DungeonHelper.teleportOutOfDungeon(player);
                        player.method_43496((class_2561)class_2561.method_43471((String)"text.dungeonz.dungeon_autokick"));
                    }
                }
                blockEntity.getDungeonPlayerUuids().clear();
                blockEntity.getDeadDungeonPlayerUUIDs().clear();
                blockEntity.autoKickTime = 0;
            }
        } else if (blockEntity.autoKickTime != 0) {
            blockEntity.autoKickTime = 0;
        }
        if (blockEntity.dungeonTeleportCountdown >= 1) {
            class_3222 serverPlayerEntity;
            class_1297 class_12972;
            if (blockEntity.dungeonTeleportCountdown % 20 == 0) {
                for (i = 0; i < blockEntity.getWaitingUuids().size(); ++i) {
                    if (((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i)) == null || !((class_12972 = ((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i))) instanceof class_3222)) continue;
                    serverPlayerEntity = (class_3222)class_12972;
                    DungeonServerPacket.writeS2CDungeonTeleportCountdown(serverPlayerEntity, blockEntity.dungeonTeleportCountdown);
                }
            }
            --blockEntity.dungeonTeleportCountdown;
            if (blockEntity.dungeonTeleportCountdown == ConfigInit.CONFIG.defaultDungeonTeleportCountdown / 2) {
                DungeonPlacementHandler.refreshDungeon(((class_3218)blockEntity.method_10997()).method_8503(), blockEntity.method_10997().method_8503().method_3847(DimensionInit.DUNGEON_WORLD), blockEntity, blockEntity.getDungeon(), blockEntity.getDifficulty(), blockEntity.getDisableEffects());
            }
            if (blockEntity.dungeonTeleportCountdown == 0) {
                for (i = 0; i < blockEntity.getWaitingUuids().size(); ++i) {
                    if (((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i)) == null || !((class_12972 = ((class_3218)blockEntity.method_10997()).method_14190(blockEntity.getWaitingUuids().get(i))) instanceof class_3222)) continue;
                    serverPlayerEntity = (class_3222)class_12972;
                    DungeonHelper.teleportPlayer(serverPlayerEntity, blockEntity.method_10997().method_8503().method_3847(DimensionInit.DUNGEON_WORLD), blockEntity, blockEntity.method_11016());
                }
                blockEntity.getWaitingUuids().clear();
            }
        }
    }

    public class_2561 method_5476() {
        if (this.getDungeon() != null) {
            return class_2561.method_43471((String)("dungeon." + this.getDungeonType()));
        }
        return this.title;
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return new DungeonPortalScreenHandler(syncId, playerInventory, this, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    public boolean method_11400(class_2350 direction) {
        return true;
    }

    public DungeonPortalPacket getScreenOpeningData(class_3222 player) {
        ArrayList<String> difficulties = new ArrayList();
        HashMap<String, List<class_1799>> possibleLoot = new HashMap();
        Map<String, List<class_1799>> requiredItemStacks = new HashMap<String, List<class_1799>>();
        Optional<class_2960> backgroundId = Optional.empty();
        int requiredLevel = 0;
        if (this.getDungeon() != null) {
            difficulties = this.getDungeon().getDifficultyList();
            possibleLoot = DungeonHelper.getPossibleLootItemStackMap(this.getDungeon(), player.method_5682());
            requiredItemStacks = DungeonHelper.getRequiredItemStackList(this.getDungeon());
            backgroundId = Optional.ofNullable(this.getDungeon().getBackgroundId());
            requiredLevel = this.getDungeon().getRequiredLevel();
        }
        return new DungeonPortalPacket(this.field_11867, this.getDungeonPlayerUuids(), this.getDeadDungeonPlayerUUIDs(), difficulties, possibleLoot, requiredItemStacks, this.getMaxGroupSize(), this.getMinGroupSize(), this.getWaitingUuids().size(), requiredLevel, this.getCooldownTime(), this.getDifficulty(), this.getDisableEffects(), this.getPrivateGroup(), backgroundId);
    }

    public void finishDungeon(class_3218 world, class_2338 pos) {
        List players = world.method_18464(class_4051.method_36625().method_18418(64.0), null, new class_238(pos).method_1009(64.0, 64.0, 64.0));
        for (class_1657 player : players) {
            CriteriaInit.DUNGEON_COMPLETION.trigger((class_3222)player, this.getDungeonType(), this.getDifficulty());
        }
        world.method_8396(null, pos, SoundInit.DUNGEON_COMPLETION_EVENT, class_3419.field_15245, 1.0f, 0.9f + world.method_8409().method_43057() * 0.2f);
        for (int i = 0; i < this.getExitPosList().size(); ++i) {
            world.method_8652(this.getExitPosList().get(i), BlockInit.DUNGEON_PORTAL.method_9564(), 3);
        }
        world.method_8652(this.getBossLootBlockPos(), class_2246.field_10034.method_9564(), 3);
        InventoryHelper.fillInventoryWithLoot(world.method_8503(), world, this.getBossLootBlockPos(), this.getDungeon().getDifficultyBossLootTableMap().get(this.getDifficulty()), this.getDisableEffects());
        this.setCooldownTime(this.getDungeon().getCooldown() + (int)this.method_10997().method_8510());
        this.method_5431();
    }

    @Nullable
    public Dungeon getDungeon() {
        return Dungeon.getDungeon(this.dungeonType);
    }

    public void setDungeonType(String dungeonType) {
        this.dungeonType = dungeonType;
    }

    public String getDungeonType() {
        return this.dungeonType;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public void setDungeonStructureGenerated() {
        this.dungeonStructureGenerated = true;
    }

    public boolean isDungeonStructureGenerated() {
        return this.dungeonStructureGenerated;
    }

    public void joinDungeon(UUID playerUuid) {
        if (!this.dungeonPlayerUuids.contains(playerUuid)) {
            this.dungeonPlayerUuids.add(playerUuid);
        }
    }

    public void leaveDungeon(UUID playerUuid) {
        this.dungeonPlayerUuids.remove(playerUuid);
    }

    public int getDungeonPlayerCount() {
        return this.dungeonPlayerUuids.size();
    }

    public void setDungeonPlayerUuids(List<UUID> dungeonPlayerUuids) {
        this.dungeonPlayerUuids = dungeonPlayerUuids;
    }

    public List<UUID> getDungeonPlayerUuids() {
        return this.dungeonPlayerUuids;
    }

    public void addDeadDungeonPlayerUuids(UUID deadDungeonPlayerUuids) {
        this.deadDungeonPlayerUuids.add(deadDungeonPlayerUuids);
    }

    public void setDeadDungeonPlayerUuids(List<UUID> deadDungeonPlayerUuids) {
        this.deadDungeonPlayerUuids = deadDungeonPlayerUuids;
    }

    public List<UUID> getDeadDungeonPlayerUUIDs() {
        return this.deadDungeonPlayerUuids;
    }

    public void setBlockMap(HashMap<Integer, ArrayList<class_2338>> map) {
        this.blockBlockPosMap = map;
    }

    public HashMap<Integer, ArrayList<class_2338>> getBlockMap() {
        return this.blockBlockPosMap;
    }

    public void setRequiredLevel(int requiredLevel) {
        this.requiredLevel = requiredLevel;
    }

    public int getRequiredLevel() {
        return this.requiredLevel;
    }

    public void setCooldownTime(int cooldownTime) {
        this.cooldownTime = cooldownTime;
    }

    public int getCooldownTime() {
        return this.cooldownTime;
    }

    public boolean isOnCooldown(int currentTime) {
        return this.cooldownTime > currentTime;
    }

    public void setMaxGroupSize(int maxGroupSize) {
        this.maxGroupSize = maxGroupSize;
    }

    public void setMinGroupSize(int minGroupSize) {
        this.minGroupSize = minGroupSize;
    }

    public List<UUID> getWaitingUuids() {
        return this.waitingUuids;
    }

    public void addWaitingUuid(UUID uuid) {
        if (!this.waitingUuids.contains(uuid)) {
            this.waitingUuids.add(uuid);
        }
    }

    public int getMaxGroupSize() {
        return this.maxGroupSize;
    }

    public int getMinGroupSize() {
        return this.minGroupSize;
    }

    public void setDisableEffects(boolean disableEffects) {
        this.disableEffects = disableEffects;
    }

    public boolean getDisableEffects() {
        return this.disableEffects;
    }

    public void setPrivateGroup(boolean privateGroup) {
        this.privateGroup = privateGroup;
    }

    public boolean getPrivateGroup() {
        return this.privateGroup;
    }

    public void setBossBlockPos(class_2338 pos) {
        this.bossBlockPos = pos;
    }

    public class_2338 getBossBlockPos() {
        return this.bossBlockPos;
    }

    public void setBossLootBlockPos(class_2338 pos) {
        this.bossLootBlockPos = pos;
    }

    public class_2338 getBossLootBlockPos() {
        return this.bossLootBlockPos;
    }

    public void setChestPosList(List<class_2338> chestPosList) {
        this.chestPosList = chestPosList;
    }

    public List<class_2338> getChestPosList() {
        return this.chestPosList;
    }

    public void setGatePosList(List<class_2338> gatePosList) {
        this.gatePosList = gatePosList;
    }

    public List<class_2338> getGatePosList() {
        return this.gatePosList;
    }

    public void setMovingBlockMap(Map<class_2338, Integer> movingBlockMap) {
        this.movingBlockMap = movingBlockMap;
    }

    public Map<class_2338, Integer> getMovingBlockMap() {
        return this.movingBlockMap;
    }

    public void setPoweredBlockMap(Map<class_2338, Powered> poweredBlockMap) {
        this.poweredBlockMap = poweredBlockMap;
    }

    public Map<class_2338, Powered> getPoweredBlockMap() {
        return this.poweredBlockMap;
    }

    public void setExitPosList(List<class_2338> exitPosList) {
        this.exitPosList = exitPosList;
    }

    public List<class_2338> getExitPosList() {
        return this.exitPosList;
    }

    public void addDungeonEdge(int edgeX, int edgeY, int edgeZ) {
        this.dungeonEdgeList.add(edgeX);
        this.dungeonEdgeList.add(edgeY);
        this.dungeonEdgeList.add(edgeZ);
    }

    public List<Integer> getDungeonEdgeList() {
        return this.dungeonEdgeList;
    }

    public void setSpawnerPosEntityIdMap(HashMap<class_2338, Integer> spawnerPosEntityIdMap) {
        this.spawnerPosEntityIdMap = spawnerPosEntityIdMap;
    }

    public HashMap<class_2338, Integer> getSpawnerPosEntityIdMap() {
        return this.spawnerPosEntityIdMap;
    }

    public void setReplaceBlockIdMap(HashMap<class_2338, Integer> replacePosBlockIdMap) {
        this.replacePosBlockIdMap = replacePosBlockIdMap;
    }

    public void addReplaceBlockId(class_2338 pos, class_2248 block) {
        this.replacePosBlockIdMap.put(pos, class_7923.field_41175.method_10206((Object)block));
    }

    public HashMap<class_2338, Integer> getReplaceBlockIdMap() {
        return this.replacePosBlockIdMap;
    }

    public void startDungeonTeleportCountdown(class_3218 dungeonWorld) {
        this.dungeonTeleportCountdown = ConfigInit.CONFIG.defaultDungeonTeleportCountdown;
        boolean isDungeonStructureGenerated = this.isDungeonStructureGenerated();
        if (!isDungeonStructureGenerated) {
            this.setDungeonStructureGenerated();
            DungeonPlacementHandler.generateDungeonStructure(dungeonWorld, new class_2338(0, 0, 0).method_10069(this.method_11016().method_10263() * 16, 100, this.method_11016().method_10260() * 16), this);
        } else {
            DungeonPlacementHandler.prepareDungeon(dungeonWorld, this);
        }
        this.method_5431();
    }

    public int getdungeonTeleportCountdown() {
        return this.dungeonTeleportCountdown;
    }

    public static class Powered {
        private final int blockId;
        private final boolean powered;
        private final int facing;

        public Powered(int blockId, boolean powered, int facing) {
            this.blockId = blockId;
            this.powered = powered;
            this.facing = facing;
        }

        public int getBlockId() {
            return this.blockId;
        }

        public boolean getPowered() {
            return this.powered;
        }

        public int getFacing() {
            return this.facing;
        }
    }
}

