/*
 * Decompiled with CFR 0.152.
 */
package net.dungeonz.block.entity;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.dungeonz.block.DungeonGateBlock;
import net.dungeonz.init.BlockInit;
import net.dungeonz.init.ConfigInit;
import net.dungeonz.init.DimensionInit;
import net.dungeonz.init.SoundInit;
import net.minecraft.class_1301;
import net.minecraft.class_1588;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2223;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class DungeonGateEntity
extends class_2586 {
    private static final List<class_2350> directions = List.of(class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039, class_2350.field_11036, class_2350.field_11033);
    private class_2960 gateBlockId = class_2960.method_60654((String)"minecraft:chiseled_stone_bricks");
    private String unlockItemId = "";
    private String gateParticleId = "minecraft:scrape";
    private List<Integer> dungeonEdgeList = new ArrayList<Integer>();

    public DungeonGateEntity(class_2338 pos, class_2680 state) {
        super(BlockInit.DUNGEON_GATE_ENTITY, pos, state);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.gateBlockId = class_2960.method_60654((String)nbt.method_10558("GateBlockId"));
        this.unlockItemId = nbt.method_10558("UnlockItemId");
        this.gateParticleId = nbt.method_10558("GateParticleId");
        if (nbt.method_10550("DungeonEdgeSize") > 0) {
            this.dungeonEdgeList.clear();
            for (int i = 0; i < nbt.method_10550("DungeonEdgeSize") / 3; ++i) {
                this.dungeonEdgeList.add(nbt.method_10550("DungeonEdgeX" + i));
                this.dungeonEdgeList.add(nbt.method_10550("DungeonEdgeY" + i));
                this.dungeonEdgeList.add(nbt.method_10550("DungeonEdgeZ" + i));
            }
        }
    }

    public void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10582("GateBlockId", this.gateBlockId.toString());
        nbt.method_10582("UnlockItemId", this.unlockItemId.toString());
        nbt.method_10582("GateParticleId", this.gateParticleId.toString());
        nbt.method_10569("DungeonEdgeSize", this.dungeonEdgeList.size());
        if (this.dungeonEdgeList.size() > 0) {
            for (int i = 0; i < this.dungeonEdgeList.size() / 3; ++i) {
                nbt.method_10569("DungeonEdgeX" + i, this.dungeonEdgeList.get(i + 3 * i).intValue());
                nbt.method_10569("DungeonEdgeY" + i, this.dungeonEdgeList.get(i + 1 + 3 * i).intValue());
                nbt.method_10569("DungeonEdgeZ" + i, this.dungeonEdgeList.get(i + 2 + 3 * i).intValue());
            }
        }
    }

    public static void serverTick(class_1937 world, class_2338 pos, class_2680 state, DungeonGateEntity blockEntity) {
        if (world.method_8510() % 20L == 0L && blockEntity.unlockItemId == null && blockEntity.getDungeonEdgeList().size() >= 6 && world.method_27983() == DimensionInit.DUNGEON_WORLD && !ConfigInit.CONFIG.devMode && !world.method_8320(pos.method_10074()).method_27852(BlockInit.DUNGEON_GATE)) {
            if (world.method_8320(pos.method_10095()).method_27852(BlockInit.DUNGEON_GATE) && !world.method_8320(pos.method_10072()).method_27852(BlockInit.DUNGEON_GATE)) {
                if (!blockEntity.areHostileEntitiesAlive()) {
                    blockEntity.unlockGate(pos);
                }
            } else if (world.method_8320(pos.method_10078()).method_27852(BlockInit.DUNGEON_GATE) && !world.method_8320(pos.method_10067()).method_27852(BlockInit.DUNGEON_GATE) && blockEntity.areHostileEntitiesAlive()) {
                blockEntity.unlockGate(pos);
            }
        }
    }

    private boolean areHostileEntitiesAlive() {
        if (this.getDungeonEdgeList().size() < 6) {
            return false;
        }
        List hostileEntities = this.field_11863.method_8390(class_1588.class, new class_238((double)this.getDungeonEdgeList().get(0).intValue(), (double)this.getDungeonEdgeList().get(1).intValue(), (double)this.getDungeonEdgeList().get(2).intValue(), (double)this.getDungeonEdgeList().get(3).intValue(), (double)this.getDungeonEdgeList().get(4).intValue(), (double)this.getDungeonEdgeList().get(5).intValue()), class_1301.field_6155);
        return !hostileEntities.isEmpty();
    }

    public void unlockGate(class_2338 pos) {
        this.field_11863.method_8396(null, pos, SoundInit.DUNGEON_GATE_UNLOCK_EVENT, class_3419.field_15245, 1.0f, 0.9f + this.field_11863.method_8409().method_43057() * 0.2f);
        List<class_2338> dungeonGatesPosList = DungeonGateEntity.getConnectedDungeonGatePosList(this.field_11863, pos);
        for (int i = 0; i < dungeonGatesPosList.size(); ++i) {
            if (this.field_11863.method_8321(dungeonGatesPosList.get(i)) == null || !(this.field_11863.method_8321(dungeonGatesPosList.get(i)) instanceof DungeonGateEntity)) continue;
            DungeonGateEntity otherDungeonGateEntity = (DungeonGateEntity)this.field_11863.method_8321(dungeonGatesPosList.get(i));
            this.field_11863.method_8501(dungeonGatesPosList.get(i), (class_2680)otherDungeonGateEntity.method_11010().method_28493((class_2769)DungeonGateBlock.ENABLED));
            otherDungeonGateEntity.method_5431();
        }
    }

    public static List<class_2338> getConnectedDungeonGatePosList(class_1937 world, class_2338 pos) {
        int u;
        int i;
        ArrayList<class_2338> dungeonGates = new ArrayList<class_2338>();
        ArrayList<Integer> directionLengths = new ArrayList<Integer>();
        block0: for (i = 0; i < directions.size(); ++i) {
            for (u = 1; u < 100; ++u) {
                if (world.method_8320(pos.method_10079(directions.get(i), u)).method_27852(BlockInit.DUNGEON_GATE)) continue;
                directionLengths.add(u - 1);
                continue block0;
            }
        }
        for (i = -((Integer)directionLengths.get(5)).intValue(); i <= (Integer)directionLengths.get(4); ++i) {
            for (u = -((Integer)directionLengths.get(0)).intValue(); u <= (Integer)directionLengths.get(2); ++u) {
                for (int o = -((Integer)directionLengths.get(1)).intValue(); o <= (Integer)directionLengths.get(3); ++o) {
                    class_2338 checkPos = pos.method_10086(i).method_10077(u).method_10088(o);
                    if (!world.method_8320(checkPos).method_27852(BlockInit.DUNGEON_GATE) || dungeonGates.contains(checkPos)) continue;
                    dungeonGates.add(checkPos);
                }
            }
        }
        return dungeonGates;
    }

    public class_2622 toUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 registryLookup) {
        return this.method_38244(registryLookup);
    }

    public void setUnlockItemId(String unlockItemId) {
        this.unlockItemId = unlockItemId;
    }

    @Nullable
    public class_1792 getUnlockItem() {
        if (this.unlockItemId.equals("")) {
            return null;
        }
        return (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)this.unlockItemId));
    }

    public void setBlockId(class_2960 gateBlockId) {
        this.gateBlockId = gateBlockId;
    }

    public class_2680 getBlockState() {
        return ((class_2248)class_7923.field_41175.method_10223(this.gateBlockId)).method_9564();
    }

    public void setParticleEffectId(String gateParticleId) {
        this.gateParticleId = gateParticleId;
    }

    @Nullable
    public class_2394 getParticleEffect() {
        if (this.gateParticleId.equals("")) {
            return null;
        }
        try {
            return class_2223.method_9418((StringReader)new StringReader(this.gateParticleId.toString()), (class_7225.class_7874)class_7225.class_7874.method_46761(Stream.of(class_7923.field_41180.method_46771())));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return null;
        }
    }

    public void addDungeonEdge(int edgeX, int edgeY, int edgeZ) {
        this.dungeonEdgeList.add(edgeX);
        this.dungeonEdgeList.add(edgeY);
        this.dungeonEdgeList.add(edgeZ);
    }

    public List<Integer> getDungeonEdgeList() {
        return this.dungeonEdgeList;
    }
}

