/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.ToIntFunction;
import net.minecraft.class_11;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_9;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.MemoryTest;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.util.BrainUtils;

public class InteractWithDoor<E extends class_1309>
extends ExtendedBehaviour<E> {
    private static final MemoryTest MEMORY_REQUIREMENTS = MemoryTest.builder(3).hasMemory(class_4140.field_18449).usesMemories(class_4140.field_26389, class_4140.field_18441);
    protected ToIntFunction<E> doorInteractionDelay = entity -> 20;
    protected TriPredicate<E, class_1309, class_2338> holdDoorsOpenFor = (entity, other, doorPos) -> entity.method_5864() == other.method_5864() && doorPos.method_19769((class_2374)other.method_19538(), 2.0);
    protected int doorCloseCooldown = -1;
    protected class_9 lastNode = null;

    public InteractWithDoor<E> holdDoorsOpenFor(TriPredicate<E, class_1309, class_2338> predicate) {
        this.holdDoorsOpenFor = predicate;
        return this;
    }

    public InteractWithDoor<E> doorInteractionDelay(ToIntFunction<E> delay) {
        this.doorInteractionDelay = delay;
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean method_18919(class_3218 level, E entity) {
        class_11 path = (class_11)BrainUtils.getMemory(entity, class_4140.field_18449);
        return !path.method_30849() && !path.method_46();
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return BrainUtils.hasMemory(entity, class_4140.field_18449) && this.method_18919((class_3218)entity.method_37908(), entity);
    }

    @Override
    protected void tick(E entity) {
        class_3218 level = (class_3218)entity.method_37908();
        class_11 path = (class_11)BrainUtils.getMemory(entity, class_4140.field_18449);
        class_2338 prevNodePos = path.method_30850().method_22879();
        class_2338 nextNodePos = path.method_29301().method_22879();
        class_2680 prevNodeBlockState = level.method_8320(prevNodePos);
        class_2680 nextNodeBlockState = level.method_8320(nextNodePos);
        if (this.doorCloseCooldown < 0) {
            this.doorCloseCooldown = this.doorInteractionDelay.applyAsInt(entity);
            this.lastNode = path.method_29301();
        }
        if (!Objects.equals(this.lastNode, path.method_29301()) && --this.doorCloseCooldown < 0) {
            return;
        }
        BrainUtils.withMemory(entity, class_4140.field_26389, doorsToClose -> this.checkAndCloseDoors(level, entity, (Set<class_4208>)doorsToClose, prevNodePos, nextNodePos));
        if (this.isInteractableDoor(prevNodeBlockState)) {
            this.tryOpenDoor(level, entity, prevNodeBlockState, prevNodePos);
        }
        if (this.isInteractableDoor(nextNodeBlockState)) {
            this.tryOpenDoor(level, entity, nextNodeBlockState, nextNodePos);
        }
    }

    protected void checkAndCloseDoors(class_3218 level, E entity, Set<class_4208> doorsToClose, class_2338 prevNodePos, class_2338 nextNodePos) {
        Iterator<class_4208> iterator = doorsToClose.iterator();
        while (iterator.hasNext()) {
            class_2323 doorBlock;
            class_4208 doorLocation = iterator.next();
            class_2338 doorPos = doorLocation.comp_2208();
            if (doorPos.equals((Object)prevNodePos) || doorPos.equals((Object)nextNodePos)) continue;
            if (doorLocation.comp_2207() != level.method_27983() || !doorPos.method_19769((class_2374)entity.method_19538(), 3.0)) {
                iterator.remove();
                continue;
            }
            class_2680 doorState = level.method_8320(doorPos);
            if (this.isInteractableDoor(doorState) && (doorBlock = (class_2323)doorState.method_26204()).method_30841(doorState) && !this.shouldHoldDoorOpenForOthers(entity, doorPos, BrainUtils.memoryOrDefault(entity, class_4140.field_18441, List::of))) {
                doorBlock.method_10033(entity, (class_1937)level, doorState, doorPos, false);
            }
            iterator.remove();
        }
    }

    protected boolean shouldHoldDoorOpenForOthers(E entity, class_2338 doorPos, List<class_1309> others) {
        for (class_1309 other : others) {
            class_11 path;
            if (!this.holdDoorsOpenFor.test(entity, other, doorPos) || (path = (class_11)BrainUtils.getMemory(entity, class_4140.field_18449)) == null || path.method_46() || path.method_30849() || !path.method_30850().method_22879().equals((Object)doorPos) && !path.method_29301().method_22879().equals((Object)doorPos)) continue;
            return true;
        }
        return false;
    }

    protected boolean isInteractableDoor(class_2680 state) {
        return state.method_26164(class_3481.field_52288) && state.method_26204() instanceof class_2323;
    }

    protected void tryOpenDoor(class_3218 level, E entity, class_2680 blockState, class_2338 pos) {
        class_2323 door = (class_2323)blockState.method_26204();
        if (!door.method_30841(blockState)) {
            door.method_10033(entity, (class_1937)level, blockState, pos, true);
            Set doorPositions = (Set)BrainUtils.getMemory(entity, class_4140.field_26389);
            if (doorPositions == null) {
                doorPositions = new ObjectOpenHashSet();
            }
            doorPositions.add(new class_4208(level.method_27983(), pos));
        }
    }
}

