/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_12;
import net.minecraft.class_1297;
import net.minecraft.class_1314;
import net.minecraft.class_1937;
import net.minecraft.class_1941;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_4102;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4142;
import net.minecraft.class_6;
import net.minecraft.class_7;
import net.minecraft.class_8;
import net.minecraft.class_9316;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.object.TriPredicate;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.RandomUtil;

public class FollowEntity<E extends class_1314, T extends class_1297>
extends ExtendedBehaviour<E> {
    protected Function<E, T> followingEntityProvider = entity -> null;
    protected BiFunction<E, T, Double> teleportDistance = (entity, target) -> Double.MAX_VALUE;
    protected BiFunction<E, T, Double> followDistMin = (entity, target) -> 4.0;
    protected BiFunction<E, T, Float> speedMod = (entity, target) -> Float.valueOf(1.0f);
    protected TriPredicate<E, class_2338, class_2680> teleportPredicate = this::isTeleportable;
    protected Predicate<E> canTeleportOffGround = entity -> entity.method_5942().method_6342() instanceof class_12 || entity.method_5942().method_6342() instanceof class_6;
    protected float oldWaterPathMalus = 0.0f;
    protected float oldLavaPathMalus = 0.0f;

    public FollowEntity<E, T> following(Function<E, T> following) {
        this.followingEntityProvider = following;
        return this;
    }

    public FollowEntity<E, T> teleportToTargetAfter(double distance) {
        return this.teleportToTargetAfter((entity, target) -> distance);
    }

    public FollowEntity<E, T> teleportToTargetAfter(BiFunction<E, T, Double> distanceProvider) {
        this.teleportDistance = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> stopFollowingWithin(double distance) {
        return this.stopFollowingWithin((entity, target) -> distance);
    }

    public FollowEntity<E, T> stopFollowingWithin(BiFunction<E, T, Double> distanceProvider) {
        this.followDistMin = distanceProvider;
        return this;
    }

    public FollowEntity<E, T> speedMod(float modifier) {
        return this.speedMod((entity, target) -> Float.valueOf(modifier));
    }

    public FollowEntity<E, T> speedMod(BiFunction<E, T, Float> modifier) {
        this.speedMod = modifier;
        return this;
    }

    public FollowEntity<E, T> canTeleportTo(TriPredicate<E, class_2338, class_2680> teleportPosPredicate) {
        this.teleportPredicate = teleportPosPredicate;
        return this;
    }

    public FollowEntity<E, T> canTeleportOffGroundWhen(Predicate<E> predicate) {
        this.canTeleportOffGround = predicate;
        return this;
    }

    @Override
    protected List<Pair<class_4140<?>, class_4141>> getMemoryRequirements() {
        return List.of();
    }

    protected boolean checkExtraStartConditions(class_3218 level, E entity) {
        class_1297 target = (class_1297)this.followingEntityProvider.apply(entity);
        if (target == null || target.method_7325()) {
            return false;
        }
        double minDist = this.followDistMin.apply(entity, target);
        return entity.method_5858(target) > minDist * minDist;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        double minDist;
        class_1297 target = (class_1297)this.followingEntityProvider.apply(entity);
        if (target == null) {
            return false;
        }
        double dist = entity.method_5858(target);
        return dist > (minDist = this.followDistMin.apply(entity, target).doubleValue()) * minDist;
    }

    @Override
    protected void start(E entity) {
        class_1297 target = (class_1297)this.followingEntityProvider.apply(entity);
        double minDist = this.followDistMin.apply(entity, target);
        float speedMod = this.speedMod.apply(entity, target).floatValue();
        this.oldWaterPathMalus = entity.method_5944(class_7.field_18);
        if (entity.method_5753()) {
            this.oldLavaPathMalus = entity.method_5944(class_7.field_14);
            entity.method_5941(class_7.field_14, 0.0f);
        }
        BrainUtils.setMemory(entity, class_4140.field_18445, new class_4142(target, speedMod, (int)minDist));
        BrainUtils.setMemory(entity, class_4140.field_18446, new class_4102(target, true));
        entity.method_5941(class_7.field_18, 0.0f);
    }

    @Override
    protected void stop(E entity) {
        entity.method_5941(class_7.field_18, this.oldWaterPathMalus);
        if (entity.method_5753()) {
            entity.method_5941(class_7.field_14, this.oldLavaPathMalus);
        }
        entity.method_5942().method_6340();
        BrainUtils.clearMemory(entity, class_4140.field_18445);
    }

    @Override
    protected void tick(E entity) {
        class_1297 target = (class_1297)this.followingEntityProvider.apply(entity);
        double teleportDist = this.teleportDistance.apply(entity, target);
        if (entity.method_5858(target) >= teleportDist * teleportDist) {
            this.teleportToTarget(entity, target);
        }
    }

    protected void teleportToTarget(E entity, T target) {
        class_2338 targetPos = target.method_24515();
        class_2338 teleportPos = this.getTeleportPos(entity, target, targetPos);
        if (!teleportPos.equals((Object)targetPos)) {
            entity.method_5808((double)teleportPos.method_10263() + 0.5, (double)teleportPos.method_10264(), (double)teleportPos.method_10260() + 0.5, entity.method_36454(), entity.method_36455());
            entity.method_5942().method_6340();
            BrainUtils.clearMemory(entity, class_4140.field_18445);
        }
    }

    protected class_2338 getTeleportPos(E entity, T target, class_2338 targetPos) {
        class_1937 level = entity.method_37908();
        return RandomUtil.getRandomPositionWithinRange(targetPos, 5, 5, 5, 1, 1, 1, !this.canTeleportOffGround.test(entity), level, 10, (state, statePos) -> this.teleportPredicate.test(entity, (class_2338)statePos, (class_2680)state));
    }

    protected boolean isTeleportable(E entity, class_2338 pos, class_2680 state) {
        class_8 nodeEvaluator = entity.method_5942().method_6342();
        class_7 pathType = nodeEvaluator.method_17(new class_9316((class_1941)entity.method_37908(), entity), pos.method_10263(), pos.method_10264(), pos.method_10260());
        if (!this.canTeleportOffGround.test(entity) ? pathType != class_7.field_12 : pathType != class_7.field_7 && pathType != class_7.field_12) {
            return false;
        }
        return entity.method_37908().method_8587(entity, entity.method_5829().method_997(class_243.method_24955((class_2382)pos).method_1020(entity.method_19538())));
    }
}

