/*
 * Decompiled with CFR 0.152.
 */
package net.tslat.smartbrainlib.api.core.behaviour;

import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.GroupBehaviour;
import net.tslat.smartbrainlib.object.SBLShufflingList;
import org.jetbrains.annotations.Nullable;

public final class SequentialBehaviour<E extends class_1309>
extends GroupBehaviour<E> {
    private Predicate<ExtendedBehaviour<? super E>> earlyResetPredicate = behaviour -> false;
    private int runningIndex = 0;

    @SafeVarargs
    public SequentialBehaviour(Pair<ExtendedBehaviour<? super E>, Integer> ... behaviours) {
        super(behaviours);
    }

    @SafeVarargs
    public SequentialBehaviour(ExtendedBehaviour<? super E> ... behaviours) {
        super(behaviours);
    }

    public SequentialBehaviour<E> resetIf(Predicate<ExtendedBehaviour<? super E>> predicate) {
        this.earlyResetPredicate = predicate;
        return this;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return this.runningBehaviour != null && this.runningBehaviour.method_18921() != class_4097.class_4098.field_18337;
    }

    @Override
    protected boolean method_18915(long gameTime) {
        return this.runningBehaviour == null || this.runningBehaviour.method_18915(gameTime) && this.runningIndex >= this.behaviours.size();
    }

    @Override
    protected void method_18924(class_3218 level, E owner, long gameTime) {
        this.runningBehaviour.method_18923(level, (class_1309)owner, gameTime);
        if (this.runningBehaviour.method_18921() == class_4097.class_4098.field_18337) {
            if (this.pickBehaviour(level, owner, gameTime, this.behaviours) != null) {
                return;
            }
            this.method_18925(level, (class_1309)owner, gameTime);
        }
    }

    @Override
    @Nullable
    protected ExtendedBehaviour<? super E> pickBehaviour(class_3218 level, E entity, long gameTime, SBLShufflingList<ExtendedBehaviour<? super E>> extendedBehaviours) {
        if (this.runningIndex >= extendedBehaviours.size()) {
            return null;
        }
        ExtendedBehaviour<E> next = extendedBehaviours.get(this.runningIndex);
        if (next != null) {
            if (this.runningBehaviour != null && this.earlyResetPredicate.test(next)) {
                return null;
            }
            if (next.method_18922(level, entity, gameTime)) {
                this.runningBehaviour = next;
                ++this.runningIndex;
                return this.runningBehaviour;
            }
        }
        return null;
    }

    @Override
    protected void method_18926(class_3218 level, E entity, long gameTime) {
        super.method_18926(level, entity, gameTime);
        this.runningIndex = 0;
    }
}

