/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.util;

import draylar.tiered.Tiered;
import draylar.tiered.api.PotentialAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class ReforgeUtil {
    private static final List<String> ORDER = List.of("common", "uncommon", "rare", "epic", "legendary", "unique");

    public static String getDynamicGroupName(class_2960 id, Map<String, Integer> frequencyMap) {
        String path = id.method_12832().toLowerCase();
        String[] parts = path.split("_");
        if (parts.length == 0) {
            return "unknown";
        }
        String prefix = parts[0];
        return frequencyMap.getOrDefault(prefix, 0) > 1 ? prefix : path;
    }

    public static String formatModifierName(class_2960 id) {
        String path = id.method_12832();
        String[] parts = path.split("_");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1 && part.matches("\\d+")) {
                builder.append(" ").append(part);
                continue;
            }
            builder.append((String)(i == 0 ? ReforgeUtil.capitalize(part) : " " + ReforgeUtil.capitalize(part)));
        }
        return builder.toString();
    }

    public static int getColorForModifier(class_2960 id) {
        PotentialAttribute attribute = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(id);
        if (attribute != null && attribute.getStyle() != null && attribute.getStyle().method_10973() != null) {
            String color = attribute.getStyle().method_10973().method_27721();
            if (color != null) {
                color = color.toLowerCase(Locale.ROOT);
            }
            return switch (color) {
                case "red" -> 0xFF5555;
                case "gold" -> 0xFFAA00;
                case "yellow" -> 0xFFFF55;
                case "green" -> 0x55FF55;
                case "dark_green" -> 24320;
                case "aqua" -> 0x55FFFF;
                case "blue" -> 0x5555FF;
                case "purple", "light_purple" -> 0xFF55FF;
                case "dark_purple" -> 0xAA00AA;
                case "gray", "grey" -> 0xAAAAAA;
                case "dark_gray", "dark_grey" -> 0x555555;
                case "black" -> 0;
                case "white" -> 0xFFFFFF;
                default -> 0xCCCCCC;
            };
        }
        return 0xCCCCCC;
    }

    private static String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public static int getNumericSuffixOrZero(class_2960 id) {
        String path = id.method_12832();
        int underscoreIndex = path.lastIndexOf(95);
        if (underscoreIndex != -1 && underscoreIndex < path.length() - 1) {
            try {
                return Integer.parseInt(path.substring(underscoreIndex + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0;
    }

    public static List<class_2960> getAvailableModifiers(class_1799 stack) {
        ArrayList<class_2960> modifiers = new ArrayList<class_2960>();
        Map<class_2960, PotentialAttribute> allAttributes = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes();
        class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
        for (Map.Entry<class_2960, PotentialAttribute> entry : allAttributes.entrySet()) {
            if (!entry.getValue().isValid(itemId)) continue;
            modifiers.add(entry.getKey());
        }
        return modifiers;
    }

    public static int getRarityOrder(class_2960 id) {
        for (int i = 0; i < ORDER.size(); ++i) {
            if (!id.method_12832().toLowerCase().contains(ORDER.get(i))) continue;
            return i;
        }
        return ORDER.size();
    }
}

