/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.reforge;

import com.mojang.blaze3d.systems.RenderSystem;
import draylar.tiered.Tiered;
import draylar.tiered.api.ModifierUtils;
import draylar.tiered.api.TieredItemTags;
import draylar.tiered.config.ConfigInit;
import draylar.tiered.network.TieredClientPacket;
import draylar.tiered.reforge.ReforgeScreenHandler;
import draylar.tiered.util.ReforgeUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.libz.api.Tab;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1836;
import net.minecraft.class_1856;
import net.minecraft.class_22;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_465;
import net.minecraft.class_471;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9209;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ReforgeScreen
extends class_465<ReforgeScreenHandler>
implements class_1712,
Tab {
    @Nullable
    private class_2960 targetModifier = null;
    private boolean modifierAchieved = false;
    public static final class_2960 TEXTURE = class_2960.method_60655((String)"tiered", (String)"textures/gui/reforging_screen.png");
    private final List<FloatingText> floatingTexts = new ArrayList<FloatingText>();
    private class_2960 lastSeenModifier = null;
    private class_1799 lastSeenStack = class_1799.field_8037;
    public ReforgeButton reforgeButton;
    private class_339 showModifiersButton;
    private class_1799 last;
    private List<class_1792> baseItems;
    private boolean modifiersVisible = false;
    private final Map<String, List<class_2960>> groupedModifiers = new LinkedHashMap<String, List<class_2960>>();
    private final Set<String> expandedGroups = new HashSet<String>();
    private int scrollOffset = 0;
    private final int entryHeight = 12;
    private final int maxVisibleEntries = 12;
    private final List<class_2960> ungroupedModifiers = new ArrayList<class_2960>();

    public ReforgeScreen(ReforgeScreenHandler handler, class_1661 playerInventory, class_2561 title) {
        super((class_1703)handler, playerInventory, title);
        this.field_25267 = 60;
    }

    protected void method_25426() {
        super.method_25426();
        ((ReforgeScreenHandler)this.field_2797).method_7596(this);
        int x = (this.field_22789 - this.field_2792) / 2;
        int y = (this.field_22790 - this.field_2779) / 2;
        this.reforgeButton = (ReforgeButton)this.method_37063((class_364)new ReforgeButton(this, x + 79, y + 56, button -> {
            if (!this.reforgeButton.disabled && !this.modifierAchieved) {
                TieredClientPacket.writeC2SReforgePacket();
            }
        }));
        int iconX = ConfigInit.CONFIG.leftSideModifierList ? x + 5 : x + 155;
        int iconY = y + 5;
        this.showModifiersButton = new class_339(iconX, iconY, 16, 16, (class_2561)class_2561.method_43473()){

            public void method_25348(double mouseX, double mouseY) {
                class_1799 stack;
                ReforgeScreen.this.modifiersVisible = !ReforgeScreen.this.modifiersVisible;
                ReforgeScreen.this.scrollOffset = 0;
                ReforgeScreen.this.groupedModifiers.clear();
                ReforgeScreen.this.expandedGroups.clear();
                ReforgeScreen.this.ungroupedModifiers.clear();
                if (ReforgeScreen.this.modifiersVisible && !(stack = ((ReforgeScreenHandler)ReforgeScreen.this.field_2797).method_7611(1).method_7677()).method_7960()) {
                    List<class_2960> modifiers = ReforgeUtil.getAvailableModifiers(stack);
                    modifiers.sort(Comparator.comparing(ReforgeUtil::getRarityOrder).thenComparing(ReforgeUtil::getNumericSuffixOrZero));
                    HashMap<String, Integer> prefixCount = new HashMap<String, Integer>();
                    for (class_2960 id : modifiers) {
                        String[] parts = id.method_12832().split("_");
                        if (parts.length <= 0) continue;
                        prefixCount.merge(parts[0], 1, Integer::sum);
                    }
                    for (class_2960 id : modifiers) {
                        String group = ReforgeUtil.getDynamicGroupName(id, prefixCount);
                        if (prefixCount.getOrDefault(group, 0) > 1) {
                            ReforgeScreen.this.groupedModifiers.computeIfAbsent(group, k -> new ArrayList()).add(id);
                            continue;
                        }
                        ReforgeScreen.this.ungroupedModifiers.add(id);
                    }
                }
            }

            protected void method_47399(class_6382 builder) {
            }

            protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
                class_1799 stack = ((ReforgeScreenHandler)ReforgeScreen.this.field_2797).method_7611(1).method_7677();
                if (stack.method_7960()) {
                    return;
                }
                class_2960 icon = class_2960.method_60655((String)"kevs", (String)"textures/gui/anvil_sword.png");
                context.method_51448().method_22903();
                RenderSystem.setShaderColor((float)(this.method_49606() ? 1.0f : 0.5f), (float)(this.method_49606() ? 1.0f : 0.5f), (float)(this.method_49606() ? 1.0f : 0.5f), (float)1.0f);
                context.method_25290(icon, this.method_46426(), this.method_46427(), 0.0f, 0.0f, this.field_22758, this.field_22759, 16, 16);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                context.method_51448().method_22909();
            }
        };
        this.method_37063((class_364)this.showModifiersButton);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int x = ConfigInit.CONFIG.leftSideModifierList ? this.field_2776 - 130 : this.field_2776 + this.field_2792 + 10;
        int baseY = this.field_2800 + 10;
        int rendered = 0;
        if (!this.modifiersVisible || this.groupedModifiers.isEmpty() && this.ungroupedModifiers.isEmpty()) {
            return super.method_25402(mouseX, mouseY, button);
        }
        for (Map.Entry<String, List<class_2960>> entry : this.groupedModifiers.entrySet()) {
            String group = entry.getKey();
            List<class_2960> modifiers = entry.getValue();
            int groupY = baseY - this.scrollOffset + rendered * 12;
            if (mouseX >= (double)x && mouseX <= (double)(x + 120) && mouseY >= (double)groupY && mouseY <= (double)(groupY + 12)) {
                if (modifiers.size() == 1) {
                    class_2960 id = modifiers.get(0);
                    if (this.targetModifier != null && this.targetModifier.equals((Object)id)) {
                        this.targetModifier = null;
                        this.modifierAchieved = false;
                    } else {
                        this.targetModifier = id;
                        this.modifierAchieved = false;
                    }
                } else if (this.expandedGroups.contains(group)) {
                    this.expandedGroups.remove(group);
                } else {
                    this.expandedGroups.add(group);
                }
                return true;
            }
            ++rendered;
            if (!this.expandedGroups.contains(group)) continue;
            for (class_2960 id : modifiers) {
                int modY = baseY - this.scrollOffset + rendered * 12;
                if (mouseX >= (double)x && mouseX <= (double)(x + 140) && mouseY >= (double)modY && mouseY <= (double)(modY + 12)) {
                    if (this.targetModifier != null && this.targetModifier.equals((Object)id)) {
                        this.targetModifier = null;
                        this.modifierAchieved = false;
                    } else if (!this.modifierAchieved || !id.equals((Object)this.targetModifier)) {
                        this.targetModifier = id;
                        this.modifierAchieved = false;
                    }
                    return true;
                }
                ++rendered;
            }
        }
        int ungroupedY = this.field_2800 + 10 + rendered * 12;
        for (class_2960 id : this.ungroupedModifiers) {
            int modY = ungroupedY - this.scrollOffset;
            if (mouseX >= (double)x && mouseX <= (double)(x + 140) && mouseY >= (double)modY && mouseY <= (double)(modY + 12)) {
                if (this.targetModifier != null && this.targetModifier.equals((Object)id)) {
                    this.targetModifier = null;
                    this.modifierAchieved = false;
                } else {
                    this.targetModifier = id;
                    this.modifierAchieved = false;
                }
                return true;
            }
            ungroupedY += 12;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (!this.modifiersVisible) {
            return false;
        }
        int groupedCount = this.groupedModifiers.entrySet().stream().mapToInt(entry -> 1 + (this.expandedGroups.contains(entry.getKey()) ? ((List)entry.getValue()).size() : 0)).sum();
        int totalEntries = groupedCount + this.ungroupedModifiers.size();
        int maxOffset = Math.max(0, (totalEntries - 12) * 12);
        this.scrollOffset = Math.min(Math.max(this.scrollOffset - (int)(verticalAmount * 12.0), 0), maxOffset);
        return true;
    }

    private static String capitalize(String input) {
        if (input == null || input.isEmpty()) {
            return input;
        }
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        RenderSystem.disableBlend();
        this.method_2380(context, mouseX, mouseY);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        if (this.method_2378(79, 56, 18, 18, mouseX, mouseY)) {
            class_1799 ingredient;
            class_1799 itemStack = ((ReforgeScreenHandler)this.method_17577()).method_7611(1).method_7677();
            if (itemStack == null || itemStack.method_7960() || itemStack.method_31573(TieredItemTags.MODIFIER_RESTRICTED)) {
                this.baseItems = Collections.emptyList();
            } else if (itemStack != this.last) {
                this.last = itemStack;
                this.baseItems = new ArrayList<class_1792>();
                List<class_1792> items = Tiered.REFORGE_DATA_LOADER.getReforgeBaseItems(itemStack.method_7909());
                if (!items.isEmpty()) {
                    this.baseItems.addAll(items);
                } else {
                    Object object = itemStack.method_7909();
                    if (object instanceof class_1831) {
                        class_1831 toolItem = (class_1831)object;
                        for (class_1799 class_17992 : toolItem.method_8022().method_8023().method_8105()) {
                            this.baseItems.add(class_17992.method_7909());
                        }
                    } else {
                        class_1738 armorItem;
                        object = itemStack.method_7909();
                        if (object instanceof class_1738 && ((class_1741)(armorItem = (class_1738)object).method_7686().comp_349()).comp_2301() != null) {
                            for (class_1799 class_17993 : ((class_1856)((class_1741)armorItem.method_7686().comp_349()).comp_2301().get()).method_8105()) {
                                this.baseItems.add(class_17993.method_7909());
                            }
                        } else {
                            for (class_6880 itemRegistryEntry : class_7923.field_41178.method_40260(TieredItemTags.REFORGE_BASE_ITEM)) {
                                this.baseItems.add((class_1792)itemRegistryEntry.comp_349());
                            }
                        }
                    }
                }
            }
            ArrayList<Object> tooltip = new ArrayList<Object>();
            if (!(this.baseItems.isEmpty() || (ingredient = ((ReforgeScreenHandler)this.method_17577()).method_7611(0).method_7677()) != null && !ingredient.method_7960() && this.baseItems.contains(ingredient.method_7909()))) {
                tooltip.add(class_2561.method_43471((String)"screen.tiered.reforge_ingredient"));
                for (class_1792 item : this.baseItems) {
                    tooltip.add(item.method_7848());
                }
            }
            if (itemStack.method_7963() && itemStack.method_7986()) {
                tooltip.add(class_2561.method_43471((String)"screen.tiered.reforge_damaged"));
            }
            if (!tooltip.isEmpty()) {
                context.method_51434(this.field_22793, tooltip, mouseX, mouseY);
            }
        }
        if (!ConfigInit.CONFIG.uniqueReforge && !((ReforgeScreenHandler)this.method_17577()).method_7611(1).method_7677().method_7960() && ModifierUtils.getAttributeId(((ReforgeScreenHandler)this.method_17577()).method_7611(1).method_7677()) != null && ModifierUtils.getAttributeId(((ReforgeScreenHandler)this.method_17577()).method_7611(1).method_7677()).method_12832().contains("unique")) {
            context.method_25302(TEXTURE, this.field_2776 + 74, this.field_2800 + 29, 0, 166, 28, 26);
        }
        if (!(!this.modifiersVisible || this.groupedModifiers.isEmpty() && this.ungroupedModifiers.isEmpty())) {
            int viewHeight;
            int groupedCount;
            int totalEntries;
            int contentHeight;
            void var14_31;
            boolean hoveredTooltipDrawn = false;
            int listX = ConfigInit.CONFIG.leftSideModifierList ? this.field_2776 - 135 : this.field_2776 + this.field_2792 + 5;
            int listY = this.field_2800 + 10;
            int maxWidth = 130;
            int totalHeight = 144;
            int top = listY - 4;
            int bottom = top + totalHeight + 8;
            context.method_25294(listX - 4, top, listX + maxWidth + 4, bottom, -1156509423);
            context.method_49601(listX - 4, top, maxWidth + 8, bottom - top, -10066330);
            Object var14_25 = null;
            int tooltipX = 0;
            int tooltipY = 0;
            int scaleFactor = (int)this.field_22787.method_22683().method_4495();
            RenderSystem.enableScissor((int)((listX - 4) * scaleFactor), (int)((this.field_22790 - (listY + 144 + 4)) * scaleFactor), (int)((maxWidth + 8) * scaleFactor), (int)(152 * scaleFactor));
            int rendered = 0;
            for (Map.Entry<String, List<class_2960>> entry2 : this.groupedModifiers.entrySet()) {
                boolean isSingleEntry;
                String rarity = entry2.getKey();
                List<class_2960> modifiers = entry2.getValue();
                int groupY = listY - this.scrollOffset + rendered * 12;
                boolean groupHeaderVisible = groupY + 12 >= listY && groupY <= listY + 144;
                String displayName = ReforgeScreen.capitalize(rarity);
                boolean bl = isSingleEntry = modifiers.size() == 1 && this.groupedModifiers.get(rarity).size() == 1;
                String prefix = isSingleEntry ? "\u2022 " : (this.expandedGroups.contains(rarity) ? "\u25bc " : "\u25b6 ");
                context.method_25294(listX - 2, groupY - 1, listX + maxWidth - 2, groupY + 12, 0x55222222);
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)(prefix + displayName)).method_27694(s -> s.method_10982(Boolean.valueOf(true))), listX, groupY, 0xFFFFFF, false);
                if (!hoveredTooltipDrawn && mouseX >= listX && mouseX <= listX + 120 && mouseY >= groupY && mouseY <= groupY + 12) {
                    List<class_5250> list = List.of(class_2561.method_43470((String)"Click to expand/collapse"));
                    tooltipX = mouseX;
                    tooltipY = mouseY;
                    hoveredTooltipDrawn = true;
                }
                ++rendered;
                if (modifiers.size() != 1 && !this.expandedGroups.contains(rarity)) continue;
                for (class_2960 id : modifiers) {
                    boolean isHovered;
                    String niceName;
                    int modY = listY - this.scrollOffset + rendered * 12;
                    if (modY + 12 < listY || modY > listY + 144) {
                        ++rendered;
                        continue;
                    }
                    if (this.groupedModifiers.containsKey(rarity) && this.groupedModifiers.get(rarity).size() > 1) {
                        String groupPrefix = rarity.toLowerCase() + "_";
                        String fullName = id.method_12832();
                        if (fullName.startsWith(groupPrefix)) {
                            String trimmed = fullName.substring(groupPrefix.length());
                            niceName = ReforgeUtil.formatModifierName(class_2960.method_60655((String)id.method_12836(), (String)trimmed));
                        } else {
                            niceName = ReforgeUtil.formatModifierName(id);
                        }
                    } else {
                        niceName = ReforgeUtil.formatModifierName(id);
                    }
                    boolean bl2 = isHovered = mouseX >= listX && mouseX <= listX + 140 && mouseY >= modY && mouseY <= modY + 12;
                    if (isHovered && !hoveredTooltipDrawn) {
                        context.method_25294(listX - 2, modY - 1, listX + maxWidth - 2, modY + 12, 0x44FFFFFF);
                    }
                    String label = "\u2022 " + niceName;
                    int modColor = ReforgeUtil.getColorForModifier(id);
                    int maxTextWidth = 120;
                    String trimmed = this.field_22793.method_27523(label, maxTextWidth).toString();
                    int textX = listX + 5;
                    int textY = modY + 2;
                    context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)trimmed), textX, textY, modColor, false);
                    if (id.equals((Object)this.targetModifier)) {
                        class_2960 lockIcon = class_2960.method_60655((String)"kevs", (String)"textures/gui/lock.png");
                        int iconSize = 8;
                        int textWidth = this.field_22793.method_1727(trimmed);
                        int iconX = textX + textWidth + 4;
                        int iconY = textY;
                        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        context.method_25290(lockIcon, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                    }
                    if (isHovered && !hoveredTooltipDrawn) {
                        class_1799 base = ((ReforgeScreenHandler)this.field_2797).method_7611(1).method_7677();
                        if (!base.method_7960()) {
                            class_1799 preview = base.method_7972();
                            ModifierUtils.setItemStackAttributeWithId(preview, id);
                            class_1792.class_9635 tooltipContext = new class_1792.class_9635(this){

                                @Nullable
                                public class_7225.class_7874 method_59527() {
                                    return null;
                                }

                                public float method_59531() {
                                    return 0.0f;
                                }

                                @Nullable
                                public class_22 method_59529(class_9209 id) {
                                    return null;
                                }
                            };
                            List list = preview.method_7950(tooltipContext, (class_1657)this.field_22787.field_1724, (class_1836)class_1836.field_41071);
                        } else {
                            List<class_5250> list = List.of(class_2561.method_43470((String)("Modifier: " + id.method_12832())));
                        }
                        tooltipX = mouseX;
                        tooltipY = mouseY;
                        hoveredTooltipDrawn = true;
                    }
                    ++rendered;
                }
            }
            for (class_2960 id : this.ungroupedModifiers) {
                boolean isHovered;
                int modY = listY - this.scrollOffset + rendered * 12;
                if (modY + 12 < listY || modY > listY + 144) {
                    ++rendered;
                    continue;
                }
                String niceName = ReforgeUtil.formatModifierName(id);
                boolean bl = isHovered = mouseX >= listX && mouseX <= listX + 140 && mouseY >= modY && mouseY <= modY + 12;
                if (isHovered && !hoveredTooltipDrawn) {
                    context.method_25294(listX - 2, modY - 1, listX + maxWidth - 2, modY + 12, 0x44FFFFFF);
                }
                String label = "\u2022 " + niceName;
                int modColor = ReforgeUtil.getColorForModifier(id);
                int maxTextWidth = 120;
                String trimmed = this.field_22793.method_27523(label, maxTextWidth).toString();
                int textX = listX + 5;
                int textY = modY + 2;
                context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)trimmed), textX, textY, modColor, false);
                if (id.equals((Object)this.targetModifier)) {
                    class_2960 lockIcon = class_2960.method_60655((String)"kevs", (String)"textures/gui/lock.png");
                    int iconSize = 8;
                    int textWidth = this.field_22793.method_1727(trimmed);
                    int iconX = textX + textWidth + 4;
                    int iconY = textY;
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    context.method_25290(lockIcon, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
                }
                if (isHovered && !hoveredTooltipDrawn) {
                    class_1799 base = ((ReforgeScreenHandler)this.field_2797).method_7611(1).method_7677();
                    if (!base.method_7960()) {
                        class_1799 preview = base.method_7972();
                        ModifierUtils.setItemStackAttributeWithId(preview, id);
                        class_1792.class_9635 tooltipContext = new class_1792.class_9635(this){

                            @Nullable
                            public class_7225.class_7874 method_59527() {
                                return null;
                            }

                            public float method_59531() {
                                return 0.0f;
                            }

                            @Nullable
                            public class_22 method_59529(class_9209 id) {
                                return null;
                            }
                        };
                        List list = preview.method_7950(tooltipContext, (class_1657)this.field_22787.field_1724, (class_1836)class_1836.field_41071);
                    } else {
                        List<class_5250> list = List.of(class_2561.method_43470((String)("Modifier: " + id.method_12832())));
                    }
                    tooltipX = mouseX;
                    tooltipY = mouseY;
                    hoveredTooltipDrawn = true;
                }
                ++rendered;
            }
            RenderSystem.disableScissor();
            if (var14_31 != null) {
                context.method_51434(this.field_22793, (List)var14_31, tooltipX, tooltipY);
            }
            if ((contentHeight = (totalEntries = (groupedCount = this.groupedModifiers.entrySet().stream().mapToInt(entry -> 1 + (this.expandedGroups.contains(entry.getKey()) ? ((List)entry.getValue()).size() : 0)).sum()) + this.ungroupedModifiers.size()) * 12) > (viewHeight = 144)) {
                int scrollbarHeight = Math.max((int)((float)viewHeight / (float)contentHeight * (float)viewHeight), 10);
                int scrollPosition = (int)((float)this.scrollOffset / (float)(contentHeight - viewHeight) * (float)(viewHeight - scrollbarHeight));
                int scrollbarX = listX + maxWidth - 5;
                int scrollbarY = listY + scrollPosition;
                context.method_25294(scrollbarX, scrollbarY, scrollbarX + 4, scrollbarY + scrollbarHeight, -7829368);
            }
        }
        Iterator<FloatingText> iterator = this.floatingTexts.iterator();
        while (iterator.hasNext()) {
            FloatingText ft = iterator.next();
            ft.tick();
            if (ft.isExpired()) {
                iterator.remove();
                continue;
            }
            int color = ft.getRenderColor();
            float yOffset = ft.getYOffset();
            int textWidth = this.field_22793.method_27525((class_5348)ft.text);
            int drawX = ft.x - textWidth / 2;
            int drawY = (int)((float)ft.y + yOffset);
            context.method_51439(this.field_22793, ft.text, drawX, drawY, color, true);
        }
    }

    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        context.method_25302(TEXTURE, i, j, 0, 0, this.field_2792, this.field_2779);
    }

    public void method_25432() {
        super.method_25432();
        ((ReforgeScreenHandler)this.field_2797).method_7603(this);
    }

    public void method_7633(class_1703 handler, int property, int value) {
    }

    public void method_7635(class_1703 handler, int slotId, class_1799 stack) {
        if (slotId == 1) {
            class_2960 newId;
            if (!class_1799.method_7984((class_1799)stack, (class_1799)this.lastSeenStack)) {
                this.lastSeenStack = stack.method_7972();
                if (this.modifiersVisible) {
                    this.groupedModifiers.clear();
                    this.expandedGroups.clear();
                    this.ungroupedModifiers.clear();
                    this.scrollOffset = 0;
                    if (!stack.method_7960()) {
                        List<class_2960> modifiers = ReforgeUtil.getAvailableModifiers(stack);
                        modifiers.sort(Comparator.comparing(ReforgeUtil::getRarityOrder).thenComparing(ReforgeUtil::getNumericSuffixOrZero));
                        HashMap<String, Integer> prefixCount = new HashMap<String, Integer>();
                        for (class_2960 id : modifiers) {
                            String[] parts = id.method_12832().split("_");
                            if (parts.length <= 0) continue;
                            prefixCount.merge(parts[0], 1, Integer::sum);
                        }
                        for (class_2960 id : modifiers) {
                            String group = ReforgeUtil.getDynamicGroupName(id, prefixCount);
                            if (prefixCount.getOrDefault(group, 0) > 1) {
                                this.groupedModifiers.computeIfAbsent(group, k -> new ArrayList()).add(id);
                                continue;
                            }
                            this.ungroupedModifiers.add(id);
                        }
                    }
                }
            }
            if (!(stack.method_7960() || (newId = ModifierUtils.getAttributeId(stack)) == null || newId.equals((Object)this.lastSeenModifier) && class_1799.method_7984((class_1799)stack, (class_1799)this.lastSeenStack))) {
                this.lastSeenModifier = newId;
                int slotX = ((ReforgeScreenHandler)this.method_17577()).method_7611((int)1).field_7873;
                int slotY = ((ReforgeScreenHandler)this.method_17577()).method_7611((int)1).field_7872;
                int x = this.field_2776 + slotX + 8;
                int y = this.field_2800 + slotY - 6;
                if (this.targetModifier != null && newId.equals((Object)this.targetModifier)) {
                    this.modifierAchieved = true;
                    this.floatingTexts.add(new FloatingText(this, (class_2561)class_2561.method_43470((String)"\u2714 Modifier Achieved"), 0x55FF55, x, y));
                    if (this.reforgeButton != null) {
                        this.reforgeButton.setDisabled(true);
                    }
                    return;
                }
                HashMap<String, Integer> prefixFrequency = new HashMap<String, Integer>();
                String[] parts = newId.method_12832().toLowerCase().split("_");
                if (parts.length > 0) {
                    prefixFrequency.put(parts[0], 2);
                }
                String group = ReforgeUtil.getDynamicGroupName(newId, prefixFrequency);
                class_5250 displayText = class_2561.method_43470((String)("\u2726 " + ReforgeScreen.capitalize(group) + " \u2726"));
                int color = ReforgeUtil.getColorForModifier(newId);
                this.floatingTexts.add(new FloatingText(this, (class_2561)displayText, color, x, y));
                if (this.reforgeButton != null && this.reforgeButton.disabled && !this.modifierAchieved) {
                    this.reforgeButton.setDisabled(false);
                }
            }
        }
    }

    public Class<?> getParentScreenClass() {
        return class_471.class;
    }

    public class ReforgeButton
    extends class_4185 {
        private boolean disabled = true;

        public ReforgeButton(ReforgeScreen this$0, int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 18, 18, class_5244.field_39003, onPress, field_40754);
            this.field_22763 = true;
        }

        public void press() {
            this.field_22767.onPress((class_4185)this);
        }

        protected void method_48579(class_332 context, int mouseX, int mouseY, float delta) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.enableDepthTest();
            int j = 176;
            if (this.disabled) {
                j += this.field_22758 * 2;
            } else if (this.method_49606()) {
                j += this.field_22758;
            }
            context.method_25302(TEXTURE, this.method_46426(), this.method_46427(), j, 0, this.field_22758, this.field_22759);
        }

        public void setDisabled(boolean disable) {
            this.disabled = disable;
            this.field_22763 = true;
        }
    }

    private class FloatingText {
        final class_2561 text;
        final int baseColor;
        int age = 0;
        final int maxAge = 50;
        final int x;
        final int y;

        FloatingText(ReforgeScreen reforgeScreen, class_2561 text, int color, int x, int y) {
            this.text = text;
            this.baseColor = color;
            this.x = x;
            this.y = y;
        }

        void tick() {
            ++this.age;
        }

        boolean isExpired() {
            return this.age >= 50;
        }

        float getAlpha() {
            if (this.age < 10) {
                float t = (float)this.age / 10.0f;
                return t * t;
            }
            if (this.age < 30) {
                return 1.0f;
            }
            if (this.age < 50) {
                float t = (float)(50 - this.age) / 20.0f;
                return t * t;
            }
            return 0.0f;
        }

        float getYOffset() {
            float t = (float)this.age / 50.0f;
            return (float)(-Math.pow(t, 0.6) * 20.0);
        }

        int getRenderColor() {
            int alpha = (int)(this.getAlpha() * 255.0f);
            return alpha << 24 | this.baseColor;
        }
    }
}

