/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.mixin;

import draylar.tiered.Tiered;
import draylar.tiered.api.AttributeTemplate;
import draylar.tiered.api.ModifierUtils;
import draylar.tiered.api.PotentialAttribute;
import draylar.tiered.api.TierComponent;
import io.wispforest.accessories.api.slot.SlotReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_9274;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1799.class})
public abstract class ItemStackMixin {
    @Inject(method={"getMaxDamage"}, at={@At(value="TAIL")}, cancellable=true)
    private void getMaxDamageMixin(CallbackInfoReturnable<Integer> info) {
        class_1799 stack = (class_1799)this;
        if (stack.method_57824(Tiered.TIER) != null && ((TierComponent)stack.method_57824(Tiered.TIER)).durable() > 0.0f) {
            if (((TierComponent)stack.method_57824(Tiered.TIER)).operation() == 0) {
                info.setReturnValue((Object)((Integer)info.getReturnValue() + (int)((TierComponent)stack.method_57824(Tiered.TIER)).durable()));
            } else {
                info.setReturnValue((Object)((Integer)info.getReturnValue() + (int)((float)((Integer)info.getReturnValue()).intValue() * ((TierComponent)stack.method_57824(Tiered.TIER)).durable())));
            }
        }
    }

    @Inject(method={"Lnet/minecraft/item/ItemStack;applyAttributeModifier(Lnet/minecraft/component/type/AttributeModifierSlot;Ljava/util/function/BiConsumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;applyAttributeModifiers(Lnet/minecraft/item/ItemStack;Lnet/minecraft/component/type/AttributeModifierSlot;Ljava/util/function/BiConsumer;)V")})
    private void applyAttributeModifierMixin(class_9274 slot, BiConsumer<class_6880<class_1320>, class_1322> attributeModifierConsumer, CallbackInfo info) {
        this.applyAttributeModifier(null, slot, attributeModifierConsumer);
    }

    @Inject(method={"Lnet/minecraft/item/ItemStack;applyAttributeModifiers(Lnet/minecraft/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/enchantment/EnchantmentHelper;applyAttributeModifiers(Lnet/minecraft/item/ItemStack;Lnet/minecraft/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V")})
    private void applyAttributeModifiersMixin(class_1304 slot, BiConsumer<class_6880<class_1320>, class_1322> attributeModifierConsumer, CallbackInfo info) {
        this.applyAttributeModifier(slot, null, attributeModifierConsumer);
    }

    private void applyAttributeModifier(@Nullable class_1304 equipmentSlot, @Nullable class_9274 attributeModifierSlot, BiConsumer<class_6880<class_1320>, class_1322> attributeModifierConsumer) {
        class_1799 itemStack = (class_1799)this;
        if (itemStack.method_57824(Tiered.TIER) != null) {
            class_2960 tier = ModifierUtils.getAttributeId(itemStack);
            PotentialAttribute potentialAttribute = Tiered.ATTRIBUTE_DATA_LOADER.getItemAttributes().get(tier);
            if (potentialAttribute != null) {
                for (AttributeTemplate template : potentialAttribute.getAttributes()) {
                    Optional<class_1304> optional;
                    if (template.getRequiredEquipmentSlots() != null) {
                        String[] requiredEquipmentSlots = new ArrayList(Arrays.asList(template.getRequiredEquipmentSlots()));
                        if (equipmentSlot != null && requiredEquipmentSlots.contains(equipmentSlot)) {
                            template.applyModifiers(equipmentSlot, attributeModifierConsumer);
                        } else if (attributeModifierSlot != null) {
                            optional = Arrays.stream(template.getRequiredEquipmentSlots()).filter(arg_0 -> ((class_9274)attributeModifierSlot).method_57286(arg_0)).findFirst();
                            if (optional.isPresent() && Tiered.isPreferredEquipmentSlot(itemStack, optional.get())) {
                                template.applyModifiers(optional.get(), attributeModifierConsumer);
                            }
                        }
                    }
                    if (template.isOnlyForAccessories()) continue;
                    if (template.getOptionalAccessoriesSlots() != null) {
                        for (String slotName : template.getOptionalAccessoriesSlots()) {
                            SlotReference ref = SlotReference.of(null, (String)slotName, (int)0);
                            template.applyAccessoryModifiers(itemStack, ref, attributeModifierConsumer);
                        }
                    }
                    if (template.getOptionalEquipmentSlots() == null) continue;
                    ArrayList<class_1304> optionalEquipmentSlots = new ArrayList<class_1304>(Arrays.asList(template.getOptionalEquipmentSlots()));
                    if (equipmentSlot != null && optionalEquipmentSlots.contains(equipmentSlot) && Tiered.isPreferredEquipmentSlot(itemStack, equipmentSlot)) {
                        template.applyModifiers(equipmentSlot, attributeModifierConsumer);
                        continue;
                    }
                    if (attributeModifierSlot == null || attributeModifierSlot == class_9274.field_49216 || attributeModifierSlot == class_9274.field_49219) continue;
                    optional = Arrays.stream(template.getOptionalEquipmentSlots()).filter(arg_0 -> ((class_9274)attributeModifierSlot).method_57286(arg_0)).findFirst();
                    if (!optional.isPresent() || !Tiered.isPreferredEquipmentSlot(itemStack, optional.get())) continue;
                    template.applyModifiers(optional.get(), attributeModifierConsumer);
                }
            }
        }
    }
}

