/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.gson;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import draylar.tiered.mixin.access.StyleAccessor;
import java.lang.reflect.Type;
import java.util.Optional;
import net.minecraft.class_151;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class StyleDeserializer
implements JsonDeserializer<class_2583> {
    @Nullable
    private static String parseInsertion(JsonObject root) {
        return class_3518.method_15253((JsonObject)root, (String)"insertion", null);
    }

    @Nullable
    private static class_5251 parseColor(JsonObject root) {
        if (root.has("color")) {
            String string = class_3518.method_15265((JsonObject)root, (String)"color");
            return (class_5251)class_5251.method_27719((String)string).getOrThrow();
        }
        return null;
    }

    @Nullable
    private static Boolean parseNullableBoolean(JsonObject root, String key) {
        if (root.has(key)) {
            return root.get(key).getAsBoolean();
        }
        return null;
    }

    @Nullable
    private static class_2960 getFont(JsonObject root) {
        if (root.has("font")) {
            String string = class_3518.method_15265((JsonObject)root, (String)"font");
            try {
                return class_2960.method_60654((String)string);
            }
            catch (class_151 invalidIdentifierException) {
                throw new JsonSyntaxException("Invalid font name: " + string);
            }
        }
        return null;
    }

    @Nullable
    public class_2583 deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            if (jsonObject == null) {
                return null;
            }
            Boolean bold = StyleDeserializer.parseNullableBoolean(jsonObject, "bold");
            Boolean italic = StyleDeserializer.parseNullableBoolean(jsonObject, "italic");
            Boolean underlined = StyleDeserializer.parseNullableBoolean(jsonObject, "underlined");
            Boolean strikethrough = StyleDeserializer.parseNullableBoolean(jsonObject, "strikethrough");
            Boolean obfuscated = StyleDeserializer.parseNullableBoolean(jsonObject, "obfuscated");
            class_5251 textColor = StyleDeserializer.parseColor(jsonObject);
            String insertion = StyleDeserializer.parseInsertion(jsonObject);
            class_2960 font = StyleDeserializer.getFont(jsonObject);
            return StyleAccessor.invokeOf(Optional.ofNullable(textColor), Optional.ofNullable(bold), Optional.ofNullable(italic), Optional.ofNullable(underlined), Optional.ofNullable(strikethrough), Optional.ofNullable(obfuscated), Optional.empty(), Optional.empty(), Optional.ofNullable(insertion), Optional.ofNullable(font));
        }
        return null;
    }
}

