/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.data;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import draylar.tiered.TieredClient;
import draylar.tiered.TieredServer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReforgeDataLoader
implements SimpleSynchronousResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"TieredZ");
    private final List<class_2960> reforgeIdentifiers = new ArrayList<class_2960>();
    private final Map<class_2960, List<class_1792>> reforgeBaseMap = new HashMap<class_2960, List<class_1792>>();

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"tiered", (String)"reforge_loader");
    }

    public void method_14491(class_3300 resourceManager) {
        this.reforgeIdentifiers.clear();
        this.reforgeBaseMap.clear();
        resourceManager.method_14488("reforge_items", id -> id.method_12832().endsWith(".json")).forEach((id, resourceRef) -> {
            try (InputStream stream = resourceRef.method_14482();){
                JsonObject data = JsonParser.parseReader((Reader)new InputStreamReader(stream)).getAsJsonObject();
                ArrayList baseRaw = new ArrayList();
                ArrayList itemRaw = new ArrayList();
                data.getAsJsonArray("base").forEach(el -> baseRaw.add(el.getAsString()));
                data.getAsJsonArray("items").forEach(el -> itemRaw.add(el.getAsString()));
                Runnable task = () -> {
                    class_1792 item;
                    class_2960 itemId;
                    class_6862 tagKey;
                    class_2960 tagId;
                    ArrayList<class_1792> baseItems = new ArrayList<class_1792>();
                    for (String entry : baseRaw) {
                        if (entry.startsWith("#")) {
                            tagId = class_2960.method_60654((String)entry.substring(1));
                            tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
                            class_7923.field_41178.method_40266(tagKey).ifPresentOrElse(list -> list.forEach(e -> baseItems.add((class_1792)e.comp_349())), () -> LOGGER.warn("Base tag '{}' not found in file '{}'", (Object)tagId, id));
                            continue;
                        }
                        itemId = class_2960.method_60654((String)entry);
                        item = (class_1792)class_7923.field_41178.method_10223(itemId);
                        if (!item.toString().equals("air")) {
                            baseItems.add(item);
                            continue;
                        }
                        LOGGER.warn("Invalid base item '{}' in {}", (Object)entry, id);
                    }
                    for (String itemEntry : itemRaw) {
                        if (itemEntry.startsWith("#")) {
                            tagId = class_2960.method_60654((String)itemEntry.substring(1));
                            tagKey = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)tagId);
                            class_7923.field_41178.method_40266(tagKey).ifPresentOrElse(list -> {
                                for (class_6880 entry : list) {
                                    class_2960 itemId = class_7923.field_41178.method_10221((Object)((class_1792)entry.comp_349()));
                                    this.reforgeIdentifiers.add(itemId);
                                    this.reforgeBaseMap.put(itemId, new ArrayList(baseItems));
                                    LOGGER.debug("[Tiered] Added reforge tag item: {} -> {}", (Object)tagId, (Object)itemId);
                                }
                            }, () -> LOGGER.warn("Target tag '{}' not found in file '{}'", (Object)tagId, id));
                            continue;
                        }
                        itemId = class_2960.method_60654((String)itemEntry);
                        item = (class_1792)class_7923.field_41178.method_10223(itemId);
                        if (!item.toString().equals("air")) {
                            this.reforgeIdentifiers.add(itemId);
                            this.reforgeBaseMap.put(itemId, new ArrayList(baseItems));
                            LOGGER.debug("[Tiered] Added reforge item: {}", (Object)itemId);
                            continue;
                        }
                        LOGGER.warn("Invalid target item '{}' in {}", (Object)itemEntry, id);
                    }
                };
                if (FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
                    TieredClient.TASK_QUEUE.add(task);
                } else {
                    TieredServer.TASK_QUEUE.add(task);
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load reforge config '{}': {}", id, (Object)e.toString());
                e.printStackTrace();
            }
        });
    }

    public List<class_1792> getReforgeBaseItems(class_1792 item) {
        class_2960 id = class_7923.field_41178.method_10221((Object)item);
        return this.reforgeBaseMap.getOrDefault(id, new ArrayList());
    }

    public void putReforgeBaseItems(class_2960 id, List<class_1792> items) {
        this.reforgeBaseMap.put(id, items);
    }

    public void clearReforgeBaseItems() {
        this.reforgeBaseMap.clear();
    }

    public List<class_2960> getReforgeIdentifiers() {
        return this.reforgeIdentifiers;
    }
}

