/*
 * Decompiled with CFR 0.152.
 */
package draylar.tiered.data;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import draylar.tiered.api.PotentialAttribute;
import draylar.tiered.gson.EntityAttributeModifierDeserializer;
import draylar.tiered.gson.EntityAttributeModifierSerializer;
import draylar.tiered.gson.EquipmentSlotDeserializer;
import draylar.tiered.gson.EquipmentSlotSerializer;
import draylar.tiered.gson.StyleDeserializer;
import draylar.tiered.gson.StyleSerializer;
import java.util.HashMap;
import java.util.Map;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AttributeDataLoader
extends class_4309
implements SimpleSynchronousResourceReloadListener {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().registerTypeAdapter(class_1322.class, (Object)new EntityAttributeModifierDeserializer()).registerTypeAdapter(class_1322.class, (Object)new EntityAttributeModifierSerializer()).registerTypeAdapter(class_1304.class, (Object)new EquipmentSlotSerializer()).registerTypeAdapter(class_1304.class, (Object)new EquipmentSlotDeserializer()).registerTypeAdapter(class_2583.class, (Object)new StyleDeserializer()).registerTypeAdapter(class_2583.class, (Object)new StyleSerializer()).create();
    private static final String PARSING_ERROR_MESSAGE = "Parsing error loading tier {}";
    private static final String LOADED_TIERS_MESSAGE = "Loaded {} tiers";
    private static final Logger LOGGER = LogManager.getLogger();
    private Map<class_2960, PotentialAttribute> itemAttributes = new HashMap<class_2960, PotentialAttribute>();

    public AttributeDataLoader() {
        super(GSON, "item_attributes");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        HashMap readItemAttributes = Maps.newHashMap();
        for (Map.Entry<class_2960, JsonElement> entry : loader.entrySet()) {
            class_2960 identifier = entry.getKey();
            try {
                PotentialAttribute itemAttribute = (PotentialAttribute)GSON.fromJson(entry.getValue(), PotentialAttribute.class);
                readItemAttributes.put(class_2960.method_60654((String)itemAttribute.getID()), itemAttribute);
            }
            catch (JsonParseException | IllegalArgumentException exception) {
                LOGGER.error(PARSING_ERROR_MESSAGE, (Object)identifier, (Object)exception);
            }
        }
        this.itemAttributes = readItemAttributes;
        LOGGER.info(LOADED_TIERS_MESSAGE, (Object)readItemAttributes.size());
    }

    public Map<class_2960, PotentialAttribute> getItemAttributes() {
        return this.itemAttributes;
    }

    public class_2960 getFabricId() {
        return class_2960.method_60655((String)"tiered", (String)"item_attributes");
    }

    public void method_14491(class_3300 resourceManager) {
    }
}

